/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.autoscaling.instances;

import com.eucalyptus.autoscaling.instances.AutoScalingInstance;
import com.eucalyptus.autoscaling.instances.AutoScalingInstanceCoreView;
import com.google.common.base.Predicate;
import javax.annotation.Nullable;

public enum ConfigurationState implements Predicate<AutoScalingInstance>
{
    Nihil,
    Instantiated,
    Registered;


    public boolean apply(@Nullable AutoScalingInstance instance) {
        return instance != null && this == instance.getConfigurationState();
    }

    public Predicate<AutoScalingInstanceCoreView> forView() {
        return new Predicate<AutoScalingInstanceCoreView>(){

            public boolean apply(@Nullable AutoScalingInstanceCoreView instance) {
                return instance != null && ConfigurationState.this == instance.getConfigurationState();
            }
        };
    }

    public Predicate<AutoScalingInstance> transitionTo(ConfigurationState to) {
        return new ConfigurationStateTransition(this, to);
    }

    private static final class ConfigurationStateTransition
    implements Predicate<AutoScalingInstance> {
        private final ConfigurationState from;
        private final ConfigurationState to;

        private ConfigurationStateTransition(ConfigurationState from, ConfigurationState to) {
            this.from = from;
            this.to = to;
        }

        public boolean apply(AutoScalingInstance instance) {
            boolean transitioned = false;
            if (this.from.apply(instance)) {
                instance.setConfigurationState(this.to);
                instance.setRegistrationAttempts(0);
                transitioned = true;
            }
            return transitioned;
        }
    }
}

