/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.autoscaling.instances;

import com.eucalyptus.autoscaling.common.AutoScalingMetadata;
import com.eucalyptus.autoscaling.common.AutoScalingMetadatas;
import com.eucalyptus.autoscaling.common.backend.msgs.AutoScalingInstanceDetails;
import com.eucalyptus.autoscaling.common.backend.msgs.Instance;
import com.eucalyptus.autoscaling.instances.AutoScalingInstance;
import com.eucalyptus.autoscaling.instances.AutoScalingInstanceCoreView;
import com.eucalyptus.autoscaling.instances.AutoScalingInstanceGroupView;
import com.eucalyptus.autoscaling.instances.ConfigurationState;
import com.eucalyptus.autoscaling.instances.LifecycleState;
import com.eucalyptus.autoscaling.metadata.AutoScalingMetadataException;
import com.eucalyptus.util.Callback;
import com.eucalyptus.util.OwnerFullName;
import com.eucalyptus.util.Strings;
import com.eucalyptus.util.TypeMapper;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public abstract class AutoScalingInstances {
    public abstract <T> List<T> list(OwnerFullName var1, Predicate<? super AutoScalingInstance> var2, Function<? super AutoScalingInstance, T> var3) throws AutoScalingMetadataException;

    public abstract <T> List<T> listByGroup(OwnerFullName var1, String var2, Function<? super AutoScalingInstance, T> var3) throws AutoScalingMetadataException;

    public abstract <T> List<T> listByGroup(AutoScalingMetadata.AutoScalingGroupMetadata var1, Predicate<? super AutoScalingInstance> var2, Function<? super AutoScalingInstance, T> var3) throws AutoScalingMetadataException;

    public abstract <T> List<T> listByState(LifecycleState var1, ConfigurationState var2, Function<? super AutoScalingInstance, T> var3) throws AutoScalingMetadataException;

    public abstract <T> List<T> listUnhealthyByGroup(AutoScalingMetadata.AutoScalingGroupMetadata var1, Function<? super AutoScalingInstance, T> var2) throws AutoScalingMetadataException;

    public abstract <T> T lookup(OwnerFullName var1, String var2, Function<? super AutoScalingInstance, T> var3) throws AutoScalingMetadataException;

    public abstract void update(OwnerFullName var1, String var2, Callback<AutoScalingInstance> var3) throws AutoScalingMetadataException;

    public abstract void markMissingInstancesUnhealthy(AutoScalingMetadata.AutoScalingGroupMetadata var1, Collection<String> var2) throws AutoScalingMetadataException;

    public abstract void markExpiredPendingUnhealthy(AutoScalingMetadata.AutoScalingGroupMetadata var1, Collection<String> var2, long var3) throws AutoScalingMetadataException;

    public abstract Set<String> verifyInstanceIds(String var1, Collection<String> var2) throws AutoScalingMetadataException;

    public abstract void transitionState(AutoScalingMetadata.AutoScalingGroupMetadata var1, LifecycleState var2, LifecycleState var3, Collection<String> var4) throws AutoScalingMetadataException;

    public abstract void transitionConfigurationState(AutoScalingMetadata.AutoScalingGroupMetadata var1, ConfigurationState var2, ConfigurationState var3, Collection<String> var4) throws AutoScalingMetadataException;

    public abstract int registrationFailure(AutoScalingMetadata.AutoScalingGroupMetadata var1, Collection<String> var2) throws AutoScalingMetadataException;

    public abstract boolean delete(AutoScalingMetadata.AutoScalingInstanceMetadata var1) throws AutoScalingMetadataException;

    public abstract boolean deleteByGroup(AutoScalingMetadata.AutoScalingGroupMetadata var1) throws AutoScalingMetadataException;

    public abstract AutoScalingInstance save(AutoScalingInstance var1) throws AutoScalingMetadataException;

    public static Function<AutoScalingInstance, String> instanceId() {
        return AutoScalingMetadatas.toDisplayName();
    }

    public static Function<AutoScalingInstanceCoreView, String> launchConfigurationName() {
        return AutoScalingInstanceProperties.LAUNCH_CONFIGURATION_NAME;
    }

    public static Function<AutoScalingInstanceCoreView, String> availabilityZone() {
        return AutoScalingInstanceProperties.AVAILABILITY_ZONE;
    }

    public static Function<AutoScalingInstanceGroupView, String> groupArn() {
        return AutoScalingInstanceGroupProperties.GROUP_ARN;
    }

    private static enum AutoScalingInstanceProperties implements Function<AutoScalingInstanceCoreView, String>
    {
        AVAILABILITY_ZONE{

            public String apply(AutoScalingInstanceCoreView autoScalingInstance) {
                return autoScalingInstance.getAvailabilityZone();
            }
        }
        ,
        LAUNCH_CONFIGURATION_NAME{

            public String apply(AutoScalingInstanceCoreView autoScalingInstance) {
                return autoScalingInstance.getLaunchConfigurationName();
            }
        };

    }

    private static enum AutoScalingInstanceGroupProperties implements Function<AutoScalingInstanceGroupView, String>
    {
        GROUP_ARN{

            public String apply(AutoScalingInstanceGroupView autoScalingInstance) {
                return (String)AutoScalingMetadatas.toArn().apply((Object)autoScalingInstance.getAutoScalingGroup());
            }
        };

    }

    @TypeMapper
    public static enum AutoScalingInstanceSummaryTransform implements Function<AutoScalingInstance, Instance>
    {
        INSTANCE;


        public Instance apply(AutoScalingInstance autoScalingInstance) {
            Instance details = new Instance();
            details.setAvailabilityZone(autoScalingInstance.getAvailabilityZone());
            details.setHealthStatus(Strings.toString((Object)((Object)autoScalingInstance.getHealthStatus())));
            details.setInstanceId(autoScalingInstance.getInstanceId());
            details.setLaunchConfigurationName(autoScalingInstance.getLaunchConfigurationName());
            details.setLifecycleState(Strings.toString((Object)((Object)autoScalingInstance.getLifecycleState())));
            return details;
        }
    }

    @TypeMapper
    public static enum AutoScalingInstanceGroupViewTransform implements Function<AutoScalingInstance, AutoScalingInstanceGroupView>
    {
        INSTANCE;


        public AutoScalingInstanceGroupView apply(AutoScalingInstance autoScalingInstance) {
            return new AutoScalingInstanceGroupView(autoScalingInstance);
        }
    }

    @TypeMapper
    public static enum AutoScalingInstanceCoreViewTransform implements Function<AutoScalingInstance, AutoScalingInstanceCoreView>
    {
        INSTANCE;


        public AutoScalingInstanceCoreView apply(AutoScalingInstance autoScalingInstance) {
            return new AutoScalingInstanceCoreView(autoScalingInstance);
        }
    }

    @TypeMapper
    public static enum AutoScalingInstanceTransform implements Function<AutoScalingInstance, AutoScalingInstanceDetails>
    {
        INSTANCE;


        public AutoScalingInstanceDetails apply(AutoScalingInstance autoScalingInstance) {
            AutoScalingInstanceDetails details = new AutoScalingInstanceDetails();
            details.setAutoScalingGroupName(autoScalingInstance.getAutoScalingGroupName());
            details.setAvailabilityZone(autoScalingInstance.getAvailabilityZone());
            details.setHealthStatus(Strings.toString((Object)((Object)autoScalingInstance.getHealthStatus())));
            details.setInstanceId(autoScalingInstance.getInstanceId());
            details.setLaunchConfigurationName(autoScalingInstance.getLaunchConfigurationName());
            details.setLifecycleState(Strings.toString((Object)((Object)autoScalingInstance.getLifecycleState())));
            return details;
        }
    }
}

