/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.autoscaling.instances;

import com.eucalyptus.autoscaling.common.AutoScalingMetadata;
import com.eucalyptus.autoscaling.common.AutoScalingMetadatas;
import com.eucalyptus.autoscaling.groups.AutoScalingGroup;
import com.eucalyptus.autoscaling.instances.ConfigurationState;
import com.eucalyptus.autoscaling.instances.HealthStatus;
import com.eucalyptus.autoscaling.instances.LifecycleState;
import com.eucalyptus.entities.AbstractOwnedPersistent;
import com.eucalyptus.util.OwnerFullName;
import com.google.common.base.Objects;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.PersistenceContext;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

@Entity
@PersistenceContext(name="eucalyptus_autoscaling")
@Table(name="metadata_auto_scaling_instances")
@Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
public class AutoScalingInstance
extends AbstractOwnedPersistent
implements AutoScalingMetadata.AutoScalingInstanceMetadata {
    private static final long serialVersionUID = 1L;
    @Column(name="metadata_availability_zone", nullable=false, updatable=false)
    private String availabilityZone;
    @Column(name="metadata_health_status", nullable=false)
    @Enumerated(value=EnumType.STRING)
    private HealthStatus healthStatus;
    @ManyToOne(optional=false)
    @JoinColumn(name="metadata_auto_scaling_group_id")
    @Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
    private AutoScalingGroup autoScalingGroup;
    @Column(name="metadata_auto_scaling_group_name", nullable=false, updatable=false)
    private String autoScalingGroupName;
    @Column(name="metadata_launch_configuration_name", nullable=false, updatable=false)
    private String launchConfigurationName;
    @Column(name="metadata_lifecycle_state", nullable=false)
    @Enumerated(value=EnumType.STRING)
    private LifecycleState lifecycleState;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="metadata_in_service_timestamp")
    private Date inServiceTimestamp;
    @Column(name="metadata_configuration_state", nullable=false)
    @Enumerated(value=EnumType.STRING)
    private ConfigurationState configurationState;
    @Column(name="metadata_registration_attempts", nullable=false)
    private Integer registrationAttempts;

    protected AutoScalingInstance() {
    }

    protected AutoScalingInstance(OwnerFullName owner) {
        super(owner);
    }

    protected AutoScalingInstance(OwnerFullName owner, String displayName) {
        super(owner, displayName);
    }

    public String getInstanceId() {
        return this.getDisplayName();
    }

    public String getAvailabilityZone() {
        return this.availabilityZone;
    }

    public void setAvailabilityZone(String availabilityZone) {
        this.availabilityZone = availabilityZone;
    }

    public HealthStatus getHealthStatus() {
        return this.healthStatus;
    }

    public void setHealthStatus(HealthStatus healthStatus) {
        this.healthStatus = healthStatus;
    }

    public AutoScalingGroup getAutoScalingGroup() {
        return this.autoScalingGroup;
    }

    public void setAutoScalingGroup(AutoScalingGroup autoScalingGroup) {
        this.autoScalingGroup = autoScalingGroup;
    }

    public String getAutoScalingGroupName() {
        return this.autoScalingGroupName;
    }

    public void setAutoScalingGroupName(String autoScalingGroupName) {
        this.autoScalingGroupName = autoScalingGroupName;
    }

    public String getLaunchConfigurationName() {
        return this.launchConfigurationName;
    }

    public void setLaunchConfigurationName(String launchConfigurationName) {
        this.launchConfigurationName = launchConfigurationName;
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public void setLifecycleState(LifecycleState lifecycleState) {
        this.lifecycleState = lifecycleState;
    }

    public Date getInServiceTimestamp() {
        return this.inServiceTimestamp;
    }

    public void setInServiceTimestamp(Date inServiceTimestamp) {
        this.inServiceTimestamp = inServiceTimestamp;
    }

    public ConfigurationState getConfigurationState() {
        return this.configurationState;
    }

    public void setConfigurationState(ConfigurationState configurationState) {
        this.configurationState = configurationState;
    }

    public Integer getRegistrationAttempts() {
        return this.registrationAttempts;
    }

    public void setRegistrationAttempts(Integer registrationAttempts) {
        this.registrationAttempts = registrationAttempts;
    }

    public boolean healthStatusGracePeriodExpired() {
        long gracePeriodMillis = TimeUnit.SECONDS.toMillis(((Integer)Objects.firstNonNull((Object)this.getAutoScalingGroup().getHealthCheckGracePeriod(), (Object)0)).intValue());
        return this.getInServiceTimestamp() != null && System.currentTimeMillis() - this.getInServiceTimestamp().getTime() > gracePeriodMillis;
    }

    public int incrementRegistrationAttempts() {
        AutoScalingInstance autoScalingInstance = this;
        autoScalingInstance.registrationAttempts = autoScalingInstance.registrationAttempts + 1;
        return autoScalingInstance.registrationAttempts;
    }

    public static AutoScalingInstance withOwner(OwnerFullName ownerFullName) {
        return new AutoScalingInstance(ownerFullName);
    }

    public static AutoScalingInstance withOwner(String accountNumber) {
        AutoScalingInstance example = new AutoScalingInstance();
        example.setOwnerAccountNumber(accountNumber);
        return example;
    }

    public static AutoScalingInstance named(OwnerFullName ownerFullName, String name) {
        return new AutoScalingInstance(ownerFullName, name);
    }

    public static AutoScalingInstance withUuid(String uuid) {
        AutoScalingInstance example = new AutoScalingInstance();
        example.setNaturalId(uuid);
        return example;
    }

    public static AutoScalingInstance withHealthStatus(HealthStatus healthStatus) {
        AutoScalingInstance example = new AutoScalingInstance();
        example.setHealthStatus(healthStatus);
        return example;
    }

    public static AutoScalingInstance withStates(LifecycleState lifecycleState, ConfigurationState configurationState) {
        AutoScalingInstance example = new AutoScalingInstance();
        example.setLifecycleState(lifecycleState);
        example.setConfigurationState(configurationState);
        return example;
    }

    public static AutoScalingInstance create(@Nonnull OwnerFullName ownerFullName, @Nonnull String instanceId, @Nonnull String availabilityZone, @Nonnull AutoScalingGroup group) {
        AutoScalingInstance autoScalingInstance = new AutoScalingInstance(ownerFullName, instanceId);
        autoScalingInstance.setAvailabilityZone(availabilityZone);
        autoScalingInstance.setAutoScalingGroup(group);
        autoScalingInstance.setLaunchConfigurationName((String)AutoScalingMetadatas.toDisplayName().apply((Object)group.getLaunchConfiguration()));
        autoScalingInstance.setHealthStatus(HealthStatus.Healthy);
        autoScalingInstance.setLifecycleState(LifecycleState.Pending);
        autoScalingInstance.setConfigurationState(ConfigurationState.Instantiated);
        autoScalingInstance.setRegistrationAttempts(0);
        return autoScalingInstance;
    }

    @PrePersist
    @PreUpdate
    private void preUpdate() {
        this.autoScalingGroupName = (String)AutoScalingMetadatas.toDisplayName().apply((Object)this.autoScalingGroup);
        if (this.lifecycleState == LifecycleState.InService && this.getInServiceTimestamp() == null) {
            this.setInServiceTimestamp(new Date());
        }
    }
}

