/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.autoscaling.groups;

import com.eucalyptus.auth.principal.Principals;
import com.eucalyptus.autoscaling.common.AutoScalingMetadata;
import com.eucalyptus.autoscaling.instances.AutoScalingInstanceCoreView;
import com.eucalyptus.autoscaling.instances.AutoScalingInstances;
import com.eucalyptus.util.CollectionUtils;
import com.eucalyptus.util.OwnerFullName;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;

public enum TerminationPolicyType implements AutoScalingMetadata.TerminationPolicyTypeMetadata
{
    OldestInstance{

        @Override
        public List<AutoScalingInstanceCoreView> selectForTermination(List<AutoScalingInstanceCoreView> instances) {
            Date oldest = TerminationPolicyType.dateOfOldestInstance(instances);
            return TerminationPolicyType.filterByPropertyEquality(instances, oldest, InstanceCreatedDate.INSTANCE);
        }
    }
    ,
    OldestLaunchConfiguration{

        @Override
        public List<AutoScalingInstanceCoreView> selectForTermination(List<AutoScalingInstanceCoreView> instances) {
            Date oldest = TerminationPolicyType.dateOfOldestInstance(instances);
            AutoScalingInstanceCoreView instanceWithOldestLaunchConfiguration = (AutoScalingInstanceCoreView)Iterables.find(instances, (Predicate)Predicates.compose((Predicate)Predicates.equalTo((Object)oldest), (Function)InstanceCreatedDate.INSTANCE), null);
            String oldestLaunchConfiguration = instanceWithOldestLaunchConfiguration == null ? null : instanceWithOldestLaunchConfiguration.getLaunchConfigurationName();
            return TerminationPolicyType.filterByPropertyEquality(instances, oldestLaunchConfiguration, AutoScalingInstances.launchConfigurationName());
        }
    }
    ,
    NewestInstance{

        @Override
        public List<AutoScalingInstanceCoreView> selectForTermination(List<AutoScalingInstanceCoreView> instances) {
            Date newest = TerminationPolicyType.dateOfNewestInstance(instances);
            return TerminationPolicyType.filterByPropertyEquality(instances, newest, InstanceCreatedDate.INSTANCE);
        }
    }
    ,
    ClosestToNextInstanceHour{

        @Override
        public List<AutoScalingInstanceCoreView> selectForTermination(List<AutoScalingInstanceCoreView> instances) {
            Function secondsToInstanceHourFunction = Functions.compose((Function)DateToTimeUntilNextHour.INSTANCE, (Function)InstanceCreatedDate.INSTANCE);
            Integer secondsToInstanceHour = (Integer)CollectionUtils.reduce((Iterable)Iterables.transform(instances, (Function)secondsToInstanceHourFunction), (Object)Integer.MAX_VALUE, (Function)CollectionUtils.comparator((Comparator)Ordering.natural()));
            return TerminationPolicyType.filterByPropertyEquality(instances, secondsToInstanceHour, secondsToInstanceHourFunction);
        }
    }
    ,
    Default{

        @Override
        public List<AutoScalingInstanceCoreView> selectForTermination(List<AutoScalingInstanceCoreView> instances) {
            List result;
            List<AutoScalingInstanceCoreView> oldestList = OldestLaunchConfiguration.selectForTermination(instances);
            ArrayList closestToInstanceHour = ClosestToNextInstanceHour.selectForTermination(oldestList);
            if (closestToInstanceHour.size() == 1) {
                result = closestToInstanceHour;
            } else if (closestToInstanceHour.isEmpty()) {
                result = Lists.newArrayList();
            } else {
                Collections.shuffle(closestToInstanceHour);
                result = closestToInstanceHour.subList(0, 1);
            }
            return result;
        }
    };


    public String getDisplayName() {
        return this.name();
    }

    public OwnerFullName getOwner() {
        return Principals.systemFullName();
    }

    public abstract List<AutoScalingInstanceCoreView> selectForTermination(List<AutoScalingInstanceCoreView> var1);

    public static AutoScalingInstanceCoreView selectForTermination(Collection<TerminationPolicyType> terminationPolicyTypes, List<AutoScalingInstanceCoreView> instances) {
        if (instances.isEmpty()) {
            throw new IllegalArgumentException("No instances provided");
        }
        List<AutoScalingInstanceCoreView> currentList = instances;
        for (TerminationPolicyType terminationPolicyType : Iterables.concat(terminationPolicyTypes, Collections.singleton(Default))) {
            if (currentList.size() == 1) break;
            currentList = terminationPolicyType.selectForTermination(currentList);
        }
        return currentList.get(0);
    }

    private static <T> List<AutoScalingInstanceCoreView> filterByPropertyEquality(List<AutoScalingInstanceCoreView> instances, T target, Function<? super AutoScalingInstanceCoreView, T> propertyFunction) {
        return Lists.newArrayList((Iterable)Iterables.filter(instances, (Predicate)Predicates.compose((Predicate)Predicates.equalTo(target), propertyFunction)));
    }

    private static Date dateOfOldestInstance(List<AutoScalingInstanceCoreView> instances) {
        return TerminationPolicyType.dateOfInstance(instances, new Date(Long.MAX_VALUE), (Comparator<Date>)Ordering.natural());
    }

    private static Date dateOfNewestInstance(List<AutoScalingInstanceCoreView> instances) {
        return TerminationPolicyType.dateOfInstance(instances, new Date(0L), (Comparator<Date>)Ordering.natural().reverse());
    }

    private static Date dateOfInstance(List<AutoScalingInstanceCoreView> instances, Date initialDate, Comparator<Date> comparator) {
        return (Date)CollectionUtils.reduce((Iterable)Iterables.transform(instances, (Function)InstanceCreatedDate.INSTANCE), (Object)initialDate, (Function)CollectionUtils.comparator(comparator));
    }

    private static enum InstanceCreatedDate implements Function<AutoScalingInstanceCoreView, Date>
    {
        INSTANCE;


        public Date apply(AutoScalingInstanceCoreView instance) {
            return new Date(instance.getCreationTimestamp());
        }
    }

    private static enum DateToTimeUntilNextHour implements Function<Date, Integer>
    {
        INSTANCE;


        public Integer apply(Date date) {
            long timeInHour = date.getTime() % TimeUnit.HOURS.toMillis(1L);
            return (int)((TimeUnit.HOURS.toMillis(1L) - timeInHour) / 1000L);
        }
    }
}

