/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.autoscaling.groups;

import com.eucalyptus.autoscaling.groups.ScalingProcessType;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Embeddable;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

@Embeddable
public class SuspendedProcess {
    @Column(name="metadata_scaling_process_type", nullable=false, updatable=false)
    @Enumerated(value=EnumType.STRING)
    private ScalingProcessType scalingProcessType;
    @Column(name="metadata_reason", nullable=false, updatable=false)
    private String reason;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="creation_timestamp", nullable=false, updatable=false)
    private Date creationTimestamp;

    public ScalingProcessType getScalingProcessType() {
        return this.scalingProcessType;
    }

    public void setScalingProcessType(ScalingProcessType scalingProcessType) {
        this.scalingProcessType = scalingProcessType;
    }

    public String getReason() {
        return this.reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public Date getCreationTimestamp() {
        return this.creationTimestamp;
    }

    public void setCreationTimestamp(Date creationTimestamp) {
        this.creationTimestamp = creationTimestamp;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SuspendedProcess that = (SuspendedProcess)o;
        return this.scalingProcessType == that.scalingProcessType;
    }

    public int hashCode() {
        return this.scalingProcessType != null ? this.scalingProcessType.hashCode() : 0;
    }

    public static SuspendedProcess createManual(ScalingProcessType scalingProcessType) {
        return SuspendedProcess.buildSuspendedProcess(scalingProcessType, "Manual suspension");
    }

    public static SuspendedProcess createAdministrative(ScalingProcessType scalingProcessType) {
        return SuspendedProcess.buildSuspendedProcess(scalingProcessType, "Administrative suspension");
    }

    private static SuspendedProcess buildSuspendedProcess(ScalingProcessType scalingProcessType, String reason) {
        SuspendedProcess suspendedProcess = new SuspendedProcess();
        suspendedProcess.setCreationTimestamp(new Date());
        suspendedProcess.setScalingProcessType(scalingProcessType);
        suspendedProcess.setReason(reason);
        return suspendedProcess;
    }
}

