/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.autoscaling.groups;

import com.eucalyptus.auth.principal.Principals;
import com.eucalyptus.autoscaling.common.AutoScalingMetadata;
import com.eucalyptus.autoscaling.groups.AutoScalingGroup;
import com.eucalyptus.autoscaling.groups.AutoScalingGroupCoreView;
import com.eucalyptus.autoscaling.groups.SuspendedProcess;
import com.eucalyptus.util.OwnerFullName;
import com.google.common.base.Predicate;
import javax.annotation.Nullable;

public enum ScalingProcessType implements Predicate<AutoScalingGroup>,
AutoScalingMetadata.ScalingProcessTypeMetadata
{
    AZRebalance,
    AddToLoadBalancer,
    AlarmNotification,
    HealthCheck,
    Launch,
    ReplaceUnhealthy,
    ScheduledActions,
    Terminate;


    public boolean apply(@Nullable AutoScalingGroup group) {
        return group == null || ScalingProcessType.isEnabled(this, group.getSuspendedProcesses());
    }

    public Predicate<AutoScalingGroupCoreView> forView() {
        return new Predicate<AutoScalingGroupCoreView>(){

            public boolean apply(AutoScalingGroupCoreView group) {
                return group == null || ScalingProcessType.isEnabled(ScalingProcessType.this, group.getSuspendedProcesses());
            }
        };
    }

    public String getDisplayName() {
        return this.name();
    }

    public OwnerFullName getOwner() {
        return Principals.systemFullName();
    }

    private static boolean isEnabled(ScalingProcessType scalingProcessType, Iterable<SuspendedProcess> suspendedProcesses) {
        boolean enabled = true;
        for (SuspendedProcess suspendedProcess : suspendedProcesses) {
            if (suspendedProcess.getScalingProcessType() != scalingProcessType) continue;
            enabled = false;
            break;
        }
        return enabled;
    }
}

