/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.autoscaling.groups;

import com.eucalyptus.autoscaling.common.AutoScalingMetadata;
import com.eucalyptus.autoscaling.common.AutoScalingResourceName;
import com.eucalyptus.autoscaling.groups.AutoScalingGroup;
import com.eucalyptus.autoscaling.groups.AutoScalingGroups;
import com.eucalyptus.autoscaling.instances.AutoScalingInstance;
import com.eucalyptus.autoscaling.instances.HealthStatus;
import com.eucalyptus.autoscaling.metadata.AbstractOwnedPersistents;
import com.eucalyptus.autoscaling.metadata.AbstractOwnedPersistentsWithResourceNameSupport;
import com.eucalyptus.autoscaling.metadata.AutoScalingMetadataException;
import com.eucalyptus.component.annotation.ComponentNamed;
import com.eucalyptus.entities.AbstractPersistent;
import com.eucalyptus.util.Callback;
import com.eucalyptus.util.OwnerFullName;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Disjunction;
import org.hibernate.criterion.Example;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Property;
import org.hibernate.criterion.Restrictions;

@ComponentNamed
public class PersistenceAutoScalingGroups
extends AutoScalingGroups {
    private PersistenceSupport persistenceSupport = new PersistenceSupport();

    @Override
    public <T> List<T> list(OwnerFullName ownerFullName, Predicate<? super AutoScalingGroup> filter, Function<? super AutoScalingGroup, T> transform) throws AutoScalingMetadataException {
        return this.persistenceSupport.list(ownerFullName, filter, transform);
    }

    @Override
    public <T> List<T> listRequiringScaling(Function<? super AutoScalingGroup, T> transform) throws AutoScalingMetadataException {
        return this.persistenceSupport.listByExample((AbstractPersistent)AutoScalingGroup.requiringScaling(), Predicates.alwaysTrue(), transform);
    }

    @Override
    public <T> List<T> listRequiringInstanceReplacement(Function<? super AutoScalingGroup, T> transform) throws AutoScalingMetadataException {
        DetachedCriteria criteria = DetachedCriteria.forClass(AutoScalingInstance.class).add((Criterion)Example.create((Object)((Object)AutoScalingInstance.withHealthStatus(HealthStatus.Unhealthy)))).setProjection((Projection)Projections.property((String)"autoScalingGroup"));
        return this.persistenceSupport.listByExample((AbstractPersistent)AutoScalingGroup.withOwner(null), Predicates.alwaysTrue(), Property.forName((String)"id").in(criteria), Collections.emptyMap(), transform);
    }

    @Override
    public <T> List<T> listRequiringMonitoring(long interval, Function<? super AutoScalingGroup, T> transform) throws AutoScalingMetadataException {
        int group = (int)(System.currentTimeMillis() / interval % 6L);
        ArrayList suffixes = Lists.newArrayList();
        switch (group) {
            case 0: {
                suffixes.add("0");
                suffixes.add("1");
                suffixes.add("2");
                break;
            }
            case 1: {
                suffixes.add("3");
                suffixes.add("4");
                suffixes.add("5");
                break;
            }
            case 2: {
                suffixes.add("6");
                suffixes.add("7");
                suffixes.add("8");
                break;
            }
            case 3: {
                suffixes.add("9");
                suffixes.add("a");
                suffixes.add("b");
                break;
            }
            case 4: {
                suffixes.add("c");
                suffixes.add("d");
                break;
            }
            default: {
                suffixes.add("e");
                suffixes.add("f");
            }
        }
        Disjunction likeAnyOf = Restrictions.disjunction();
        for (String suffix : suffixes) {
            likeAnyOf.add(Restrictions.ilike((String)"id", (Object)("%" + suffix)));
        }
        return this.persistenceSupport.listByExample((AbstractPersistent)AutoScalingGroup.withOwner(null), Predicates.alwaysTrue(), (Criterion)likeAnyOf, Collections.emptyMap(), transform);
    }

    @Override
    public <T> T lookup(OwnerFullName ownerFullName, String autoScalingGroupName, Function<? super AutoScalingGroup, T> transform) throws AutoScalingMetadataException {
        return this.persistenceSupport.lookup(ownerFullName, autoScalingGroupName, transform);
    }

    @Override
    public void update(OwnerFullName ownerFullName, String autoScalingGroupName, Callback<AutoScalingGroup> groupUpdateCallback) throws AutoScalingMetadataException {
        this.persistenceSupport.update(ownerFullName, autoScalingGroupName, groupUpdateCallback);
    }

    @Override
    public void markScalingRequiredForZones(final Set<String> availabilityZones) throws AutoScalingMetadataException {
        if (!availabilityZones.isEmpty()) {
            this.persistenceSupport.transactionWithRetry(AutoScalingGroup.class, new AbstractOwnedPersistents.WorkCallback<Void>(){

                @Override
                public Void doWork() throws AutoScalingMetadataException {
                    List groups = PersistenceAutoScalingGroups.this.persistenceSupport.listByExample((AbstractPersistent)AutoScalingGroup.withOwner(null), Predicates.alwaysTrue(), Functions.identity());
                    for (AutoScalingGroup group : groups) {
                        if (Sets.union((Set)Sets.newHashSet(group.getAvailabilityZones()), (Set)availabilityZones).isEmpty()) continue;
                        group.setScalingRequired(true);
                    }
                    return null;
                }
            });
        }
    }

    @Override
    public boolean delete(AutoScalingMetadata.AutoScalingGroupMetadata autoScalingGroup) throws AutoScalingMetadataException {
        return this.persistenceSupport.delete((AutoScalingMetadata)autoScalingGroup);
    }

    @Override
    public AutoScalingGroup save(AutoScalingGroup autoScalingGroup) throws AutoScalingMetadataException {
        return (AutoScalingGroup)this.persistenceSupport.save((AbstractPersistent)autoScalingGroup);
    }

    private static class PersistenceSupport
    extends AbstractOwnedPersistentsWithResourceNameSupport<AutoScalingGroup> {
        private PersistenceSupport() {
            super(AutoScalingResourceName.Type.autoScalingGroup);
        }

        protected AutoScalingGroup exampleWithOwner(OwnerFullName ownerFullName) {
            return AutoScalingGroup.withOwner(ownerFullName);
        }

        protected AutoScalingGroup exampleWithName(OwnerFullName ownerFullName, String name) {
            return AutoScalingGroup.named(ownerFullName, name);
        }

        @Override
        protected AutoScalingGroup exampleWithUuid(String uuid) {
            return AutoScalingGroup.withUuid(uuid);
        }
    }
}

