/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.autoscaling.groups;

import com.eucalyptus.auth.principal.Principals;
import com.eucalyptus.autoscaling.common.AutoScalingMetadata;
import com.eucalyptus.autoscaling.groups.AutoScalingGroupMinimumView;
import com.eucalyptus.autoscaling.instances.AutoScalingInstanceCoreView;
import com.eucalyptus.autoscaling.instances.LifecycleState;
import com.eucalyptus.util.CollectionUtils;
import com.eucalyptus.util.OwnerFullName;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;

public enum MetricCollectionType implements AutoScalingMetadata.MetricCollectionTypeMetadata
{
    GroupDesiredCapacity{

        @Override
        public Double getValue(AutoScalingGroupMinimumView autoScalingGroup, Iterable<? extends AutoScalingInstanceCoreView> autoScalingInstances) {
            return (double)autoScalingGroup.getDesiredCapacity();
        }
    }
    ,
    GroupInServiceInstances{

        @Override
        public Double getValue(AutoScalingGroupMinimumView autoScalingGroup, Iterable<? extends AutoScalingInstanceCoreView> autoScalingInstances) {
            return MetricCollectionType.countInstancesInState(autoScalingInstances, LifecycleState.InService);
        }
    }
    ,
    GroupMaxSize{

        @Override
        public Double getValue(AutoScalingGroupMinimumView autoScalingGroup, Iterable<? extends AutoScalingInstanceCoreView> autoScalingInstances) {
            return (double)autoScalingGroup.getMaxSize();
        }
    }
    ,
    GroupMinSize{

        @Override
        public Double getValue(AutoScalingGroupMinimumView autoScalingGroup, Iterable<? extends AutoScalingInstanceCoreView> autoScalingInstances) {
            return (double)autoScalingGroup.getMinSize();
        }
    }
    ,
    GroupPendingInstances{

        @Override
        public Double getValue(AutoScalingGroupMinimumView autoScalingGroup, Iterable<? extends AutoScalingInstanceCoreView> autoScalingInstances) {
            return MetricCollectionType.countInstancesInState(autoScalingInstances, LifecycleState.Pending);
        }
    }
    ,
    GroupTerminatingInstances{

        @Override
        public Double getValue(AutoScalingGroupMinimumView autoScalingGroup, Iterable<? extends AutoScalingInstanceCoreView> autoScalingInstances) {
            return MetricCollectionType.countInstancesInState(autoScalingInstances, LifecycleState.Terminating);
        }
    }
    ,
    GroupTotalInstances{

        @Override
        public Double getValue(AutoScalingGroupMinimumView autoScalingGroup, Iterable<? extends AutoScalingInstanceCoreView> autoScalingInstances) {
            return Iterables.size(autoScalingInstances);
        }
    };


    public String getDisplayName() {
        return this.name();
    }

    public OwnerFullName getOwner() {
        return Principals.systemFullName();
    }

    public abstract Double getValue(AutoScalingGroupMinimumView var1, Iterable<? extends AutoScalingInstanceCoreView> var2);

    private static Double countInstancesInState(Iterable<? extends AutoScalingInstanceCoreView> autoScalingInstances, LifecycleState state) {
        return (double)((Integer)CollectionUtils.reduce(autoScalingInstances, (Object)0, (Function)CollectionUtils.count(state.forView())));
    }
}

