/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.autoscaling.groups;

import com.eucalyptus.autoscaling.common.AutoScalingMetadata;
import com.eucalyptus.autoscaling.common.AutoScalingMetadatas;
import com.eucalyptus.autoscaling.common.backend.msgs.AutoScalingGroupType;
import com.eucalyptus.autoscaling.common.backend.msgs.AvailabilityZones;
import com.eucalyptus.autoscaling.common.backend.msgs.EnabledMetrics;
import com.eucalyptus.autoscaling.common.backend.msgs.Instance;
import com.eucalyptus.autoscaling.common.backend.msgs.Instances;
import com.eucalyptus.autoscaling.common.backend.msgs.LoadBalancerNames;
import com.eucalyptus.autoscaling.common.backend.msgs.ProcessType;
import com.eucalyptus.autoscaling.common.backend.msgs.SuspendedProcessType;
import com.eucalyptus.autoscaling.common.backend.msgs.SuspendedProcesses;
import com.eucalyptus.autoscaling.common.backend.msgs.TagType;
import com.eucalyptus.autoscaling.common.backend.msgs.TerminationPolicies;
import com.eucalyptus.autoscaling.configurations.LaunchConfiguration;
import com.eucalyptus.autoscaling.groups.AutoScalingGroup;
import com.eucalyptus.autoscaling.groups.AutoScalingGroupCoreView;
import com.eucalyptus.autoscaling.groups.AutoScalingGroupMetricsView;
import com.eucalyptus.autoscaling.groups.AutoScalingGroupMinimumView;
import com.eucalyptus.autoscaling.groups.AutoScalingGroupScalingView;
import com.eucalyptus.autoscaling.groups.ScalingProcessType;
import com.eucalyptus.autoscaling.groups.SuspendedProcess;
import com.eucalyptus.autoscaling.instances.AutoScalingInstance;
import com.eucalyptus.autoscaling.metadata.AutoScalingMetadataException;
import com.eucalyptus.autoscaling.tags.AutoScalingGroupTag;
import com.eucalyptus.entities.Entities;
import com.eucalyptus.util.Callback;
import com.eucalyptus.util.OwnerFullName;
import com.eucalyptus.util.RestrictedTypes;
import com.eucalyptus.util.Strings;
import com.eucalyptus.util.TypeMapper;
import com.eucalyptus.util.TypeMappers;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterables;
import com.google.common.collect.Ordering;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.persistence.EntityTransaction;

public abstract class AutoScalingGroups {
    public abstract <T> List<T> list(OwnerFullName var1, Predicate<? super AutoScalingGroup> var2, Function<? super AutoScalingGroup, T> var3) throws AutoScalingMetadataException;

    public abstract <T> List<T> listRequiringScaling(Function<? super AutoScalingGroup, T> var1) throws AutoScalingMetadataException;

    public abstract <T> List<T> listRequiringInstanceReplacement(Function<? super AutoScalingGroup, T> var1) throws AutoScalingMetadataException;

    public abstract <T> List<T> listRequiringMonitoring(long var1, Function<? super AutoScalingGroup, T> var3) throws AutoScalingMetadataException;

    public abstract <T> T lookup(OwnerFullName var1, String var2, Function<? super AutoScalingGroup, T> var3) throws AutoScalingMetadataException;

    public abstract void update(OwnerFullName var1, String var2, Callback<AutoScalingGroup> var3) throws AutoScalingMetadataException;

    public abstract void markScalingRequiredForZones(Set<String> var1) throws AutoScalingMetadataException;

    public abstract boolean delete(AutoScalingMetadata.AutoScalingGroupMetadata var1) throws AutoScalingMetadataException;

    public abstract AutoScalingGroup save(AutoScalingGroup var1) throws AutoScalingMetadataException;

    public final PersistingBuilder create(OwnerFullName ownerFullName, String autoScalingGroupName, LaunchConfiguration launchConfiguration, Integer minSize, Integer maxSize) {
        return new PersistingBuilder(this, ownerFullName, autoScalingGroupName, launchConfiguration, minSize, maxSize);
    }

    @RestrictedTypes.QuantityMetricFunction(value=AutoScalingMetadata.AutoScalingGroupMetadata.class)
    public static enum CountAutoScalingGroups implements Function<OwnerFullName, Long>
    {
        INSTANCE;


        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Long apply(OwnerFullName input) {
            EntityTransaction db = Entities.get(AutoScalingGroup.class);
            try {
                Long l = Entities.count((Object)((Object)AutoScalingGroup.withOwner(input)));
                return l;
            }
            finally {
                db.rollback();
            }
        }
    }

    @TypeMapper
    public static enum AutoScalingTagTransform implements Function<TagType, AutoScalingGroupTag>
    {
        INSTANCE;


        public AutoScalingGroupTag apply(TagType tagType) {
            AutoScalingGroupTag groupTag = AutoScalingGroupTag.createUnassigned();
            groupTag.setKey(tagType.getKey());
            groupTag.setValue((String)Objects.firstNonNull((Object)tagType.getValue(), (Object)""));
            groupTag.setPropagateAtLaunch((Boolean)Objects.firstNonNull((Object)tagType.getPropagateAtLaunch(), (Object)Boolean.FALSE));
            return groupTag;
        }
    }

    @TypeMapper
    public static enum ScalingProcessTypeTransform implements Function<ScalingProcessType, ProcessType>
    {
        INSTANCE;


        public ProcessType apply(ScalingProcessType scalingProcessType) {
            ProcessType processType = new ProcessType();
            processType.setProcessName(scalingProcessType.toString());
            return processType;
        }
    }

    @TypeMapper
    public static enum SuspendedProcessTransform implements Function<SuspendedProcess, SuspendedProcessType>
    {
        INSTANCE;


        public SuspendedProcessType apply(SuspendedProcess suspendedProcess) {
            SuspendedProcessType suspendedProcessType = new SuspendedProcessType();
            suspendedProcessType.setProcessName(suspendedProcess.getScalingProcessType().toString());
            suspendedProcessType.setSuspensionReason(suspendedProcess.getReason());
            return suspendedProcessType;
        }
    }

    @TypeMapper
    public static enum AutoScalingGroupMetricsViewTransform implements Function<AutoScalingGroup, AutoScalingGroupMetricsView>
    {
        INSTANCE;


        public AutoScalingGroupMetricsView apply(AutoScalingGroup group) {
            return new AutoScalingGroupMetricsView(group);
        }
    }

    @TypeMapper
    public static enum AutoScalingGroupScalingViewTransform implements Function<AutoScalingGroup, AutoScalingGroupScalingView>
    {
        INSTANCE;


        public AutoScalingGroupScalingView apply(AutoScalingGroup group) {
            return new AutoScalingGroupScalingView(group);
        }
    }

    @TypeMapper
    public static enum AutoScalingGroupCoreViewTransform implements Function<AutoScalingGroup, AutoScalingGroupCoreView>
    {
        INSTANCE;


        public AutoScalingGroupCoreView apply(AutoScalingGroup group) {
            return new AutoScalingGroupCoreView(group);
        }
    }

    @TypeMapper
    public static enum AutoScalingGroupMinimumViewTransform implements Function<AutoScalingGroup, AutoScalingGroupMinimumView>
    {
        INSTANCE;


        public AutoScalingGroupMinimumView apply(AutoScalingGroup group) {
            return new AutoScalingGroupMinimumView(group);
        }
    }

    @TypeMapper
    public static enum AutoScalingGroupTransform implements Function<AutoScalingGroup, AutoScalingGroupType>
    {
        INSTANCE;


        public AutoScalingGroupType apply(AutoScalingGroup group) {
            AutoScalingGroupType type = new AutoScalingGroupType();
            type.setAutoScalingGroupARN(group.getArn());
            type.setAutoScalingGroupName(group.getAutoScalingGroupName());
            type.setAvailabilityZones(new AvailabilityZones(group.getAvailabilityZones()));
            type.setVpcZoneIdentifier(com.google.common.base.Strings.emptyToNull((String)Joiner.on((char)',').join(group.getSubnetIdByZone().values())));
            type.setCreatedTime(group.getCreationTimestamp());
            type.setDefaultCooldown(group.getDefaultCooldown());
            type.setDesiredCapacity(group.getDesiredCapacity());
            type.setEnabledMetrics(new EnabledMetrics(group.getEnabledMetrics() == null ? null : Ordering.natural().sortedCopy(Iterables.transform(group.getEnabledMetrics(), (Function)Strings.toStringFunction()))));
            type.setHealthCheckGracePeriod(group.getHealthCheckGracePeriod());
            type.setHealthCheckType(Strings.toString((Object)((Object)group.getHealthCheckType())));
            type.setLaunchConfigurationName((String)AutoScalingMetadatas.toDisplayName().apply((Object)group.getLaunchConfiguration()));
            type.setLoadBalancerNames(new LoadBalancerNames(group.getLoadBalancerNames()));
            type.setMaxSize(group.getMaxSize());
            type.setMinSize(group.getMinSize());
            Set<SuspendedProcess> suspendedProcesses = group.getSuspendedProcesses();
            if (suspendedProcesses != null && !suspendedProcesses.isEmpty()) {
                type.setSuspendedProcesses(new SuspendedProcesses());
                Iterables.addAll((Collection)type.getSuspendedProcesses().getMember(), (Iterable)Iterables.transform(suspendedProcesses, (Function)TypeMappers.lookup(SuspendedProcess.class, SuspendedProcessType.class)));
            }
            type.setTerminationPolicies(new TerminationPolicies(group.getTerminationPolicies() == null ? null : Collections2.transform(group.getTerminationPolicies(), (Function)Strings.toStringFunction())));
            if (group.getAutoScalingInstances() != null && !group.getAutoScalingInstances().isEmpty()) {
                type.setInstances(new Instances());
                Iterables.addAll((Collection)type.getInstances().getMember(), (Iterable)Iterables.transform(group.getAutoScalingInstances(), (Function)TypeMappers.lookup(AutoScalingInstance.class, Instance.class)));
            }
            return type;
        }
    }

    public static class PersistingBuilder
    extends AutoScalingGroup.BaseBuilder<PersistingBuilder> {
        private final AutoScalingGroups autoScalingGroups;

        PersistingBuilder(AutoScalingGroups autoScalingGroups, OwnerFullName ownerFullName, String name, LaunchConfiguration launchConfiguration, Integer minSize, Integer maxSize) {
            super(ownerFullName, name, launchConfiguration, minSize, maxSize);
            this.autoScalingGroups = autoScalingGroups;
        }

        @Override
        protected PersistingBuilder builder() {
            return this;
        }

        public AutoScalingGroup persist() throws AutoScalingMetadataException {
            return this.autoScalingGroups.save(this.build());
        }
    }
}

