/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.autoscaling.groups;

import com.eucalyptus.autoscaling.configurations.LaunchConfigurationCoreView;
import com.eucalyptus.autoscaling.groups.AutoScalingGroup;
import com.eucalyptus.autoscaling.groups.AutoScalingGroupCoreView;
import com.eucalyptus.autoscaling.groups.TerminationPolicyType;
import com.eucalyptus.util.TypeMappers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;

public class AutoScalingGroupScalingView
extends AutoScalingGroupCoreView {
    private final ImmutableList<TerminationPolicyType> terminationPolicies;
    private final LaunchConfigurationCoreView launchConfiguration;
    private final Map<String, String> subnetIdByZone;

    public AutoScalingGroupScalingView(AutoScalingGroup group) {
        super(group);
        this.terminationPolicies = ImmutableList.copyOf(group.getTerminationPolicies());
        this.launchConfiguration = (LaunchConfigurationCoreView)TypeMappers.transform((Object)((Object)group.getLaunchConfiguration()), LaunchConfigurationCoreView.class);
        this.subnetIdByZone = ImmutableMap.copyOf(group.getSubnetIdByZone());
    }

    public List<TerminationPolicyType> getTerminationPolicies() {
        return this.terminationPolicies;
    }

    public LaunchConfigurationCoreView getLaunchConfiguration() {
        return this.launchConfiguration;
    }

    public Map<String, String> getSubnetIdByZone() {
        return this.subnetIdByZone;
    }
}

