/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.autoscaling.groups;

import com.eucalyptus.autoscaling.groups.AutoScalingGroup;
import com.eucalyptus.autoscaling.groups.AutoScalingGroupMinimumView;
import com.eucalyptus.autoscaling.groups.GroupScalingCause;
import com.eucalyptus.autoscaling.groups.SuspendedProcess;
import com.google.common.collect.ImmutableList;
import java.util.List;

public class AutoScalingGroupCoreView
extends AutoScalingGroupMinimumView {
    private final ImmutableList<String> availabilityZones;
    private final ImmutableList<String> loadBalancerNames;
    private final ImmutableList<GroupScalingCause> scalingCauses;
    private final ImmutableList<SuspendedProcess> suspendedProcesses;

    public AutoScalingGroupCoreView(AutoScalingGroup group) {
        super(group);
        this.availabilityZones = ImmutableList.copyOf(group.getAvailabilityZones());
        this.loadBalancerNames = ImmutableList.copyOf(group.getLoadBalancerNames());
        this.scalingCauses = ImmutableList.copyOf(group.getScalingCauses());
        this.suspendedProcesses = ImmutableList.copyOf(group.getSuspendedProcesses());
    }

    public List<String> getAvailabilityZones() {
        return this.availabilityZones;
    }

    public List<GroupScalingCause> getScalingCauses() {
        return this.scalingCauses;
    }

    public List<SuspendedProcess> getSuspendedProcesses() {
        return this.suspendedProcesses;
    }

    public List<String> getLoadBalancerNames() {
        return this.loadBalancerNames;
    }
}

