/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.autoscaling.groups;

import com.eucalyptus.autoscaling.activities.ScalingActivity;
import com.eucalyptus.autoscaling.common.AutoScalingMetadata;
import com.eucalyptus.autoscaling.configurations.LaunchConfiguration;
import com.eucalyptus.autoscaling.groups.GroupScalingCause;
import com.eucalyptus.autoscaling.groups.HealthCheckType;
import com.eucalyptus.autoscaling.groups.MetricCollectionType;
import com.eucalyptus.autoscaling.groups.SuspendedProcess;
import com.eucalyptus.autoscaling.groups.TerminationPolicyType;
import com.eucalyptus.autoscaling.instances.AutoScalingInstance;
import com.eucalyptus.autoscaling.policies.ScalingPolicy;
import com.eucalyptus.autoscaling.tags.AutoScalingGroupTag;
import com.eucalyptus.entities.AbstractOwnedPersistent;
import com.eucalyptus.util.OwnerFullName;
import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import javax.persistence.CascadeType;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.MapKeyColumn;
import javax.persistence.OneToMany;
import javax.persistence.OrderColumn;
import javax.persistence.PersistenceContext;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

@Entity
@PersistenceContext(name="eucalyptus_autoscaling")
@Table(name="metadata_auto_scaling_groups")
@Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
public class AutoScalingGroup
extends AbstractOwnedPersistent
implements AutoScalingMetadata.AutoScalingGroupMetadata {
    private static final long serialVersionUID = 1L;
    @Column(name="metadata_max_size", nullable=false)
    private Integer maxSize;
    @Column(name="metadata_min_size", nullable=false)
    private Integer minSize;
    @ManyToOne(optional=false)
    @JoinColumn(name="metadata_launch_configuration_id")
    @Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
    private LaunchConfiguration launchConfiguration;
    @Column(name="metadata_capacity_timestamp", nullable=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date capacityTimestamp;
    @Column(name="metadata_default_cooldown", nullable=false)
    private Integer defaultCooldown;
    @Column(name="metadata_desired_capacity", nullable=false)
    private Integer desiredCapacity;
    @Column(name="metadata_capacity", nullable=false)
    private Integer capacity;
    @Column(name="metadata_scaling_required", nullable=false)
    private Boolean scalingRequired;
    @Column(name="metadata_health_check_grace_period")
    private Integer healthCheckGracePeriod;
    @Column(name="metadata_health_check_type", nullable=false)
    @Enumerated(value=EnumType.STRING)
    private HealthCheckType healthCheckType;
    @ElementCollection
    @CollectionTable(name="metadata_auto_scaling_group_availability_zones")
    @Column(name="metadata_availability_zone")
    @JoinColumn(name="metadata_auto_scaling_group_id")
    @OrderColumn(name="metadata_availability_zone_index")
    @Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
    private List<String> availabilityZones = Lists.newArrayList();
    @ElementCollection
    @CollectionTable(name="metadata_auto_scaling_group_zones_to_subnets")
    @MapKeyColumn(name="metadata_availability_zone")
    @Column(name="metadata_subnet_id")
    @JoinColumn(name="metadata_auto_scaling_group_id")
    @Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
    private Map<String, String> subnetIdByZone = Maps.newHashMap();
    @ElementCollection
    @CollectionTable(name="metadata_auto_scaling_group_termination_policies")
    @Column(name="metadata_termination_policy")
    @JoinColumn(name="metadata_auto_scaling_group_id")
    @OrderColumn(name="metadata_policy_index")
    @Enumerated(value=EnumType.STRING)
    @Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
    private List<TerminationPolicyType> terminationPolicies = Lists.newArrayList();
    @ElementCollection
    @CollectionTable(name="metadata_auto_scaling_group_load_balancers")
    @Column(name="metadata_load_balancer_name")
    @JoinColumn(name="metadata_auto_scaling_group_id")
    @OrderColumn(name="metadata_load_balancer_index")
    @Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
    private List<String> loadBalancerNames = Lists.newArrayList();
    @ElementCollection
    @CollectionTable(name="metadata_auto_scaling_group_suspended_processes")
    @JoinColumn(name="metadata_auto_scaling_group_id")
    @Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
    private Set<SuspendedProcess> suspendedProcesses = Sets.newHashSet();
    @ElementCollection
    @CollectionTable(name="metadata_auto_scaling_group_enabled_metrics")
    @Column(name="metadata_metric")
    @JoinColumn(name="metadata_auto_scaling_group_id")
    @Enumerated(value=EnumType.STRING)
    @Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
    private Set<MetricCollectionType> enabledMetrics = Sets.newHashSet();
    @ElementCollection
    @CollectionTable(name="metadata_auto_scaling_group_scaling_causes")
    @JoinColumn(name="metadata_auto_scaling_group_id")
    @OrderColumn(name="metadata_scaling_causes_index")
    @Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
    private List<GroupScalingCause> scalingCauses = Lists.newArrayList();
    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.REMOVE}, orphanRemoval=true, mappedBy="group")
    private Collection<ScalingActivity> scalingActivity;
    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.REMOVE}, orphanRemoval=true, mappedBy="group")
    private Collection<ScalingPolicy> scalingPolicies;
    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="group")
    private Collection<AutoScalingGroupTag> tags = Lists.newArrayList();
    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.REFRESH}, mappedBy="autoScalingGroup")
    private List<AutoScalingInstance> instances = Lists.newArrayList();

    protected AutoScalingGroup() {
    }

    protected AutoScalingGroup(@Nullable OwnerFullName owner) {
        super(owner);
    }

    protected AutoScalingGroup(OwnerFullName owner, String displayName) {
        super(owner, displayName);
    }

    public String getAutoScalingGroupName() {
        return this.getDisplayName();
    }

    public Integer getMaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(Integer maxSize) {
        this.maxSize = maxSize;
    }

    public Integer getMinSize() {
        return this.minSize;
    }

    public void setMinSize(Integer minSize) {
        this.minSize = minSize;
    }

    public LaunchConfiguration getLaunchConfiguration() {
        return this.launchConfiguration;
    }

    public void setLaunchConfiguration(LaunchConfiguration launchConfiguration) {
        this.launchConfiguration = launchConfiguration;
    }

    public Date getCapacityTimestamp() {
        return this.capacityTimestamp;
    }

    public void setCapacityTimestamp(Date capacityTimestamp) {
        this.capacityTimestamp = capacityTimestamp;
    }

    public Integer getDefaultCooldown() {
        return this.defaultCooldown;
    }

    public void setDefaultCooldown(Integer defaultCooldown) {
        this.defaultCooldown = defaultCooldown;
    }

    public Integer getDesiredCapacity() {
        return this.desiredCapacity;
    }

    public void setDesiredCapacity(Integer desiredCapacity) {
        this.desiredCapacity = desiredCapacity;
    }

    public Integer getCapacity() {
        return this.capacity;
    }

    public void setCapacity(Integer capacity) {
        this.capacity = capacity;
    }

    public Boolean getScalingRequired() {
        return this.scalingRequired;
    }

    public void setScalingRequired(Boolean scalingRequired) {
        this.scalingRequired = scalingRequired;
    }

    public Integer getHealthCheckGracePeriod() {
        return this.healthCheckGracePeriod;
    }

    public void setHealthCheckGracePeriod(Integer healthCheckGracePeriod) {
        this.healthCheckGracePeriod = healthCheckGracePeriod;
    }

    public HealthCheckType getHealthCheckType() {
        return this.healthCheckType;
    }

    public void setHealthCheckType(HealthCheckType healthCheckType) {
        this.healthCheckType = healthCheckType;
    }

    public List<String> getAvailabilityZones() {
        return this.availabilityZones;
    }

    public void setAvailabilityZones(List<String> availabilityZones) {
        this.availabilityZones = availabilityZones;
    }

    public Map<String, String> getSubnetIdByZone() {
        return this.subnetIdByZone;
    }

    public void setSubnetIdByZone(Map<String, String> subnetIdByZone) {
        this.subnetIdByZone = subnetIdByZone;
    }

    public List<TerminationPolicyType> getTerminationPolicies() {
        return this.terminationPolicies;
    }

    public void setTerminationPolicies(List<TerminationPolicyType> terminationPolicies) {
        this.terminationPolicies = terminationPolicies;
    }

    public List<String> getLoadBalancerNames() {
        return this.loadBalancerNames;
    }

    public void setLoadBalancerNames(List<String> loadBalancerNames) {
        this.loadBalancerNames = loadBalancerNames;
    }

    public Set<SuspendedProcess> getSuspendedProcesses() {
        return this.suspendedProcesses;
    }

    public void setSuspendedProcesses(Set<SuspendedProcess> suspendedProcesses) {
        this.suspendedProcesses = suspendedProcesses;
    }

    public Set<MetricCollectionType> getEnabledMetrics() {
        return this.enabledMetrics;
    }

    public void setEnabledMetrics(Set<MetricCollectionType> enabledMetrics) {
        this.enabledMetrics = enabledMetrics;
    }

    public List<GroupScalingCause> getScalingCauses() {
        return this.scalingCauses;
    }

    public void setScalingCauses(List<GroupScalingCause> scalingCauses) {
        this.scalingCauses = scalingCauses;
    }

    public List<AutoScalingInstance> getAutoScalingInstances() {
        return this.instances;
    }

    public void updateCapacity(int capacity) {
        this.scalingRequired = this.scalingRequired != false || this.desiredCapacity == null || capacity != this.desiredCapacity;
        this.capacity = capacity;
    }

    public void updateDesiredCapacity(int desiredCapacity, String reason) {
        if (!this.desiredCapacity.equals(desiredCapacity)) {
            this.scalingCauses.add(new GroupScalingCause(reason));
            while (this.scalingCauses.size() > 100) {
                this.scalingCauses.remove(0);
            }
        }
        this.scalingRequired = this.scalingRequired != false || this.capacity == null || !this.capacity.equals(desiredCapacity);
        this.desiredCapacity = desiredCapacity;
    }

    public void updateAvailabilityZones(List<String> availabilityZones) {
        HashSet newZones;
        HashSet currentZones = Sets.newHashSet(this.availabilityZones);
        if (!currentZones.equals(newZones = Sets.newHashSet(availabilityZones))) {
            String removedZones = Joiner.on((String)",").join((Iterable)Sets.difference((Set)currentZones, (Set)newZones));
            String addedZones = Joiner.on((String)",").join((Iterable)Sets.difference((Set)newZones, (Set)currentZones));
            this.scalingCauses.add(new GroupScalingCause(String.format("a user request removed the zones %1$s from this AutoScalingGroup making them invalid", removedZones)));
            this.scalingCauses.add(new GroupScalingCause(String.format("a user request added the zones %1$s to this AutoScalingGroup and the group may require rebalancing", addedZones)));
        }
        this.scalingRequired = this.scalingRequired != false || !currentZones.equals(newZones);
        this.availabilityZones = availabilityZones;
    }

    public String getArn() {
        return String.format("arn:aws:autoscaling::%1s:autoScalingGroup:%2s:autoScalingGroupName/%3s", this.getOwnerAccountNumber(), this.getNaturalId(), this.getDisplayName());
    }

    public static AutoScalingGroup withOwner(@Nullable OwnerFullName ownerFullName) {
        return new AutoScalingGroup(ownerFullName);
    }

    public static AutoScalingGroup named(OwnerFullName ownerFullName, String name) {
        return new AutoScalingGroup(ownerFullName, name);
    }

    public static AutoScalingGroup withId(String id) {
        AutoScalingGroup example = new AutoScalingGroup();
        example.setId(id);
        return example;
    }

    public static AutoScalingGroup withUuid(String uuid) {
        AutoScalingGroup example = new AutoScalingGroup();
        example.setNaturalId(uuid);
        return example;
    }

    public static AutoScalingGroup requiringScaling() {
        AutoScalingGroup example = new AutoScalingGroup();
        example.setScalingRequired(true);
        return example;
    }

    public static AutoScalingGroup create(OwnerFullName ownerFullName, String name, LaunchConfiguration launchConfiguration, Integer minSize, Integer maxSize, List<AutoScalingGroupTag> tags) {
        AutoScalingGroup autoScalingGroup = new AutoScalingGroup(ownerFullName, name);
        autoScalingGroup.setLaunchConfiguration(launchConfiguration);
        autoScalingGroup.setMinSize(minSize);
        autoScalingGroup.setMaxSize(maxSize);
        autoScalingGroup.setCapacity(0);
        for (AutoScalingGroupTag tag : tags) {
            tag.setGroup(autoScalingGroup);
            tag.setOwner(autoScalingGroup.getOwner());
            autoScalingGroup.tags.add(tag);
        }
        return autoScalingGroup;
    }

    @PrePersist
    @PreUpdate
    private void preUpdate() {
        if (this.capacityTimestamp == null) {
            this.capacityTimestamp = new Date();
        }
    }

    protected static abstract class BaseBuilder<T extends BaseBuilder<T>> {
        private OwnerFullName ownerFullName;
        private String name;
        private Integer minSize;
        private Integer maxSize;
        private Integer defaultCooldown;
        private Integer desiredCapacity;
        private Integer healthCheckGracePeriod;
        private HealthCheckType healthCheckType;
        private LaunchConfiguration launchConfiguration;
        private Set<String> availabilityZones = Sets.newLinkedHashSet();
        private Map<String, String> subnetsByZone = Maps.newHashMap();
        private Set<TerminationPolicyType> terminationPolicies = Sets.newLinkedHashSet();
        private Set<String> loadBalancerNames = Sets.newLinkedHashSet();
        private List<AutoScalingGroupTag> tags = Lists.newArrayList();

        BaseBuilder(OwnerFullName ownerFullName, String name, LaunchConfiguration launchConfiguration, Integer minSize, Integer maxSize) {
            this.ownerFullName = ownerFullName;
            this.name = name;
            this.launchConfiguration = launchConfiguration;
            this.minSize = minSize;
            this.maxSize = maxSize;
        }

        protected abstract T builder();

        public T withDefaultCooldown(Integer defaultCooldown) {
            this.defaultCooldown = defaultCooldown;
            return this.builder();
        }

        public T withDesiredCapacity(Integer desiredCapacity) {
            this.desiredCapacity = desiredCapacity;
            return this.builder();
        }

        public T withHealthCheckGracePeriod(Integer healthCheckGracePeriod) {
            this.healthCheckGracePeriod = healthCheckGracePeriod;
            return this.builder();
        }

        public T withHealthCheckType(HealthCheckType healthCheckType) {
            this.healthCheckType = healthCheckType;
            return this.builder();
        }

        public T withAvailabilityZones(Iterable<String> availabilityZones) {
            if (availabilityZones != null) {
                Iterables.addAll(this.availabilityZones, availabilityZones);
            }
            return this.builder();
        }

        public T withSubnetsByZone(Map<String, String> subnetsByZone) {
            if (subnetsByZone != null) {
                this.subnetsByZone.putAll(subnetsByZone);
            }
            return this.builder();
        }

        public T withTerminationPolicyTypes(Iterable<TerminationPolicyType> terminationPolicies) {
            if (terminationPolicies != null) {
                Iterables.addAll(this.terminationPolicies, terminationPolicies);
            }
            return this.builder();
        }

        public T withLoadBalancerNames(Iterable<String> loadBalancerNames) {
            if (loadBalancerNames != null) {
                Iterables.addAll(this.loadBalancerNames, loadBalancerNames);
            }
            return this.builder();
        }

        public T withTags(Iterable<AutoScalingGroupTag> tags) {
            if (tags != null) {
                Iterables.addAll(this.tags, tags);
            }
            return this.builder();
        }

        protected AutoScalingGroup build() {
            AutoScalingGroup group = AutoScalingGroup.create(this.ownerFullName, this.name, this.launchConfiguration, this.minSize, this.maxSize, this.tags);
            group.setDefaultCooldown((Integer)Objects.firstNonNull((Object)this.defaultCooldown, (Object)300));
            group.setDesiredCapacity((Integer)Objects.firstNonNull((Object)this.desiredCapacity, (Object)this.minSize));
            group.setHealthCheckGracePeriod((Integer)Objects.firstNonNull((Object)this.healthCheckGracePeriod, (Object)0));
            group.setHealthCheckType((HealthCheckType)((Object)Objects.firstNonNull((Object)((Object)this.healthCheckType), (Object)((Object)HealthCheckType.EC2))));
            group.setAvailabilityZones(Lists.newArrayList(this.availabilityZones));
            group.setSubnetIdByZone(Maps.newHashMap(this.subnetsByZone));
            group.setTerminationPolicies(this.terminationPolicies.isEmpty() ? Collections.singletonList(TerminationPolicyType.Default) : Lists.newArrayList(this.terminationPolicies));
            group.setLoadBalancerNames(Lists.newArrayList(this.loadBalancerNames));
            group.setScalingRequired(group.getDesiredCapacity() > 0);
            return group;
        }
    }
}

