/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.autoscaling.configurations;

import com.eucalyptus.autoscaling.common.AutoScalingMetadata;
import com.eucalyptus.autoscaling.common.AutoScalingResourceName;
import com.eucalyptus.autoscaling.configurations.LaunchConfiguration;
import com.eucalyptus.autoscaling.configurations.LaunchConfigurations;
import com.eucalyptus.autoscaling.metadata.AbstractOwnedPersistentsWithResourceNameSupport;
import com.eucalyptus.autoscaling.metadata.AutoScalingMetadataException;
import com.eucalyptus.component.annotation.ComponentNamed;
import com.eucalyptus.entities.AbstractPersistent;
import com.eucalyptus.util.OwnerFullName;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import java.util.List;

@ComponentNamed
public class PersistenceLaunchConfigurations
extends LaunchConfigurations {
    private PersistenceSupport persistenceSupport = new PersistenceSupport();

    @Override
    public <T> List<T> list(OwnerFullName ownerFullName, Predicate<? super LaunchConfiguration> filter, Function<? super LaunchConfiguration, T> transform) throws AutoScalingMetadataException {
        return this.persistenceSupport.list(ownerFullName, filter, transform);
    }

    @Override
    public <T> T lookup(OwnerFullName ownerFullName, String launchConfigurationNameOrArn, Function<? super LaunchConfiguration, T> transform) throws AutoScalingMetadataException {
        return this.persistenceSupport.lookup(ownerFullName, launchConfigurationNameOrArn, transform);
    }

    @Override
    public boolean delete(AutoScalingMetadata.LaunchConfigurationMetadata launchConfiguration) throws AutoScalingMetadataException {
        return this.persistenceSupport.delete((AutoScalingMetadata)launchConfiguration);
    }

    @Override
    public LaunchConfiguration save(LaunchConfiguration launchConfiguration) throws AutoScalingMetadataException {
        return (LaunchConfiguration)this.persistenceSupport.save((AbstractPersistent)launchConfiguration);
    }

    private static class PersistenceSupport
    extends AbstractOwnedPersistentsWithResourceNameSupport<LaunchConfiguration> {
        private PersistenceSupport() {
            super(AutoScalingResourceName.Type.launchConfiguration);
        }

        protected LaunchConfiguration exampleWithOwner(OwnerFullName ownerFullName) {
            return LaunchConfiguration.withOwner(ownerFullName);
        }

        protected LaunchConfiguration exampleWithName(OwnerFullName ownerFullName, String name) {
            return LaunchConfiguration.named(ownerFullName, name);
        }

        @Override
        protected LaunchConfiguration exampleWithUuid(String uuid) {
            return LaunchConfiguration.withUuid(uuid);
        }
    }
}

