/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.autoscaling.configurations;

import com.eucalyptus.autoscaling.common.AutoScalingMetadata;
import com.eucalyptus.autoscaling.common.backend.msgs.BlockDeviceMappingType;
import com.eucalyptus.autoscaling.common.backend.msgs.BlockDeviceMappings;
import com.eucalyptus.autoscaling.common.backend.msgs.InstanceMonitoring;
import com.eucalyptus.autoscaling.common.backend.msgs.LaunchConfigurationType;
import com.eucalyptus.autoscaling.common.backend.msgs.SecurityGroups;
import com.eucalyptus.autoscaling.configurations.BlockDeviceMapping;
import com.eucalyptus.autoscaling.configurations.LaunchConfiguration;
import com.eucalyptus.autoscaling.configurations.LaunchConfigurationCoreView;
import com.eucalyptus.autoscaling.configurations.LaunchConfigurationMinimumView;
import com.eucalyptus.autoscaling.metadata.AutoScalingMetadataException;
import com.eucalyptus.compute.common.BlockDeviceMappingItemType;
import com.eucalyptus.compute.common.EbsDeviceMapping;
import com.eucalyptus.compute.common.InstanceNetworkInterfaceSetItemRequestType;
import com.eucalyptus.compute.common.backend.RunInstancesType;
import com.eucalyptus.entities.Entities;
import com.eucalyptus.util.OwnerFullName;
import com.eucalyptus.util.RestrictedTypes;
import com.eucalyptus.util.TypeMapper;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityTransaction;

public abstract class LaunchConfigurations {
    public abstract <T> List<T> list(OwnerFullName var1, Predicate<? super LaunchConfiguration> var2, Function<? super LaunchConfiguration, T> var3) throws AutoScalingMetadataException;

    public abstract <T> T lookup(OwnerFullName var1, String var2, Function<? super LaunchConfiguration, T> var3) throws AutoScalingMetadataException;

    public abstract boolean delete(AutoScalingMetadata.LaunchConfigurationMetadata var1) throws AutoScalingMetadataException;

    public abstract LaunchConfiguration save(LaunchConfiguration var1) throws AutoScalingMetadataException;

    public final PersistingBuilder create(OwnerFullName ownerFullName, String launchConfigurationName, String imageId, String instanceType) {
        return new PersistingBuilder(this, ownerFullName, launchConfigurationName, imageId, instanceType);
    }

    public static boolean containsSecurityGroupIdentifiers(Iterable<String> groups) {
        return !Iterables.isEmpty(groups) && ((String)Iterables.get(groups, (int)0)).matches("sg-[0-9A-Fa-f]{8}");
    }

    @RestrictedTypes.QuantityMetricFunction(value=AutoScalingMetadata.LaunchConfigurationMetadata.class)
    public static enum CountLaunchConfigurations implements Function<OwnerFullName, Long>
    {
        INSTANCE;


        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Long apply(OwnerFullName input) {
            EntityTransaction db = Entities.get(LaunchConfiguration.class);
            try {
                Long l = Entities.count((Object)((Object)LaunchConfiguration.withOwner(input)));
                return l;
            }
            finally {
                db.rollback();
            }
        }
    }

    @TypeMapper
    public static enum LaunchConfigurationToRunInstances implements Function<LaunchConfigurationCoreView, RunInstancesType>
    {
        INSTANCE;


        public RunInstancesType apply(LaunchConfigurationCoreView launchConfiguration) {
            RunInstancesType runInstances = new RunInstancesType();
            runInstances.setKernelId(launchConfiguration.getKernelId());
            runInstances.setRamdiskId(launchConfiguration.getRamdiskId());
            runInstances.setImageId(launchConfiguration.getImageId());
            runInstances.setInstanceType(launchConfiguration.getInstanceType());
            runInstances.setMinCount(1);
            runInstances.setMaxCount(1);
            for (BlockDeviceMapping mapping : launchConfiguration.getBlockDeviceMappings()) {
                BlockDeviceMappingItemType type = new BlockDeviceMappingItemType();
                type.setDeviceName(mapping.getDeviceName());
                type.setVirtualName(mapping.getVirtualName());
                if (mapping.getSnapshotId() != null || mapping.getVolumeSize() != null) {
                    EbsDeviceMapping ebsType = new EbsDeviceMapping();
                    ebsType.setSnapshotId(mapping.getSnapshotId());
                    ebsType.setVolumeSize(mapping.getVolumeSize());
                    ebsType.setDeleteOnTermination(Boolean.valueOf(true));
                    type.setEbs(ebsType);
                }
                runInstances.getBlockDeviceMapping().add(type);
            }
            runInstances.setKeyName(launchConfiguration.getKeyName());
            ArrayList securityGroups = Lists.newArrayList(launchConfiguration.getSecurityGroups());
            if (launchConfiguration.getAssociatePublicIpAddress() != null) {
                InstanceNetworkInterfaceSetItemRequestType networkInterface = runInstances.primaryNetworkInterface(true);
                networkInterface.setAssociatePublicIpAddress(launchConfiguration.getAssociatePublicIpAddress());
                networkInterface.securityGroups((Iterable)securityGroups);
            } else if (LaunchConfigurations.containsSecurityGroupIdentifiers(securityGroups)) {
                runInstances.setGroupIdSet(securityGroups);
            } else {
                runInstances.setGroupSet(securityGroups);
            }
            runInstances.setMonitoring(launchConfiguration.getInstanceMonitoring());
            if (launchConfiguration.getIamInstanceProfile() != null) {
                runInstances.setInstanceProfileNameOrArn(launchConfiguration.getIamInstanceProfile());
            }
            runInstances.setUserData(launchConfiguration.getUserData());
            return runInstances;
        }
    }

    @TypeMapper
    public static enum BlockDeviceTransform implements Function<BlockDeviceMapping, BlockDeviceMappingType>
    {
        INSTANCE;


        public BlockDeviceMappingType apply(BlockDeviceMapping blockDeviceMapping) {
            return new BlockDeviceMappingType(blockDeviceMapping.getDeviceName(), blockDeviceMapping.getVirtualName(), blockDeviceMapping.getSnapshotId(), blockDeviceMapping.getVolumeSize());
        }
    }

    @TypeMapper
    public static enum LaunchConfigurationTransform implements Function<LaunchConfiguration, LaunchConfigurationType>
    {
        INSTANCE;


        public LaunchConfigurationType apply(LaunchConfiguration launchConfiguration) {
            LaunchConfigurationType type = new LaunchConfigurationType();
            type.setCreatedTime(launchConfiguration.getCreationTimestamp());
            type.setIamInstanceProfile(launchConfiguration.getIamInstanceProfile());
            type.setImageId(launchConfiguration.getImageId());
            type.setAssociatePublicIpAddress(launchConfiguration.getAssociatePublicIpAddress());
            if (launchConfiguration.getInstanceMonitoring() != null) {
                type.setInstanceMonitoring(new InstanceMonitoring(launchConfiguration.getInstanceMonitoring()));
            }
            type.setInstanceType(launchConfiguration.getInstanceType());
            type.setKernelId(launchConfiguration.getKernelId());
            type.setKeyName(launchConfiguration.getKeyName());
            type.setLaunchConfigurationARN(launchConfiguration.getArn());
            type.setLaunchConfigurationName(launchConfiguration.getLaunchConfigurationName());
            type.setRamdiskId(launchConfiguration.getRamdiskId());
            if (launchConfiguration.getSecurityGroups() != null && !launchConfiguration.getSecurityGroups().isEmpty()) {
                type.setSecurityGroups(new SecurityGroups(launchConfiguration.getSecurityGroups()));
            }
            type.setUserData(launchConfiguration.getUserData());
            if (launchConfiguration.getBlockDeviceMappings() != null && !launchConfiguration.getBlockDeviceMappings().isEmpty()) {
                type.setBlockDeviceMappings(new BlockDeviceMappings(Collections2.transform(launchConfiguration.getBlockDeviceMappings(), (Function)BlockDeviceTransform.INSTANCE)));
            }
            return type;
        }
    }

    @TypeMapper
    public static enum LaunchConfigurationMinimumViewTransform implements Function<LaunchConfiguration, LaunchConfigurationMinimumView>
    {
        INSTANCE;


        public LaunchConfigurationMinimumView apply(LaunchConfiguration launchConfiguration) {
            return new LaunchConfigurationMinimumView(launchConfiguration);
        }
    }

    @TypeMapper
    public static enum LaunchConfigurationCoreViewTransform implements Function<LaunchConfiguration, LaunchConfigurationCoreView>
    {
        INSTANCE;


        public LaunchConfigurationCoreView apply(LaunchConfiguration launchConfiguration) {
            return new LaunchConfigurationCoreView(launchConfiguration);
        }
    }

    public static class PersistingBuilder
    extends LaunchConfiguration.BaseBuilder<PersistingBuilder> {
        private final LaunchConfigurations launchConfigurations;

        PersistingBuilder(LaunchConfigurations launchConfigurations, OwnerFullName ownerFullName, String name, String imageId, String instanceType) {
            super(ownerFullName, name, imageId, instanceType);
            this.launchConfigurations = launchConfigurations;
        }

        @Override
        protected PersistingBuilder builder() {
            return this;
        }

        public LaunchConfiguration persist() throws AutoScalingMetadataException {
            return this.launchConfigurations.save(this.build());
        }
    }
}

