/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.autoscaling.configurations;

import com.eucalyptus.autoscaling.common.AutoScalingMetadata;
import com.eucalyptus.autoscaling.configurations.BlockDeviceMapping;
import com.eucalyptus.entities.AbstractOwnedPersistent;
import com.eucalyptus.util.OwnerFullName;
import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.OrderColumn;
import javax.persistence.PersistenceContext;
import javax.persistence.Table;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Type;

@Entity
@PersistenceContext(name="eucalyptus_autoscaling")
@Table(name="metadata_launch_configurations")
@Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
public class LaunchConfiguration
extends AbstractOwnedPersistent
implements AutoScalingMetadata.LaunchConfigurationMetadata {
    private static final long serialVersionUID = 1L;
    @Column(name="metadata_image_id", nullable=false)
    private String imageId;
    @Column(name="metadata_kernel_id")
    private String kernelId;
    @Column(name="metadata_ramdisk_id")
    private String ramdiskId;
    @Column(name="metadata_key_name")
    private String keyName;
    @ElementCollection
    @CollectionTable(name="metadata_launch_configuration_security_groups")
    @Column(name="metadata_security_group")
    @JoinColumn(name="metadata_launch_configuration_id")
    @OrderColumn(name="metadata_security_group_index")
    @Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
    private List<String> securityGroups = Lists.newArrayList();
    @Column(name="metadata_user_data")
    @Lob
    @Type(type="org.hibernate.type.StringClobType")
    private String userData;
    @Column(name="metadata_instance_type", nullable=false)
    private String instanceType;
    @ElementCollection
    @CollectionTable(name="metadata_launch_configuration_block_device_mappings")
    @JoinColumn(name="metadata_launch_configuration_id")
    @OrderColumn(name="metadata_device_mapping_index")
    @Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
    private List<BlockDeviceMapping> blockDeviceMappings = Lists.newArrayList();
    @Column(name="metadata_associate_public_ip")
    private Boolean associatePublicIpAddress;
    @Column(name="metadata_instance_monitoring")
    private Boolean instanceMonitoring;
    @Column(name="metadata_instance_profile", length=1600)
    private String iamInstanceProfile;

    protected LaunchConfiguration() {
    }

    protected LaunchConfiguration(OwnerFullName owner) {
        super(owner);
    }

    protected LaunchConfiguration(OwnerFullName owner, String displayName) {
        super(owner, displayName);
    }

    public String getLaunchConfigurationName() {
        return this.getDisplayName();
    }

    public String getImageId() {
        return this.imageId;
    }

    public void setImageId(String imageId) {
        this.imageId = imageId;
    }

    public String getKernelId() {
        return this.kernelId;
    }

    public void setKernelId(String kernelId) {
        this.kernelId = kernelId;
    }

    public String getRamdiskId() {
        return this.ramdiskId;
    }

    public void setRamdiskId(String ramdiskId) {
        this.ramdiskId = ramdiskId;
    }

    public String getKeyName() {
        return this.keyName;
    }

    public void setKeyName(String keyName) {
        this.keyName = keyName;
    }

    public List<String> getSecurityGroups() {
        return this.securityGroups;
    }

    public void setSecurityGroups(List<String> securityGroups) {
        this.securityGroups = securityGroups;
    }

    public String getUserData() {
        return this.userData;
    }

    public void setUserData(String userData) {
        this.userData = userData;
    }

    public String getInstanceType() {
        return this.instanceType;
    }

    public void setInstanceType(String instanceType) {
        this.instanceType = instanceType;
    }

    public List<BlockDeviceMapping> getBlockDeviceMappings() {
        return this.blockDeviceMappings;
    }

    public void setBlockDeviceMappings(List<BlockDeviceMapping> blockDeviceMappings) {
        this.blockDeviceMappings = blockDeviceMappings;
    }

    public Boolean getAssociatePublicIpAddress() {
        return this.associatePublicIpAddress;
    }

    public void setAssociatePublicIpAddress(Boolean associatePublicIpAddress) {
        this.associatePublicIpAddress = associatePublicIpAddress;
    }

    public Boolean getInstanceMonitoring() {
        return this.instanceMonitoring;
    }

    public void setInstanceMonitoring(Boolean instanceMonitoring) {
        this.instanceMonitoring = instanceMonitoring;
    }

    public String getIamInstanceProfile() {
        return this.iamInstanceProfile;
    }

    public void setIamInstanceProfile(String iamInstanceProfile) {
        this.iamInstanceProfile = iamInstanceProfile;
    }

    public String getArn() {
        return String.format("arn:aws:autoscaling::%1s:launchConfiguration:%2s:launchConfigurationName/%3s", this.getOwnerAccountNumber(), this.getNaturalId(), this.getDisplayName());
    }

    public static LaunchConfiguration withOwner(OwnerFullName ownerFullName) {
        return new LaunchConfiguration(ownerFullName);
    }

    public static LaunchConfiguration named(OwnerFullName ownerFullName, String name) {
        return new LaunchConfiguration(ownerFullName, name);
    }

    public static LaunchConfiguration withId(String id) {
        LaunchConfiguration example = new LaunchConfiguration();
        example.setId(id);
        return example;
    }

    public static LaunchConfiguration withUuid(String uuid) {
        LaunchConfiguration example = new LaunchConfiguration();
        example.setNaturalId(uuid);
        return example;
    }

    public static LaunchConfiguration create(OwnerFullName ownerFullName, String name, String imageId, String instanceType) {
        LaunchConfiguration launchConfiguration = new LaunchConfiguration(ownerFullName, name);
        launchConfiguration.setImageId(imageId);
        launchConfiguration.setInstanceType(instanceType);
        return launchConfiguration;
    }

    protected static abstract class BaseBuilder<T extends BaseBuilder<T>> {
        private OwnerFullName ownerFullName;
        private String name;
        private String instanceType;
        private String imageId;
        private String kernelId;
        private String ramdiskId;
        private String keyName;
        private String userData;
        private Boolean associatePublicIpAddress;
        private Boolean instanceMonitoring;
        private String iamInstanceProfile;
        private Set<String> securityGroups = Sets.newLinkedHashSet();
        private Set<BlockDeviceMapping> blockDeviceMappings = Sets.newLinkedHashSet();

        BaseBuilder(OwnerFullName ownerFullName, String name, String imageId, String instanceType) {
            this.ownerFullName = ownerFullName;
            this.name = name;
            this.imageId = imageId;
            this.instanceType = instanceType;
        }

        protected abstract T builder();

        public T withKernelId(String kernelId) {
            this.kernelId = kernelId;
            return this.builder();
        }

        public T withRamdiskId(String ramdiskId) {
            this.ramdiskId = ramdiskId;
            return this.builder();
        }

        public T withKeyName(String keyName) {
            this.keyName = keyName;
            return this.builder();
        }

        public T withUserData(String userData) {
            this.userData = userData;
            return this.builder();
        }

        public T withAssociatePublicIpAddress(Boolean associatePublicIpAddress) {
            this.associatePublicIpAddress = associatePublicIpAddress;
            return this.builder();
        }

        public T withInstanceMonitoring(Boolean instanceMonitoring) {
            this.instanceMonitoring = instanceMonitoring;
            return this.builder();
        }

        public T withInstanceProfile(String iamInstanceProfile) {
            this.iamInstanceProfile = iamInstanceProfile;
            return this.builder();
        }

        public T withSecurityGroups(Collection<String> securityGroups) {
            if (securityGroups != null) {
                this.securityGroups.addAll(securityGroups);
            }
            return this.builder();
        }

        public T withBlockDeviceMapping(String deviceName, String virtualName, String snapshotId, Integer volumeSize) {
            this.blockDeviceMappings.add(new BlockDeviceMapping(deviceName, virtualName, snapshotId, volumeSize));
            return this.builder();
        }

        protected LaunchConfiguration build() {
            LaunchConfiguration configuration = LaunchConfiguration.create(this.ownerFullName, this.name, this.imageId, this.instanceType);
            configuration.setKernelId(this.kernelId);
            configuration.setRamdiskId(this.ramdiskId);
            configuration.setKeyName(this.keyName);
            configuration.setUserData(this.userData);
            configuration.setAssociatePublicIpAddress(this.associatePublicIpAddress);
            configuration.setInstanceMonitoring((Boolean)Objects.firstNonNull((Object)this.instanceMonitoring, (Object)Boolean.TRUE));
            configuration.setIamInstanceProfile(this.iamInstanceProfile);
            configuration.setSecurityGroups(Lists.newArrayList(this.securityGroups));
            configuration.setBlockDeviceMappings(Lists.newArrayList(this.blockDeviceMappings));
            return configuration;
        }
    }
}

