/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.autoscaling.config;

import com.eucalyptus.autoscaling.activities.ActivityManager;
import com.eucalyptus.autoscaling.groups.ScalingProcessType;
import com.eucalyptus.configurable.ConfigurableClass;
import com.eucalyptus.configurable.ConfigurableField;
import com.eucalyptus.configurable.ConfigurableProperty;
import com.eucalyptus.configurable.ConfigurablePropertyException;
import com.eucalyptus.configurable.PropertyChangeListener;
import com.eucalyptus.util.Intervals;
import com.google.common.base.Enums;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.lang.reflect.Field;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.log4j.Logger;

@ConfigurableClass(root="autoscaling", description="Parameters controlling auto scaling")
public class AutoScalingConfiguration {
    private static final Logger logger = Logger.getLogger(AutoScalingConfiguration.class);
    @ConfigurableField(initial="5m", description="Timeout for a scaling activity.", changeListener=AutoScalingIntervalPropertyChangeListener.class)
    public static volatile String activityTimeout = "5m";
    @ConfigurableField(initial="42d", description="Expiry age for scaling activities. Older activities are deleted.", changeListener=AutoScalingIntervalPropertyChangeListener.class)
    public static volatile String activityExpiry = "42d";
    @ConfigurableField(initial="20", description="Maximum instances to launch at one time.")
    public static volatile int maxLaunchIncrement = 20;
    @ConfigurableField(initial="5", description="Number of times to attempt load balancer registration for each instance.")
    public static volatile int maxRegistrationRetries = 5;
    @ConfigurableField(initial="5m", description="Time after which an unavailable zone should be treated as failed", changeListener=AutoScalingIntervalPropertyChangeListener.class)
    public static volatile String zoneFailureThreshold = "5m";
    @ConfigurableField(initial="1d", description="Timeout for administrative suspension of scaling activities for a group.", changeListener=AutoScalingIntervalPropertyChangeListener.class)
    public static volatile String suspensionTimeout = "1d";
    @ConfigurableField(initial="15", description="Minimum launch attempts for administrative suspension of scaling activities for a group.")
    public static volatile int suspensionLaunchAttemptsThreshold = 15;
    @ConfigurableField(initial="", description="Globally suspended scaling processes.", changeListener=AutoScalingSuspendedProcessesPropertyChangeListener.class)
    public static volatile String suspendedProcesses = "";
    @ConfigurableField(initial="", description="Suspended scaling tasks.", changeListener=AutoScalingSuspendedTasksPropertyChangeListener.class)
    public static volatile String suspendedTasks = "";
    @ConfigurableField(initial="5m", description="Timeout for termination of untracked auto scaling instances.")
    public static volatile String untrackedInstanceTimeout = "5m";
    @ConfigurableField(initial="15m", description="Timeout for a pending instance.", changeListener=AutoScalingIntervalPropertyChangeListener.class)
    public static volatile String pendingInstanceTimeout = "15m";
    @ConfigurableField(initial="15m", description="Maximum backoff period for failing activities.", changeListener=AutoScalingIntervalPropertyChangeListener.class)
    public static volatile String activityMaxBackoff = "15m";
    @ConfigurableField(initial="9s", description="Initial backoff period for failing activities.", changeListener=AutoScalingIntervalPropertyChangeListener.class)
    public static volatile String activityInitialBackoff = "9s";
    private static AtomicLong activityTimeoutMillis = new AtomicLong(Intervals.parse((String)activityTimeout, (long)TimeUnit.MINUTES.toMillis(5L)));
    private static AtomicLong activityExpiryMillis = new AtomicLong(Intervals.parse((String)activityExpiry, (long)TimeUnit.DAYS.toMillis(42L)));
    private static AtomicLong zoneFailureThresholdMillis = new AtomicLong(Intervals.parse((String)zoneFailureThreshold, (long)TimeUnit.MINUTES.toMillis(5L)));
    private static AtomicLong suspensionTimeoutMillis = new AtomicLong(Intervals.parse((String)suspensionTimeout, (long)TimeUnit.DAYS.toMillis(1L)));
    private static AtomicLong untrackedInstanceTimeoutMillis = new AtomicLong(Intervals.parse((String)untrackedInstanceTimeout, (long)TimeUnit.MINUTES.toMillis(5L)));
    private static AtomicLong pendingInstanceTimeoutMillis = new AtomicLong(Intervals.parse((String)pendingInstanceTimeout, (long)TimeUnit.MINUTES.toMillis(15L)));
    private static AtomicLong activityMaxBackoffMillis = new AtomicLong(Intervals.parse((String)activityMaxBackoff, (long)TimeUnit.MINUTES.toMillis(15L)));
    private static AtomicLong activityInitialBackoffMillis = new AtomicLong(Intervals.parse((String)activityInitialBackoff, (long)TimeUnit.SECONDS.toMillis(9L)));
    private static AtomicReference<EnumSet<ScalingProcessType>> suspendedProcessesSet = new AtomicReference<EnumSet<ScalingProcessType>>(AutoScalingConfiguration.toEnumSet(ScalingProcessType.class, suspendedProcesses));
    private static AtomicReference<EnumSet<ActivityManager.ActivityTask>> suspendedTasksSet = new AtomicReference<EnumSet<ActivityManager.ActivityTask>>(AutoScalingConfiguration.toEnumSet(ActivityManager.ActivityTask.class, suspendedTasks));

    public static int getMaxLaunchIncrement() {
        return maxLaunchIncrement;
    }

    public static int getMaxRegistrationRetries() {
        return maxRegistrationRetries;
    }

    public static int getSuspensionLaunchAttemptsThreshold() {
        return suspensionLaunchAttemptsThreshold;
    }

    public static long getActivityTimeoutMillis() {
        return activityTimeoutMillis.get();
    }

    public static long getActivityExpiryMillis() {
        return activityExpiryMillis.get();
    }

    public static long getZoneFailureThresholdMillis() {
        return zoneFailureThresholdMillis.get();
    }

    public static long getSuspensionTimeoutMillis() {
        return suspensionTimeoutMillis.get();
    }

    public static long getUntrackedInstanceTimeoutMillis() {
        return untrackedInstanceTimeoutMillis.get();
    }

    public static long getPendingInstanceTimeoutMillis() {
        return pendingInstanceTimeoutMillis.get();
    }

    public static long getActivityMaxBackoffMillis() {
        return activityMaxBackoffMillis.get();
    }

    public static long getActivityInitialBackoffMillis() {
        return activityInitialBackoffMillis.get();
    }

    public static EnumSet<ScalingProcessType> getSuspendedProcesses() {
        return suspendedProcessesSet.get();
    }

    public static EnumSet<ActivityManager.ActivityTask> getSuspendedTasks() {
        return suspendedTasksSet.get();
    }

    private static <E extends Enum<E>> EnumSet<E> toEnumSet(Class<E> enumClass, String text) {
        ArrayList values = Lists.newArrayList((Iterable)Iterables.filter((Iterable)Iterables.transform((Iterable)Splitter.on((String)",").omitEmptyStrings().trimResults().split((CharSequence)text), (Function)Enums.valueOfFunction(enumClass)), (Predicate)Predicates.notNull()));
        return values.isEmpty() ? EnumSet.noneOf(enumClass) : EnumSet.copyOf(values);
    }

    public static final class AutoScalingSuspendedTasksPropertyChangeListener
    implements PropertyChangeListener {
        public void fireChange(ConfigurableProperty configurableProperty, Object newValue) throws ConfigurablePropertyException {
            EnumSet activityTasks = AutoScalingConfiguration.toEnumSet(ActivityManager.ActivityTask.class, String.valueOf(newValue));
            logger.info((Object)("Suspended auto scaling activity tasks updated: " + activityTasks));
            suspendedTasksSet.set(activityTasks);
        }
    }

    public static final class AutoScalingSuspendedProcessesPropertyChangeListener
    implements PropertyChangeListener {
        public void fireChange(ConfigurableProperty configurableProperty, Object newValue) throws ConfigurablePropertyException {
            EnumSet scalingProcessTypes = AutoScalingConfiguration.toEnumSet(ScalingProcessType.class, String.valueOf(newValue));
            logger.info((Object)("Suspended auto scaling processes updated: " + scalingProcessTypes));
            suspendedProcessesSet.set(scalingProcessTypes);
        }
    }

    public static final class AutoScalingIntervalPropertyChangeListener
    implements PropertyChangeListener {
        public void fireChange(ConfigurableProperty configurableProperty, Object newValue) throws ConfigurablePropertyException {
            try {
                String fieldName = configurableProperty.getField().getName() + "Millis";
                Field field = AutoScalingConfiguration.class.getDeclaredField(fieldName);
                long defaultValue = Intervals.parse((String)configurableProperty.getDefaultValue());
                long value = Intervals.parse((String)String.valueOf(newValue), (long)defaultValue);
                field.setAccessible(true);
                logger.info((Object)("Auto scaling configuration updated " + field.getName() + ": " + value + "ms"));
                ((AtomicLong)field.get(null)).set(value);
            }
            catch (NoSuchFieldException e) {
                logger.error((Object)e, (Throwable)e);
            }
            catch (ParseException e) {
                logger.error((Object)e, (Throwable)e);
            }
            catch (IllegalAccessException e) {
                logger.error((Object)e, (Throwable)e);
            }
        }
    }
}

