/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.autoscaling.backend;

import com.eucalyptus.auth.AuthContextSupplier;
import com.eucalyptus.auth.AuthQuotaException;
import com.eucalyptus.auth.Permissions;
import com.eucalyptus.auth.policy.PolicySpec;
import com.eucalyptus.auth.principal.Account;
import com.eucalyptus.auth.principal.AccountFullName;
import com.eucalyptus.auth.principal.UserFullName;
import com.eucalyptus.autoscaling.activities.ActivityManager;
import com.eucalyptus.autoscaling.activities.ScalingActivities;
import com.eucalyptus.autoscaling.activities.ScalingActivity;
import com.eucalyptus.autoscaling.backend.AlreadyExistsException;
import com.eucalyptus.autoscaling.backend.AutoScalingException;
import com.eucalyptus.autoscaling.backend.InternalFailureException;
import com.eucalyptus.autoscaling.backend.LimitExceededException;
import com.eucalyptus.autoscaling.backend.ResourceInUseException;
import com.eucalyptus.autoscaling.backend.ScalingActivityInProgressException;
import com.eucalyptus.autoscaling.backend.ValidationErrorException;
import com.eucalyptus.autoscaling.common.AutoScalingMetadata;
import com.eucalyptus.autoscaling.common.AutoScalingMetadatas;
import com.eucalyptus.autoscaling.common.AutoScalingResourceName;
import com.eucalyptus.autoscaling.common.backend.msgs.Activity;
import com.eucalyptus.autoscaling.common.backend.msgs.AdjustmentTypes;
import com.eucalyptus.autoscaling.common.backend.msgs.Alarms;
import com.eucalyptus.autoscaling.common.backend.msgs.AutoScalingGroupType;
import com.eucalyptus.autoscaling.common.backend.msgs.AutoScalingInstanceDetails;
import com.eucalyptus.autoscaling.common.backend.msgs.BlockDeviceMappingType;
import com.eucalyptus.autoscaling.common.backend.msgs.CreateAutoScalingGroupResponseType;
import com.eucalyptus.autoscaling.common.backend.msgs.CreateAutoScalingGroupType;
import com.eucalyptus.autoscaling.common.backend.msgs.CreateLaunchConfigurationResponseType;
import com.eucalyptus.autoscaling.common.backend.msgs.CreateLaunchConfigurationType;
import com.eucalyptus.autoscaling.common.backend.msgs.CreateOrUpdateTagsResponseType;
import com.eucalyptus.autoscaling.common.backend.msgs.CreateOrUpdateTagsType;
import com.eucalyptus.autoscaling.common.backend.msgs.DeleteAutoScalingGroupResponseType;
import com.eucalyptus.autoscaling.common.backend.msgs.DeleteAutoScalingGroupType;
import com.eucalyptus.autoscaling.common.backend.msgs.DeleteLaunchConfigurationResponseType;
import com.eucalyptus.autoscaling.common.backend.msgs.DeleteLaunchConfigurationType;
import com.eucalyptus.autoscaling.common.backend.msgs.DeleteNotificationConfigurationResponseType;
import com.eucalyptus.autoscaling.common.backend.msgs.DeleteNotificationConfigurationType;
import com.eucalyptus.autoscaling.common.backend.msgs.DeletePolicyResponseType;
import com.eucalyptus.autoscaling.common.backend.msgs.DeletePolicyType;
import com.eucalyptus.autoscaling.common.backend.msgs.DeleteScheduledActionResponseType;
import com.eucalyptus.autoscaling.common.backend.msgs.DeleteScheduledActionType;
import com.eucalyptus.autoscaling.common.backend.msgs.DeleteTagsResponseType;
import com.eucalyptus.autoscaling.common.backend.msgs.DeleteTagsType;
import com.eucalyptus.autoscaling.common.backend.msgs.DescribeAdjustmentTypesResponseType;
import com.eucalyptus.autoscaling.common.backend.msgs.DescribeAdjustmentTypesType;
import com.eucalyptus.autoscaling.common.backend.msgs.DescribeAutoScalingGroupsResponseType;
import com.eucalyptus.autoscaling.common.backend.msgs.DescribeAutoScalingGroupsType;
import com.eucalyptus.autoscaling.common.backend.msgs.DescribeAutoScalingInstancesResponseType;
import com.eucalyptus.autoscaling.common.backend.msgs.DescribeAutoScalingInstancesType;
import com.eucalyptus.autoscaling.common.backend.msgs.DescribeAutoScalingNotificationTypesResponseType;
import com.eucalyptus.autoscaling.common.backend.msgs.DescribeAutoScalingNotificationTypesType;
import com.eucalyptus.autoscaling.common.backend.msgs.DescribeLaunchConfigurationsResponseType;
import com.eucalyptus.autoscaling.common.backend.msgs.DescribeLaunchConfigurationsType;
import com.eucalyptus.autoscaling.common.backend.msgs.DescribeMetricCollectionTypesResponseType;
import com.eucalyptus.autoscaling.common.backend.msgs.DescribeMetricCollectionTypesType;
import com.eucalyptus.autoscaling.common.backend.msgs.DescribeNotificationConfigurationsResponseType;
import com.eucalyptus.autoscaling.common.backend.msgs.DescribeNotificationConfigurationsType;
import com.eucalyptus.autoscaling.common.backend.msgs.DescribePoliciesResponseType;
import com.eucalyptus.autoscaling.common.backend.msgs.DescribePoliciesType;
import com.eucalyptus.autoscaling.common.backend.msgs.DescribeScalingActivitiesResponseType;
import com.eucalyptus.autoscaling.common.backend.msgs.DescribeScalingActivitiesType;
import com.eucalyptus.autoscaling.common.backend.msgs.DescribeScalingProcessTypesResponseType;
import com.eucalyptus.autoscaling.common.backend.msgs.DescribeScalingProcessTypesType;
import com.eucalyptus.autoscaling.common.backend.msgs.DescribeScheduledActionsResponseType;
import com.eucalyptus.autoscaling.common.backend.msgs.DescribeScheduledActionsType;
import com.eucalyptus.autoscaling.common.backend.msgs.DescribeTagsResponseType;
import com.eucalyptus.autoscaling.common.backend.msgs.DescribeTagsType;
import com.eucalyptus.autoscaling.common.backend.msgs.DescribeTerminationPolicyTypesResponseType;
import com.eucalyptus.autoscaling.common.backend.msgs.DescribeTerminationPolicyTypesType;
import com.eucalyptus.autoscaling.common.backend.msgs.DisableMetricsCollectionResponseType;
import com.eucalyptus.autoscaling.common.backend.msgs.DisableMetricsCollectionType;
import com.eucalyptus.autoscaling.common.backend.msgs.EnableMetricsCollectionResponseType;
import com.eucalyptus.autoscaling.common.backend.msgs.EnableMetricsCollectionType;
import com.eucalyptus.autoscaling.common.backend.msgs.ExecutePolicyResponseType;
import com.eucalyptus.autoscaling.common.backend.msgs.ExecutePolicyType;
import com.eucalyptus.autoscaling.common.backend.msgs.Filter;
import com.eucalyptus.autoscaling.common.backend.msgs.LaunchConfigurationType;
import com.eucalyptus.autoscaling.common.backend.msgs.MetricCollectionTypes;
import com.eucalyptus.autoscaling.common.backend.msgs.MetricGranularityType;
import com.eucalyptus.autoscaling.common.backend.msgs.MetricGranularityTypes;
import com.eucalyptus.autoscaling.common.backend.msgs.ProcessType;
import com.eucalyptus.autoscaling.common.backend.msgs.PutNotificationConfigurationResponseType;
import com.eucalyptus.autoscaling.common.backend.msgs.PutNotificationConfigurationType;
import com.eucalyptus.autoscaling.common.backend.msgs.PutScalingPolicyResponseType;
import com.eucalyptus.autoscaling.common.backend.msgs.PutScalingPolicyType;
import com.eucalyptus.autoscaling.common.backend.msgs.PutScheduledUpdateGroupActionResponseType;
import com.eucalyptus.autoscaling.common.backend.msgs.PutScheduledUpdateGroupActionType;
import com.eucalyptus.autoscaling.common.backend.msgs.ResumeProcessesResponseType;
import com.eucalyptus.autoscaling.common.backend.msgs.ResumeProcessesType;
import com.eucalyptus.autoscaling.common.backend.msgs.ScalingPolicyType;
import com.eucalyptus.autoscaling.common.backend.msgs.SetDesiredCapacityResponseType;
import com.eucalyptus.autoscaling.common.backend.msgs.SetDesiredCapacityType;
import com.eucalyptus.autoscaling.common.backend.msgs.SetInstanceHealthResponseType;
import com.eucalyptus.autoscaling.common.backend.msgs.SetInstanceHealthType;
import com.eucalyptus.autoscaling.common.backend.msgs.SuspendProcessesResponseType;
import com.eucalyptus.autoscaling.common.backend.msgs.SuspendProcessesType;
import com.eucalyptus.autoscaling.common.backend.msgs.TagDescription;
import com.eucalyptus.autoscaling.common.backend.msgs.TagDescriptionList;
import com.eucalyptus.autoscaling.common.backend.msgs.TagType;
import com.eucalyptus.autoscaling.common.backend.msgs.TerminateInstanceInAutoScalingGroupResponseType;
import com.eucalyptus.autoscaling.common.backend.msgs.TerminateInstanceInAutoScalingGroupType;
import com.eucalyptus.autoscaling.common.backend.msgs.UpdateAutoScalingGroupResponseType;
import com.eucalyptus.autoscaling.common.backend.msgs.UpdateAutoScalingGroupType;
import com.eucalyptus.autoscaling.config.AutoScalingConfiguration;
import com.eucalyptus.autoscaling.configurations.LaunchConfiguration;
import com.eucalyptus.autoscaling.configurations.LaunchConfigurationMinimumView;
import com.eucalyptus.autoscaling.configurations.LaunchConfigurations;
import com.eucalyptus.autoscaling.groups.AutoScalingGroup;
import com.eucalyptus.autoscaling.groups.AutoScalingGroupCoreView;
import com.eucalyptus.autoscaling.groups.AutoScalingGroupMinimumView;
import com.eucalyptus.autoscaling.groups.AutoScalingGroups;
import com.eucalyptus.autoscaling.groups.HealthCheckType;
import com.eucalyptus.autoscaling.groups.MetricCollectionType;
import com.eucalyptus.autoscaling.groups.ScalingProcessType;
import com.eucalyptus.autoscaling.groups.SuspendedProcess;
import com.eucalyptus.autoscaling.groups.TerminationPolicyType;
import com.eucalyptus.autoscaling.instances.AutoScalingInstance;
import com.eucalyptus.autoscaling.instances.AutoScalingInstanceGroupView;
import com.eucalyptus.autoscaling.instances.AutoScalingInstances;
import com.eucalyptus.autoscaling.instances.HealthStatus;
import com.eucalyptus.autoscaling.metadata.AutoScalingMetadataException;
import com.eucalyptus.autoscaling.metadata.AutoScalingMetadataNotFoundException;
import com.eucalyptus.autoscaling.policies.AdjustmentType;
import com.eucalyptus.autoscaling.policies.ScalingPolicies;
import com.eucalyptus.autoscaling.policies.ScalingPolicy;
import com.eucalyptus.autoscaling.policies.ScalingPolicyView;
import com.eucalyptus.autoscaling.tags.AutoScalingGroupTag;
import com.eucalyptus.autoscaling.tags.Tag;
import com.eucalyptus.autoscaling.tags.TagSupport;
import com.eucalyptus.autoscaling.tags.Tags;
import com.eucalyptus.component.annotation.ComponentNamed;
import com.eucalyptus.context.Context;
import com.eucalyptus.context.Contexts;
import com.eucalyptus.entities.AbstractOwnedPersistent;
import com.eucalyptus.entities.Entities;
import com.eucalyptus.entities.TransactionException;
import com.eucalyptus.records.Logs;
import com.eucalyptus.util.Callback;
import com.eucalyptus.util.Consumer;
import com.eucalyptus.util.Consumers;
import com.eucalyptus.util.EucalyptusCloudException;
import com.eucalyptus.util.Exceptions;
import com.eucalyptus.util.Numbers;
import com.eucalyptus.util.OwnerFullName;
import com.eucalyptus.util.RestrictedTypes;
import com.eucalyptus.util.TypeMappers;
import com.google.common.base.Enums;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.base.Supplier;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.hibernate.exception.ConstraintViolationException;

@ComponentNamed
public class AutoScalingBackendService {
    private static final Logger logger = Logger.getLogger(AutoScalingBackendService.class);
    private static final Set<String> reservedPrefixes = ImmutableSet.builder().add((Object)"aws:").add((Object)"euca:").build();
    private static final Map<String, Function<Tag, String>> tagFilterExtractors = ImmutableMap.builder().put((Object)"auto-scaling-group", Tags.resourceId()).put((Object)"key", Tags.key()).put((Object)"value", Tags.value()).put((Object)"propagate-at-launch", Tags.propagateAtLaunch()).build();
    private static final Map<String, Function<String, String>> tagValuePreProcessors = ImmutableMap.builder().put((Object)"propagate-at-launch", (Object)com.eucalyptus.util.Strings.lower()).build();
    public static long MAX_TAGS_PER_RESOURCE = 10L;
    private final LaunchConfigurations launchConfigurations;
    private final AutoScalingGroups autoScalingGroups;
    private final AutoScalingInstances autoScalingInstances;
    private final ScalingPolicies scalingPolicies;
    private final ActivityManager activityManager;
    private final ScalingActivities scalingActivities;

    @Inject
    public AutoScalingBackendService(LaunchConfigurations launchConfigurations, AutoScalingGroups autoScalingGroups, AutoScalingInstances autoScalingInstances, ScalingPolicies scalingPolicies, ActivityManager activityManager, ScalingActivities scalingActivities) {
        this.launchConfigurations = launchConfigurations;
        this.autoScalingGroups = autoScalingGroups;
        this.autoScalingInstances = autoScalingInstances;
        this.scalingPolicies = scalingPolicies;
        this.activityManager = activityManager;
        this.scalingActivities = scalingActivities;
    }

    public DescribeAutoScalingGroupsResponseType describeAutoScalingGroups(DescribeAutoScalingGroupsType request) throws EucalyptusCloudException {
        DescribeAutoScalingGroupsResponseType reply = (DescribeAutoScalingGroupsResponseType)request.getReply();
        Context ctx = Contexts.lookup();
        boolean showAll = request.autoScalingGroupNames().remove("verbose");
        AccountFullName ownerFullName = ctx.isAdministrator() && showAll ? null : ctx.getUserFullName().asAccountFullName();
        Predicate requestedAndAccessible = AutoScalingMetadatas.filterPrivilegesByIdOrArn(AutoScalingMetadata.AutoScalingGroupMetadata.class, (Collection)request.autoScalingGroupNames());
        try {
            ArrayList results = reply.getDescribeAutoScalingGroupsResult().getAutoScalingGroups().getMember();
            results.addAll(this.autoScalingGroups.list((OwnerFullName)ownerFullName, (Predicate<? super AutoScalingGroup>)requestedAndAccessible, TypeMappers.lookup(AutoScalingGroup.class, AutoScalingGroupType.class)));
            Map<String, List<Tag>> tagsMap = TagSupport.forResourceClass(AutoScalingGroup.class).getResourceTagMap((OwnerFullName)ctx.getUserFullName().asAccountFullName(), Iterables.transform((Iterable)results, (Function)AutoScalingGroupType.groupName()), (Predicate<? super Tag>)Predicates.alwaysTrue());
            for (AutoScalingGroupType type : results) {
                TagDescriptionList tags = new TagDescriptionList();
                Tags.addFromTags(tags.getMember(), TagDescription.class, (Iterable<Tag>)tagsMap.get(type.getAutoScalingGroupName()));
                if (tags.getMember().isEmpty()) continue;
                type.setTags(tags);
            }
        }
        catch (Exception e) {
            AutoScalingBackendService.handleException(e);
        }
        return reply;
    }

    public EnableMetricsCollectionResponseType enableMetricsCollection(final EnableMetricsCollectionType request) throws EucalyptusCloudException {
        EnableMetricsCollectionResponseType reply = (EnableMetricsCollectionResponseType)request.getReply();
        Context ctx = Contexts.lookup();
        try {
            AccountFullName accountFullName = ctx.getUserFullName().asAccountFullName();
            Callback<AutoScalingGroup> groupCallback = new Callback<AutoScalingGroup>(){

                public void fire(AutoScalingGroup autoScalingGroup) {
                    if (RestrictedTypes.filterPrivileged().apply((Object)autoScalingGroup)) {
                        EnumSet<MetricCollectionType> metricsToEnable = EnumSet.allOf(MetricCollectionType.class);
                        if (request.getMetrics() != null && !request.getMetrics().getMember().isEmpty()) {
                            metricsToEnable.clear();
                            Iterables.addAll(metricsToEnable, (Iterable)Iterables.transform((Iterable)request.getMetrics().getMember(), (Function)Enums.valueOfFunction(MetricCollectionType.class)));
                        }
                        autoScalingGroup.getEnabledMetrics().addAll(metricsToEnable);
                    }
                }
            };
            this.autoScalingGroups.update((OwnerFullName)accountFullName, request.getAutoScalingGroupName(), groupCallback);
        }
        catch (AutoScalingMetadataNotFoundException e) {
            throw new ValidationErrorException("Auto scaling group not found: " + request.getAutoScalingGroupName());
        }
        catch (Exception e) {
            AutoScalingBackendService.handleException(e);
        }
        return reply;
    }

    public ResumeProcessesResponseType resumeProcesses(final ResumeProcessesType request) throws EucalyptusCloudException {
        ResumeProcessesResponseType reply = (ResumeProcessesResponseType)request.getReply();
        Context ctx = Contexts.lookup();
        try {
            AccountFullName accountFullName = ctx.getUserFullName().asAccountFullName();
            Callback<AutoScalingGroup> groupCallback = new Callback<AutoScalingGroup>(){

                public void fire(AutoScalingGroup autoScalingGroup) {
                    if (RestrictedTypes.filterPrivileged().apply((Object)autoScalingGroup)) {
                        EnumSet<ScalingProcessType> processesToResume = EnumSet.allOf(ScalingProcessType.class);
                        if (request.getScalingProcesses() != null && !request.getScalingProcesses().getMember().isEmpty()) {
                            processesToResume.clear();
                            Iterables.addAll(processesToResume, (Iterable)Iterables.transform((Iterable)request.getScalingProcesses().getMember(), (Function)Enums.valueOfFunction(ScalingProcessType.class)));
                        }
                        for (ScalingProcessType scalingProcessType : processesToResume) {
                            autoScalingGroup.getSuspendedProcesses().remove(SuspendedProcess.createManual(scalingProcessType));
                        }
                    }
                }
            };
            this.autoScalingGroups.update((OwnerFullName)accountFullName, request.getAutoScalingGroupName(), groupCallback);
        }
        catch (AutoScalingMetadataNotFoundException e) {
            throw new ValidationErrorException("Auto scaling group not found: " + request.getAutoScalingGroupName());
        }
        catch (Exception e) {
            AutoScalingBackendService.handleException(e);
        }
        return reply;
    }

    public DeleteLaunchConfigurationResponseType deleteLaunchConfiguration(DeleteLaunchConfigurationType request) throws EucalyptusCloudException {
        DeleteLaunchConfigurationResponseType reply = (DeleteLaunchConfigurationResponseType)request.getReply();
        Context ctx = Contexts.lookup();
        try {
            LaunchConfigurationMinimumView launchConfiguration = (LaunchConfigurationMinimumView)this.launchConfigurations.lookup((OwnerFullName)ctx.getUserFullName().asAccountFullName(), request.getLaunchConfigurationName(), TypeMappers.lookup(LaunchConfiguration.class, LaunchConfigurationMinimumView.class));
            if (RestrictedTypes.filterPrivileged().apply((Object)launchConfiguration)) {
                this.launchConfigurations.delete(launchConfiguration);
            }
        }
        catch (AutoScalingMetadataNotFoundException launchConfiguration) {
        }
        catch (Exception e) {
            AutoScalingBackendService.handleException(e);
        }
        return reply;
    }

    public DescribePoliciesResponseType describePolicies(DescribePoliciesType request) throws EucalyptusCloudException {
        DescribePoliciesResponseType reply = (DescribePoliciesResponseType)request.getReply();
        Context ctx = Contexts.lookup();
        boolean showAll = request.policyNames().remove("verbose");
        AccountFullName ownerFullName = ctx.isAdministrator() && showAll ? null : ctx.getUserFullName().asAccountFullName();
        try {
            Predicate requestedAndAccessible = Predicates.and((Predicate)AutoScalingMetadatas.filterPrivilegesByIdOrArn(ScalingPolicy.class, (Collection)request.policyNames()), (Predicate)(AutoScalingResourceName.isResourceName().apply((Object)request.getAutoScalingGroupName()) ? AutoScalingMetadatas.filterByProperty((String)AutoScalingResourceName.parse((String)request.getAutoScalingGroupName(), (AutoScalingResourceName.Type)AutoScalingResourceName.Type.autoScalingGroup).getUuid(), ScalingPolicies.toGroupUuid()) : AutoScalingMetadatas.filterByProperty((String)request.getAutoScalingGroupName(), ScalingPolicies.toGroupName())));
            ArrayList results = reply.getDescribePoliciesResult().getScalingPolicies().getMember();
            results.addAll(this.scalingPolicies.list((OwnerFullName)ownerFullName, (Predicate<? super ScalingPolicy>)requestedAndAccessible, TypeMappers.lookup(ScalingPolicy.class, ScalingPolicyType.class)));
            List scalingPolicyArns = Lists.transform((List)results, (Function)ScalingPolicyType.policyArn());
            Map<String, Collection<String>> policyArnToAlarmArns = this.activityManager.getAlarmsForPolicies((OwnerFullName)ctx.getUserFullName(), scalingPolicyArns);
            for (ScalingPolicyType scalingPolicyType : results) {
                Collection<String> alarmArns = policyArnToAlarmArns.get(scalingPolicyType.getPolicyARN());
                if (alarmArns == null || alarmArns.isEmpty()) continue;
                scalingPolicyType.setAlarms(new Alarms(alarmArns));
            }
        }
        catch (Exception e) {
            AutoScalingBackendService.handleException(e);
        }
        return reply;
    }

    public DescribeScalingProcessTypesResponseType describeScalingProcessTypes(DescribeScalingProcessTypesType request) throws EucalyptusCloudException {
        DescribeScalingProcessTypesResponseType reply = (DescribeScalingProcessTypesResponseType)request.getReply();
        ArrayList policies = reply.getDescribeScalingProcessTypesResult().getProcesses().getMember();
        policies.addAll(Collections2.transform((Collection)Collections2.filter(EnumSet.allOf(ScalingProcessType.class), (Predicate)RestrictedTypes.filterPrivilegedWithoutOwner()), (Function)TypeMappers.lookup(ScalingProcessType.class, ProcessType.class)));
        return reply;
    }

    public CreateAutoScalingGroupResponseType createAutoScalingGroup(final CreateAutoScalingGroupType request) throws EucalyptusCloudException {
        CreateAutoScalingGroupResponseType reply = (CreateAutoScalingGroupResponseType)request.getReply();
        final Context ctx = Contexts.lookup();
        if (request.getTags() != null) {
            for (TagType tagType : request.getTags().getMember()) {
                String key = tagType.getKey();
                if (!Strings.isNullOrEmpty((String)key) && key.trim().length() <= 128 && !AutoScalingBackendService.isReserved(key)) continue;
                throw new ValidationErrorException("Invalid key (max length 128, must not be empty, reserved prefixes " + reservedPrefixes + "): " + key);
            }
            if ((long)request.getTags().getMember().size() > MAX_TAGS_PER_RESOURCE) {
                throw Exceptions.toUndeclared((Throwable)((Object)new LimitExceededException("Tag limit exceeded")));
            }
        }
        Supplier<AutoScalingGroup> allocator = new Supplier<AutoScalingGroup>(){

            public AutoScalingGroup get() {
                try {
                    Integer minSize = Numbers.intValue((Number)request.getMinSize());
                    Integer maxSize = Numbers.intValue((Number)request.getMaxSize());
                    Integer desiredCapacity = Numbers.intValue((Number)request.getDesiredCapacity());
                    if (desiredCapacity != null && desiredCapacity < minSize) {
                        throw Exceptions.toUndeclared((Throwable)((Object)new ValidationErrorException("DesiredCapacity must not be less than MinSize")));
                    }
                    if (desiredCapacity != null && desiredCapacity > maxSize) {
                        throw Exceptions.toUndeclared((Throwable)((Object)new ValidationErrorException("DesiredCapacity must not be greater than MaxSize")));
                    }
                    Iterable subnetIds = Splitter.on((char)',').trimResults().omitEmptyStrings().split((CharSequence)Strings.nullToEmpty((String)request.getVpcZoneIdentifier()));
                    AtomicReference subnetsByZone = new AtomicReference();
                    List<String> referenceErrors = AutoScalingBackendService.this.activityManager.validateReferences((OwnerFullName)ctx.getUserFullName(), (Consumer<? super Map<String, String>>)Consumers.atomic(subnetsByZone), request.availabilityZones(), request.loadBalancerNames(), subnetIds);
                    AutoScalingBackendService.verifyUnsupportedReferences(referenceErrors, request.getPlacementGroup());
                    if (!referenceErrors.isEmpty()) {
                        throw Exceptions.toUndeclared((Throwable)((Object)new ValidationErrorException("Invalid parameters " + referenceErrors)));
                    }
                    AccountFullName accountFullName = ctx.getUserFullName().asAccountFullName();
                    AutoScalingGroups.PersistingBuilder builder = (AutoScalingGroups.PersistingBuilder)((AutoScalingGroups.PersistingBuilder)((AutoScalingGroups.PersistingBuilder)((AutoScalingGroups.PersistingBuilder)((AutoScalingGroups.PersistingBuilder)((AutoScalingGroups.PersistingBuilder)((AutoScalingGroups.PersistingBuilder)((AutoScalingGroups.PersistingBuilder)((AutoScalingGroups.PersistingBuilder)AutoScalingBackendService.this.autoScalingGroups.create((OwnerFullName)ctx.getUserFullName(), request.getAutoScalingGroupName(), (LaunchConfiguration)AutoScalingBackendService.verifyOwnership((OwnerFullName)accountFullName, (AbstractOwnedPersistent)AutoScalingBackendService.this.launchConfigurations.lookup((OwnerFullName)accountFullName, request.getLaunchConfigurationName(), Functions.identity())), minSize, maxSize).withAvailabilityZones(request.availabilityZones() != null && !request.availabilityZones().isEmpty() ? request.availabilityZones() : (subnetsByZone.get() == null ? null : ((Map)subnetsByZone.get()).keySet()))).withSubnetsByZone((Map)subnetsByZone.get())).withDefaultCooldown(Numbers.intValue((Number)request.getDefaultCooldown()))).withDesiredCapacity(desiredCapacity)).withHealthCheckGracePeriod(Numbers.intValue((Number)request.getHealthCheckGracePeriod()))).withHealthCheckType(request.getHealthCheckType() == null ? null : HealthCheckType.valueOf(request.getHealthCheckType()))).withLoadBalancerNames(request.loadBalancerNames())).withTerminationPolicyTypes(request.terminationPolicies() == null ? null : Collections2.filter((Collection)Collections2.transform((Collection)request.terminationPolicies(), (Function)Enums.valueOfFunction(TerminationPolicyType.class)), (Predicate)Predicates.not((Predicate)Predicates.isNull())))).withTags(request.getTags() == null ? null : Iterables.transform((Iterable)request.getTags().getMember(), (Function)TypeMappers.lookup(TagType.class, AutoScalingGroupTag.class)));
                    return builder.persist();
                }
                catch (AutoScalingMetadataNotFoundException e) {
                    throw Exceptions.toUndeclared((Throwable)((Object)new ValidationErrorException("Launch configuration not found: " + request.getLaunchConfigurationName())));
                }
                catch (IllegalArgumentException e) {
                    throw Exceptions.toUndeclared((Throwable)((Object)new ValidationErrorException("Invalid health check type: " + request.getHealthCheckType())));
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            }
        };
        try {
            RestrictedTypes.allocateUnitlessResource((Supplier)allocator);
        }
        catch (Exception e) {
            AutoScalingBackendService.handleException(e, true);
        }
        return reply;
    }

    public DescribeScalingActivitiesResponseType describeScalingActivities(DescribeScalingActivitiesType request) throws EucalyptusCloudException {
        DescribeScalingActivitiesResponseType reply = (DescribeScalingActivitiesResponseType)request.getReply();
        Context ctx = Contexts.lookup();
        boolean showAll = request.activityIds().remove("verbose");
        AccountFullName ownerFullName = ctx.isAdministrator() && showAll ? null : ctx.getUserFullName().asAccountFullName();
        try {
            AutoScalingGroupMinimumView group = Strings.isNullOrEmpty((String)request.getAutoScalingGroupName()) ? null : (AutoScalingGroupMinimumView)this.autoScalingGroups.lookup((OwnerFullName)ownerFullName, request.getAutoScalingGroupName(), TypeMappers.lookup(AutoScalingGroup.class, AutoScalingGroupMinimumView.class));
            List scalingActivities = this.scalingActivities.list((OwnerFullName)ownerFullName, group, request.activityIds(), (Predicate<? super ScalingActivity>)AutoScalingMetadatas.filteringFor(ScalingActivity.class).byPrivileges().buildPredicate(), TypeMappers.lookup(ScalingActivity.class, Activity.class));
            Collections.sort(scalingActivities, Ordering.natural().reverse().onResultOf(Activity.startTime()));
            reply.getDescribeScalingActivitiesResult().getActivities().getMember().addAll(scalingActivities);
        }
        catch (AutoScalingMetadataNotFoundException e) {
            throw new ValidationErrorException("Auto scaling group not found: " + request.getAutoScalingGroupName());
        }
        catch (AutoScalingMetadataException e) {
            AutoScalingBackendService.handleException(e);
        }
        return reply;
    }

    public DescribeNotificationConfigurationsResponseType describeNotificationConfigurations(DescribeNotificationConfigurationsType request) throws EucalyptusCloudException {
        DescribeNotificationConfigurationsResponseType reply = (DescribeNotificationConfigurationsResponseType)request.getReply();
        return reply;
    }

    public DescribeTerminationPolicyTypesResponseType describeTerminationPolicyTypes(DescribeTerminationPolicyTypesType request) throws EucalyptusCloudException {
        DescribeTerminationPolicyTypesResponseType reply = (DescribeTerminationPolicyTypesResponseType)request.getReply();
        ArrayList policies = reply.getDescribeTerminationPolicyTypesResult().getTerminationPolicyTypes().getMember();
        policies.addAll(Collections2.transform((Collection)Collections2.filter(EnumSet.allOf(TerminationPolicyType.class), (Predicate)RestrictedTypes.filterPrivilegedWithoutOwner()), (Function)com.eucalyptus.util.Strings.toStringFunction()));
        return reply;
    }

    public DescribeTagsResponseType describeTags(DescribeTagsType request) throws EucalyptusCloudException {
        DescribeTagsResponseType reply = (DescribeTagsResponseType)request.getReply();
        ArrayList tagFilters = Lists.newArrayList();
        for (Filter filter : request.filters()) {
            Function<Tag, String> extractor = tagFilterExtractors.get(filter.getName());
            if (extractor == null) {
                throw new ValidationErrorException("Filter type " + filter.getName() + " is not correct. Allowed Filter types are: auto-scaling-group key value propagate-at-launch");
            }
            Function tagValueConverter = (Function)Objects.firstNonNull(tagValuePreProcessors.get(filter.getName()), (Object)Functions.identity());
            tagFilters.add(Predicates.compose((Predicate)Predicates.in((Collection)Collections2.transform((Collection)filter.values(), (Function)tagValueConverter)), extractor));
        }
        Context context = Contexts.lookup();
        Ordering ordering = Ordering.natural().onResultOf(Tags.resourceId()).compound((Comparator)Ordering.natural().onResultOf(Tags.key())).compound((Comparator)Ordering.natural().onResultOf(Tags.value()));
        try {
            TagDescriptionList tagDescriptions = new TagDescriptionList();
            for (Tag tag : ordering.sortedCopy(Tags.list((OwnerFullName)context.getUserFullName().asAccountFullName(), (Predicate<? super Tag>)Predicates.and((Iterable)tagFilters), (Criterion)Restrictions.conjunction(), Collections.emptyMap()))) {
                if (!Permissions.isAuthorized((String)"autoscaling", (String)tag.getResourceType(), (String)tag.getKey(), (Account)context.getAccount(), (String)PolicySpec.describeAction((String)"autoscaling", (String)tag.getResourceType()), (AuthContextSupplier)context.getAuthContext())) continue;
                tagDescriptions.getMember().add(TypeMappers.transform((Object)((Object)tag), TagDescription.class));
            }
            if (!tagDescriptions.getMember().isEmpty()) {
                reply.getDescribeTagsResult().setTags(tagDescriptions);
            }
        }
        catch (AutoScalingMetadataNotFoundException e) {
            AutoScalingBackendService.handleException(e);
        }
        return reply;
    }

    public ExecutePolicyResponseType executePolicy(final ExecutePolicyType request) throws EucalyptusCloudException {
        ExecutePolicyResponseType reply = (ExecutePolicyResponseType)request.getReply();
        Context ctx = Contexts.lookup();
        AccountFullName accountFullName = ctx.getUserFullName().asAccountFullName();
        try {
            ScalingPolicyView scalingPolicy;
            try {
                scalingPolicy = (ScalingPolicyView)this.scalingPolicies.lookup((OwnerFullName)accountFullName, request.getAutoScalingGroupName(), request.getPolicyName(), TypeMappers.lookup(ScalingPolicy.class, ScalingPolicyView.class));
            }
            catch (AutoScalingMetadataNotFoundException e) {
                throw new ValidationErrorException("Scaling policy not found: " + request.getPolicyName());
            }
            Callback<AutoScalingGroup> updateCallback = new Callback<AutoScalingGroup>(){

                public void fire(AutoScalingGroup autoScalingGroup) {
                    boolean isCloudWatch = Contexts.lookup().isPrivileged();
                    if (isCloudWatch && !AutoScalingBackendService.scalingProcessEnabled(ScalingProcessType.AlarmNotification, autoScalingGroup)) {
                        logger.debug((Object)"Ignoring policy execution due to alarm notification suspension");
                        return;
                    }
                    AutoScalingBackendService.failIfScaling(AutoScalingBackendService.this.activityManager, autoScalingGroup);
                    Integer desiredCapacity = scalingPolicy.getAdjustmentType().adjustCapacity(autoScalingGroup.getDesiredCapacity(), scalingPolicy.getScalingAdjustment(), (Integer)Objects.firstNonNull((Object)scalingPolicy.getMinAdjustmentStep(), (Object)0), (Integer)Objects.firstNonNull((Object)autoScalingGroup.getMinSize(), (Object)0), (Integer)Objects.firstNonNull((Object)autoScalingGroup.getMaxSize(), (Object)Integer.MAX_VALUE));
                    AutoScalingBackendService.setDesiredCapacityWithCooldown(autoScalingGroup, request.getHonorCooldown(), scalingPolicy.getCooldown(), desiredCapacity, String.format(isCloudWatch ? "a CloudWatch alarm triggered policy %1$s changing the desired capacity from %2$d to %3$d" : "a user request executed policy %1$s changing the desired capacity from %2$d to %3$d", scalingPolicy.getDisplayName(), autoScalingGroup.getDesiredCapacity(), desiredCapacity));
                }
            };
            if (RestrictedTypes.filterPrivileged().apply((Object)scalingPolicy)) {
                this.autoScalingGroups.update((OwnerFullName)AccountFullName.getInstance((String)scalingPolicy.getOwnerAccountNumber(), (String[])new String[0]), scalingPolicy.getAutoScalingGroupName(), updateCallback);
            }
        }
        catch (Exception e) {
            AutoScalingBackendService.handleException(e);
        }
        return reply;
    }

    public DeleteTagsResponseType deleteTags(DeleteTagsType request) throws EucalyptusCloudException {
        DeleteTagsResponseType reply = (DeleteTagsResponseType)request.getReply();
        Context context = Contexts.lookup();
        AccountFullName ownerFullName = context.getUserFullName().asAccountFullName();
        final List tagTypes = (List)Objects.firstNonNull((Object)request.getTags().getMember(), Collections.emptyList());
        for (TagType tagType : tagTypes) {
            String key = tagType.getKey();
            if (!Strings.isNullOrEmpty((String)key) && key.trim().length() <= 128 && !AutoScalingBackendService.isReserved(key)) continue;
            throw new ValidationErrorException("Invalid key (max length 128, must not be empty, reserved prefixes " + reservedPrefixes + "): " + key);
        }
        if (tagTypes.size() > 0) {
            Predicate<Void> delete = new Predicate<Void>((OwnerFullName)ownerFullName, context){
                final /* synthetic */ OwnerFullName val$ownerFullName;
                final /* synthetic */ Context val$context;
                {
                    this.val$ownerFullName = ownerFullName;
                    this.val$context = context;
                }

                public boolean apply(Void v) {
                    for (TagType tagType : tagTypes) {
                        try {
                            AutoScalingMetadata resource;
                            TagSupport tagSupport = TagSupport.fromResourceType(tagType.getResourceType());
                            Tag example = tagSupport.example(resource = tagSupport.lookup(this.val$ownerFullName, tagType.getResourceId()), this.val$ownerFullName, tagType.getKey(), tagType.getValue());
                            if (example == null || !Permissions.isAuthorized((String)"autoscaling", (String)"tag", (String)(example.getResourceType() + ":" + example.getResourceId() + ":" + example.getKey()), (Account)this.val$context.getAccount(), (String)"deletetags", (AuthContextSupplier)this.val$context.getAuthContext())) continue;
                            Tags.delete(example);
                        }
                        catch (AutoScalingMetadataNotFoundException e) {
                            logger.debug((Object)e, (Throwable)e);
                        }
                        catch (TransactionException e) {
                            throw Exceptions.toUndeclared((Throwable)e);
                        }
                    }
                    return true;
                }
            };
            try {
                Entities.asTransaction(Tag.class, (Predicate)delete).apply(null);
            }
            catch (Exception e) {
                AutoScalingBackendService.handleException(e);
            }
        }
        return reply;
    }

    public PutScalingPolicyResponseType putScalingPolicy(final PutScalingPolicyType request) throws EucalyptusCloudException {
        PutScalingPolicyResponseType reply = (PutScalingPolicyResponseType)request.getReply();
        final Context ctx = Contexts.lookup();
        final AccountFullName accountFullName = ctx.getUserFullName().asAccountFullName();
        try {
            ScalingPolicy scalingPolicy = this.scalingPolicies.update((OwnerFullName)accountFullName, request.getAutoScalingGroupName(), request.getPolicyName(), new Callback<ScalingPolicy>(){

                public void fire(ScalingPolicy scalingPolicy) {
                    if (RestrictedTypes.filterPrivileged().apply((Object)scalingPolicy)) {
                        if (request.getAdjustmentType() != null) {
                            scalingPolicy.setAdjustmentType((AdjustmentType)((Object)Enums.valueOfFunction(AdjustmentType.class).apply((Object)request.getAdjustmentType())));
                        }
                        if (request.getScalingAdjustment() != null) {
                            if (AdjustmentType.ExactCapacity == scalingPolicy.getAdjustmentType() && request.getScalingAdjustment() < 0) {
                                throw Exceptions.toUndeclared((Throwable)((Object)new ValidationErrorException("ScalingAdjustment cannot be negative with the specified adjustment type.")));
                            }
                            scalingPolicy.setScalingAdjustment(request.getScalingAdjustment());
                        }
                        if (request.getCooldown() != null) {
                            scalingPolicy.setCooldown(request.getCooldown());
                        }
                        if (request.getMinAdjustmentStep() != null) {
                            if (AdjustmentType.PercentChangeInCapacity != scalingPolicy.getAdjustmentType()) {
                                throw Exceptions.toUndeclared((Throwable)((Object)new ValidationErrorException("MinAdjustmentStep is not supported by the specified adjustment type.")));
                            }
                            scalingPolicy.setMinAdjustmentStep(request.getMinAdjustmentStep());
                        }
                    }
                }
            });
            reply.getPutScalingPolicyResult().setPolicyARN(scalingPolicy.getArn());
        }
        catch (AutoScalingMetadataNotFoundException e) {
            Supplier<ScalingPolicy> allocator = new Supplier<ScalingPolicy>(){

                public ScalingPolicy get() {
                    try {
                        AdjustmentType adjustmentType = (AdjustmentType)((Object)Enums.valueOfFunction(AdjustmentType.class).apply((Object)request.getAdjustmentType()));
                        if (request.getMinAdjustmentStep() != null && AdjustmentType.PercentChangeInCapacity != adjustmentType) {
                            throw Exceptions.toUndeclared((Throwable)((Object)new ValidationErrorException("MinAdjustmentStep is not supported by the specified adjustment type.")));
                        }
                        if (AdjustmentType.ExactCapacity == adjustmentType && request.getScalingAdjustment() < 0) {
                            throw Exceptions.toUndeclared((Throwable)((Object)new ValidationErrorException("ScalingAdjustment cannot be negative with the specified adjustment type.")));
                        }
                        ScalingPolicies.PersistingBuilder builder = (ScalingPolicies.PersistingBuilder)((ScalingPolicies.PersistingBuilder)AutoScalingBackendService.this.scalingPolicies.create((OwnerFullName)ctx.getUserFullName(), (AutoScalingGroup)AutoScalingBackendService.verifyOwnership((OwnerFullName)accountFullName, (AbstractOwnedPersistent)AutoScalingBackendService.this.autoScalingGroups.lookup((OwnerFullName)accountFullName, request.getAutoScalingGroupName(), Functions.identity())), request.getPolicyName(), adjustmentType, request.getScalingAdjustment()).withCooldown(request.getCooldown())).withMinAdjustmentStep(request.getMinAdjustmentStep());
                        return builder.persist();
                    }
                    catch (AutoScalingMetadataNotFoundException e) {
                        throw Exceptions.toUndeclared((Throwable)((Object)new ValidationErrorException("Auto scaling group not found: " + request.getAutoScalingGroupName())));
                    }
                    catch (IllegalArgumentException e) {
                        throw Exceptions.toUndeclared((Throwable)((Object)new ValidationErrorException("Invalid adjustment type: " + request.getAdjustmentType())));
                    }
                    catch (Exception ex) {
                        throw new RuntimeException(ex);
                    }
                }
            };
            try {
                ScalingPolicy scalingPolicy = (ScalingPolicy)RestrictedTypes.allocateUnitlessResource((Supplier)allocator);
                reply.getPutScalingPolicyResult().setPolicyARN(scalingPolicy.getArn());
            }
            catch (Exception exception) {
                AutoScalingBackendService.handleException(exception, true);
            }
        }
        catch (Exception e) {
            AutoScalingBackendService.handleException(e);
        }
        return reply;
    }

    public PutNotificationConfigurationResponseType putNotificationConfiguration(PutNotificationConfigurationType request) throws EucalyptusCloudException {
        PutNotificationConfigurationResponseType reply = (PutNotificationConfigurationResponseType)request.getReply();
        return reply;
    }

    public DeletePolicyResponseType deletePolicy(DeletePolicyType request) throws EucalyptusCloudException {
        DeletePolicyResponseType reply = (DeletePolicyResponseType)request.getReply();
        Context ctx = Contexts.lookup();
        try {
            ScalingPolicyView scalingPolicy = (ScalingPolicyView)this.scalingPolicies.lookup((OwnerFullName)ctx.getUserFullName().asAccountFullName(), request.getAutoScalingGroupName(), request.getPolicyName(), TypeMappers.lookup(ScalingPolicy.class, ScalingPolicyView.class));
            if (RestrictedTypes.filterPrivileged().apply((Object)scalingPolicy)) {
                this.scalingPolicies.delete(scalingPolicy);
            }
        }
        catch (AutoScalingMetadataNotFoundException scalingPolicy) {
        }
        catch (Exception e) {
            AutoScalingBackendService.handleException(e);
        }
        return reply;
    }

    public DeleteNotificationConfigurationResponseType deleteNotificationConfiguration(DeleteNotificationConfigurationType request) throws EucalyptusCloudException {
        DeleteNotificationConfigurationResponseType reply = (DeleteNotificationConfigurationResponseType)request.getReply();
        return reply;
    }

    public DeleteScheduledActionResponseType deleteScheduledAction(DeleteScheduledActionType request) throws EucalyptusCloudException {
        DeleteScheduledActionResponseType reply = (DeleteScheduledActionResponseType)request.getReply();
        return reply;
    }

    public SetInstanceHealthResponseType setInstanceHealth(final SetInstanceHealthType request) throws EucalyptusCloudException {
        SetInstanceHealthResponseType reply = (SetInstanceHealthResponseType)request.getReply();
        Context ctx = Contexts.lookup();
        AccountFullName ownerFullName = ctx.isAdministrator() ? null : ctx.getUserFullName().asAccountFullName();
        try {
            Callback<AutoScalingInstance> instanceUpdateCallback = new Callback<AutoScalingInstance>(){

                public void fire(AutoScalingInstance instance) {
                    if (RestrictedTypes.filterPrivileged().apply((Object)instance)) {
                        if (!((Boolean)Objects.firstNonNull((Object)request.getShouldRespectGracePeriod(), (Object)Boolean.FALSE)).booleanValue() || instance.healthStatusGracePeriodExpired()) {
                            instance.setHealthStatus((HealthStatus)((Object)Enums.valueOfFunction(HealthStatus.class).apply((Object)request.getHealthStatus())));
                        }
                    } else {
                        throw Exceptions.toUndeclared((Throwable)new AutoScalingMetadataNotFoundException("Instance not found"));
                    }
                }
            };
            this.autoScalingInstances.update((OwnerFullName)ownerFullName, request.getInstanceId(), instanceUpdateCallback);
        }
        catch (AutoScalingMetadataNotFoundException e) {
            throw new ValidationErrorException("Auto scaling instance not found: " + request.getInstanceId());
        }
        catch (Exception e) {
            AutoScalingBackendService.handleException(e);
        }
        return reply;
    }

    public DescribeAutoScalingNotificationTypesResponseType describeAutoScalingNotificationTypes(DescribeAutoScalingNotificationTypesType request) throws EucalyptusCloudException {
        DescribeAutoScalingNotificationTypesResponseType reply = (DescribeAutoScalingNotificationTypesResponseType)request.getReply();
        return reply;
    }

    public CreateOrUpdateTagsResponseType createOrUpdateTags(final CreateOrUpdateTagsType request) throws EucalyptusCloudException {
        CreateOrUpdateTagsResponseType reply = (CreateOrUpdateTagsResponseType)request.getReply();
        Context context = Contexts.lookup();
        final UserFullName ownerFullName = context.getUserFullName();
        final AccountFullName accountFullName = ownerFullName.asAccountFullName();
        for (TagType tagType : request.getTags().getMember()) {
            String key = tagType.getKey();
            String value = Strings.nullToEmpty((String)tagType.getValue()).trim();
            if (Strings.isNullOrEmpty((String)key) || key.trim().length() > 128 || AutoScalingBackendService.isReserved(key)) {
                throw new ValidationErrorException("Invalid key (max length 128, must not be empty, reserved prefixes " + reservedPrefixes + "): " + key);
            }
            if (value.length() <= 256 && !AutoScalingBackendService.isReserved(key)) continue;
            throw new ValidationErrorException("Invalid value (max length 256, reserved prefixes " + reservedPrefixes + "): " + value);
        }
        if (request.getTags().getMember().size() > 0) {
            Predicate<Void> creator = new Predicate<Void>(){

                public boolean apply(Void v) {
                    try {
                        for (TagType tagType : request.getTags().getMember()) {
                            TagSupport tagSupport = TagSupport.fromResourceType(tagType.getResourceType());
                            AutoScalingMetadata resource = null;
                            try {
                                resource = tagSupport.lookup((OwnerFullName)accountFullName, tagType.getResourceId());
                            }
                            catch (NoSuchElementException e) {
                                Logs.extreme().info((Object)e, (Throwable)e);
                            }
                            if (resource == null || !RestrictedTypes.filterPrivileged().apply((Object)resource)) {
                                throw Exceptions.toUndeclared((Throwable)((Object)new ValidationErrorException("Resource not found " + tagType.getResourceId())));
                            }
                            String key = Strings.nullToEmpty((String)tagType.getKey()).trim();
                            String value = Strings.nullToEmpty((String)tagType.getValue()).trim();
                            Boolean propagateAtLaunch = (Boolean)Objects.firstNonNull((Object)tagType.getPropagateAtLaunch(), (Object)Boolean.FALSE);
                            tagSupport.createOrUpdate(resource, (OwnerFullName)ownerFullName, key, value, propagateAtLaunch);
                            Tag example = tagSupport.example(resource, (OwnerFullName)accountFullName, null, null);
                            if (Entities.count((Object)((Object)example)) <= MAX_TAGS_PER_RESOURCE) continue;
                            throw Exceptions.toUndeclared((Throwable)((Object)new LimitExceededException("Tag limit exceeded for resource '" + resource.getDisplayName() + "'")));
                        }
                        return true;
                    }
                    catch (Exception e) {
                        throw Exceptions.toUndeclared((Throwable)e);
                    }
                }
            };
            try {
                Entities.asTransaction(Tag.class, (Predicate)creator).apply(null);
            }
            catch (Exception e) {
                AutoScalingBackendService.handleException(e, true);
            }
        }
        return reply;
    }

    public SuspendProcessesResponseType suspendProcesses(final SuspendProcessesType request) throws EucalyptusCloudException {
        SuspendProcessesResponseType reply = (SuspendProcessesResponseType)request.getReply();
        final Context ctx = Contexts.lookup();
        try {
            final AccountFullName accountFullName = ctx.getUserFullName().asAccountFullName();
            Callback<AutoScalingGroup> groupCallback = new Callback<AutoScalingGroup>(){

                public void fire(AutoScalingGroup autoScalingGroup) {
                    if (RestrictedTypes.filterPrivileged().apply((Object)autoScalingGroup)) {
                        boolean isAdminSuspension = ctx.isAdministrator() && !autoScalingGroup.getOwnerAccountNumber().equals(accountFullName.getAccountNumber());
                        EnumSet<ScalingProcessType> processesToSuspend = EnumSet.allOf(ScalingProcessType.class);
                        if (request.getScalingProcesses() != null && !request.getScalingProcesses().getMember().isEmpty()) {
                            processesToSuspend.clear();
                            Iterables.addAll(processesToSuspend, (Iterable)Iterables.transform((Iterable)request.getScalingProcesses().getMember(), (Function)Enums.valueOfFunction(ScalingProcessType.class)));
                        }
                        for (ScalingProcessType scalingProcessType : processesToSuspend) {
                            if (!scalingProcessType.apply(autoScalingGroup)) continue;
                            autoScalingGroup.getSuspendedProcesses().add(isAdminSuspension ? SuspendedProcess.createAdministrative(scalingProcessType) : SuspendedProcess.createManual(scalingProcessType));
                        }
                    }
                }
            };
            this.autoScalingGroups.update((OwnerFullName)accountFullName, request.getAutoScalingGroupName(), groupCallback);
        }
        catch (AutoScalingMetadataNotFoundException e) {
            throw new ValidationErrorException("Auto scaling group not found: " + request.getAutoScalingGroupName());
        }
        catch (Exception e) {
            AutoScalingBackendService.handleException(e);
        }
        return reply;
    }

    public DescribeAutoScalingInstancesResponseType describeAutoScalingInstances(DescribeAutoScalingInstancesType request) throws EucalyptusCloudException {
        DescribeAutoScalingInstancesResponseType reply = (DescribeAutoScalingInstancesResponseType)request.getReply();
        Context ctx = Contexts.lookup();
        boolean showAll = request.instanceIds().remove("verbose");
        AccountFullName ownerFullName = ctx.isAdministrator() && showAll ? null : ctx.getUserFullName().asAccountFullName();
        Predicate requestedAndAccessible = AutoScalingMetadatas.filteringFor(AutoScalingInstance.class).byId((Collection)request.instanceIds()).byPrivileges().buildPredicate();
        try {
            ArrayList results = reply.getDescribeAutoScalingInstancesResult().getAutoScalingInstances().getMember();
            results.addAll(this.autoScalingInstances.list((OwnerFullName)ownerFullName, (Predicate<? super AutoScalingInstance>)requestedAndAccessible, TypeMappers.lookup(AutoScalingInstance.class, AutoScalingInstanceDetails.class)));
        }
        catch (Exception e) {
            AutoScalingBackendService.handleException(e);
        }
        return reply;
    }

    public CreateLaunchConfigurationResponseType createLaunchConfiguration(final CreateLaunchConfigurationType request) throws EucalyptusCloudException {
        CreateLaunchConfigurationResponseType reply = (CreateLaunchConfigurationResponseType)request.getReply();
        final Context ctx = Contexts.lookup();
        Supplier<LaunchConfiguration> allocator = new Supplier<LaunchConfiguration>(){

            public LaunchConfiguration get() {
                try {
                    List<String> referenceErrors;
                    LaunchConfigurations.PersistingBuilder builder = (LaunchConfigurations.PersistingBuilder)((LaunchConfigurations.PersistingBuilder)((LaunchConfigurations.PersistingBuilder)((LaunchConfigurations.PersistingBuilder)((LaunchConfigurations.PersistingBuilder)((LaunchConfigurations.PersistingBuilder)((LaunchConfigurations.PersistingBuilder)((LaunchConfigurations.PersistingBuilder)AutoScalingBackendService.this.launchConfigurations.create((OwnerFullName)ctx.getUserFullName(), request.getLaunchConfigurationName(), request.getImageId(), request.getInstanceType()).withKernelId(request.getKernelId())).withRamdiskId(request.getRamdiskId())).withKeyName(request.getKeyName())).withUserData(request.getUserData())).withInstanceMonitoring(request.getInstanceMonitoring() != null ? request.getInstanceMonitoring().getEnabled() : null)).withInstanceProfile(request.getIamInstanceProfile())).withSecurityGroups(request.getSecurityGroups() != null ? request.getSecurityGroups().getMember() : null)).withAssociatePublicIpAddress(request.getAssociatePublicIpAddress());
                    if (request.getBlockDeviceMappings() != null) {
                        for (BlockDeviceMappingType blockDeviceMappingType : request.getBlockDeviceMappings().getMember()) {
                            builder.withBlockDeviceMapping(blockDeviceMappingType.getDeviceName(), blockDeviceMappingType.getVirtualName(), blockDeviceMappingType.getEbs() != null ? blockDeviceMappingType.getEbs().getSnapshotId() : null, blockDeviceMappingType.getEbs() != null ? Numbers.intValue((Number)blockDeviceMappingType.getEbs().getVolumeSize()) : null);
                        }
                    }
                    if (!(referenceErrors = AutoScalingBackendService.this.activityManager.validateReferences((OwnerFullName)ctx.getUserFullName(), Iterables.filter((Iterable)Lists.newArrayList((Object[])new String[]{request.getImageId(), request.getKernelId(), request.getRamdiskId()}), (Predicate)Predicates.notNull()), request.getInstanceType(), request.getKeyName(), request.getSecurityGroups() == null ? Collections.emptyList() : request.getSecurityGroups().getMember(), request.getIamInstanceProfile())).isEmpty()) {
                        throw Exceptions.toUndeclared((Throwable)((Object)new ValidationErrorException("Invalid parameters " + referenceErrors)));
                    }
                    return builder.persist();
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            }
        };
        try {
            RestrictedTypes.allocateUnitlessResource((Supplier)allocator);
        }
        catch (Exception e) {
            AutoScalingBackendService.handleException(e, true);
        }
        return reply;
    }

    public DeleteAutoScalingGroupResponseType deleteAutoScalingGroup(DeleteAutoScalingGroupType request) throws EucalyptusCloudException {
        DeleteAutoScalingGroupResponseType reply = (DeleteAutoScalingGroupResponseType)request.getReply();
        Context ctx = Contexts.lookup();
        try {
            AutoScalingGroupCoreView group = (AutoScalingGroupCoreView)this.autoScalingGroups.lookup((OwnerFullName)ctx.getUserFullName().asAccountFullName(), request.getAutoScalingGroupName(), TypeMappers.lookup(AutoScalingGroup.class, AutoScalingGroupCoreView.class));
            if (RestrictedTypes.filterPrivileged().apply((Object)group)) {
                if (((Boolean)Objects.firstNonNull((Object)request.getForceDelete(), (Object)Boolean.FALSE)).booleanValue()) {
                    List<String> instanceIds = this.autoScalingInstances.listByGroup(group, (Predicate<? super AutoScalingInstance>)Predicates.alwaysTrue(), AutoScalingInstances.instanceId());
                    if (!instanceIds.isEmpty()) {
                        List<ScalingActivity> activities = this.activityManager.terminateInstances(group, instanceIds);
                        if (activities == null || activities.isEmpty()) {
                            throw new ScalingActivityInProgressException("Scaling activity in progress");
                        }
                        this.autoScalingInstances.deleteByGroup(group);
                    }
                } else {
                    AutoScalingBackendService.failIfScaling(this.activityManager, group);
                }
                this.autoScalingGroups.delete(group);
            }
        }
        catch (AutoScalingMetadataNotFoundException group) {
        }
        catch (Exception e) {
            AutoScalingBackendService.handleException(e);
        }
        return reply;
    }

    public DisableMetricsCollectionResponseType disableMetricsCollection(final DisableMetricsCollectionType request) throws EucalyptusCloudException {
        DisableMetricsCollectionResponseType reply = (DisableMetricsCollectionResponseType)request.getReply();
        Context ctx = Contexts.lookup();
        try {
            AccountFullName accountFullName = ctx.getUserFullName().asAccountFullName();
            Callback<AutoScalingGroup> groupCallback = new Callback<AutoScalingGroup>(){

                public void fire(AutoScalingGroup autoScalingGroup) {
                    if (RestrictedTypes.filterPrivileged().apply((Object)autoScalingGroup)) {
                        EnumSet<MetricCollectionType> metricsToDisable = EnumSet.allOf(MetricCollectionType.class);
                        if (request.getMetrics() != null && !request.getMetrics().getMember().isEmpty()) {
                            metricsToDisable.clear();
                            Iterables.addAll(metricsToDisable, (Iterable)Iterables.transform((Iterable)request.getMetrics().getMember(), (Function)Enums.valueOfFunction(MetricCollectionType.class)));
                        }
                        autoScalingGroup.getEnabledMetrics().removeAll(metricsToDisable);
                    }
                }
            };
            this.autoScalingGroups.update((OwnerFullName)accountFullName, request.getAutoScalingGroupName(), groupCallback);
        }
        catch (AutoScalingMetadataNotFoundException e) {
            throw new ValidationErrorException("Auto scaling group not found: " + request.getAutoScalingGroupName());
        }
        catch (Exception e) {
            AutoScalingBackendService.handleException(e);
        }
        return reply;
    }

    public UpdateAutoScalingGroupResponseType updateAutoScalingGroup(final UpdateAutoScalingGroupType request) throws EucalyptusCloudException {
        UpdateAutoScalingGroupResponseType reply = (UpdateAutoScalingGroupResponseType)request.getReply();
        Context ctx = Contexts.lookup();
        try {
            final AccountFullName accountFullName = ctx.getUserFullName().asAccountFullName();
            Callback<AutoScalingGroup> groupCallback = new Callback<AutoScalingGroup>(){

                public void fire(AutoScalingGroup autoScalingGroup) {
                    if (RestrictedTypes.filterPrivileged().apply((Object)autoScalingGroup)) {
                        if (request.getDefaultCooldown() != null) {
                            autoScalingGroup.setDefaultCooldown(Numbers.intValue((Number)request.getDefaultCooldown()));
                        }
                        if (request.getHealthCheckGracePeriod() != null) {
                            autoScalingGroup.setHealthCheckGracePeriod(Numbers.intValue((Number)request.getHealthCheckGracePeriod()));
                        }
                        if (request.getHealthCheckType() != null) {
                            autoScalingGroup.setHealthCheckType((HealthCheckType)((Object)Enums.valueOfFunction(HealthCheckType.class).apply((Object)request.getHealthCheckType())));
                        }
                        if (request.getLaunchConfigurationName() != null) {
                            try {
                                autoScalingGroup.setLaunchConfiguration((LaunchConfiguration)AutoScalingBackendService.verifyOwnership((OwnerFullName)accountFullName, (AbstractOwnedPersistent)AutoScalingBackendService.this.launchConfigurations.lookup((OwnerFullName)accountFullName, request.getLaunchConfigurationName(), Functions.identity())));
                            }
                            catch (AutoScalingMetadataNotFoundException e) {
                                throw Exceptions.toUndeclared((Throwable)((Object)new ValidationErrorException("Launch configuration not found: " + request.getLaunchConfigurationName())));
                            }
                            catch (AutoScalingMetadataException e) {
                                throw Exceptions.toUndeclared((Throwable)e);
                            }
                        }
                        if (request.getMaxSize() != null) {
                            autoScalingGroup.setMaxSize(Numbers.intValue((Number)request.getMaxSize()));
                        }
                        if (request.getMinSize() != null) {
                            autoScalingGroup.setMinSize(Numbers.intValue((Number)request.getMinSize()));
                        }
                        if (request.terminationPolicies() != null && !request.terminationPolicies().isEmpty()) {
                            autoScalingGroup.setTerminationPolicies(Lists.newArrayList((Iterable)Sets.newLinkedHashSet((Iterable)Iterables.filter((Iterable)Iterables.transform((Iterable)request.terminationPolicies(), (Function)Enums.valueOfFunction(TerminationPolicyType.class)), (Predicate)Predicates.not((Predicate)Predicates.isNull())))));
                        }
                        if (request.getDesiredCapacity() != null) {
                            Integer updatedDesiredCapacity = Numbers.intValue((Number)request.getDesiredCapacity());
                            autoScalingGroup.updateDesiredCapacity(updatedDesiredCapacity, String.format("a user request update of AutoScalingGroup constraints to min: %1$d, max: %2$d, desired: %4$d changing the desired capacity from %3$d to %4$d", autoScalingGroup.getMinSize(), autoScalingGroup.getMaxSize(), autoScalingGroup.getDesiredCapacity(), updatedDesiredCapacity));
                        }
                        if (autoScalingGroup.getDesiredCapacity() < autoScalingGroup.getMinSize()) {
                            throw Exceptions.toUndeclared((Throwable)((Object)new ValidationErrorException("DesiredCapacity must not be less than MinSize")));
                        }
                        if (autoScalingGroup.getDesiredCapacity() > autoScalingGroup.getMaxSize()) {
                            throw Exceptions.toUndeclared((Throwable)((Object)new ValidationErrorException("DesiredCapacity must not be greater than MaxSize")));
                        }
                        Iterable subnetIds = Splitter.on((char)',').trimResults().omitEmptyStrings().split((CharSequence)Strings.nullToEmpty((String)request.getVpcZoneIdentifier()));
                        AtomicReference subnetsByZone = new AtomicReference();
                        List<String> referenceErrors = AutoScalingBackendService.this.activityManager.validateReferences(autoScalingGroup.getOwner(), (Consumer<? super Map<String, String>>)Consumers.atomic(subnetsByZone), autoScalingGroup.getAvailabilityZones(), Collections.emptyList(), subnetIds);
                        AutoScalingBackendService.verifyUnsupportedReferences(referenceErrors, request.getPlacementGroup());
                        if (!referenceErrors.isEmpty()) {
                            throw Exceptions.toUndeclared((Throwable)((Object)new ValidationErrorException("Invalid parameters " + referenceErrors)));
                        }
                        if (request.getVpcZoneIdentifier() != null) {
                            autoScalingGroup.setSubnetIdByZone((Map)subnetsByZone.get());
                            autoScalingGroup.updateAvailabilityZones(Lists.newArrayList((Iterable)Sets.newLinkedHashSet(request.availabilityZones() != null && !request.availabilityZones().isEmpty() ? request.availabilityZones() : ((Map)subnetsByZone.get()).keySet())));
                        } else if (request.availabilityZones() != null && !request.availabilityZones().isEmpty()) {
                            autoScalingGroup.updateAvailabilityZones(Lists.newArrayList((Iterable)Sets.newLinkedHashSet((Iterable)request.availabilityZones())));
                        }
                    }
                }
            };
            this.autoScalingGroups.update((OwnerFullName)accountFullName, request.getAutoScalingGroupName(), groupCallback);
        }
        catch (AutoScalingMetadataNotFoundException e) {
            throw new ValidationErrorException("Auto scaling group not found: " + request.getAutoScalingGroupName());
        }
        catch (Exception e) {
            AutoScalingBackendService.handleException(e);
        }
        return reply;
    }

    public DescribeLaunchConfigurationsResponseType describeLaunchConfigurations(DescribeLaunchConfigurationsType request) throws EucalyptusCloudException {
        DescribeLaunchConfigurationsResponseType reply = (DescribeLaunchConfigurationsResponseType)request.getReply();
        Context ctx = Contexts.lookup();
        boolean showAll = request.launchConfigurationNames().remove("verbose");
        AccountFullName ownerFullName = ctx.isAdministrator() && showAll ? null : ctx.getUserFullName().asAccountFullName();
        Predicate requestedAndAccessible = AutoScalingMetadatas.filterPrivilegesByIdOrArn(AutoScalingMetadata.LaunchConfigurationMetadata.class, (Collection)request.launchConfigurationNames());
        try {
            ArrayList results = reply.getDescribeLaunchConfigurationsResult().getLaunchConfigurations().getMember();
            results.addAll(this.launchConfigurations.list((OwnerFullName)ownerFullName, (Predicate<? super LaunchConfiguration>)requestedAndAccessible, TypeMappers.lookup(LaunchConfiguration.class, LaunchConfigurationType.class)));
        }
        catch (Exception e) {
            AutoScalingBackendService.handleException(e);
        }
        return reply;
    }

    public DescribeAdjustmentTypesResponseType describeAdjustmentTypes(DescribeAdjustmentTypesType request) throws EucalyptusCloudException {
        DescribeAdjustmentTypesResponseType reply = (DescribeAdjustmentTypesResponseType)request.getReply();
        reply.getDescribeAdjustmentTypesResult().setAdjustmentTypes(new AdjustmentTypes(Collections2.transform((Collection)Collections2.filter(EnumSet.allOf(AdjustmentType.class), (Predicate)RestrictedTypes.filterPrivilegedWithoutOwner()), (Function)com.eucalyptus.util.Strings.toStringFunction())));
        return reply;
    }

    public DescribeScheduledActionsResponseType describeScheduledActions(DescribeScheduledActionsType request) throws EucalyptusCloudException {
        DescribeScheduledActionsResponseType reply = (DescribeScheduledActionsResponseType)request.getReply();
        return reply;
    }

    public PutScheduledUpdateGroupActionResponseType putScheduledUpdateGroupAction(PutScheduledUpdateGroupActionType request) throws EucalyptusCloudException {
        PutScheduledUpdateGroupActionResponseType reply = (PutScheduledUpdateGroupActionResponseType)request.getReply();
        return reply;
    }

    public DescribeMetricCollectionTypesResponseType describeMetricCollectionTypes(DescribeMetricCollectionTypesType request) throws EucalyptusCloudException {
        DescribeMetricCollectionTypesResponseType reply = (DescribeMetricCollectionTypesResponseType)request.getReply();
        reply.getDescribeMetricCollectionTypesResult().setMetrics(new MetricCollectionTypes(Collections2.transform((Collection)Collections2.filter(EnumSet.allOf(MetricCollectionType.class), (Predicate)RestrictedTypes.filterPrivilegedWithoutOwner()), (Function)com.eucalyptus.util.Strings.toStringFunction())));
        reply.getDescribeMetricCollectionTypesResult().setGranularities(new MetricGranularityTypes(Collections.singletonList(new MetricGranularityType("1Minute"))));
        return reply;
    }

    public SetDesiredCapacityResponseType setDesiredCapacity(final SetDesiredCapacityType request) throws EucalyptusCloudException {
        SetDesiredCapacityResponseType reply = (SetDesiredCapacityResponseType)request.getReply();
        Context ctx = Contexts.lookup();
        try {
            Callback<AutoScalingGroup> groupCallback = new Callback<AutoScalingGroup>(){

                public void fire(AutoScalingGroup autoScalingGroup) {
                    if (RestrictedTypes.filterPrivileged().apply((Object)autoScalingGroup)) {
                        AutoScalingBackendService.failIfScaling(AutoScalingBackendService.this.activityManager, autoScalingGroup);
                        Integer desiredCapacity = Numbers.intValue((Number)request.getDesiredCapacity());
                        if (desiredCapacity < autoScalingGroup.getMinSize()) {
                            throw Exceptions.toUndeclared((Throwable)((Object)new ValidationErrorException(String.format("New SetDesiredCapacity value %d is below min value %d for the AutoScalingGroup.", desiredCapacity, autoScalingGroup.getMinSize()))));
                        }
                        if (desiredCapacity > autoScalingGroup.getMaxSize()) {
                            throw Exceptions.toUndeclared((Throwable)((Object)new ValidationErrorException(String.format("New SetDesiredCapacity value %d is above max value %d for the AutoScalingGroup.", desiredCapacity, autoScalingGroup.getMaxSize()))));
                        }
                        AutoScalingBackendService.setDesiredCapacityWithCooldown(autoScalingGroup, request.getHonorCooldown(), null, desiredCapacity, String.format("a user request explicitly set group desired capacity changing the desired capacity from %1$d to %2$d", autoScalingGroup.getDesiredCapacity(), desiredCapacity));
                    }
                }
            };
            this.autoScalingGroups.update((OwnerFullName)ctx.getUserFullName().asAccountFullName(), request.getAutoScalingGroupName(), groupCallback);
        }
        catch (AutoScalingMetadataNotFoundException e) {
            throw new ValidationErrorException("Auto scaling group not found: " + request.getAutoScalingGroupName());
        }
        catch (Exception e) {
            AutoScalingBackendService.handleException(e);
        }
        return reply;
    }

    public TerminateInstanceInAutoScalingGroupResponseType terminateInstanceInAutoScalingGroup(final TerminateInstanceInAutoScalingGroupType request) throws EucalyptusCloudException {
        TerminateInstanceInAutoScalingGroupResponseType reply = (TerminateInstanceInAutoScalingGroupResponseType)request.getReply();
        Context ctx = Contexts.lookup();
        AccountFullName ownerFullName = ctx.isAdministrator() ? null : ctx.getUserFullName().asAccountFullName();
        try {
            AutoScalingInstanceGroupView instance = (AutoScalingInstanceGroupView)this.autoScalingInstances.lookup((OwnerFullName)ownerFullName, request.getInstanceId(), TypeMappers.lookup(AutoScalingInstance.class, AutoScalingInstanceGroupView.class));
            if (!RestrictedTypes.filterPrivileged().apply((Object)instance)) {
                throw new AutoScalingMetadataNotFoundException("Instance not found");
            }
            List<ScalingActivity> activities = this.activityManager.terminateInstances(instance.getAutoScalingGroup(), Collections.singletonList(instance.getInstanceId()));
            if (activities == null || activities.isEmpty()) {
                throw new ScalingActivityInProgressException("Scaling activity in progress");
            }
            reply.getTerminateInstanceInAutoScalingGroupResult().setActivity((Activity)TypeMappers.transform((Object)((Object)activities.get(0)), Activity.class));
            String groupArn = instance.getAutoScalingGroup().getArn();
            Callback<AutoScalingGroup> groupCallback = new Callback<AutoScalingGroup>(){

                public void fire(AutoScalingGroup autoScalingGroup) {
                    if (((Boolean)Objects.firstNonNull((Object)request.getShouldDecrementDesiredCapacity(), (Object)Boolean.FALSE)).booleanValue()) {
                        autoScalingGroup.setDesiredCapacity(autoScalingGroup.getDesiredCapacity() - 1);
                    } else {
                        autoScalingGroup.setScalingRequired(true);
                    }
                }
            };
            this.autoScalingGroups.update((OwnerFullName)ctx.getUserFullName().asAccountFullName(), groupArn, groupCallback);
        }
        catch (AutoScalingMetadataNotFoundException e) {
            throw new ValidationErrorException("Auto scaling instance not found: " + request.getInstanceId());
        }
        catch (Exception e) {
            AutoScalingBackendService.handleException(e);
        }
        return reply;
    }

    private static void failIfScaling(ActivityManager activityManager, AutoScalingMetadata.AutoScalingGroupMetadata group) {
        if (activityManager.scalingInProgress(group)) {
            throw Exceptions.toUndeclared((Throwable)((Object)new ScalingActivityInProgressException("Scaling activity in progress")));
        }
    }

    private static boolean scalingProcessEnabled(ScalingProcessType type, AutoScalingGroup group) {
        return !AutoScalingConfiguration.getSuspendedProcesses().contains((Object)type) && type.apply(group);
    }

    private static void setDesiredCapacityWithCooldown(AutoScalingGroup autoScalingGroup, Boolean honorCooldown, Integer cooldown, int capacity, String reason) {
        long cooldownMs = TimeUnit.SECONDS.toMillis(((Integer)Objects.firstNonNull((Object)cooldown, (Object)autoScalingGroup.getDefaultCooldown())).intValue());
        if (((Boolean)Objects.firstNonNull((Object)honorCooldown, (Object)Boolean.FALSE)).booleanValue() && System.currentTimeMillis() - autoScalingGroup.getCapacityTimestamp().getTime() <= cooldownMs) {
            throw Exceptions.toUndeclared((Throwable)((Object)new InternalFailureException("Group is in cooldown")));
        }
        autoScalingGroup.updateDesiredCapacity(capacity, reason);
        autoScalingGroup.setCapacityTimestamp(new Date());
    }

    private static void verifyUnsupportedReferences(List<String> referenceErrors, String placementGroup) {
        if (!Strings.isNullOrEmpty((String)placementGroup)) {
            referenceErrors.add("Invalid placement group: " + placementGroup);
        }
    }

    private static <AOP extends AbstractOwnedPersistent> AOP verifyOwnership(OwnerFullName ownerFullName, AOP aop) throws AutoScalingMetadataNotFoundException {
        if (!AutoScalingMetadatas.filterByOwner((OwnerFullName)ownerFullName).apply(aop)) {
            throw new AutoScalingMetadataNotFoundException("Not found: " + aop.getDisplayName());
        }
        return aop;
    }

    private static boolean isReserved(String text) {
        return !Contexts.lookup().isPrivileged() && Iterables.any(reservedPrefixes, (Predicate)com.eucalyptus.util.Strings.isPrefixOf((String)text));
    }

    private static void handleException(Exception e) throws AutoScalingException {
        AutoScalingBackendService.handleException(e, false);
    }

    private static void handleException(Exception e, boolean isCreate) throws AutoScalingException {
        AutoScalingException cause = (AutoScalingException)((Object)Exceptions.findCause((Throwable)e, AutoScalingException.class));
        if (cause != null) {
            throw cause;
        }
        AuthQuotaException quotaCause = (AuthQuotaException)Exceptions.findCause((Throwable)e, AuthQuotaException.class);
        if (quotaCause != null) {
            throw new LimitExceededException("Request would exceed quota for type: " + quotaCause.getType());
        }
        ConstraintViolationException constraintViolationException = (ConstraintViolationException)Exceptions.findCause((Throwable)e, ConstraintViolationException.class);
        if (constraintViolationException != null) {
            throw isCreate ? new AlreadyExistsException("Resource already exists") : new ResourceInUseException("Resource in use");
        }
        AutoScalingResourceName.InvalidResourceNameException invalidResourceNameException = (AutoScalingResourceName.InvalidResourceNameException)Exceptions.findCause((Throwable)e, AutoScalingResourceName.InvalidResourceNameException.class);
        if (invalidResourceNameException != null) {
            throw new ValidationErrorException(invalidResourceNameException.getMessage());
        }
        logger.error((Object)e, (Throwable)e);
        InternalFailureException exception = new InternalFailureException(String.valueOf(e.getMessage()));
        if (Contexts.lookup().hasAdministrativePrivileges()) {
            exception.initCause(e);
        }
        throw exception;
    }
}

