/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.autoscaling.activities;

import com.eucalyptus.component.Partition;
import com.eucalyptus.component.Partitions;
import com.eucalyptus.component.Topology;
import com.eucalyptus.component.id.ClusterController;
import com.eucalyptus.empyrean.DescribeServicesResponseType;
import com.eucalyptus.empyrean.DescribeServicesType;
import com.eucalyptus.empyrean.Empyrean;
import com.eucalyptus.empyrean.ServiceStatusType;
import com.eucalyptus.records.Logs;
import com.eucalyptus.util.Callback;
import com.eucalyptus.util.DispatchingClient;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import edu.ucsb.eucalyptus.msgs.BaseMessage;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

class ZoneMonitor {
    private static Logger logger = Logger.getLogger(ZoneMonitor.class);
    private static final Map<String, ZoneFailureInfo> failureMap = Maps.newHashMap();
    private static final Object failureMapSync = new Object();

    ZoneMonitor() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getUnavailableZones(long duration) {
        Object object = failureMapSync;
        synchronized (object) {
            return Sets.newHashSet((Iterable)Iterables.transform((Iterable)Iterables.filter(failureMap.values(), ZoneMonitor.unavailableSince(System.currentTimeMillis() - duration)), (Function)ZoneName.INSTANCE));
        }
    }

    public static void checkZones() {
        try {
            DescribeServicesType describeServices = new DescribeServicesType();
            describeServices.setByServiceType("cluster");
            DispatchingClient client = new DispatchingClient(Empyrean.class);
            client.init();
            client.dispatch((BaseMessage)describeServices, (Callback.Checked)ZoneCallback.INSTANCE);
        }
        catch (DispatchingClient.DispatchingClientException e) {
            ZoneMonitor.logWarning("Error describing zones", e);
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void checkAvailabilityForZones(Set<String> zones) {
        for (String zone : zones) {
            boolean available = ZoneAvailableFilter.INSTANCE.apply(zone);
            Object object = failureMapSync;
            synchronized (object) {
                if (available) {
                    failureMap.remove(zone);
                } else {
                    ZoneFailureInfo info = failureMap.get(zone);
                    if (info == null) {
                        failureMap.put(zone, new ZoneFailureInfo(zone));
                    }
                }
            }
        }
    }

    private static Predicate<ZoneFailureInfo> unavailableSince(final long since) {
        return new Predicate<ZoneFailureInfo>(){

            public boolean apply(ZoneFailureInfo zoneFailureInfo) {
                return zoneFailureInfo.since < since;
            }
        };
    }

    private static void logWarning(String description, Throwable t) {
        String message = description + ": " + t.getMessage();
        logger.warn((Object)message);
        Logs.extreme().warn((Object)message, t);
    }

    private static final class ZoneFailureInfo {
        private final String name;
        private final long since;

        private ZoneFailureInfo(String name) {
            this.name = name;
            this.since = System.currentTimeMillis();
        }
    }

    private static enum ZoneCallback implements Callback.Checked<DescribeServicesResponseType>
    {
        INSTANCE;


        public void fireException(Throwable t) {
            ZoneMonitor.logWarning("Error describing zones", t);
        }

        public void fire(DescribeServicesResponseType zonesResponse) {
            HashSet zones = Sets.newHashSet();
            if (zonesResponse.getServiceStatuses() != null) {
                for (ServiceStatusType serviceStatus : zonesResponse.getServiceStatuses()) {
                    if (serviceStatus == null || serviceStatus.getServiceId() == null || serviceStatus.getServiceId().getPartition() == null) continue;
                    zones.add(serviceStatus.getServiceId().getPartition());
                }
            }
            ZoneMonitor.checkAvailabilityForZones(zones);
        }
    }

    private static enum ZoneName implements Function<ZoneFailureInfo, String>
    {
        INSTANCE;


        public String apply(ZoneFailureInfo info) {
            return info.name;
        }
    }

    private static enum ZoneAvailableFilter implements Predicate<String>
    {
        INSTANCE;


        public boolean apply(String zone) {
            boolean enabled = false;
            Partition partition = Partitions.lookupByName((String)zone);
            if (partition != null) {
                try {
                    Topology.lookup(ClusterController.class, (Partition[])new Partition[]{partition});
                    enabled = true;
                }
                catch (Exception e) {
                    Logs.exhaust().info((Object)("Lookup failed for zone: " + zone), (Throwable)e);
                }
            }
            return enabled;
        }
    }
}

