/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.autoscaling.activities;

import com.eucalyptus.autoscaling.activities.ActivityCause;
import com.eucalyptus.autoscaling.activities.ActivityStatusCode;
import com.eucalyptus.autoscaling.common.AutoScalingMetadata;
import com.eucalyptus.autoscaling.common.AutoScalingMetadatas;
import com.eucalyptus.autoscaling.groups.AutoScalingGroup;
import com.eucalyptus.entities.AbstractOwnedPersistent;
import com.eucalyptus.util.OwnerFullName;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OrderColumn;
import javax.persistence.PersistenceContext;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import javax.persistence.Table;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

@Entity
@PersistenceContext(name="eucalyptus_autoscaling")
@Table(name="metadata_scaling_activities")
@Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
public class ScalingActivity
extends AbstractOwnedPersistent
implements AutoScalingMetadata.ScalingActivityMetadata {
    private static final long serialVersionUID = 1L;
    @ManyToOne(optional=false)
    @JoinColumn(name="metadata_group_id", nullable=false, updatable=false)
    @Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
    private AutoScalingGroup group;
    @Column(name="metadata_auto_scaling_group_name", nullable=false, updatable=false)
    private String autoScalingGroupName;
    @Column(name="metadata_description")
    private String description;
    @Column(name="metadata_details")
    private String details;
    @Column(name="metadata_end_time")
    private Date endTime;
    @Column(name="metadata_progress", nullable=false)
    private Integer progress;
    @Column(name="metadata_status_code", nullable=false)
    @Enumerated(value=EnumType.STRING)
    private ActivityStatusCode statusCode;
    @Column(name="metadata_status_message")
    private String statusMessage;
    @Column(name="metadata_client_token")
    private String clientToken;
    @ElementCollection
    @CollectionTable(name="metadata_scaling_activity_causes")
    @JoinColumn(name="metadata_scaling_activity_id")
    @OrderColumn(name="metadata_cause_index")
    @Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
    private List<ActivityCause> causes = Lists.newArrayList();

    protected ScalingActivity() {
    }

    protected ScalingActivity(OwnerFullName ownerFullName) {
        super(ownerFullName);
    }

    protected ScalingActivity(OwnerFullName ownerFullName, String activityId) {
        super(ownerFullName, activityId);
    }

    public String getActivityId() {
        return this.getNaturalId();
    }

    public String getDisplayName() {
        return this.getNaturalId();
    }

    public AutoScalingGroup getGroup() {
        return this.group;
    }

    public void setGroup(AutoScalingGroup group) {
        this.group = group;
    }

    public String getAutoScalingGroupName() {
        return this.autoScalingGroupName;
    }

    public void setAutoScalingGroupName(String autoScalingGroupName) {
        this.autoScalingGroupName = autoScalingGroupName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDetails() {
        return this.details;
    }

    public void setDetails(String details) {
        this.details = details;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public int getProgress() {
        return this.progress;
    }

    public void setProgress(int progress) {
        this.progress = progress;
    }

    public ActivityStatusCode getStatusCode() {
        return this.statusCode;
    }

    public void setStatusCode(ActivityStatusCode statusCode) {
        this.statusCode = statusCode;
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }

    public void setStatusMessage(String statusMessage) {
        this.statusMessage = statusMessage;
    }

    public String getClientToken() {
        return this.clientToken;
    }

    public void setClientToken(String clientToken) {
        this.clientToken = clientToken;
    }

    public List<ActivityCause> getCauses() {
        return this.causes;
    }

    public void setCauses(List<ActivityCause> causes) {
        this.causes = causes;
    }

    public String getCauseAsString() {
        return Joiner.on((String)"  ").join(this.getCauses());
    }

    public static ScalingActivity create(@Nonnull AutoScalingGroup group, @Nullable String clientToken, @Nonnull Collection<ActivityCause> causes) {
        ScalingActivity activity = new ScalingActivity(group.getOwner());
        activity.setGroup(group);
        activity.setClientToken(clientToken);
        activity.setCauses(Lists.newArrayList(causes));
        activity.setStatusCode(ActivityStatusCode.InProgress);
        return activity;
    }

    public static ScalingActivity withOwner(@Nullable OwnerFullName ownerFullName) {
        return new ScalingActivity(ownerFullName);
    }

    public static ScalingActivity named(OwnerFullName ownerFullName, String activityId) {
        ScalingActivity example = ScalingActivity.withOwner(ownerFullName);
        example.setDisplayName(activityId);
        return example;
    }

    public static ScalingActivity withUuid(String uuid) {
        ScalingActivity example = new ScalingActivity();
        example.setNaturalId(uuid);
        return example;
    }

    protected String createUniqueName() {
        return this.getNaturalId();
    }

    @PrePersist
    @PreUpdate
    private void preUpdate() {
        this.setDisplayName(this.getNaturalId());
        this.autoScalingGroupName = (String)AutoScalingMetadatas.toDisplayName().apply((Object)this.group);
    }
}

