/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.autoscaling.activities;

import com.eucalyptus.autoscaling.activities.ActivityStatusCode;
import com.eucalyptus.autoscaling.activities.ScalingActivity;
import com.eucalyptus.autoscaling.common.AutoScalingMetadata;
import com.eucalyptus.autoscaling.common.backend.msgs.Activity;
import com.eucalyptus.autoscaling.groups.AutoScalingGroup;
import com.eucalyptus.autoscaling.metadata.AutoScalingMetadataException;
import com.eucalyptus.util.Callback;
import com.eucalyptus.util.OwnerFullName;
import com.eucalyptus.util.Strings;
import com.eucalyptus.util.TypeMapper;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class ScalingActivities {
    public abstract <T> List<T> list(@Nullable OwnerFullName var1, @Nonnull Predicate<? super ScalingActivity> var2, @Nonnull Function<? super ScalingActivity, T> var3) throws AutoScalingMetadataException;

    public abstract <T> List<T> list(@Nullable OwnerFullName var1, @Nullable AutoScalingMetadata.AutoScalingGroupMetadata var2, @Nonnull Collection<String> var3, @Nonnull Predicate<? super ScalingActivity> var4, @Nonnull Function<? super ScalingActivity, T> var5) throws AutoScalingMetadataException;

    public abstract <T> List<T> listByActivityStatusCode(@Nullable OwnerFullName var1, @Nonnull Collection<ActivityStatusCode> var2, @Nonnull Function<? super ScalingActivity, T> var3) throws AutoScalingMetadataException;

    public abstract void update(OwnerFullName var1, String var2, Callback<ScalingActivity> var3) throws AutoScalingMetadataException;

    public abstract boolean delete(AutoScalingMetadata.ScalingActivityMetadata var1) throws AutoScalingMetadataException;

    public abstract int deleteByCreatedAge(@Nullable OwnerFullName var1, long var2) throws AutoScalingMetadataException;

    public abstract ScalingActivity save(ScalingActivity var1) throws AutoScalingMetadataException;

    public static Function<ScalingActivity, AutoScalingGroup> group() {
        return ScalingActivityToGroup.INSTANCE;
    }

    private static enum ScalingActivityToGroup implements Function<ScalingActivity, AutoScalingGroup>
    {
        INSTANCE;


        public AutoScalingGroup apply(@Nullable ScalingActivity scalingActivity) {
            return scalingActivity == null ? null : scalingActivity.getGroup();
        }
    }

    @TypeMapper
    public static enum ScalingActivityTransform implements Function<ScalingActivity, Activity>
    {
        INSTANCE;


        public Activity apply(ScalingActivity activity) {
            Activity type = new Activity();
            type.setActivityId(activity.getActivityId());
            type.setAutoScalingGroupName(activity.getAutoScalingGroupName());
            type.setCause(activity.getCauseAsString());
            type.setDescription(activity.getDescription());
            type.setDetails(activity.getDetails());
            type.setEndTime(activity.getEndTime());
            type.setProgress(Integer.valueOf(activity.getProgress()));
            type.setStartTime(activity.getCreationTimestamp());
            type.setStatusCode(Strings.toString((Object)((Object)activity.getStatusCode())));
            type.setStatusMessage(activity.getStatusMessage());
            return type;
        }
    }
}

