/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.autoscaling.activities;

import com.eucalyptus.autoscaling.activities.ZoneUnavailabilityMarker;
import com.eucalyptus.autoscaling.activities.ZoneUnavailabilityMarkers;
import com.eucalyptus.autoscaling.metadata.AutoScalingMetadataException;
import com.eucalyptus.entities.Entities;
import com.eucalyptus.util.Exceptions;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class PersistenceZoneUnavailabilityMarkers
extends ZoneUnavailabilityMarkers {
    @Override
    public void updateUnavailableZones(Set<String> unavailableZones, ZoneUnavailabilityMarkers.ZoneCallback callback) throws AutoScalingMetadataException {
        try {
            Entities.asTransaction(ZoneUnavailabilityMarker.class, (Function)UnavailableZoneUpdate.INSTANCE).apply((Object)new ZoneParams(unavailableZones, callback));
        }
        catch (Exception e) {
            throw new AutoScalingMetadataException("Error marking zones as unavailable", e);
        }
    }

    private static enum ZoneName implements Function<ZoneUnavailabilityMarker, String>
    {
        INSTANCE;


        public String apply(ZoneUnavailabilityMarker zoneUnavailabilityMarker) {
            return zoneUnavailabilityMarker.getName();
        }
    }

    private static enum UnavailableZoneUpdate implements Function<ZoneParams, Void>
    {
        INSTANCE;


        public Void apply(ZoneParams zoneParams) {
            List unavailableZoneList = Entities.query((Object)((Object)new ZoneUnavailabilityMarker()));
            HashSet currentUnavailableZones = Sets.newHashSet((Iterable)Iterables.transform((Iterable)unavailableZoneList, (Function)ZoneName.INSTANCE));
            HashSet changedZones = Sets.newHashSet();
            for (String zone : zoneParams.getUnavailableZones()) {
                if (currentUnavailableZones.contains(zone)) continue;
                changedZones.add(zone);
                Entities.persist((Object)((Object)new ZoneUnavailabilityMarker(zone)));
            }
            for (ZoneUnavailabilityMarker marker : unavailableZoneList) {
                if (zoneParams.getUnavailableZones().contains(marker.getName())) continue;
                changedZones.add(marker.getName());
                Entities.delete((Object)((Object)marker));
            }
            try {
                zoneParams.getCallback().notifyChangedZones(changedZones);
            }
            catch (AutoScalingMetadataException e) {
                throw Exceptions.toUndeclared((Throwable)e);
            }
            return null;
        }
    }

    private static class ZoneParams {
        private final Set<String> unavailableZones;
        private final ZoneUnavailabilityMarkers.ZoneCallback callback;

        private ZoneParams(Set<String> unavailableZones, ZoneUnavailabilityMarkers.ZoneCallback callback) {
            this.unavailableZones = unavailableZones;
            this.callback = callback;
        }

        public Set<String> getUnavailableZones() {
            return this.unavailableZones;
        }

        public ZoneUnavailabilityMarkers.ZoneCallback getCallback() {
            return this.callback;
        }
    }
}

