/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.autoscaling.activities;

import com.eucalyptus.autoscaling.activities.ActivityStatusCode;
import com.eucalyptus.autoscaling.activities.ScalingActivities;
import com.eucalyptus.autoscaling.activities.ScalingActivity;
import com.eucalyptus.autoscaling.common.AutoScalingMetadata;
import com.eucalyptus.autoscaling.common.AutoScalingMetadatas;
import com.eucalyptus.autoscaling.metadata.AbstractOwnedPersistents;
import com.eucalyptus.autoscaling.metadata.AutoScalingMetadataException;
import com.eucalyptus.component.annotation.ComponentNamed;
import com.eucalyptus.entities.AbstractPersistent;
import com.eucalyptus.util.Callback;
import com.eucalyptus.util.CollectionUtils;
import com.eucalyptus.util.OwnerFullName;
import com.eucalyptus.util.RestrictedType;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.hibernate.criterion.Conjunction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;

@ComponentNamed
public class PersistenceScalingActivities
extends ScalingActivities {
    private PersistenceSupport persistenceSupport = new PersistenceSupport();

    @Override
    public <T> List<T> list(@Nullable OwnerFullName ownerFullName, @Nonnull Predicate<? super ScalingActivity> filter, @Nonnull Function<? super ScalingActivity, T> transform) throws AutoScalingMetadataException {
        return this.persistenceSupport.list(ownerFullName, filter, transform);
    }

    @Override
    public <T> List<T> list(@Nullable OwnerFullName ownerFullName, @Nullable AutoScalingMetadata.AutoScalingGroupMetadata group, @Nonnull Collection<String> activityIds, @Nonnull Predicate<? super ScalingActivity> filter, @Nonnull Function<? super ScalingActivity, T> transform) throws AutoScalingMetadataException {
        ScalingActivity example = ScalingActivity.withOwner(ownerFullName);
        Conjunction conjunction = Restrictions.conjunction();
        ArrayList predicates = Lists.newArrayList();
        predicates.add(filter);
        if (group != null) {
            predicates.add(CollectionUtils.propertyPredicate((Object)group.getArn(), (Function)Functions.compose((Function)AutoScalingMetadatas.toArn(), ScalingActivities.group())));
            conjunction.add((Criterion)Restrictions.eq((String)"autoScalingGroupName", (Object)group.getDisplayName()));
        }
        if (!activityIds.isEmpty()) {
            conjunction.add(Restrictions.in((String)"displayName", activityIds));
        }
        return this.persistenceSupport.listByExample((AbstractPersistent)example, Predicates.and((Iterable)predicates), (Criterion)conjunction, Collections.emptyMap(), transform);
    }

    @Override
    public <T> List<T> listByActivityStatusCode(@Nullable OwnerFullName ownerFullName, @Nonnull Collection<ActivityStatusCode> statusCodes, @Nonnull Function<? super ScalingActivity, T> transform) throws AutoScalingMetadataException {
        ScalingActivity example = ScalingActivity.withOwner(ownerFullName);
        Conjunction conjunction = Restrictions.conjunction();
        if (!statusCodes.isEmpty()) {
            conjunction.add(Restrictions.in((String)"statusCode", statusCodes));
        }
        return this.persistenceSupport.listByExample((AbstractPersistent)example, Predicates.alwaysTrue(), (Criterion)conjunction, Collections.emptyMap(), transform);
    }

    @Override
    public void update(OwnerFullName ownerFullName, String activityId, Callback<ScalingActivity> activityUpdateCallback) throws AutoScalingMetadataException {
        this.persistenceSupport.updateByExample((AbstractPersistent)this.persistenceSupport.exampleWithName(ownerFullName, activityId), ownerFullName, activityId, activityUpdateCallback);
    }

    @Override
    public boolean delete(AutoScalingMetadata.ScalingActivityMetadata scalingActivity) throws AutoScalingMetadataException {
        return this.persistenceSupport.delete((RestrictedType)scalingActivity);
    }

    @Override
    public int deleteByCreatedAge(@Nullable OwnerFullName ownerFullName, long createdBefore) throws AutoScalingMetadataException {
        return this.persistenceSupport.deleteByExample((AbstractPersistent)ScalingActivity.withOwner(ownerFullName), (Criterion)Restrictions.lt((String)"creationTimestamp", (Object)new Date(createdBefore)), Collections.emptyMap()).size();
    }

    @Override
    public ScalingActivity save(ScalingActivity scalingActivity) throws AutoScalingMetadataException {
        return (ScalingActivity)this.persistenceSupport.save((AbstractPersistent)scalingActivity);
    }

    private static class PersistenceSupport
    extends AbstractOwnedPersistents<ScalingActivity> {
        private PersistenceSupport() {
            super("scaling activity");
        }

        protected ScalingActivity exampleWithOwner(OwnerFullName ownerFullName) {
            return ScalingActivity.withOwner(ownerFullName);
        }

        protected ScalingActivity exampleWithName(OwnerFullName ownerFullName, String name) {
            return ScalingActivity.named(ownerFullName, name);
        }
    }
}

