/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.autoscaling.activities;

import com.eucalyptus.autoscaling.config.AutoScalingConfiguration;
import com.eucalyptus.util.async.CheckedListenableFuture;
import com.eucalyptus.util.async.Futures;
import com.google.common.collect.Maps;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;

public class BackoffRunner {
    private static final Logger logger = Logger.getLogger(BackoffRunner.class);
    private static final ConcurrentMap<String, TaskInfo> tasksInProgress = Maps.newConcurrentMap();
    private static final BackoffRunner instance = new BackoffRunner();

    static BackoffRunner getInstance() {
        return instance;
    }

    BackoffRunner() {
    }

    boolean taskInProgress(String uniqueKey) {
        long timestamp = this.timestamp();
        TaskInfo taskInfo = (TaskInfo)tasksInProgress.get(uniqueKey);
        return taskInfo != null && !taskInfo.isDone(timestamp);
    }

    boolean runTask(TaskWithBackOff task) {
        boolean run = BackoffRunner.doRunTask(task, this.timestamp());
        if (run) {
            task.runTask();
        } else {
            logger.info((Object)("Not running task " + task));
        }
        return run;
    }

    protected long timestamp() {
        return System.currentTimeMillis();
    }

    private static long getTaskTimeout() {
        return AutoScalingConfiguration.getActivityTimeoutMillis();
    }

    private static long getMaxBackoff() {
        return AutoScalingConfiguration.getActivityMaxBackoffMillis();
    }

    private static long getInitialBackoff() {
        return AutoScalingConfiguration.getActivityInitialBackoffMillis();
    }

    private static boolean doRunTask(TaskWithBackOff task, long timestamp) {
        boolean run = false;
        TaskInfo previous = tasksInProgress.putIfAbsent(task.getUniqueKey(), task.info(new TaskInfo(task, timestamp, 0)));
        if (previous == null) {
            run = true;
        } else if (previous.canFollow(timestamp, task.getBackoffGroup()) && tasksInProgress.remove(task.getUniqueKey(), previous) && tasksInProgress.putIfAbsent(task.getUniqueKey(), task.info(new TaskInfo(task, timestamp, previous.getNextFailureCount(task.getBackoffGroup())))) == null) {
            run = true;
        }
        return run;
    }

    private static final class TaskInfo {
        private final String group;
        private final long created;
        private final Future<Boolean> resultFuture;
        private final int failureCount;

        private TaskInfo(TaskWithBackOff task, long created, int failureCount) {
            this.group = task.getBackoffGroup();
            this.created = created;
            this.resultFuture = task.getFuture();
            this.failureCount = failureCount;
        }

        private boolean canFollow(long timestamp, String group) {
            return this.isSuccess() || this.isDone(timestamp) && this.isBackoffExpired(timestamp, group);
        }

        private boolean isBackoffExpired(long timestamp, String group) {
            return !this.group.equals(group) || timestamp - this.created > this.calculateBackoff();
        }

        private long calculateBackoff() {
            long backoff = BackoffRunner.getInitialBackoff();
            for (int i = 0; i < this.failureCount && backoff < BackoffRunner.getMaxBackoff(); backoff *= 2L, ++i) {
            }
            return Math.min(backoff, BackoffRunner.getMaxBackoff());
        }

        private int getNextFailureCount(String group) {
            return this.group.equals(group) && !this.isSuccess() ? this.failureCount + 1 : 0;
        }

        private boolean isDone(long timestamp) {
            return this.isTimedOut(timestamp) || this.isComplete();
        }

        private boolean isTimedOut(long timestamp) {
            return timestamp - this.created > BackoffRunner.getTaskTimeout();
        }

        private boolean isSuccess() {
            try {
                return this.resultFuture != null && this.resultFuture.isDone() && !this.resultFuture.isCancelled() && this.resultFuture.get() != false;
            }
            catch (ExecutionException e) {
                return false;
            }
            catch (InterruptedException e) {
                return false;
            }
        }

        private boolean isComplete() {
            return this.resultFuture != null && this.resultFuture.isDone();
        }
    }

    static abstract class TaskWithBackOff {
        private final String uniqueKey;
        private final String backoffGroup;
        private final CheckedListenableFuture<Boolean> future;
        private volatile TaskInfo taskInfo;

        TaskWithBackOff(String uniqueKey, String backoffGroup) {
            this.uniqueKey = uniqueKey;
            this.backoffGroup = backoffGroup;
            this.future = Futures.newGenericeFuture();
        }

        TaskInfo info(TaskInfo taskInfo) {
            this.taskInfo = taskInfo;
            return this.taskInfo;
        }

        @Nullable
        TaskWithBackOff onSuccess() {
            return null;
        }

        final String getUniqueKey() {
            return this.uniqueKey;
        }

        final String getBackoffGroup() {
            return this.backoffGroup;
        }

        private Future<Boolean> getFuture() {
            return this.future;
        }

        abstract void runTask();

        final void success() {
            TaskWithBackOff onSuccess = this.onSuccess();
            if (onSuccess != null) {
                boolean run;
                boolean bl = run = this.getUniqueKey().equals(onSuccess.getUniqueKey()) ? tasksInProgress.replace(this.getUniqueKey(), this.taskInfo, onSuccess.info(new TaskInfo(onSuccess, System.currentTimeMillis(), 0))) : BackoffRunner.doRunTask(onSuccess, System.currentTimeMillis());
                if (!run) {
                    logger.info((Object)("Unable to create activity: " + onSuccess.getBackoffGroup() + " for " + onSuccess.getUniqueKey()));
                } else {
                    this.future.set((Object)true);
                    onSuccess.runTask();
                }
            }
            if (!this.future.isDone()) {
                this.future.set((Object)true);
            }
        }

        final void failure() {
            this.future.set((Object)false);
        }

        public String toString() {
            return this.uniqueKey + " " + this.backoffGroup;
        }
    }
}

