/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.autoscaling.activities;

import com.eucalyptus.auth.Accounts;
import com.eucalyptus.auth.AuthException;
import com.eucalyptus.auth.policy.PolicySpec;
import com.eucalyptus.auth.policy.ern.Ern;
import com.eucalyptus.auth.policy.ern.EuareResourceName;
import com.eucalyptus.auth.principal.AccountFullName;
import com.eucalyptus.autoscaling.activities.ActivityCause;
import com.eucalyptus.autoscaling.activities.ActivityStatusCode;
import com.eucalyptus.autoscaling.activities.BackoffRunner;
import com.eucalyptus.autoscaling.activities.CloudWatchClient;
import com.eucalyptus.autoscaling.activities.ElbClient;
import com.eucalyptus.autoscaling.activities.EucalyptusClient;
import com.eucalyptus.autoscaling.activities.PersistenceScalingActivities;
import com.eucalyptus.autoscaling.activities.PersistenceZoneUnavailabilityMarkers;
import com.eucalyptus.autoscaling.activities.ScalingActivities;
import com.eucalyptus.autoscaling.activities.ScalingActivity;
import com.eucalyptus.autoscaling.activities.VmTypesClient;
import com.eucalyptus.autoscaling.activities.ZoneMonitor;
import com.eucalyptus.autoscaling.activities.ZoneUnavailabilityMarkers;
import com.eucalyptus.autoscaling.common.AutoScalingBackend;
import com.eucalyptus.autoscaling.common.AutoScalingMetadata;
import com.eucalyptus.autoscaling.config.AutoScalingConfiguration;
import com.eucalyptus.autoscaling.configurations.LaunchConfigurationCoreView;
import com.eucalyptus.autoscaling.configurations.LaunchConfigurations;
import com.eucalyptus.autoscaling.groups.AutoScalingGroup;
import com.eucalyptus.autoscaling.groups.AutoScalingGroupCoreView;
import com.eucalyptus.autoscaling.groups.AutoScalingGroupMetricsView;
import com.eucalyptus.autoscaling.groups.AutoScalingGroupMinimumView;
import com.eucalyptus.autoscaling.groups.AutoScalingGroupScalingView;
import com.eucalyptus.autoscaling.groups.AutoScalingGroups;
import com.eucalyptus.autoscaling.groups.GroupScalingCause;
import com.eucalyptus.autoscaling.groups.HealthCheckType;
import com.eucalyptus.autoscaling.groups.MetricCollectionType;
import com.eucalyptus.autoscaling.groups.PersistenceAutoScalingGroups;
import com.eucalyptus.autoscaling.groups.ScalingProcessType;
import com.eucalyptus.autoscaling.groups.SuspendedProcess;
import com.eucalyptus.autoscaling.groups.TerminationPolicyType;
import com.eucalyptus.autoscaling.instances.AutoScalingInstance;
import com.eucalyptus.autoscaling.instances.AutoScalingInstanceCoreView;
import com.eucalyptus.autoscaling.instances.AutoScalingInstanceGroupView;
import com.eucalyptus.autoscaling.instances.AutoScalingInstances;
import com.eucalyptus.autoscaling.instances.ConfigurationState;
import com.eucalyptus.autoscaling.instances.HealthStatus;
import com.eucalyptus.autoscaling.instances.LifecycleState;
import com.eucalyptus.autoscaling.instances.PersistenceAutoScalingInstances;
import com.eucalyptus.autoscaling.metadata.AutoScalingMetadataException;
import com.eucalyptus.autoscaling.metadata.AutoScalingMetadataNotFoundException;
import com.eucalyptus.autoscaling.tags.Tag;
import com.eucalyptus.autoscaling.tags.TagSupport;
import com.eucalyptus.bootstrap.Bootstrap;
import com.eucalyptus.cloudwatch.common.msgs.DescribeAlarmsResponseType;
import com.eucalyptus.cloudwatch.common.msgs.DescribeAlarmsType;
import com.eucalyptus.cloudwatch.common.msgs.Dimension;
import com.eucalyptus.cloudwatch.common.msgs.Dimensions;
import com.eucalyptus.cloudwatch.common.msgs.MetricAlarm;
import com.eucalyptus.cloudwatch.common.msgs.MetricData;
import com.eucalyptus.cloudwatch.common.msgs.MetricDatum;
import com.eucalyptus.cloudwatch.common.msgs.PutMetricDataResponseType;
import com.eucalyptus.cloudwatch.common.msgs.PutMetricDataType;
import com.eucalyptus.cloudwatch.common.msgs.ResourceList;
import com.eucalyptus.component.Topology;
import com.eucalyptus.component.annotation.ComponentNamed;
import com.eucalyptus.component.id.Eucalyptus;
import com.eucalyptus.compute.common.ClusterInfoType;
import com.eucalyptus.compute.common.DescribeTagsType;
import com.eucalyptus.compute.common.Filter;
import com.eucalyptus.compute.common.ImageDetails;
import com.eucalyptus.compute.common.InstanceNetworkInterfaceSetItemRequestType;
import com.eucalyptus.compute.common.InstanceStatusItemType;
import com.eucalyptus.compute.common.ResourceTag;
import com.eucalyptus.compute.common.RunningInstancesItemType;
import com.eucalyptus.compute.common.SecurityGroupItemType;
import com.eucalyptus.compute.common.SubnetIdSetItemType;
import com.eucalyptus.compute.common.SubnetIdSetType;
import com.eucalyptus.compute.common.SubnetType;
import com.eucalyptus.compute.common.TagInfo;
import com.eucalyptus.compute.common.backend.CreateTagsResponseType;
import com.eucalyptus.compute.common.backend.CreateTagsType;
import com.eucalyptus.compute.common.backend.DescribeAvailabilityZonesResponseType;
import com.eucalyptus.compute.common.backend.DescribeAvailabilityZonesType;
import com.eucalyptus.compute.common.backend.DescribeImagesResponseType;
import com.eucalyptus.compute.common.backend.DescribeImagesType;
import com.eucalyptus.compute.common.backend.DescribeInstanceStatusResponseType;
import com.eucalyptus.compute.common.backend.DescribeInstanceStatusType;
import com.eucalyptus.compute.common.backend.DescribeInstanceTypesResponseType;
import com.eucalyptus.compute.common.backend.DescribeInstanceTypesType;
import com.eucalyptus.compute.common.backend.DescribeKeyPairsResponseType;
import com.eucalyptus.compute.common.backend.DescribeKeyPairsType;
import com.eucalyptus.compute.common.backend.DescribeSecurityGroupsResponseType;
import com.eucalyptus.compute.common.backend.DescribeSecurityGroupsType;
import com.eucalyptus.compute.common.backend.DescribeSubnetsResponseType;
import com.eucalyptus.compute.common.backend.DescribeSubnetsType;
import com.eucalyptus.compute.common.backend.DescribeTagsResponseType;
import com.eucalyptus.compute.common.backend.RunInstancesResponseType;
import com.eucalyptus.compute.common.backend.RunInstancesType;
import com.eucalyptus.compute.common.backend.TerminateInstancesResponseType;
import com.eucalyptus.compute.common.backend.TerminateInstancesType;
import com.eucalyptus.event.ClockTick;
import com.eucalyptus.event.EventListener;
import com.eucalyptus.event.Listeners;
import com.eucalyptus.event.SystemClock;
import com.eucalyptus.loadbalancing.common.msgs.DeregisterInstancesFromLoadBalancerResponseType;
import com.eucalyptus.loadbalancing.common.msgs.DeregisterInstancesFromLoadBalancerType;
import com.eucalyptus.loadbalancing.common.msgs.DescribeInstanceHealthResponseType;
import com.eucalyptus.loadbalancing.common.msgs.DescribeInstanceHealthType;
import com.eucalyptus.loadbalancing.common.msgs.DescribeLoadBalancersResponseType;
import com.eucalyptus.loadbalancing.common.msgs.DescribeLoadBalancersType;
import com.eucalyptus.loadbalancing.common.msgs.Error;
import com.eucalyptus.loadbalancing.common.msgs.ErrorResponse;
import com.eucalyptus.loadbalancing.common.msgs.Instance;
import com.eucalyptus.loadbalancing.common.msgs.InstanceState;
import com.eucalyptus.loadbalancing.common.msgs.LoadBalancerDescription;
import com.eucalyptus.loadbalancing.common.msgs.LoadBalancerNames;
import com.eucalyptus.loadbalancing.common.msgs.RegisterInstancesWithLoadBalancerResponseType;
import com.eucalyptus.loadbalancing.common.msgs.RegisterInstancesWithLoadBalancerType;
import com.eucalyptus.records.Logs;
import com.eucalyptus.util.Callback;
import com.eucalyptus.util.CollectionUtils;
import com.eucalyptus.util.Consumer;
import com.eucalyptus.util.Consumers;
import com.eucalyptus.util.DispatchingClient;
import com.eucalyptus.util.EucalyptusCloudException;
import com.eucalyptus.util.Exceptions;
import com.eucalyptus.util.OwnerFullName;
import com.eucalyptus.util.RestrictedTypes;
import com.eucalyptus.util.TypeMappers;
import com.eucalyptus.util.async.CheckedListenableFuture;
import com.eucalyptus.util.async.FailedRequestException;
import com.eucalyptus.util.async.Futures;
import com.eucalyptus.ws.EucalyptusRemoteFault;
import com.eucalyptus.ws.EucalyptusWebServiceException;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Splitter;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import edu.ucsb.eucalyptus.msgs.BaseMessage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;
import org.mule.component.ComponentException;

@ComponentNamed
public class ActivityManager {
    private static final Logger logger = Logger.getLogger(ActivityManager.class);
    private static final EnumSet<ActivityStatusCode> completedActivityStates = EnumSet.of(ActivityStatusCode.Cancelled, ActivityStatusCode.Failed, ActivityStatusCode.Successful);
    private static final Set<MetricCollectionType> instanceMetrics = EnumSet.of(MetricCollectionType.GroupInServiceInstances, MetricCollectionType.GroupPendingInstances, MetricCollectionType.GroupTerminatingInstances, MetricCollectionType.GroupTotalInstances);
    private static final String INSTANCE_PROFILE_RESOURCE = PolicySpec.qualifiedName((String)"iam", (String)"instance-profile");
    private final ScalingActivities scalingActivities;
    private final AutoScalingGroups autoScalingGroups;
    private final AutoScalingInstances autoScalingInstances;
    private final ZoneUnavailabilityMarkers zoneAvailabilityMarkers;
    private final ZoneMonitor zoneMonitor;
    private final BackoffRunner runner = BackoffRunner.getInstance();
    private final ConcurrentMap<String, TimestampedValue<Integer>> launchFailureCounters = Maps.newConcurrentMap();
    private final ConcurrentMap<String, TimestampedValue<Void>> untrackedInstanceTimestamps = Maps.newConcurrentMap();
    private final List<UnstableInstanceState> unstableInstanceStates = ImmutableList.builder().add((Object)ActivityManager.state(LifecycleState.Terminating, ConfigurationState.Instantiated, this.terminateInstancesTask())).add((Object)ActivityManager.state(LifecycleState.Terminating, ConfigurationState.Registered, this.removeFromLoadBalancerOrTerminate())).add((Object)ActivityManager.state(LifecycleState.InService, ConfigurationState.Instantiated, this.addToLoadBalancer())).build();
    private final List<ScalingTask> scalingTasks = ImmutableList.builder().add((Object)new ScalingTask(30, ActivityTask.Timeout){

        @Override
        void doWork() throws Exception {
            ActivityManager.this.timeoutScalingActivities();
        }
    }).add((Object)new ScalingTask(3600, ActivityTask.Expiry){

        @Override
        void doWork() throws Exception {
            ActivityManager.this.deleteExpiredActivities();
        }
    }).add((Object)new ScalingTask(10, ActivityTask.ZoneHealth){

        @Override
        void doWork() throws Exception {
            ActivityManager.this.updateUnavailableZones();
        }
    }).add((Object)new ScalingTask(10, ActivityTask.Recovery){

        @Override
        void doWork() throws Exception {
            ActivityManager.this.progressUnstableStates();
        }
    }).add((Object)new ScalingTask(10, ActivityTask.Scaling){

        @Override
        void doWork() throws Exception {
            ActivityManager.this.replaceUnhealthy();
        }
    }).add((Object)new ScalingTask(10, ActivityTask.Scaling){

        @Override
        void doWork() throws Exception {
            ActivityManager.this.scalingActivities();
        }
    }).add((Object)new ScalingTask(10, ActivityTask.InstanceCleanup){

        @Override
        void doWork() throws Exception {
            ActivityManager.this.runningInstanceChecks();
        }
    }).add((Object)new ScalingTask(10, ActivityTask.MetricsSubmission){

        @Override
        void doWork() throws Exception {
            ActivityManager.this.submitMetrics();
        }
    }).build();

    private static UnstableInstanceState state(LifecycleState lifecycleState, ConfigurationState configurationState, Function<Iterable<AutoScalingInstanceGroupView>, ? extends ScalingProcessTask<?, ?>> stateProgressFunction) {
        return new UnstableInstanceState(lifecycleState, configurationState, stateProgressFunction);
    }

    public ActivityManager() {
        this(new PersistenceScalingActivities(), new PersistenceAutoScalingGroups(), new PersistenceAutoScalingInstances(), new PersistenceZoneUnavailabilityMarkers(), new ZoneMonitor());
    }

    protected ActivityManager(ScalingActivities scalingActivities, AutoScalingGroups autoScalingGroups, AutoScalingInstances autoScalingInstances, ZoneUnavailabilityMarkers zoneAvailabilityMarkers, ZoneMonitor zoneMonitor) {
        this.scalingActivities = scalingActivities;
        this.autoScalingGroups = autoScalingGroups;
        this.autoScalingInstances = autoScalingInstances;
        this.zoneAvailabilityMarkers = zoneAvailabilityMarkers;
        this.zoneMonitor = zoneMonitor;
    }

    public void doScaling() {
        for (ScalingTask scalingTask : this.scalingTasks) {
            try {
                scalingTask.perhapsWork();
            }
            catch (Exception e) {
                logger.error((Object)e, (Throwable)e);
            }
        }
    }

    public boolean scalingInProgress(AutoScalingMetadata.AutoScalingGroupMetadata group) {
        String arn = group.getArn();
        return this.taskInProgress(arn);
    }

    @Nullable
    public List<ScalingActivity> terminateInstances(AutoScalingGroupCoreView group, List<String> instanceIds) {
        UserTerminateInstancesScalingProcessTask task = new UserTerminateInstancesScalingProcessTask(group, instanceIds);
        this.runTask(task);
        List<ScalingActivity> activities = task.getActivities();
        if (activities != null && !activities.isEmpty()) {
            this.runTask(new UserRemoveFromLoadBalancerScalingProcessTask(group, instanceIds));
        }
        return activities;
    }

    public List<String> validateReferences(OwnerFullName owner, Consumer<? super Map<String, String>> availabilityZoneToSubnetMapConsumer, Iterable<String> availabilityZones, Iterable<String> loadBalancerNames, Iterable<String> subnetIds) {
        return this.validateReferences(owner, availabilityZoneToSubnetMapConsumer, (Iterable)Objects.firstNonNull(availabilityZones, Collections.emptyList()), (Iterable)Objects.firstNonNull(loadBalancerNames, Collections.emptyList()), (Iterable)Objects.firstNonNull(subnetIds, Collections.emptyList()), Collections.emptyList(), null, null, Collections.emptyList(), null);
    }

    public List<String> validateReferences(OwnerFullName owner, Iterable<String> imageIds, String instanceType, String keyName, Iterable<String> securityGroups, String iamInstanceProfile) {
        return this.validateReferences(owner, (Consumer<? super Map<String, String>>)Consumers.drop(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), (Iterable)Objects.firstNonNull(imageIds, Collections.emptyList()), instanceType, keyName, (Iterable)Objects.firstNonNull(securityGroups, Collections.emptyList()), iamInstanceProfile);
    }

    public Map<String, Collection<String>> getAlarmsForPolicies(OwnerFullName owner, List<String> policyArns) {
        HashMap policyArnToAlarmArnMap = Maps.newHashMap();
        AlarmLookupProcessTask task = new AlarmLookupProcessTask(owner, policyArns);
        this.runTask(task);
        try {
            boolean success = task.getFuture().get();
            if (success) {
                policyArnToAlarmArnMap.putAll(task.getPolicyArnToAlarmArns());
            }
        }
        catch (InterruptedException | ExecutionException e) {
            logger.error((Object)e, (Throwable)e);
        }
        return policyArnToAlarmArnMap;
    }

    protected long timestamp() {
        return System.currentTimeMillis();
    }

    private void timeoutScalingActivities() throws AutoScalingMetadataException {
        List activities = this.scalingActivities.listByActivityStatusCode(null, completedActivityStates, Functions.identity());
        for (ScalingActivity activity : activities) {
            if (completedActivityStates.contains((Object)activity.getStatusCode()) || !this.isTimedOut(activity.getLastUpdateTimestamp())) continue;
            this.scalingActivities.update(activity.getOwner(), activity.getActivityId(), new Callback<ScalingActivity>(){

                public void fire(ScalingActivity scalingActivity) {
                    logger.debug((Object)("Timing out expired scaling activity: " + scalingActivity.getActivityId()));
                    scalingActivity.setStatusCode(ActivityStatusCode.Cancelled);
                    scalingActivity.setEndTime(new Date());
                }
            });
        }
    }

    private void deleteExpiredActivities() throws AutoScalingMetadataException {
        logger.debug((Object)"Deleting expired scaling activities");
        this.scalingActivities.deleteByCreatedAge(null, System.currentTimeMillis() - AutoScalingConfiguration.getActivityExpiryMillis());
    }

    private void runningInstanceChecks() {
        HashMap autoScalingAccounts = Maps.newHashMap();
        try {
            for (AutoScalingGroupCoreView group : this.autoScalingGroups.listRequiringMonitoring(10000L, TypeMappers.lookup(AutoScalingGroup.class, AutoScalingGroupCoreView.class))) {
                autoScalingAccounts.put(group.getOwnerAccountNumber(), group);
                List<String> groupInstancesPending = this.autoScalingInstances.listByGroup(group, LifecycleState.Pending, AutoScalingInstances.instanceId());
                List<String> groupInstancesInService = this.autoScalingInstances.listByGroup(group, LifecycleState.InService, AutoScalingInstances.instanceId());
                if (groupInstancesPending.isEmpty() && groupInstancesInService.isEmpty()) continue;
                this.runTask(new MonitoringScalingProcessTask(group, groupInstancesPending, groupInstancesInService));
            }
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
        }
        try {
            for (AutoScalingGroupCoreView group : autoScalingAccounts.values()) {
                this.runTask(new UntrackedInstanceTerminationScalingProcessTask(group));
            }
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
        }
        this.expireValues(this.launchFailureCounters, AutoScalingConfiguration.getActivityMaxBackoffMillis() * (long)AutoScalingConfiguration.getSuspensionLaunchAttemptsThreshold());
        this.expireValues(this.untrackedInstanceTimestamps, AutoScalingConfiguration.getUntrackedInstanceTimeoutMillis() + TimeUnit.MINUTES.toMillis(10L));
    }

    private <T> void expireValues(ConcurrentMap<String, TimestampedValue<T>> map, long maxAge) {
        for (Map.Entry entry : map.entrySet()) {
            if (((TimestampedValue)entry.getValue()).getTimestamp() >= maxAge) continue;
            map.remove(entry.getKey(), entry.getValue());
        }
    }

    private void submitMetrics() {
        try {
            for (AutoScalingGroupMetricsView group : this.autoScalingGroups.listRequiringMonitoring(10000L, TypeMappers.lookup(AutoScalingGroup.class, AutoScalingGroupMetricsView.class))) {
                if (group.getEnabledMetrics().isEmpty()) continue;
                List<AutoScalingInstanceCoreView> groupInstances = Sets.intersection(group.getEnabledMetrics(), instanceMetrics).isEmpty() ? Collections.emptyList() : this.autoScalingInstances.listByGroup(group, (Predicate<? super AutoScalingInstance>)Predicates.alwaysTrue(), TypeMappers.lookup(AutoScalingInstance.class, AutoScalingInstanceCoreView.class));
                this.runTask(new MetricsSubmissionScalingProcessTask(group, groupInstances));
            }
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
        }
    }

    private void replaceUnhealthy() throws AutoScalingMetadataException {
        for (AutoScalingGroupScalingView group : this.autoScalingGroups.listRequiringInstanceReplacement(TypeMappers.lookup(AutoScalingGroup.class, AutoScalingGroupScalingView.class))) {
            this.runTask(this.perhapsReplaceInstances(group));
        }
    }

    private void scalingActivities() throws AutoScalingMetadataException {
        for (AutoScalingGroupScalingView group : this.autoScalingGroups.listRequiringScaling(TypeMappers.lookup(AutoScalingGroup.class, AutoScalingGroupScalingView.class))) {
            this.runTask(this.perhapsScale(group));
        }
    }

    private void progressUnstableStates() {
        for (UnstableInstanceState state : this.unstableInstanceStates) {
            try {
                List instanceInState = this.autoScalingInstances.listByState(state.getLifecycleState(), state.getConfigurationState(), TypeMappers.lookup(AutoScalingInstance.class, AutoScalingInstanceGroupView.class));
                HashSet groupArns = Sets.newHashSet((Iterable)Iterables.transform(instanceInState, AutoScalingInstances.groupArn()));
                for (String groupArn : groupArns) {
                    Iterable groupInstances = Iterables.filter(instanceInState, (Predicate)CollectionUtils.propertyPredicate((Object)groupArn, AutoScalingInstances.groupArn()));
                    this.runTask((ScalingProcessTask)state.getStateProgressFunction().apply((Object)groupInstances));
                }
            }
            catch (Exception e) {
                logger.error((Object)e, (Throwable)e);
            }
        }
    }

    private void updateUnavailableZones() throws AutoScalingMetadataException {
        Set<String> unavailableZones = this.zoneMonitor.getUnavailableZones(AutoScalingConfiguration.getZoneFailureThresholdMillis());
        this.zoneAvailabilityMarkers.updateUnavailableZones(unavailableZones, new ZoneUnavailabilityMarkers.ZoneCallback(){

            @Override
            public void notifyChangedZones(Set<String> zones) throws AutoScalingMetadataException {
                ActivityManager.this.autoScalingGroups.markScalingRequiredForZones(zones);
            }
        });
    }

    private List<String> validateReferences(OwnerFullName owner, Consumer<? super Map<String, String>> availabilityZoneToSubnetMapConsumer, Iterable<String> availabilityZones, Iterable<String> loadBalancerNames, Iterable<String> subnetIds, Iterable<String> imageIds, @Nullable String instanceType, @Nullable String keyName, Iterable<String> securityGroups, @Nullable String iamInstanceProfile) {
        ArrayList errors = Lists.newArrayList();
        ValidationScalingProcessTask task = new ValidationScalingProcessTask(owner, availabilityZoneToSubnetMapConsumer, Lists.newArrayList((Iterable)Sets.newLinkedHashSet(availabilityZones)), Lists.newArrayList((Iterable)Sets.newLinkedHashSet(loadBalancerNames)), Lists.newArrayList((Iterable)Sets.newLinkedHashSet(subnetIds)), Lists.newArrayList((Iterable)Sets.newLinkedHashSet(imageIds)), instanceType, keyName, Lists.newArrayList((Iterable)Sets.newLinkedHashSet(securityGroups)));
        this.runTask(task);
        try {
            boolean success = task.getFuture().get();
            if (success) {
                errors.addAll(task.getValidationErrors());
            } else if (task.shouldRun()) {
                errors.add("Unable to validate references at this time.");
            }
            this.validateIamInstanceProfile(owner, iamInstanceProfile, errors);
        }
        catch (ExecutionException e) {
            logger.error((Object)e, (Throwable)e);
            errors.add("Error during reference validation");
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            errors.add("Validation interrupted");
        }
        return errors;
    }

    private void validateIamInstanceProfile(OwnerFullName owner, String iamInstanceProfile, List<String> errors) {
        if (iamInstanceProfile != null) {
            try {
                String accountNumber = owner.getAccountNumber();
                String instanceProfileName = iamInstanceProfile;
                if (iamInstanceProfile.startsWith("arn:")) {
                    Ern ern = Ern.parse((String)iamInstanceProfile);
                    if (ern instanceof EuareResourceName && INSTANCE_PROFILE_RESOURCE.equals(ern.getResourceType())) {
                        if (accountNumber.equals(ern.getNamespace())) {
                            instanceProfileName = ((EuareResourceName)ern).getName();
                        } else {
                            instanceProfileName = null;
                            errors.add("Invalid instance profile: " + iamInstanceProfile);
                        }
                    } else {
                        instanceProfileName = null;
                        errors.add("Invalid instance profile: " + iamInstanceProfile);
                    }
                }
                if (instanceProfileName != null) {
                    Accounts.lookupAccountById((String)accountNumber).lookupInstanceProfileByName(instanceProfileName);
                }
            }
            catch (Exception e) {
                errors.add("Invalid instance profile: " + iamInstanceProfile);
            }
        }
    }

    private boolean scalingProcessEnabled(ScalingProcessType type, AutoScalingGroupCoreView group) {
        return !AutoScalingConfiguration.getSuspendedProcesses().contains((Object)type) && type.forView().apply((Object)group);
    }

    private void setScalingNotRequired(AutoScalingGroupCoreView group) {
        try {
            this.updateScalingRequiredFlag(group, false);
        }
        catch (AutoScalingMetadataException e) {
            logger.error((Object)e, (Throwable)e);
        }
    }

    private void updateScalingRequiredFlag(final AutoScalingGroupCoreView group, final boolean scalingRequired) throws AutoScalingMetadataException {
        this.autoScalingGroups.update(group.getOwner(), group.getAutoScalingGroupName(), new Callback<AutoScalingGroup>(){

            public void fire(AutoScalingGroup autoScalingGroup) {
                if (scalingRequired || group.getVersion().equals(autoScalingGroup.getVersion())) {
                    autoScalingGroup.setScalingRequired(scalingRequired);
                    if (!scalingRequired) {
                        autoScalingGroup.setScalingCauses(Lists.newArrayList());
                    }
                }
            }
        });
    }

    private Function<Iterable<AutoScalingInstanceGroupView>, TerminateInstancesScalingProcessTask> terminateInstancesTask() {
        return new Function<Iterable<AutoScalingInstanceGroupView>, TerminateInstancesScalingProcessTask>(){

            public TerminateInstancesScalingProcessTask apply(Iterable<AutoScalingInstanceGroupView> groupInstances) {
                return ActivityManager.this.terminateInstancesTask(groupInstances);
            }
        };
    }

    private TerminateInstancesScalingProcessTask terminateInstancesTask(Iterable<AutoScalingInstanceGroupView> groupInstances) {
        return new TerminateInstancesScalingProcessTask(((AutoScalingInstanceGroupView)Iterables.get(groupInstances, (int)0)).getAutoScalingGroup(), ((AutoScalingInstanceGroupView)Iterables.get(groupInstances, (int)0)).getAutoScalingGroup().getCapacity(), (List<String>)Lists.newArrayList((Iterable)Iterables.transform(groupInstances, (Function)RestrictedTypes.toDisplayName())), Collections.emptyList(), true, true);
    }

    private ScalingProcessTask<?, ?> perhapsTerminateInstances(AutoScalingGroupScalingView group, int terminateCount) {
        ArrayList instancesToTerminate = Lists.newArrayList();
        boolean anyRegisteredInstances = false;
        int currentCapacity = 0;
        try {
            List<AutoScalingInstanceCoreView> currentInstances = this.autoScalingInstances.listByGroup(group, (Predicate<? super AutoScalingInstance>)Predicates.alwaysTrue(), TypeMappers.lookup(AutoScalingInstance.class, AutoScalingInstanceCoreView.class));
            currentCapacity = currentInstances.size();
            if (currentInstances.size() == terminateCount) {
                Iterables.addAll((Collection)instancesToTerminate, (Iterable)Iterables.transform(currentInstances, (Function)RestrictedTypes.toDisplayName()));
                anyRegisteredInstances = Iterables.any(currentInstances, ConfigurationState.Registered.forView());
            } else {
                HashSet targetZones;
                LinkedHashSet groupZones = Sets.newLinkedHashSet(group.getAvailabilityZones());
                groupZones.removeAll(this.zoneMonitor.getUnavailableZones(AutoScalingConfiguration.getZoneFailureThresholdMillis()));
                HashSet unwantedZones = Sets.newHashSet((Iterable)Iterables.transform(currentInstances, AutoScalingInstances.availabilityZone()));
                unwantedZones.removeAll(groupZones);
                ArrayList remainingInstances = Lists.newArrayList(currentInstances);
                if (!unwantedZones.isEmpty()) {
                    int unwantedInstanceCount = (Integer)CollectionUtils.reduce(currentInstances, (Object)0, (Function)CollectionUtils.count(this.withAvailabilityZone(unwantedZones)));
                    if (unwantedInstanceCount < terminateCount) {
                        Iterable unwantedInstances = Iterables.filter(currentInstances, this.withAvailabilityZone(unwantedZones));
                        Iterables.addAll((Collection)instancesToTerminate, (Iterable)Iterables.transform((Iterable)unwantedInstances, (Function)RestrictedTypes.toDisplayName()));
                        Iterables.removeAll((Iterable)remainingInstances, (Collection)Lists.newArrayList((Iterable)unwantedInstances));
                        anyRegisteredInstances = Iterables.any((Iterable)unwantedInstances, ConfigurationState.Registered.forView());
                        targetZones = groupZones;
                    } else {
                        targetZones = unwantedZones;
                    }
                } else {
                    targetZones = groupZones;
                }
                Map<String, Integer> zoneCounts = this.buildAvailabilityZoneInstanceCounts(currentInstances, targetZones);
                for (int i = instancesToTerminate.size(); i < terminateCount && remainingInstances.size() >= 1; ++i) {
                    Map.Entry<String, Integer> entry = this.selectEntry(zoneCounts, (Comparator)Ordering.natural().reverse());
                    AutoScalingInstanceCoreView instanceForTermination = TerminationPolicyType.selectForTermination(group.getTerminationPolicies(), Lists.newArrayList((Iterable)Iterables.filter((Iterable)remainingInstances, this.withAvailabilityZone(entry.getKey()))));
                    remainingInstances.remove(instanceForTermination);
                    entry.setValue(entry.getValue() - 1);
                    instancesToTerminate.add(instanceForTermination.getInstanceId());
                    anyRegisteredInstances |= ConfigurationState.Registered.forView().apply((Object)instanceForTermination);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
        }
        ArrayList causes = Lists.newArrayList();
        causes.add(new ActivityCause(String.format("an instance was taken out of service in response to a difference between desired and actual capacity, shrinking the capacity from %1$d to %2$d", group.getCapacity(), group.getCapacity() - instancesToTerminate.size())));
        for (String instanceId : instancesToTerminate) {
            causes.add(new ActivityCause(String.format("instance %1$s was selected for termination", instanceId)));
        }
        return this.removeFromLoadBalancerOrTerminate(group, currentCapacity, anyRegisteredInstances, instancesToTerminate, causes, false);
    }

    private ScalingProcessTask<?, ?> perhapsReplaceInstances(AutoScalingGroupScalingView group) {
        ArrayList instancesToTerminate = Lists.newArrayList();
        boolean anyRegisteredInstances = false;
        if (this.scalingProcessEnabled(ScalingProcessType.ReplaceUnhealthy, group)) {
            try {
                List currentInstances = this.autoScalingInstances.listUnhealthyByGroup(group, TypeMappers.lookup(AutoScalingInstance.class, AutoScalingInstanceCoreView.class));
                Iterables.addAll((Collection)instancesToTerminate, (Iterable)Iterables.limit((Iterable)Iterables.transform(currentInstances, (Function)RestrictedTypes.toDisplayName()), (int)Math.min(AutoScalingConfiguration.getMaxLaunchIncrement(), currentInstances.size())));
                anyRegisteredInstances = Iterables.any(currentInstances, ConfigurationState.Registered.forView());
                if (!instancesToTerminate.isEmpty()) {
                    logger.info((Object)("Terminating unhealthy instances: " + instancesToTerminate));
                }
            }
            catch (Exception e) {
                logger.error((Object)e, (Throwable)e);
            }
        }
        return this.removeFromLoadBalancerOrTerminate(group, group.getCapacity(), anyRegisteredInstances, instancesToTerminate, Collections.singletonList(new ActivityCause("an instance was taken out of service in response to a health-check")), true);
    }

    private ScalingProcessTask<?, ?> perhapsScale(AutoScalingGroupScalingView group) {
        String cause;
        List currentInstances;
        try {
            currentInstances = this.autoScalingInstances.listByGroup(group, (Predicate<? super AutoScalingInstance>)Predicates.alwaysTrue(), TypeMappers.lookup(AutoScalingInstance.class, AutoScalingInstanceCoreView.class));
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
            return new LaunchInstancesScalingProcessTask(group, 0, "");
        }
        if (group.getCapacity() > group.getDesiredCapacity()) {
            if (!Iterables.all(currentInstances, (Predicate)Predicates.and((Predicate[])new Predicate[]{LifecycleState.InService.forView(), ConfigurationState.Registered.forView(), HealthStatus.Healthy.forView()}))) {
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("Group over desired capacity (" + group.getCapacity() + "/" + group.getDesiredCapacity() + "), waiting for scaling operations to complete."));
                }
                return new LaunchInstancesScalingProcessTask(group, 0, "");
            }
            return this.perhapsTerminateInstances(group, group.getCapacity() - group.getDesiredCapacity());
        }
        List zones = Lists.transform(currentInstances, AutoScalingInstances.availabilityZone());
        LinkedHashSet groupZones = Sets.newLinkedHashSet(group.getAvailabilityZones());
        Set<String> unavailableZones = this.zoneMonitor.getUnavailableZones(AutoScalingConfiguration.getZoneFailureThresholdMillis());
        groupZones.removeAll(unavailableZones);
        int expectedInstancesPerZone = group.getCapacity() / Math.max(1, groupZones.size());
        int requiredInstances = 0;
        for (String zone : groupZones) {
            int instanceCount = (Integer)CollectionUtils.reduce((Iterable)zones, (Object)0, (Function)CollectionUtils.count((Predicate)Predicates.equalTo((Object)zone)));
            if (instanceCount >= expectedInstancesPerZone) continue;
            requiredInstances += expectedInstancesPerZone - instanceCount;
        }
        int hardInstanceLimit = group.getDesiredCapacity() + Math.max(1, group.getDesiredCapacity() / 10);
        if (requiredInstances + group.getCapacity() > hardInstanceLimit) {
            requiredInstances = hardInstanceLimit - group.getCapacity();
        } else if (requiredInstances + group.getCapacity() < group.getDesiredCapacity()) {
            requiredInstances = group.getDesiredCapacity() - group.getCapacity();
        }
        if (requiredInstances == 0) {
            this.setScalingNotRequired(group);
        } else if (!this.scalingProcessEnabled(ScalingProcessType.AZRebalance, group) && group.getCapacity().equals(group.getDesiredCapacity())) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("AZ rebalancing disabled, suppressing launch of " + requiredInstances + " instance(s)"));
            }
            requiredInstances = 0;
        }
        if (group.getCapacity() < group.getDesiredCapacity()) {
            cause = String.format("an instance was started in response to a difference between desired and actual capacity, increasing the capacity from %1$d to %2$d", group.getCapacity(), group.getCapacity() + requiredInstances);
        } else {
            HashSet groupZoneSet = Sets.newHashSet(group.getAvailabilityZones());
            TreeSet invalidZoneSet = Sets.newTreeSet();
            Iterables.addAll((Collection)invalidZoneSet, (Iterable)Sets.intersection((Set)groupZoneSet, unavailableZones));
            Iterables.addAll((Collection)invalidZoneSet, (Iterable)Sets.difference((Set)Sets.newHashSet((Iterable)zones), (Set)groupZoneSet));
            ArrayList invalidZoneCounts = Lists.newArrayList();
            for (String zone : invalidZoneSet) {
                invalidZoneCounts.add(CollectionUtils.reduce((Iterable)zones, (Object)0, (Function)CollectionUtils.count((Predicate)Predicates.equalTo((Object)zone))));
            }
            String invalidZones = Joiner.on((String)", ").join((Iterable)invalidZoneSet);
            String invalidZoneInstanceCounts = Joiner.on((String)", ").join((Iterable)invalidZoneCounts);
            cause = String.format("invalid availability zones %1$s had %2$s instances respectively. An instance was launched to aid in migrating instances from these zones to valid ones", invalidZones, invalidZoneInstanceCounts);
        }
        return new LaunchInstancesScalingProcessTask(group, requiredInstances, cause);
    }

    private Function<Iterable<AutoScalingInstanceGroupView>, AddToLoadBalancerScalingProcessTask> addToLoadBalancer() {
        return new Function<Iterable<AutoScalingInstanceGroupView>, AddToLoadBalancerScalingProcessTask>(){

            public AddToLoadBalancerScalingProcessTask apply(Iterable<AutoScalingInstanceGroupView> groupInstances) {
                return ActivityManager.this.addToLoadBalancer(groupInstances);
            }
        };
    }

    private AddToLoadBalancerScalingProcessTask addToLoadBalancer(Iterable<AutoScalingInstanceGroupView> unregisteredInstances) {
        AutoScalingGroupCoreView group = ((AutoScalingInstanceGroupView)Iterables.get(unregisteredInstances, (int)0)).getAutoScalingGroup();
        ArrayList instancesToRegister = Lists.newArrayList();
        if (group.getLoadBalancerNames().isEmpty() || !this.scalingProcessEnabled(ScalingProcessType.AddToLoadBalancer, group)) {
            this.transitionToRegistered(group, Lists.newArrayList((Iterable)Iterables.transform(unregisteredInstances, (Function)RestrictedTypes.toDisplayName())));
        } else {
            Iterables.addAll((Collection)instancesToRegister, (Iterable)Iterables.transform(unregisteredInstances, (Function)RestrictedTypes.toDisplayName()));
        }
        return new AddToLoadBalancerScalingProcessTask(group, instancesToRegister);
    }

    private Function<Iterable<AutoScalingInstanceGroupView>, ScalingProcessTask<?, ?>> removeFromLoadBalancerOrTerminate() {
        return new Function<Iterable<AutoScalingInstanceGroupView>, ScalingProcessTask<?, ?>>(){

            public ScalingProcessTask<?, ?> apply(Iterable<AutoScalingInstanceGroupView> groupInstances) {
                boolean anyRegisteredInstances = Iterables.any(groupInstances, ConfigurationState.Registered.forView());
                return ActivityManager.this.removeFromLoadBalancerOrTerminate(((AutoScalingInstanceGroupView)Iterables.get(groupInstances, (int)0)).getAutoScalingGroup(), anyRegisteredInstances, Lists.newArrayList((Iterable)Iterables.transform(groupInstances, (Function)RestrictedTypes.toDisplayName())));
            }
        };
    }

    private ScalingProcessTask<?, ?> removeFromLoadBalancerOrTerminate(AutoScalingGroupCoreView group, boolean anyRegisteredInstances, List<String> registeredInstances) {
        ScalingProcessTask task;
        if (group.getLoadBalancerNames().isEmpty() || !anyRegisteredInstances) {
            this.transitionToDeregistered(group, registeredInstances);
            task = new TerminateInstancesScalingProcessTask(group, group.getCapacity(), registeredInstances, Collections.emptyList(), true, true);
        } else {
            task = new RemoveFromLoadBalancerScalingProcessTask(group.getArn(), group, "RemoveFromLoadBalancer", registeredInstances);
        }
        return task;
    }

    private ScalingProcessTask<?, ?> removeFromLoadBalancerOrTerminate(AutoScalingGroupScalingView group, int currentCapacity, boolean anyRegisteredInstances, List<String> registeredInstances, List<ActivityCause> causes, boolean replace) {
        ScalingProcessTask task;
        if (group.getLoadBalancerNames().isEmpty() || !anyRegisteredInstances) {
            this.transitionToDeregistered(group, registeredInstances);
            task = new TerminateInstancesScalingProcessTask(group, currentCapacity, registeredInstances, causes, replace, true, true);
        } else {
            task = new RemoveFromLoadBalancerScalingProcessTask(group, currentCapacity, registeredInstances, causes, replace);
        }
        return task;
    }

    private RunInstancesType runInstances(AutoScalingGroupScalingView group, String availabilityZone, String clientToken, int attemptToLaunch) {
        LaunchConfigurationCoreView launchConfiguration = group.getLaunchConfiguration();
        RunInstancesType runInstances = (RunInstancesType)TypeMappers.transform((Object)launchConfiguration, RunInstancesType.class);
        String subnetId = group.getSubnetIdByZone().get(availabilityZone);
        if (subnetId != null) {
            InstanceNetworkInterfaceSetItemRequestType networkInterface = runInstances.primaryNetworkInterface(true);
            networkInterface.setSubnetId(subnetId);
            if (runInstances.getGroupIdSet() != null && !runInstances.getGroupIdSet().isEmpty()) {
                networkInterface.securityGroups((Iterable)runInstances.getGroupIdSet());
                runInstances.setGroupIdSet(Lists.newArrayList());
            }
        } else {
            runInstances.setAvailabilityZone(availabilityZone);
        }
        runInstances.setClientToken(clientToken);
        runInstances.setMaxCount(attemptToLaunch);
        return runInstances;
    }

    private CreateTagsType tagInstances(List<String> instanceIds, String autoScalingGroupName, List<Tag> tags) {
        CreateTagsType createTags = new CreateTagsType();
        createTags.getTagSet().add(new ResourceTag("aws:autoscaling:groupName", autoScalingGroupName));
        for (Tag tag : tags) {
            createTags.getTagSet().add(new ResourceTag(tag.getKey(), tag.getValue()));
        }
        createTags.getResourcesSet().addAll(instanceIds);
        return createTags;
    }

    private RegisterInstancesWithLoadBalancerType registerInstances(String loadBalancerName, List<String> instanceIds) {
        return new RegisterInstancesWithLoadBalancerType(loadBalancerName, instanceIds);
    }

    private DeregisterInstancesFromLoadBalancerType deregisterInstances(String loadBalancerName, List<String> instanceIds) {
        return new DeregisterInstancesFromLoadBalancerType(loadBalancerName, instanceIds);
    }

    private DescribeInstanceHealthType describeInstanceHealth(String loadBalancerName) {
        return new DescribeInstanceHealthType(loadBalancerName, Collections.emptyList());
    }

    private TerminateInstancesType terminateInstances(Collection<String> instancesToTerminate) {
        TerminateInstancesType terminateInstances = new TerminateInstancesType();
        terminateInstances.getInstancesSet().addAll(instancesToTerminate);
        return terminateInstances;
    }

    private DescribeInstanceStatusType monitorInstances(Collection<String> instanceIds) {
        DescribeInstanceStatusType describeInstanceStatusType = new DescribeInstanceStatusType();
        describeInstanceStatusType.setIncludeAllInstances(Boolean.valueOf(true));
        describeInstanceStatusType.getInstancesSet().addAll(instanceIds);
        describeInstanceStatusType.getFilterSet().add(this.filter("instance-state-name", "pending", "running"));
        describeInstanceStatusType.getFilterSet().add(this.filter("system-status.status", "not-applicable", "initializing", "ok"));
        describeInstanceStatusType.getFilterSet().add(this.filter("instance-status.status", "not-applicable", "initializing", "ok"));
        return describeInstanceStatusType;
    }

    private DescribeTagsType describeTags() {
        DescribeTagsType describeTagsType = new DescribeTagsType();
        describeTagsType.getFilterSet().add(this.filter("key", "aws:autoscaling:groupName"));
        describeTagsType.getFilterSet().add(this.filter("resource-type", "instance"));
        return describeTagsType;
    }

    private Filter filter(String name, String ... values) {
        Filter filter = new Filter();
        filter.setName(name);
        filter.getValueSet().addAll(Arrays.asList(values));
        return filter;
    }

    private Filter filter(String name, Collection<String> values) {
        Filter filter = new Filter();
        filter.setName(name);
        filter.getValueSet().addAll(values);
        return filter;
    }

    private void transitionToRegistered(AutoScalingMetadata.AutoScalingGroupMetadata group, List<String> instanceIds) {
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Transitioning instances " + instanceIds + " to registered for group: " + group.getArn()));
            }
            this.autoScalingInstances.transitionConfigurationState(group, ConfigurationState.Instantiated, ConfigurationState.Registered, instanceIds);
        }
        catch (AutoScalingMetadataException e) {
            logger.error((Object)e, (Throwable)e);
        }
    }

    private void transitionToDeregistered(AutoScalingMetadata.AutoScalingGroupMetadata group, List<String> instanceIds) {
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Transitioning instances " + instanceIds + " to deregistered for group: " + group.getArn()));
            }
            this.autoScalingInstances.transitionConfigurationState(group, ConfigurationState.Registered, ConfigurationState.Instantiated, instanceIds);
        }
        catch (AutoScalingMetadataException e) {
            logger.error((Object)e, (Throwable)e);
        }
    }

    private boolean isTimedOut(Date timestamp) {
        return this.timestamp() - timestamp.getTime() > AutoScalingConfiguration.getActivityTimeoutMillis();
    }

    private Map<String, Integer> buildAvailabilityZoneInstanceCounts(Collection<AutoScalingInstanceCoreView> instances, Collection<String> availabilityZones) {
        TreeMap instanceCountByAz = Maps.newTreeMap();
        for (String az : availabilityZones) {
            instanceCountByAz.put(az, CollectionUtils.reduce(instances, (Object)0, (Function)CollectionUtils.count(this.withAvailabilityZone(az))));
        }
        return instanceCountByAz;
    }

    private Predicate<AutoScalingInstanceCoreView> withAvailabilityZone(String availabilityZone) {
        return this.withAvailabilityZone(Collections.singleton(availabilityZone));
    }

    private Predicate<AutoScalingInstanceCoreView> withAvailabilityZone(Collection<String> availabilityZones) {
        return Predicates.compose((Predicate)Predicates.in(availabilityZones), AutoScalingInstances.availabilityZone());
    }

    private <K, V> Map.Entry<K, V> selectEntry(Map<K, V> map, Comparator<? super V> valueComparator) {
        Map.Entry<K, V> entry = null;
        for (Map.Entry<K, V> currentEntry : map.entrySet()) {
            if (entry != null && valueComparator.compare(entry.getValue(), currentEntry.getValue()) <= 0) continue;
            entry = currentEntry;
        }
        return entry;
    }

    void runTask(ScalingProcessTask task) {
        this.runner.runTask(task);
    }

    boolean taskInProgress(String groupArn) {
        return this.runner.taskInProgress(groupArn);
    }

    EucalyptusClient createEucalyptusClientForUser(String userId) {
        try {
            EucalyptusClient client = new EucalyptusClient(userId);
            client.init();
            return client;
        }
        catch (DispatchingClient.DispatchingClientException e) {
            throw Exceptions.toUndeclared((Throwable)e);
        }
    }

    ElbClient createElbClientForUser(String userId) {
        try {
            ElbClient client = new ElbClient(userId);
            client.init();
            return client;
        }
        catch (DispatchingClient.DispatchingClientException e) {
            throw Exceptions.toUndeclared((Throwable)e);
        }
    }

    public CloudWatchClient createCloudWatchClientForUser(String userId) {
        try {
            CloudWatchClient client = new CloudWatchClient(userId);
            client.init();
            return client;
        }
        catch (DispatchingClient.DispatchingClientException e) {
            throw Exceptions.toUndeclared((Throwable)e);
        }
    }

    VmTypesClient createVmTypesClientForUser(String userId) {
        try {
            VmTypesClient client = new VmTypesClient(userId);
            client.init();
            return client;
        }
        catch (DispatchingClient.DispatchingClientException e) {
            throw Exceptions.toUndeclared((Throwable)e);
        }
    }

    Supplier<String> userIdSupplier(final String accountNumber) {
        return new Supplier<String>(){

            public String get() {
                try {
                    return Accounts.lookupAccountById((String)accountNumber).lookupAdmin().getUserId();
                }
                catch (AuthException e) {
                    throw Exceptions.toUndeclared((Throwable)e);
                }
            }
        };
    }

    List<Tag> getTags(AutoScalingMetadata.AutoScalingGroupMetadata group) {
        AccountFullName accountFullName = AccountFullName.getInstance((String)group.getOwner().getAccountNumber(), (String[])new String[0]);
        return TagSupport.forResourceClass(AutoScalingGroup.class).getResourceTags((OwnerFullName)accountFullName, group.getDisplayName(), (Predicate<? super Tag>)new Predicate<Tag>(){

            public boolean apply(Tag tag) {
                return (Boolean)Objects.firstNonNull((Object)tag.getPropagateAtLaunch(), (Object)Boolean.FALSE);
            }
        });
    }

    private boolean shouldSuspendDueToLaunchFailure(AutoScalingMetadata.AutoScalingGroupMetadata group) {
        TimestampedValue newCount;
        TimestampedValue count;
        do {
            count = (TimestampedValue)this.launchFailureCounters.get(group.getArn());
            newCount = new TimestampedValue((Integer)((TimestampedValue)Objects.firstNonNull((Object)count, new TimestampedValue(0))).getValue() + 1);
        } while ((count != null || this.launchFailureCounters.putIfAbsent(group.getArn(), newCount) != null) && (count == null || !this.launchFailureCounters.replace(group.getArn(), count, newCount)));
        return (Integer)newCount.getValue() >= AutoScalingConfiguration.getSuspensionLaunchAttemptsThreshold();
    }

    private void clearLaunchFailures(AutoScalingMetadata.AutoScalingGroupMetadata group) {
        this.launchFailureCounters.remove(group.getArn());
    }

    private boolean shouldTerminateUntrackedInstance(String instanceId) {
        TimestampedValue newTimestamp;
        TimestampedValue timestamp;
        do {
            timestamp = (TimestampedValue)this.untrackedInstanceTimestamps.get(instanceId);
            newTimestamp = (TimestampedValue)Objects.firstNonNull((Object)timestamp, new TimestampedValue(null));
        } while ((timestamp != null || this.untrackedInstanceTimestamps.putIfAbsent(instanceId, newTimestamp) != null) && timestamp == null);
        return this.timestamp() - newTimestamp.getTimestamp() >= AutoScalingConfiguration.getUntrackedInstanceTimeoutMillis();
    }

    private Predicate<String> shouldTerminateUntrackedInstance() {
        return new Predicate<String>(){

            public boolean apply(String instanceId) {
                return ActivityManager.this.shouldTerminateUntrackedInstance(instanceId);
            }
        };
    }

    private void clearUntrackedInstances(Collection<String> instanceIds) {
        this.untrackedInstanceTimestamps.keySet().removeAll(instanceIds);
    }

    public static class ActivityManagerEventListener
    implements EventListener<ClockTick> {
        private final ActivityManager activityManager = new ActivityManager();

        public static void register() {
            Listeners.register(ClockTick.class, (EventListener)new ActivityManagerEventListener());
        }

        public void fireEvent(ClockTick event) {
            if (Bootstrap.isOperational().booleanValue() && Topology.isEnabledLocally(AutoScalingBackend.class) && Topology.isEnabled(Eucalyptus.class)) {
                this.activityManager.doScaling();
            }
        }
    }

    private static enum CauseTransform implements Function<GroupScalingCause, ActivityCause>
    {
        INSTANCE;


        public ActivityCause apply(GroupScalingCause groupScalingCause) {
            return new ActivityCause(groupScalingCause.getTimestamp(), groupScalingCause.getDetail());
        }
    }

    private static class TimestampedValue<T> {
        private final T value;
        private final long timestamp;

        private TimestampedValue(T value) {
            this.value = value;
            this.timestamp = System.currentTimeMillis();
        }

        public T getValue() {
            return this.value;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TimestampedValue that = (TimestampedValue)o;
            return this.timestamp == that.timestamp && !(this.value == null ? that.value != null : !this.value.equals(that.value));
        }

        public int hashCode() {
            int result = this.value != null ? this.value.hashCode() : 0;
            result = 31 * result + (int)(this.timestamp ^ this.timestamp >>> 32);
            return result;
        }
    }

    private static abstract class ScalingTask {
        private volatile int count = 0;
        private final int factor;
        private final ActivityTask task;

        ScalingTask(int factor, ActivityTask task) {
            this.factor = factor;
            this.task = task;
        }

        int calcFactor() {
            return this.factor / (int)Math.max(1L, SystemClock.RATE / 1000L);
        }

        void perhapsWork() throws Exception {
            if (++this.count % this.calcFactor() == 0 && !AutoScalingConfiguration.getSuspendedTasks().contains((Object)this.task)) {
                logger.trace((Object)("Running auto scaling task: " + (Object)((Object)this.task)));
                this.doWork();
                logger.trace((Object)("Completed auto scaling task: " + (Object)((Object)this.task)));
            }
        }

        abstract void doWork() throws Exception;
    }

    private class AlarmLookupProcessTask
    extends ScalingProcessTask<AutoScalingGroupCoreView, AlarmLookupActivityTask> {
        private final List<String> policyArns;
        private final AtomicReference<Map<String, Collection<String>>> policyArnToAlarmArns;

        AlarmLookupProcessTask(OwnerFullName owner, List<String> policyArns) {
            super(ActivityManager.this, UUID.randomUUID().toString() + "-alarm-lookup", (AutoScalingGroupCoreView)TypeMappers.transform((Object)((Object)AutoScalingGroup.withOwner(owner)), AutoScalingGroupCoreView.class), "AlarmLookup");
            this.policyArnToAlarmArns = new AtomicReference(Collections.emptyMap());
            this.policyArns = policyArns;
        }

        @Override
        boolean shouldRun() {
            return !this.policyArns.isEmpty();
        }

        @Override
        List<AlarmLookupActivityTask> buildActivityTasks() throws AutoScalingMetadataException {
            ArrayList tasks = Lists.newArrayList();
            for (String policyArn : this.policyArns) {
                tasks.add(new AlarmLookupActivityTask((AutoScalingGroupCoreView)this.getGroup(), this.newActivity(), policyArn));
            }
            return tasks;
        }

        @Override
        void partialSuccess(List<AlarmLookupActivityTask> tasks) {
            HashMap policyArnToAlarmArns = Maps.newHashMap();
            for (AlarmLookupActivityTask task : tasks) {
                policyArnToAlarmArns.put(task.getPolicyArn(), task.getAlarmArns());
            }
            this.policyArnToAlarmArns.set((Map<String, Collection<String>>)ImmutableMap.copyOf((Map)policyArnToAlarmArns));
        }

        Map<String, Collection<String>> getPolicyArnToAlarmArns() {
            return this.policyArnToAlarmArns.get();
        }
    }

    private class AlarmLookupActivityTask
    extends ScalingActivityTask<AutoScalingGroupCoreView, DescribeAlarmsResponseType> {
        private final String policyArn;
        private final AtomicReference<Collection<String>> alarmArns;

        private AlarmLookupActivityTask(AutoScalingGroupCoreView group, ScalingActivity activity, String policyArn) {
            super(ActivityManager.this, group, activity, false);
            this.alarmArns = new AtomicReference(Collections.emptyList());
            this.policyArn = policyArn;
        }

        @Override
        void dispatchInternal(ActivityContext context, Callback.Checked<DescribeAlarmsResponseType> callback) {
            CloudWatchClient client = context.getCloudWatchClient();
            DescribeAlarmsType describeAlarmsType = new DescribeAlarmsType();
            describeAlarmsType.setActionPrefix(this.policyArn);
            client.dispatch((BaseMessage)describeAlarmsType, callback);
        }

        @Override
        void dispatchSuccess(ActivityContext context, DescribeAlarmsResponseType response) {
            ArrayList arns = Lists.newArrayList();
            if (response.getDescribeAlarmsResult() != null && response.getDescribeAlarmsResult().getMetricAlarms() != null) {
                for (MetricAlarm metricAlarm : response.getDescribeAlarmsResult().getMetricAlarms().getMember()) {
                    ResourceList list = metricAlarm.getAlarmActions();
                    if (list == null || !list.getMember().contains(this.policyArn)) continue;
                    arns.add(metricAlarm.getAlarmArn());
                }
            }
            this.alarmArns.set(arns);
            this.setActivityFinalStatus(ActivityStatusCode.Successful);
        }

        String getPolicyArn() {
            return this.policyArn;
        }

        Collection<String> getAlarmArns() {
            return this.alarmArns.get();
        }
    }

    private class ValidationScalingProcessTask
    extends ScalingProcessTask<AutoScalingGroupCoreView, ValidationScalingActivityTask<?>> {
        private final Consumer<? super Map<String, String>> availabilityZoneToSubnetMapConsumer;
        private final List<String> availabilityZones;
        private final List<String> loadBalancerNames;
        private final List<String> subnetIds;
        private final List<String> imageIds;
        private final List<String> securityGroups;
        @Nullable
        private final String instanceType;
        @Nullable
        private final String keyName;
        private final AtomicReference<List<String>> validationErrors;

        ValidationScalingProcessTask(OwnerFullName owner, Consumer<? super Map<String, String>> availabilityZoneToSubnetMapConsumer, List<String> availabilityZones, List<String> loadBalancerNames, List<String> subnetIds, @Nullable List<String> imageIds, @Nullable String instanceType, String keyName, List<String> securityGroups) {
            super(ActivityManager.this, UUID.randomUUID().toString() + "-validation", (AutoScalingGroupCoreView)TypeMappers.transform((Object)((Object)AutoScalingGroup.withOwner(owner)), AutoScalingGroupCoreView.class), "Validate");
            this.validationErrors = new AtomicReference(Collections.emptyList());
            this.availabilityZoneToSubnetMapConsumer = availabilityZoneToSubnetMapConsumer;
            this.availabilityZones = availabilityZones;
            this.loadBalancerNames = loadBalancerNames;
            this.subnetIds = subnetIds;
            this.imageIds = imageIds;
            this.instanceType = instanceType;
            this.keyName = keyName;
            this.securityGroups = securityGroups;
        }

        @Override
        boolean shouldRun() {
            return !this.availabilityZones.isEmpty() || !this.subnetIds.isEmpty() || !this.loadBalancerNames.isEmpty() || !this.imageIds.isEmpty() || this.instanceType != null || this.keyName != null || !this.securityGroups.isEmpty();
        }

        @Override
        List<ValidationScalingActivityTask<?>> buildActivityTasks() throws AutoScalingMetadataException {
            ArrayList tasks = Lists.newArrayList();
            if (!this.availabilityZones.isEmpty()) {
                tasks.add(new AZValidationScalingActivityTask((AutoScalingGroupCoreView)this.getGroup(), this.newActivity(), this.availabilityZones));
            }
            if (!this.loadBalancerNames.isEmpty()) {
                tasks.add(new LoadBalancerValidationScalingActivityTask((AutoScalingGroupCoreView)this.getGroup(), this.newActivity(), this.loadBalancerNames));
            }
            if (!this.subnetIds.isEmpty()) {
                tasks.add(new SubnetValidationScalingActivityTask((AutoScalingGroupCoreView)this.getGroup(), this.newActivity(), this.subnetIds, this.availabilityZones, (Consumer)this.availabilityZoneToSubnetMapConsumer));
            }
            if (!this.imageIds.isEmpty()) {
                tasks.add(new ImageIdValidationScalingActivityTask((AutoScalingGroupCoreView)this.getGroup(), this.newActivity(), this.imageIds));
            }
            if (this.instanceType != null) {
                tasks.add(new InstanceTypeValidationScalingActivityTask((AutoScalingGroupCoreView)this.getGroup(), this.newActivity(), this.instanceType));
            }
            if (this.keyName != null) {
                tasks.add(new SshKeyValidationScalingActivityTask((AutoScalingGroupCoreView)this.getGroup(), this.newActivity(), this.keyName));
            }
            if (!this.securityGroups.isEmpty()) {
                tasks.add(new SecurityGroupValidationScalingActivityTask((AutoScalingGroupCoreView)this.getGroup(), this.newActivity(), this.securityGroups));
            }
            return tasks;
        }

        @Override
        void partialSuccess(List<ValidationScalingActivityTask<?>> tasks) {
            ArrayList validationErrors = Lists.newArrayList();
            for (ValidationScalingActivityTask<?> task : tasks) {
                validationErrors.addAll(task.getValidationErrors());
            }
            this.validationErrors.set((List<String>)ImmutableList.copyOf((Collection)validationErrors));
        }

        List<String> getValidationErrors() {
            return this.validationErrors.get();
        }
    }

    private class SecurityGroupValidationScalingActivityTask
    extends ValidationScalingActivityTask<DescribeSecurityGroupsResponseType> {
        private final List<String> groups;
        private final boolean identifiers;

        private SecurityGroupValidationScalingActivityTask(AutoScalingGroupCoreView group, ScalingActivity activity, List<String> groups) {
            super(group, activity, "security group(s)");
            this.groups = groups;
            this.identifiers = LaunchConfigurations.containsSecurityGroupIdentifiers(groups);
        }

        @Override
        void dispatchInternal(ActivityContext context, Callback.Checked<DescribeSecurityGroupsResponseType> callback) {
            EucalyptusClient client = context.getEucalyptusClient();
            DescribeSecurityGroupsType describeSecurityGroupsType = new DescribeSecurityGroupsType();
            describeSecurityGroupsType.getSecurityGroupSet().add("verbose");
            describeSecurityGroupsType.getFilterSet().add(ActivityManager.this.filter(this.identifiers ? "group-id" : "group-name", this.groups));
            client.dispatch((BaseMessage)describeSecurityGroupsType, callback);
        }

        @Override
        void dispatchSuccess(ActivityContext context, DescribeSecurityGroupsResponseType response) {
            if (response.getSecurityGroupInfo() == null) {
                this.setValidationError("Invalid security group(s): " + this.groups);
            } else if (response.getSecurityGroupInfo().size() != this.groups.size()) {
                HashSet foundGroups = Sets.newHashSet();
                for (SecurityGroupItemType securityGroupItemType : response.getSecurityGroupInfo()) {
                    foundGroups.add(this.identifiers ? securityGroupItemType.getGroupId() : securityGroupItemType.getGroupName());
                }
                TreeSet invalidGroups = Sets.newTreeSet(this.groups);
                invalidGroups.removeAll(foundGroups);
                this.setValidationError("Invalid security group(s): " + invalidGroups);
            }
            this.setActivityFinalStatus(ActivityStatusCode.Successful);
        }
    }

    private class SshKeyValidationScalingActivityTask
    extends ValidationScalingActivityTask<DescribeKeyPairsResponseType> {
        final String sshKey;

        private SshKeyValidationScalingActivityTask(AutoScalingGroupCoreView group, ScalingActivity activity, String sshKey) {
            super(group, activity, "ssh key");
            this.sshKey = sshKey;
        }

        @Override
        void dispatchInternal(ActivityContext context, Callback.Checked<DescribeKeyPairsResponseType> callback) {
            EucalyptusClient client = context.getEucalyptusClient();
            DescribeKeyPairsType describeKeyPairsType = new DescribeKeyPairsType();
            describeKeyPairsType.getFilterSet().add(ActivityManager.this.filter("key-name", new String[]{this.sshKey}));
            client.dispatch((BaseMessage)describeKeyPairsType, callback);
        }

        @Override
        void dispatchSuccess(ActivityContext context, DescribeKeyPairsResponseType response) {
            if (response.getKeySet() == null || response.getKeySet().size() != 1) {
                this.setValidationError("Invalid ssh key: " + this.sshKey);
            }
            this.setActivityFinalStatus(ActivityStatusCode.Successful);
        }
    }

    private class InstanceTypeValidationScalingActivityTask
    extends ValidationScalingActivityTask<DescribeInstanceTypesResponseType> {
        final String instanceType;

        private InstanceTypeValidationScalingActivityTask(AutoScalingGroupCoreView group, ScalingActivity activity, String instanceType) {
            super(group, activity, "instance type");
            this.instanceType = instanceType;
        }

        @Override
        void dispatchInternal(ActivityContext context, Callback.Checked<DescribeInstanceTypesResponseType> callback) {
            VmTypesClient client = context.getVmTypesClient();
            client.dispatch((BaseMessage)new DescribeInstanceTypesType(Collections.singleton(this.instanceType)), callback);
        }

        @Override
        void dispatchSuccess(ActivityContext context, DescribeInstanceTypesResponseType response) {
            if (response.getInstanceTypeDetails() == null || response.getInstanceTypeDetails().size() != 1) {
                this.setValidationError("Invalid instance type: " + this.instanceType);
            }
            this.setActivityFinalStatus(ActivityStatusCode.Successful);
        }
    }

    private class ImageIdValidationScalingActivityTask
    extends ValidationScalingActivityTask<DescribeImagesResponseType> {
        final List<String> imageIds;

        private ImageIdValidationScalingActivityTask(AutoScalingGroupCoreView group, ScalingActivity activity, List<String> imageIds) {
            super(group, activity, "image id(s)");
            this.imageIds = imageIds;
        }

        @Override
        void dispatchInternal(ActivityContext context, Callback.Checked<DescribeImagesResponseType> callback) {
            EucalyptusClient client = context.getEucalyptusClient();
            DescribeImagesType describeImagesType = new DescribeImagesType();
            describeImagesType.getFilterSet().add(ActivityManager.this.filter("image-id", this.imageIds));
            client.dispatch((BaseMessage)describeImagesType, callback);
        }

        @Override
        void dispatchSuccess(ActivityContext context, DescribeImagesResponseType response) {
            if (response.getImagesSet() == null) {
                this.setValidationError("Invalid image id(s): " + this.imageIds);
            } else if (response.getImagesSet().size() != this.imageIds.size()) {
                HashSet images = Sets.newHashSet();
                for (ImageDetails imageDetails : response.getImagesSet()) {
                    images.add(imageDetails.getImageId());
                }
                TreeSet invalidImages = Sets.newTreeSet(this.imageIds);
                invalidImages.removeAll(images);
                this.setValidationError("Invalid image id(s): " + invalidImages);
            }
            this.setActivityFinalStatus(ActivityStatusCode.Successful);
        }
    }

    private class LoadBalancerValidationScalingActivityTask
    extends ValidationScalingActivityTask<DescribeLoadBalancersResponseType> {
        final List<String> loadBalancerNames;

        private LoadBalancerValidationScalingActivityTask(AutoScalingGroupCoreView group, ScalingActivity activity, List<String> loadBalancerNames) {
            super(group, activity, "load balancer name(s)");
            this.loadBalancerNames = loadBalancerNames;
        }

        @Override
        void dispatchInternal(ActivityContext context, Callback.Checked<DescribeLoadBalancersResponseType> callback) {
            ElbClient client = context.getElbClient();
            LoadBalancerNames loadBalancerNamesType = new LoadBalancerNames();
            loadBalancerNamesType.setMember(Lists.newArrayList(this.loadBalancerNames));
            DescribeLoadBalancersType describeLoadBalancersType = new DescribeLoadBalancersType();
            describeLoadBalancersType.setLoadBalancerNames(loadBalancerNamesType);
            client.dispatch((BaseMessage)describeLoadBalancersType, callback);
        }

        @Override
        void dispatchSuccess(ActivityContext context, DescribeLoadBalancersResponseType response) {
            if (response.getDescribeLoadBalancersResult() == null || response.getDescribeLoadBalancersResult().getLoadBalancerDescriptions() == null) {
                this.setValidationError("Invalid load balancer name(s): " + this.loadBalancerNames);
            } else if (response.getDescribeLoadBalancersResult().getLoadBalancerDescriptions().getMember().size() != this.loadBalancerNames.size()) {
                HashSet loadBalancers = Sets.newHashSet();
                for (LoadBalancerDescription loadBalancerDescription : response.getDescribeLoadBalancersResult().getLoadBalancerDescriptions().getMember()) {
                    loadBalancers.add(loadBalancerDescription.getLoadBalancerName());
                }
                TreeSet invalidLoadBalancers = Sets.newTreeSet(this.loadBalancerNames);
                invalidLoadBalancers.removeAll(loadBalancers);
                this.setValidationError("Invalid load balancer name(s): " + invalidLoadBalancers);
            }
            this.setActivityFinalStatus(ActivityStatusCode.Successful);
        }

        @Override
        void handleValidationFailure(Throwable throwable) {
            super.handleValidationFailure(throwable);
        }
    }

    private class SubnetValidationScalingActivityTask
    extends ValidationScalingActivityTask<DescribeSubnetsResponseType> {
        private final List<String> availabilityZones;
        private final List<String> subnetIds;
        private final Consumer<? super Map<String, String>> availabilityZoneToSubnetMapConsumer;

        private SubnetValidationScalingActivityTask(AutoScalingGroupCoreView group, ScalingActivity activity, List<String> subnetIds, List<String> availabilityZones, Consumer<? super Map<String, String>> availabilityZoneToSubnetMapConsumer) {
            super(group, activity, "subnetId(s)");
            this.subnetIds = subnetIds;
            this.availabilityZones = availabilityZones;
            this.availabilityZoneToSubnetMapConsumer = availabilityZoneToSubnetMapConsumer;
        }

        @Override
        void dispatchInternal(ActivityContext context, Callback.Checked<DescribeSubnetsResponseType> callback) {
            EucalyptusClient client = context.getEucalyptusClient();
            ArrayList subnetIdItems = Lists.newArrayList();
            for (String subnetId : Iterables.concat((Iterable)Lists.newArrayList((Object[])new String[]{"verbose"}), this.subnetIds)) {
                SubnetIdSetItemType subnetIdItem = new SubnetIdSetItemType();
                subnetIdItem.setSubnetId(subnetId);
                subnetIdItems.add(subnetIdItem);
            }
            SubnetIdSetType subnetIdSetType = new SubnetIdSetType();
            subnetIdSetType.setItem(subnetIdItems);
            DescribeSubnetsType describeSubnetsType = new DescribeSubnetsType();
            describeSubnetsType.setSubnetSet(subnetIdSetType);
            client.dispatch((BaseMessage)describeSubnetsType, callback);
        }

        @Override
        void dispatchSuccess(ActivityContext context, DescribeSubnetsResponseType response) {
            if (response.getSubnetSet() == null || response.getSubnetSet().getItem() == null) {
                this.setValidationError("Invalid subnet(s): " + this.subnetIds);
            } else if (response.getSubnetSet().getItem().size() != this.subnetIds.size()) {
                HashSet validSubnetIds = Sets.newHashSet();
                for (SubnetType subnetType : response.getSubnetSet().getItem()) {
                    validSubnetIds.add(subnetType.getSubnetId());
                }
                TreeSet invalidSubnets = Sets.newTreeSet(this.subnetIds);
                invalidSubnets.removeAll(validSubnetIds);
                this.setValidationError("Invalid subnet(s): " + invalidSubnets);
            } else {
                HashSet subnetZones = Sets.newHashSet();
                for (SubnetType subnetType : response.getSubnetSet().getItem()) {
                    subnetZones.add(subnetType.getAvailabilityZone());
                }
                if (subnetZones.size() != this.subnetIds.size()) {
                    this.setValidationError("Found multiple subnets for availability zone(s) ");
                }
                if (!this.availabilityZones.isEmpty() && !subnetZones.equals(Sets.newHashSet(this.availabilityZones))) {
                    this.setValidationError("Specified subnet(s) not consistent with specified availability zone(s)");
                }
                HashMap zonesToSubnetIds = Maps.newHashMap();
                for (SubnetType subnetType : response.getSubnetSet().getItem()) {
                    zonesToSubnetIds.put(subnetType.getAvailabilityZone(), subnetType.getSubnetId());
                }
                this.availabilityZoneToSubnetMapConsumer.accept((Object)ImmutableMap.copyOf((Map)zonesToSubnetIds));
            }
            this.setActivityFinalStatus(ActivityStatusCode.Successful);
        }
    }

    private class AZValidationScalingActivityTask
    extends ValidationScalingActivityTask<DescribeAvailabilityZonesResponseType> {
        final List<String> availabilityZones;

        private AZValidationScalingActivityTask(AutoScalingGroupCoreView group, ScalingActivity activity, List<String> availabilityZones) {
            super(group, activity, "availability zone(s)");
            this.availabilityZones = availabilityZones;
        }

        @Override
        void dispatchInternal(ActivityContext context, Callback.Checked<DescribeAvailabilityZonesResponseType> callback) {
            EucalyptusClient client = context.getEucalyptusClient();
            DescribeAvailabilityZonesType describeAvailabilityZonesType = new DescribeAvailabilityZonesType();
            describeAvailabilityZonesType.setAvailabilityZoneSet(Lists.newArrayList(this.availabilityZones));
            client.dispatch((BaseMessage)describeAvailabilityZonesType, callback);
        }

        @Override
        void dispatchSuccess(ActivityContext context, DescribeAvailabilityZonesResponseType response) {
            if (response.getAvailabilityZoneInfo() == null) {
                this.setValidationError("Invalid availability zone(s): " + this.availabilityZones);
            } else if (response.getAvailabilityZoneInfo().size() != this.availabilityZones.size()) {
                HashSet zones = Sets.newHashSet();
                for (ClusterInfoType clusterInfoType : response.getAvailabilityZoneInfo()) {
                    zones.add(clusterInfoType.getZoneName());
                }
                TreeSet invalidZones = Sets.newTreeSet(this.availabilityZones);
                invalidZones.removeAll(zones);
                this.setValidationError("Invalid availability zone(s): " + invalidZones);
            }
            this.setActivityFinalStatus(ActivityStatusCode.Successful);
        }
    }

    private abstract class ValidationScalingActivityTask<RES extends BaseMessage>
    extends ScalingActivityTask<AutoScalingGroupCoreView, RES> {
        private final String description;
        private final AtomicReference<List<String>> validationErrors;

        private ValidationScalingActivityTask(AutoScalingGroupCoreView group, ScalingActivity activity, String description) {
            super(ActivityManager.this, group, activity, false);
            this.validationErrors = new AtomicReference(Collections.emptyList());
            this.description = description;
        }

        @Override
        boolean dispatchFailure(ActivityContext context, Throwable throwable) {
            boolean result = super.dispatchFailure(context, throwable);
            this.handleValidationFailure(throwable);
            return result;
        }

        void handleValidationFailure(Throwable throwable) {
            this.setValidationError("Error validating " + this.description);
        }

        void setValidationError(String error) {
            this.validationErrors.set((List<String>)ImmutableList.of((Object)error));
        }

        List<String> getValidationErrors() {
            return this.validationErrors.get();
        }
    }

    private class ElbMonitoringScalingProcessTask
    extends ScalingProcessTask<AutoScalingGroupCoreView, ElbMonitoringScalingActivityTask> {
        private final List<String> loadBalancerNames;
        private final List<String> expectedInstanceIds;

        ElbMonitoringScalingProcessTask(AutoScalingGroupCoreView group, List<String> loadBalancerNames, List<String> expectedInstanceIds) {
            super(ActivityManager.this, group, "ElbMonitor");
            this.loadBalancerNames = loadBalancerNames;
            this.expectedInstanceIds = expectedInstanceIds;
        }

        @Override
        boolean shouldRun() {
            return !this.loadBalancerNames.isEmpty() && !this.expectedInstanceIds.isEmpty();
        }

        @Override
        List<ElbMonitoringScalingActivityTask> buildActivityTasks() throws AutoScalingMetadataException {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Performing ELB health check for group: " + ((AutoScalingGroupMinimumView)this.getGroup()).getArn()));
            }
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Expected instances: " + this.expectedInstanceIds));
            }
            ArrayList activities = Lists.newArrayList();
            for (String loadBalancerName : this.loadBalancerNames) {
                activities.add(new ElbMonitoringScalingActivityTask((AutoScalingGroupCoreView)this.getGroup(), this.newActivity(), loadBalancerName));
            }
            return activities;
        }

        @Override
        void partialSuccess(List<ElbMonitoringScalingActivityTask> tasks) {
            ArrayList healthyInstanceIds = Lists.newArrayList(this.expectedInstanceIds);
            for (ElbMonitoringScalingActivityTask task : tasks) {
                healthyInstanceIds.removeAll(task.getUnhealthyInstanceIds());
            }
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("ELB health check healthy instances: " + healthyInstanceIds));
            }
            try {
                ActivityManager.this.autoScalingInstances.markMissingInstancesUnhealthy((AutoScalingMetadata.AutoScalingGroupMetadata)this.getGroup(), healthyInstanceIds);
            }
            catch (AutoScalingMetadataException e) {
                logger.error((Object)e, (Throwable)e);
            }
        }
    }

    private class ElbMonitoringScalingActivityTask
    extends ScalingActivityTask<AutoScalingGroupCoreView, DescribeInstanceHealthResponseType> {
        private final String loadBalancerName;
        private final AtomicReference<List<String>> unhealthyInstanceIds;

        private ElbMonitoringScalingActivityTask(AutoScalingGroupCoreView group, ScalingActivity activity, String loadBalancerName) {
            super(ActivityManager.this, group, activity, false);
            this.unhealthyInstanceIds = new AtomicReference(Collections.emptyList());
            this.loadBalancerName = loadBalancerName;
        }

        @Override
        void dispatchInternal(ActivityContext context, Callback.Checked<DescribeInstanceHealthResponseType> callback) {
            ElbClient client = context.getElbClient();
            client.dispatch((BaseMessage)ActivityManager.this.describeInstanceHealth(this.loadBalancerName), callback);
        }

        @Override
        void dispatchSuccess(ActivityContext context, DescribeInstanceHealthResponseType response) {
            ArrayList unhealthyInstanceIds = Lists.newArrayList();
            if (response.getDescribeInstanceHealthResult() != null && response.getDescribeInstanceHealthResult().getInstanceStates() != null && response.getDescribeInstanceHealthResult().getInstanceStates().getMember() != null) {
                for (InstanceState instanceStatus : response.getDescribeInstanceHealthResult().getInstanceStates().getMember()) {
                    if (!"OutOfService".equals(instanceStatus.getState())) continue;
                    unhealthyInstanceIds.add(instanceStatus.getInstanceId());
                }
            }
            this.unhealthyInstanceIds.set((List<String>)ImmutableList.copyOf((Collection)unhealthyInstanceIds));
            this.setActivityFinalStatus(ActivityStatusCode.Successful);
        }

        List<String> getUnhealthyInstanceIds() {
            return this.unhealthyInstanceIds.get();
        }
    }

    private class MetricsSubmissionScalingProcessTask
    extends ScalingProcessTask<AutoScalingGroupMetricsView, MetricsSubmissionScalingActivityTask> {
        private final List<AutoScalingInstanceCoreView> autoScalingInstances;

        MetricsSubmissionScalingProcessTask(AutoScalingGroupMetricsView group, List<AutoScalingInstanceCoreView> autoScalingInstances) {
            super(ActivityManager.this, group.getArn() + ":Metrics", (AutoScalingGroupCoreView)group, "MetricsSubmission");
            this.autoScalingInstances = autoScalingInstances;
        }

        @Override
        boolean shouldRun() {
            return !((AutoScalingGroupMetricsView)this.getGroup()).getEnabledMetrics().isEmpty();
        }

        @Override
        List<MetricsSubmissionScalingActivityTask> buildActivityTasks() throws AutoScalingMetadataException {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Putting metrics for group: " + ((AutoScalingGroupMetricsView)this.getGroup()).getArn()));
            }
            return Collections.singletonList(new MetricsSubmissionScalingActivityTask((AutoScalingGroupMetricsView)this.getGroup(), this.newActivity(), this.autoScalingInstances));
        }
    }

    private class MetricsSubmissionScalingActivityTask
    extends ScalingActivityTask<AutoScalingGroupMetricsView, PutMetricDataResponseType> {
        private final List<AutoScalingInstanceCoreView> autoScalingInstances;

        private MetricsSubmissionScalingActivityTask(AutoScalingGroupMetricsView group, ScalingActivity activity, List<AutoScalingInstanceCoreView> autoScalingInstances) {
            super(ActivityManager.this, (AutoScalingGroupCoreView)group, activity, false);
            this.autoScalingInstances = autoScalingInstances;
        }

        @Override
        void dispatchInternal(ActivityContext context, Callback.Checked<PutMetricDataResponseType> callback) {
            CloudWatchClient client = context.getCloudWatchClient();
            Date date = new Date();
            MetricData metricData = new MetricData();
            for (MetricCollectionType metricCollectionType : ((AutoScalingGroupMetricsView)this.getGroup()).getEnabledMetrics()) {
                MetricDatum metricDatum = new MetricDatum();
                metricDatum.setDimensions(new Dimensions(new Dimension("AutoScalingGroupName", ((AutoScalingGroupMetricsView)this.getGroup()).getAutoScalingGroupName())));
                metricDatum.setTimestamp(date);
                metricDatum.setUnit("None");
                metricDatum.setMetricName(metricCollectionType.getDisplayName());
                metricDatum.setValue(metricCollectionType.getValue((AutoScalingGroupMinimumView)this.getGroup(), (Iterable<? extends AutoScalingInstanceCoreView>)this.autoScalingInstances));
                metricData.getMember().add(metricDatum);
            }
            PutMetricDataType putMetricData = new PutMetricDataType();
            putMetricData.setNamespace("AWS/AutoScaling");
            putMetricData.setMetricData(metricData);
            client.dispatch((BaseMessage)putMetricData, callback);
        }

        @Override
        void dispatchSuccess(ActivityContext context, PutMetricDataResponseType response) {
            this.setActivityFinalStatus(ActivityStatusCode.Successful);
        }
    }

    private class MonitoringScalingProcessTask
    extends ScalingProcessTask<AutoScalingGroupCoreView, MonitoringScalingActivityTask> {
        private final List<String> pendingInstanceIds;
        private final List<String> expectedRunningInstanceIds;

        MonitoringScalingProcessTask(AutoScalingGroupCoreView group, List<String> pendingInstanceIds, List<String> expectedRunningInstanceIds) {
            super(ActivityManager.this, group, "Monitor");
            this.pendingInstanceIds = pendingInstanceIds;
            this.expectedRunningInstanceIds = ActivityManager.this.scalingProcessEnabled(ScalingProcessType.HealthCheck, group) ? expectedRunningInstanceIds : Collections.emptyList();
        }

        @Override
        boolean shouldRun() {
            return !this.expectedRunningInstanceIds.isEmpty() || !this.pendingInstanceIds.isEmpty();
        }

        @Override
        ScalingProcessTask onSuccess() {
            return ((AutoScalingGroupCoreView)this.getGroup()).getLoadBalancerNames().isEmpty() || HealthCheckType.ELB != ((AutoScalingGroupMinimumView)this.getGroup()).getHealthCheckType() ? null : new ElbMonitoringScalingProcessTask((AutoScalingGroupCoreView)this.getGroup(), ((AutoScalingGroupCoreView)this.getGroup()).getLoadBalancerNames(), this.expectedRunningInstanceIds);
        }

        @Override
        List<MonitoringScalingActivityTask> buildActivityTasks() throws AutoScalingMetadataException {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Performing EC2 health check for group: " + ((AutoScalingGroupMinimumView)this.getGroup()).getArn()));
            }
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Expected pending instances: " + this.pendingInstanceIds));
                logger.trace((Object)("Expected running instances: " + this.expectedRunningInstanceIds));
            }
            ArrayList instanceIds = Lists.newArrayList((Iterable)Iterables.concat(this.pendingInstanceIds, this.expectedRunningInstanceIds));
            return Collections.singletonList(new MonitoringScalingActivityTask((AutoScalingGroupCoreView)this.getGroup(), this.newActivity(), instanceIds));
        }

        @Override
        void partialSuccess(List<MonitoringScalingActivityTask> tasks) {
            HashSet transitionToInService = Sets.newHashSet(this.pendingInstanceIds);
            HashSet transitionToUnhealthy = Sets.newHashSet(this.pendingInstanceIds);
            HashSet transitionToUnhealthyIfExpired = Sets.newHashSet(this.pendingInstanceIds);
            HashSet healthyInstanceIds = Sets.newHashSet();
            HashSet knownInstanceIds = Sets.newHashSet();
            for (MonitoringScalingActivityTask task : tasks) {
                knownInstanceIds.addAll(task.getKnownInstanceIds());
                healthyInstanceIds.addAll(task.getHealthyInstanceIds());
            }
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("EC2 health check known instances: " + knownInstanceIds));
                logger.trace((Object)("EC2 health check healthy instances: " + healthyInstanceIds));
            }
            transitionToInService.retainAll(healthyInstanceIds);
            transitionToUnhealthy.removeAll(knownInstanceIds);
            transitionToUnhealthyIfExpired.removeAll(healthyInstanceIds);
            if (ActivityManager.this.scalingProcessEnabled(ScalingProcessType.HealthCheck, this.getGroup())) {
                try {
                    ActivityManager.this.autoScalingInstances.markMissingInstancesUnhealthy((AutoScalingMetadata.AutoScalingGroupMetadata)this.getGroup(), healthyInstanceIds);
                }
                catch (AutoScalingMetadataException e) {
                    logger.error((Object)e, (Throwable)e);
                }
            }
            try {
                ActivityManager.this.autoScalingInstances.markExpiredPendingUnhealthy((AutoScalingMetadata.AutoScalingGroupMetadata)this.getGroup(), transitionToUnhealthy, ActivityManager.this.timestamp());
                ActivityManager.this.autoScalingInstances.markExpiredPendingUnhealthy((AutoScalingMetadata.AutoScalingGroupMetadata)this.getGroup(), transitionToUnhealthyIfExpired, ActivityManager.this.timestamp() - AutoScalingConfiguration.getPendingInstanceTimeoutMillis());
            }
            catch (AutoScalingMetadataException e) {
                logger.error((Object)e, (Throwable)e);
            }
            if (!transitionToInService.isEmpty()) {
                try {
                    ActivityManager.this.autoScalingInstances.transitionState((AutoScalingMetadata.AutoScalingGroupMetadata)this.getGroup(), LifecycleState.Pending, LifecycleState.InService, transitionToInService);
                }
                catch (AutoScalingMetadataException e) {
                    logger.error((Object)e, (Throwable)e);
                }
            }
        }
    }

    private class MonitoringScalingActivityTask
    extends ScalingActivityTask<AutoScalingGroupCoreView, DescribeInstanceStatusResponseType> {
        private final List<String> instanceIds;
        private final AtomicReference<List<String>> healthyInstanceIds;
        private final AtomicReference<List<String>> knownInstanceIds;

        private MonitoringScalingActivityTask(AutoScalingGroupCoreView group, ScalingActivity activity, List<String> instanceIds) {
            super(ActivityManager.this, group, activity, false);
            this.healthyInstanceIds = new AtomicReference(Collections.emptyList());
            this.knownInstanceIds = new AtomicReference(Collections.emptyList());
            this.instanceIds = instanceIds;
        }

        @Override
        void dispatchInternal(ActivityContext context, Callback.Checked<DescribeInstanceStatusResponseType> callback) {
            EucalyptusClient client = context.getEucalyptusClient();
            client.dispatch((BaseMessage)ActivityManager.this.monitorInstances(this.instanceIds), callback);
        }

        @Override
        void dispatchSuccess(ActivityContext context, DescribeInstanceStatusResponseType response) {
            ArrayList knownInstanceIds = Lists.newArrayList();
            ArrayList healthyInstanceIds = Lists.newArrayList();
            if (response.getInstanceStatusSet() != null && response.getInstanceStatusSet().getItem() != null) {
                for (InstanceStatusItemType instanceStatus : response.getInstanceStatusSet().getItem()) {
                    knownInstanceIds.add(instanceStatus.getInstanceId());
                    if (instanceStatus.getInstanceState() == null || instanceStatus.getInstanceStatus() == null || !"running".equals(instanceStatus.getInstanceState().getName()) || !"ok".equals(instanceStatus.getInstanceStatus().getStatus())) continue;
                    healthyInstanceIds.add(instanceStatus.getInstanceId());
                }
            }
            this.knownInstanceIds.set((List<String>)ImmutableList.copyOf((Collection)knownInstanceIds));
            this.healthyInstanceIds.set((List<String>)ImmutableList.copyOf((Collection)healthyInstanceIds));
            this.setActivityFinalStatus(ActivityStatusCode.Successful);
        }

        List<String> getKnownInstanceIds() {
            return this.knownInstanceIds.get();
        }

        List<String> getHealthyInstanceIds() {
            return this.healthyInstanceIds.get();
        }
    }

    private class UntrackedInstanceTerminationScalingProcessTask
    extends ScalingProcessTask<AutoScalingGroupCoreView, UntrackedInstanceTerminationScalingActivityTask> {
        private volatile String groupName;
        private volatile List<String> instanceIds;

        UntrackedInstanceTerminationScalingProcessTask(AutoScalingGroupCoreView group) {
            super(ActivityManager.this, group.getOwnerAccountNumber(), group, "UntrackedInstanceTermination");
        }

        @Override
        ScalingProcessTask onSuccess() {
            TerminateInstancesScalingProcessTask terminateTask = null;
            if (this.groupName != null) {
                AutoScalingGroupCoreView groupView = null;
                if (this.groupName.equals(((AutoScalingGroupMinimumView)this.getGroup()).getAutoScalingGroupName())) {
                    groupView = (AutoScalingGroupCoreView)this.getGroup();
                } else {
                    try {
                        groupView = (AutoScalingGroupCoreView)ActivityManager.this.autoScalingGroups.lookup(((AutoScalingGroupMinimumView)this.getGroup()).getOwner(), this.groupName, TypeMappers.lookup(AutoScalingGroup.class, AutoScalingGroupCoreView.class));
                    }
                    catch (AutoScalingMetadataNotFoundException e) {
                        AutoScalingGroup group = AutoScalingGroup.named(((AutoScalingGroupMinimumView)this.getGroup()).getOwner(), this.groupName);
                        group.setCapacity(0);
                        groupView = (AutoScalingGroupCoreView)TypeMappers.transform((Object)((Object)group), AutoScalingGroupCoreView.class);
                    }
                    catch (Exception e) {
                        logger.error((Object)e, (Throwable)e);
                    }
                }
                if (groupView != null) {
                    logger.info((Object)("Terminating untracked auto scaling instances: " + this.instanceIds));
                    terminateTask = new TerminateInstancesScalingProcessTask(groupView, (int)groupView.getCapacity(), this.instanceIds, Collections.emptyList(), false, false){

                        @Override
                        void partialSuccess(List<TerminateInstanceScalingActivityTask> tasks) {
                        }
                    };
                }
            }
            return terminateTask;
        }

        @Override
        boolean shouldRun() {
            return true;
        }

        @Override
        List<UntrackedInstanceTerminationScalingActivityTask> buildActivityTasks() throws AutoScalingMetadataException {
            return Collections.singletonList(new UntrackedInstanceTerminationScalingActivityTask((AutoScalingGroupCoreView)this.getGroup(), this.newActivity()));
        }

        @Override
        void partialSuccess(List<UntrackedInstanceTerminationScalingActivityTask> tasks) {
            HashMultimap groupNameToInstances = HashMultimap.create();
            HashSet taggedInstanceIds = Sets.newHashSet();
            for (UntrackedInstanceTerminationScalingActivityTask task : tasks) {
                groupNameToInstances.putAll((Multimap)task.knownAutoScalingInstanceIds.get());
                taggedInstanceIds.addAll(((Multimap)task.knownAutoScalingInstanceIds.get()).values());
            }
            try {
                Set<String> knownInstanceIds = ActivityManager.this.autoScalingInstances.verifyInstanceIds(((AutoScalingGroupMinimumView)this.getGroup()).getOwnerAccountNumber(), taggedInstanceIds);
                groupNameToInstances.values().removeAll(knownInstanceIds);
                ActivityManager.this.clearUntrackedInstances(knownInstanceIds);
                Map groupMap = groupNameToInstances.asMap();
                HashSet toRemove = Sets.newHashSet();
                for (Map.Entry entry : groupMap.entrySet()) {
                    if (!Iterables.all((Iterable)((Iterable)entry.getValue()), (Predicate)Predicates.not((Predicate)ActivityManager.this.shouldTerminateUntrackedInstance()))) continue;
                    toRemove.add(entry.getKey());
                }
                groupMap.keySet().removeAll(toRemove);
                int entryIndex = -1;
                if (groupMap.size() == 1) {
                    entryIndex = 0;
                } else if (!groupMap.isEmpty()) {
                    Random random = new Random();
                    entryIndex = random.nextInt(groupMap.size());
                }
                if (entryIndex >= 0) {
                    Map.Entry entry = (Map.Entry)Iterables.get(groupMap.entrySet(), (int)entryIndex);
                    this.groupName = (String)entry.getKey();
                    this.instanceIds = Lists.newArrayList((Iterable)((Iterable)entry.getValue()));
                    ActivityManager.this.clearUntrackedInstances(this.instanceIds);
                }
            }
            catch (Exception e) {
                logger.error((Object)e, (Throwable)e);
            }
        }
    }

    private class UntrackedInstanceTerminationScalingActivityTask
    extends ScalingActivityTask<AutoScalingGroupCoreView, DescribeTagsResponseType> {
        private final AtomicReference<Multimap<String, String>> knownAutoScalingInstanceIds;

        UntrackedInstanceTerminationScalingActivityTask(AutoScalingGroupCoreView group, ScalingActivity activity) {
            super(ActivityManager.this, group, activity, false);
            this.knownAutoScalingInstanceIds = new AtomicReference<HashMultimap>(HashMultimap.create());
        }

        @Override
        void dispatchInternal(ActivityContext context, Callback.Checked<DescribeTagsResponseType> callback) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Polling instance tags for groups in account: " + ((AutoScalingGroupMinimumView)this.getGroup()).getOwnerAccountNumber()));
            }
            EucalyptusClient client = context.getEucalyptusClient();
            client.dispatch((BaseMessage)ActivityManager.this.describeTags(), callback);
        }

        @Override
        void dispatchSuccess(ActivityContext context, DescribeTagsResponseType response) {
            HashMultimap instanceMap = HashMultimap.create();
            if (response.getTagSet() != null) {
                for (TagInfo tagInfo : response.getTagSet()) {
                    if (!"aws:autoscaling:groupName".equals(tagInfo.getKey()) || !"instance".equals(tagInfo.getResourceType())) continue;
                    String instanceId = tagInfo.getResourceId();
                    String groupName = tagInfo.getValue();
                    instanceMap.put((Object)groupName, (Object)instanceId);
                }
            }
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Found auto scaling tags by group (account:" + ((AutoScalingGroupMinimumView)this.getGroup()).getOwnerAccountNumber() + "): " + instanceMap));
            }
            this.knownAutoScalingInstanceIds.set((Multimap<String, String>)Multimaps.unmodifiableMultimap((Multimap)instanceMap));
            this.setActivityFinalStatus(ActivityStatusCode.Successful);
        }
    }

    private class UserRemoveFromLoadBalancerScalingProcessTask
    extends RemoveFromLoadBalancerScalingProcessTask {
        UserRemoveFromLoadBalancerScalingProcessTask(AutoScalingGroupCoreView group, List<String> instanceIds) {
            super(UUID.randomUUID().toString(), group, "UserRemoveFromLoadBalancer", instanceIds);
        }

        @Override
        ScalingProcessTask onSuccess() {
            return null;
        }
    }

    private class UserTerminateInstancesScalingProcessTask
    extends TerminateInstancesScalingProcessTaskSupport {
        UserTerminateInstancesScalingProcessTask(AutoScalingGroupCoreView group, List<String> instanceIds) {
            super(group, "UserTermination", instanceIds, Collections.singletonList(new ActivityCause("instance was taken out of service in response to a user request.")), true, false);
        }
    }

    private class TerminateInstancesScalingProcessTask
    extends TerminateInstancesScalingProcessTaskSupport {
        private final int currentCapacity;
        private final Function<Integer, ScalingProcessTask> successFunction;

        TerminateInstancesScalingProcessTask(final AutoScalingGroupScalingView group, int currentCapacity, List<String> instanceIds, List<ActivityCause> causes, boolean replace, boolean persist, boolean scaling) {
            super(group, "Terminate", instanceIds, causes, persist, scaling);
            this.currentCapacity = currentCapacity;
            this.successFunction = replace ? new Function<Integer, ScalingProcessTask>(){

                public ScalingProcessTask apply(Integer terminatedInstances) {
                    return new LaunchInstancesScalingProcessTask(group, terminatedInstances, String.format("an instance was started in response to a difference between desired and actual capacity, increasing the capacity from %1$d to %2$d", ((AutoScalingGroupMinimumView)TerminateInstancesScalingProcessTask.this.getGroup()).getCapacity() - terminatedInstances, ((AutoScalingGroupMinimumView)TerminateInstancesScalingProcessTask.this.getGroup()).getCapacity()));
                }
            } : null;
        }

        TerminateInstancesScalingProcessTask(AutoScalingGroupCoreView group, int currentCapacity, List<String> instanceIds, List<ActivityCause> causes, boolean persist, boolean scaling) {
            super(group, "Terminate", instanceIds, causes, persist, scaling);
            this.currentCapacity = currentCapacity;
            this.successFunction = null;
        }

        @Override
        ScalingProcessTask onSuccess() {
            return this.successFunction != null ? (ScalingProcessTask)this.successFunction.apply((Object)this.getTerminatedCount()) : null;
        }

        @Override
        int getCurrentCapacity() {
            return this.currentCapacity;
        }
    }

    private abstract class TerminateInstancesScalingProcessTaskSupport
    extends ScalingProcessTask<AutoScalingGroupCoreView, TerminateInstanceScalingActivityTask> {
        private final List<String> instanceIds;
        private final List<ActivityCause> causes;
        private final boolean persist;
        private final boolean scaling;
        private volatile int terminatedCount;

        TerminateInstancesScalingProcessTaskSupport(AutoScalingGroupCoreView group, String activity, List<String> instanceIds, List<ActivityCause> causes, boolean persist, boolean scaling) {
            super(ActivityManager.this, group, activity);
            this.instanceIds = instanceIds;
            this.causes = causes;
            this.persist = persist;
            this.scaling = scaling;
        }

        @Override
        boolean shouldRun() {
            return !this.instanceIds.isEmpty() && (ActivityManager.this.scalingProcessEnabled(ScalingProcessType.Terminate, this.getGroup()) || !this.scaling);
        }

        int getTerminatedCount() {
            return this.terminatedCount;
        }

        int getCurrentCapacity() {
            return ((AutoScalingGroupMinimumView)this.getGroup()).getCapacity();
        }

        @Override
        List<TerminateInstanceScalingActivityTask> buildActivityTasks() {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Terminating instances " + this.instanceIds + " for group: " + ((AutoScalingGroupMinimumView)this.getGroup()).getArn()));
            }
            ArrayList activities = Lists.newArrayList();
            try {
                ActivityManager.this.autoScalingInstances.transitionState((AutoScalingMetadata.AutoScalingGroupMetadata)this.getGroup(), LifecycleState.InService, LifecycleState.Terminating, (Collection<String>)this.instanceIds);
                for (String instanceId : this.instanceIds) {
                    activities.add(new TerminateInstanceScalingActivityTask((AutoScalingGroupCoreView)this.getGroup(), this.newActivity("Terminating EC2 instance: " + instanceId, 50, null, this.causes, ActivityStatusCode.InProgress), this.persist, instanceId));
                }
            }
            catch (AutoScalingMetadataException e) {
                logger.error((Object)e, (Throwable)e);
            }
            return activities;
        }

        @Override
        void partialSuccess(List<TerminateInstanceScalingActivityTask> tasks) {
            this.processResults(tasks);
        }

        @Override
        void failure(List<TerminateInstanceScalingActivityTask> tasks) {
            this.processResults(tasks);
        }

        private void processResults(List<TerminateInstanceScalingActivityTask> tasks) {
            int terminatedCount = 0;
            for (TerminateInstanceScalingActivityTask task : tasks) {
                terminatedCount += task.wasTerminated() ? 1 : 0;
            }
            this.terminatedCount = terminatedCount;
            if (this.terminatedCount > 0) {
                try {
                    ActivityManager.this.autoScalingGroups.update(this.getOwner(), ((AutoScalingGroupMinimumView)this.getGroup()).getAutoScalingGroupName(), new Callback<AutoScalingGroup>(){

                        public void fire(AutoScalingGroup autoScalingGroup) {
                            autoScalingGroup.updateCapacity(Math.max(0, TerminateInstancesScalingProcessTaskSupport.this.getCurrentCapacity() - TerminateInstancesScalingProcessTaskSupport.this.terminatedCount));
                        }
                    });
                }
                catch (AutoScalingMetadataNotFoundException i$) {
                }
                catch (AutoScalingMetadataException e) {
                    logger.error((Object)e, (Throwable)e);
                }
            }
        }
    }

    private class TerminateInstanceScalingActivityTask
    extends ScalingActivityTask<AutoScalingGroupCoreView, TerminateInstancesResponseType> {
        private final String instanceId;
        private volatile boolean terminated;

        private TerminateInstanceScalingActivityTask(AutoScalingGroupCoreView group, ScalingActivity activity, boolean persist, String instanceId) {
            super(ActivityManager.this, group, activity, persist);
            this.terminated = false;
            this.instanceId = instanceId;
        }

        @Override
        void dispatchInternal(ActivityContext context, Callback.Checked<TerminateInstancesResponseType> callback) {
            EucalyptusClient client = context.getEucalyptusClient();
            client.dispatch((BaseMessage)ActivityManager.this.terminateInstances(Collections.singleton(this.instanceId)), callback);
        }

        @Override
        void dispatchSuccess(ActivityContext context, TerminateInstancesResponseType response) {
            this.handleInstanceTerminated();
        }

        @Override
        boolean dispatchFailure(ActivityContext context, Throwable throwable) {
            EucalyptusWebServiceException e = (EucalyptusWebServiceException)Exceptions.findCause((Throwable)throwable, EucalyptusWebServiceException.class);
            if ("InvalidInstanceID.NotFound".equals(e.getCode())) {
                this.handleInstanceTerminated();
                return true;
            }
            return super.dispatchFailure(context, throwable);
        }

        private void handleInstanceTerminated() {
            try {
                AutoScalingInstance instance = (AutoScalingInstance)((Object)ActivityManager.this.autoScalingInstances.lookup(this.getOwner(), this.instanceId, Functions.identity()));
                ActivityManager.this.autoScalingInstances.delete(instance);
                this.terminated = true;
            }
            catch (AutoScalingMetadataNotFoundException e) {
                this.terminated = true;
            }
            catch (AutoScalingMetadataException e) {
                logger.error((Object)e, (Throwable)e);
            }
            this.setActivityFinalStatus(this.terminated ? ActivityStatusCode.Successful : ActivityStatusCode.Failed);
        }

        boolean wasTerminated() {
            return this.terminated;
        }
    }

    private class RemoveFromLoadBalancerScalingProcessTask
    extends ScalingProcessTask<AutoScalingGroupCoreView, RemoveFromLoadBalancerScalingActivityTask> {
        private final List<String> instanceIds;
        private boolean removed;
        private final Function<Boolean, ScalingProcessTask> successFunction;

        RemoveFromLoadBalancerScalingProcessTask(final AutoScalingGroupScalingView group, final int currentCapacity, final List<String> instanceIds, final List<ActivityCause> causes, final boolean replace) {
            super(ActivityManager.this, (AutoScalingGroupCoreView)group, "RemoveFromLoadBalancer");
            this.removed = false;
            this.instanceIds = instanceIds;
            this.successFunction = new Function<Boolean, ScalingProcessTask>(){

                public ScalingProcessTask apply(Boolean removed) {
                    return removed != false ? new TerminateInstancesScalingProcessTask(group, currentCapacity, instanceIds, causes, replace, true, true) : null;
                }
            };
        }

        RemoveFromLoadBalancerScalingProcessTask(String uniqueKey, AutoScalingGroupCoreView group, String activity, List<String> instanceIds) {
            super(ActivityManager.this, uniqueKey, group, activity);
            this.removed = false;
            this.instanceIds = instanceIds;
            this.successFunction = null;
        }

        @Override
        boolean shouldRun() {
            return !this.instanceIds.isEmpty() && !((AutoScalingGroupCoreView)this.getGroup()).getLoadBalancerNames().isEmpty();
        }

        @Override
        ScalingProcessTask onSuccess() {
            return this.successFunction != null ? (ScalingProcessTask)this.successFunction.apply((Object)this.removed) : null;
        }

        @Override
        List<RemoveFromLoadBalancerScalingActivityTask> buildActivityTasks() throws AutoScalingMetadataException {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Removing instances " + this.instanceIds + " from load balancers for group: " + ((AutoScalingGroupMinimumView)this.getGroup()).getArn()));
            }
            ArrayList activities = Lists.newArrayList();
            try {
                ActivityManager.this.autoScalingInstances.transitionState((AutoScalingMetadata.AutoScalingGroupMetadata)this.getGroup(), LifecycleState.InService, LifecycleState.Terminating, (Collection<String>)this.instanceIds);
                for (String loadBalancerName : ((AutoScalingGroupCoreView)this.getGroup()).getLoadBalancerNames()) {
                    activities.add(new RemoveFromLoadBalancerScalingActivityTask((AutoScalingGroupCoreView)this.getGroup(), this.newActivity(), loadBalancerName, this.instanceIds));
                }
            }
            catch (Exception e) {
                logger.error((Object)e, (Throwable)e);
            }
            return activities;
        }

        @Override
        void failure(List<RemoveFromLoadBalancerScalingActivityTask> tasks) {
            this.handleFailure();
        }

        @Override
        void partialSuccess(List<RemoveFromLoadBalancerScalingActivityTask> tasks) {
            boolean success = true;
            for (RemoveFromLoadBalancerScalingActivityTask task : tasks) {
                success = success && task.instancesDeregistered();
            }
            if (success) {
                ActivityManager.this.transitionToDeregistered(this.getGroup(), this.instanceIds);
                this.removed = true;
            } else {
                this.handleFailure();
            }
        }

        private void handleFailure() {
            try {
                int failureCount = ActivityManager.this.autoScalingInstances.registrationFailure((AutoScalingMetadata.AutoScalingGroupMetadata)this.getGroup(), (Collection<String>)this.instanceIds);
                if (failureCount > AutoScalingConfiguration.getMaxRegistrationRetries()) {
                    ActivityManager.this.transitionToDeregistered(this.getGroup(), this.instanceIds);
                }
            }
            catch (AutoScalingMetadataException e) {
                logger.error((Object)e, (Throwable)e);
            }
        }
    }

    private class RemoveFromLoadBalancerScalingActivityTask
    extends ScalingActivityTask<AutoScalingGroupCoreView, DeregisterInstancesFromLoadBalancerResponseType> {
        private final String loadBalancerName;
        private final List<String> instanceIds;
        private volatile boolean deregistered;

        private RemoveFromLoadBalancerScalingActivityTask(AutoScalingGroupCoreView group, ScalingActivity activity, String loadBalancerName, List<String> instanceIds) {
            super(ActivityManager.this, group, activity);
            this.deregistered = false;
            this.loadBalancerName = loadBalancerName;
            this.instanceIds = instanceIds;
        }

        @Override
        void dispatchInternal(ActivityContext context, Callback.Checked<DeregisterInstancesFromLoadBalancerResponseType> callback) {
            ElbClient client = context.getElbClient();
            client.dispatch((BaseMessage)ActivityManager.this.deregisterInstances(this.loadBalancerName, this.instanceIds), callback);
        }

        @Override
        void dispatchSuccess(ActivityContext context, DeregisterInstancesFromLoadBalancerResponseType response) {
            HashSet registeredInstances = Sets.newHashSet();
            if (response.getDeregisterInstancesFromLoadBalancerResult() != null && response.getDeregisterInstancesFromLoadBalancerResult().getInstances() != null && response.getDeregisterInstancesFromLoadBalancerResult().getInstances().getMember() != null) {
                for (Instance instance : response.getDeregisterInstancesFromLoadBalancerResult().getInstances().getMember()) {
                    if (instance.getInstanceId() == null) continue;
                    registeredInstances.add(instance.getInstanceId());
                }
            }
            if (!registeredInstances.removeAll(this.instanceIds)) {
                this.deregistered = true;
            }
            this.setActivityFinalStatus(this.deregistered ? ActivityStatusCode.Successful : ActivityStatusCode.Failed);
        }

        @Override
        boolean dispatchFailure(ActivityContext context, Throwable throwable) {
            BaseMessage response;
            FailedRequestException failedRequestException = (FailedRequestException)Exceptions.findCause((Throwable)throwable, FailedRequestException.class);
            BaseMessage baseMessage = response = failedRequestException == null ? null : failedRequestException.getRequest();
            if (response instanceof ErrorResponse && (this.isErrorCode("AccessPointNotFound", (ErrorResponse)response) || this.isErrorCode("InvalidEndPoint", (ErrorResponse)response))) {
                this.deregistered = true;
                this.setActivityFinalStatus(ActivityStatusCode.Successful);
                return true;
            }
            return super.dispatchFailure(context, throwable);
        }

        private boolean isErrorCode(String code, ErrorResponse response) {
            boolean foundCode = false;
            for (Error error : response.getError()) {
                if (!code.equals(error.getCode())) continue;
                foundCode = true;
                break;
            }
            return foundCode;
        }

        boolean instancesDeregistered() {
            return this.deregistered;
        }
    }

    private class AddToLoadBalancerScalingProcessTask
    extends ScalingProcessTask<AutoScalingGroupCoreView, AddToLoadBalancerScalingActivityTask> {
        private final List<String> instanceIds;

        AddToLoadBalancerScalingProcessTask(AutoScalingGroupCoreView group, List<String> instanceIds) {
            super(ActivityManager.this, group, "AddToLoadBalancer");
            this.instanceIds = instanceIds;
        }

        @Override
        boolean shouldRun() {
            return !this.instanceIds.isEmpty() && !((AutoScalingGroupCoreView)this.getGroup()).getLoadBalancerNames().isEmpty() && ActivityManager.this.scalingProcessEnabled(ScalingProcessType.AddToLoadBalancer, this.getGroup());
        }

        @Override
        List<AddToLoadBalancerScalingActivityTask> buildActivityTasks() throws AutoScalingMetadataException {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Adding instances " + this.instanceIds + " to load balancers for group: " + ((AutoScalingGroupMinimumView)this.getGroup()).getArn()));
            }
            ArrayList activities = Lists.newArrayList();
            for (String loadBalancerName : ((AutoScalingGroupCoreView)this.getGroup()).getLoadBalancerNames()) {
                activities.add(new AddToLoadBalancerScalingActivityTask((AutoScalingGroupCoreView)this.getGroup(), this.newActivity(), loadBalancerName, this.instanceIds));
            }
            return activities;
        }

        @Override
        void failure(List<AddToLoadBalancerScalingActivityTask> tasks) {
            this.handleFailure();
        }

        @Override
        void partialSuccess(List<AddToLoadBalancerScalingActivityTask> tasks) {
            boolean success = true;
            for (AddToLoadBalancerScalingActivityTask task : tasks) {
                success = success && task.instancesRegistered();
            }
            if (success) {
                ActivityManager.this.transitionToRegistered(this.getGroup(), this.instanceIds);
            } else {
                this.handleFailure();
            }
        }

        private void handleFailure() {
            try {
                int failureCount = ActivityManager.this.autoScalingInstances.registrationFailure((AutoScalingMetadata.AutoScalingGroupMetadata)this.getGroup(), (Collection<String>)this.instanceIds);
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("Failed (" + failureCount + ") to add instances " + this.instanceIds + " to load balancers: " + ((AutoScalingGroupCoreView)this.getGroup()).getLoadBalancerNames()));
                }
                if (failureCount > AutoScalingConfiguration.getMaxRegistrationRetries()) {
                    ActivityManager.this.updateScalingRequiredFlag(this.getGroup(), true);
                    ActivityManager.this.autoScalingInstances.transitionState((AutoScalingMetadata.AutoScalingGroupMetadata)this.getGroup(), LifecycleState.InService, LifecycleState.Terminating, (Collection<String>)this.instanceIds);
                    logger.info((Object)("Terminating instances " + this.instanceIds + ", due to failure adding to load balancers: " + ((AutoScalingGroupCoreView)this.getGroup()).getLoadBalancerNames()));
                }
            }
            catch (AutoScalingMetadataException e) {
                logger.error((Object)e, (Throwable)e);
            }
        }
    }

    private class AddToLoadBalancerScalingActivityTask
    extends ScalingActivityTask<AutoScalingGroupCoreView, RegisterInstancesWithLoadBalancerResponseType> {
        private final String loadBalancerName;
        private final List<String> instanceIds;
        private volatile boolean registered;

        private AddToLoadBalancerScalingActivityTask(AutoScalingGroupCoreView group, ScalingActivity activity, String loadBalancerName, List<String> instanceIds) {
            super(ActivityManager.this, group, activity);
            this.registered = false;
            this.loadBalancerName = loadBalancerName;
            this.instanceIds = instanceIds;
        }

        @Override
        void dispatchInternal(ActivityContext context, Callback.Checked<RegisterInstancesWithLoadBalancerResponseType> callback) {
            ElbClient client = context.getElbClient();
            client.dispatch((BaseMessage)ActivityManager.this.registerInstances(this.loadBalancerName, this.instanceIds), callback);
        }

        @Override
        void dispatchSuccess(ActivityContext context, RegisterInstancesWithLoadBalancerResponseType response) {
            if (response.getRegisterInstancesWithLoadBalancerResult() != null && response.getRegisterInstancesWithLoadBalancerResult().getInstances() != null && response.getRegisterInstancesWithLoadBalancerResult().getInstances().getMember() != null) {
                HashSet registeredInstances = Sets.newHashSet();
                for (Instance instance : response.getRegisterInstancesWithLoadBalancerResult().getInstances().getMember()) {
                    if (instance.getInstanceId() == null) continue;
                    registeredInstances.add(instance.getInstanceId());
                }
                if (registeredInstances.containsAll(this.instanceIds)) {
                    this.registered = true;
                }
            }
            this.setActivityFinalStatus(this.registered ? ActivityStatusCode.Successful : ActivityStatusCode.Failed);
        }

        boolean instancesRegistered() {
            return this.registered;
        }
    }

    private class LaunchInstancesScalingProcessTask
    extends ScalingProcessTask<AutoScalingGroupScalingView, LaunchInstanceScalingActivityTask> {
        private final int launchCount;
        private final String cause;

        LaunchInstancesScalingProcessTask(AutoScalingGroupScalingView group, int launchCount, String cause) {
            super(ActivityManager.this, (AutoScalingGroupCoreView)group, "Launch");
            this.launchCount = launchCount;
            this.cause = cause;
        }

        @Override
        boolean shouldRun() {
            return this.launchCount > 0 && ActivityManager.this.scalingProcessEnabled(ScalingProcessType.Launch, this.getGroup());
        }

        @Override
        List<LaunchInstanceScalingActivityTask> buildActivityTasks() throws AutoScalingMetadataException {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Launching " + this.launchCount + " instance(s) for group: " + ((AutoScalingGroupScalingView)this.getGroup()).getArn()));
            }
            List instances = ActivityManager.this.autoScalingInstances.listByGroup((AutoScalingMetadata.AutoScalingGroupMetadata)this.getGroup(), (Predicate<? super AutoScalingInstance>)Predicates.alwaysTrue(), TypeMappers.lookup(AutoScalingInstance.class, AutoScalingInstanceCoreView.class));
            HashSet zonesToUse = Sets.newHashSet(((AutoScalingGroupScalingView)this.getGroup()).getAvailabilityZones());
            zonesToUse.removeAll(ActivityManager.this.zoneMonitor.getUnavailableZones(AutoScalingConfiguration.getZoneFailureThresholdMillis()));
            Map zoneCounts = ActivityManager.this.buildAvailabilityZoneInstanceCounts(instances, zonesToUse);
            int attemptToLaunch = Math.min(AutoScalingConfiguration.getMaxLaunchIncrement(), this.launchCount);
            ArrayList activities = Lists.newArrayList();
            for (int i = 0; i < attemptToLaunch; ++i) {
                Map.Entry entry = ActivityManager.this.selectEntry(zoneCounts, (Comparator)Ordering.natural());
                if (entry == null) continue;
                String zone = (String)entry.getKey();
                String clientToken = String.format("%1$s_%2$s_1", UUID.randomUUID().toString(), Iterables.getFirst((Iterable)Splitter.fixedLength((int)24).split((CharSequence)zone), (Object)""));
                entry.setValue((Integer)entry.getValue() + 1);
                activities.add(new LaunchInstanceScalingActivityTask((AutoScalingGroupScalingView)this.getGroup(), this.newActivity("Launching a new EC2 instance", 30, clientToken, Lists.newArrayList((Object[])new ActivityCause[]{this.cause(this.cause)}), ActivityStatusCode.PreInService), zone, clientToken));
            }
            return activities;
        }

        @Override
        void failure(List<LaunchInstanceScalingActivityTask> tasks) {
            if (!ActivityManager.this.zoneMonitor.getUnavailableZones(0L).removeAll(((AutoScalingGroupScalingView)this.getGroup()).getAvailabilityZones()) && ((AutoScalingGroupScalingView)this.getGroup()).getLastUpdateTimestamp() + AutoScalingConfiguration.getSuspensionTimeoutMillis() < ActivityManager.this.timestamp()) {
                if (ActivityManager.this.shouldSuspendDueToLaunchFailure(this.getGroup())) {
                    try {
                        logger.info((Object)("Suspending launch for group: " + ((AutoScalingGroupScalingView)this.getGroup()).getArn()));
                        ActivityManager.this.autoScalingGroups.update(this.getOwner(), ((AutoScalingGroupScalingView)this.getGroup()).getAutoScalingGroupName(), new Callback<AutoScalingGroup>(){

                            public void fire(AutoScalingGroup autoScalingGroup) {
                                autoScalingGroup.getSuspendedProcesses().add(SuspendedProcess.createAdministrative(ScalingProcessType.Launch));
                            }
                        });
                    }
                    catch (AutoScalingMetadataException e) {
                        logger.error((Object)e, (Throwable)e);
                    }
                }
            } else {
                ActivityManager.this.clearLaunchFailures(this.getGroup());
            }
        }

        @Override
        void partialSuccess(List<LaunchInstanceScalingActivityTask> tasks) {
            ActivityManager.this.clearLaunchFailures(this.getGroup());
            final ArrayList instanceIds = Lists.newArrayList();
            for (LaunchInstanceScalingActivityTask task : tasks) {
                instanceIds.addAll(task.getInstanceIds());
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Launched instances " + instanceIds + " for group: " + ((AutoScalingGroupScalingView)this.getGroup()).getArn()));
            }
            try {
                ActivityManager.this.autoScalingGroups.update(this.getOwner(), ((AutoScalingGroupScalingView)this.getGroup()).getAutoScalingGroupName(), new Callback<AutoScalingGroup>(){

                    public void fire(AutoScalingGroup autoScalingGroup) {
                        autoScalingGroup.setCapacity(autoScalingGroup.getCapacity() + instanceIds.size());
                    }
                });
            }
            catch (AutoScalingMetadataException e) {
                logger.error((Object)e, (Throwable)e);
            }
            this.getEucalyptusClient().dispatch((BaseMessage)ActivityManager.this.tagInstances(instanceIds, ((AutoScalingGroupScalingView)this.getGroup()).getAutoScalingGroupName(), ActivityManager.this.getTags((AutoScalingMetadata.AutoScalingGroupMetadata)this.getGroup())), (Callback.Checked)new Callback.Failure<CreateTagsResponseType>(){

                public void fireException(Throwable e) {
                    logger.error((Object)e, e);
                }
            });
        }
    }

    private class LaunchInstanceScalingActivityTask
    extends ScalingActivityTask<AutoScalingGroupScalingView, RunInstancesResponseType> {
        private final String availabilityZone;
        private final String clientToken;
        private final AtomicReference<List<String>> instanceIds;

        private LaunchInstanceScalingActivityTask(AutoScalingGroupScalingView group, ScalingActivity activity, String availabilityZone, String clientToken) {
            super(ActivityManager.this, (AutoScalingGroupCoreView)group, activity);
            this.instanceIds = new AtomicReference(Collections.emptyList());
            this.availabilityZone = availabilityZone;
            this.clientToken = clientToken;
        }

        @Override
        void dispatchInternal(ActivityContext context, Callback.Checked<RunInstancesResponseType> callback) {
            this.setActivityStatus(ActivityStatusCode.InProgress, 50);
            EucalyptusClient client = context.getEucalyptusClient();
            client.dispatch((BaseMessage)ActivityManager.this.runInstances((AutoScalingGroupScalingView)this.getGroup(), this.availabilityZone, this.clientToken, 1), callback);
        }

        @Override
        void dispatchSuccess(ActivityContext context, RunInstancesResponseType response) {
            ArrayList instanceIds = Lists.newArrayList();
            for (RunningInstancesItemType item : response.getRsvInfo().getInstancesSet()) {
                instanceIds.add(item.getInstanceId());
                AutoScalingInstance instance = ((AutoScalingGroupScalingView)this.getGroup()).createInstance(item.getInstanceId(), item.getPlacement());
                try {
                    ActivityManager.this.autoScalingInstances.save(instance);
                }
                catch (AutoScalingMetadataException e) {
                    logger.error((Object)e, (Throwable)e);
                }
            }
            this.instanceIds.set((List<String>)ImmutableList.copyOf((Collection)instanceIds));
            this.setActivityFinalStatus(ActivityStatusCode.Successful, null, String.format("Launching a new EC2 instance: %1$s", Joiner.on((String)", ").join((Iterable)instanceIds)));
        }

        List<String> getInstanceIds() {
            return this.instanceIds.get();
        }
    }

    static abstract class ScalingProcessTask<GVT extends AutoScalingGroupCoreView, AT extends ScalingActivityTask>
    extends BackoffRunner.TaskWithBackOff
    implements ActivityContext {
        private final GVT group;
        private final Supplier<String> userIdSupplier;
        private final AtomicReference<List<ScalingActivity>> activities;
        private volatile CheckedListenableFuture<Boolean> taskFuture;
        final /* synthetic */ ActivityManager this$0;

        ScalingProcessTask(String uniqueKey, GVT group, String activity) {
            this.this$0 = var1_1;
            super(uniqueKey, activity);
            this.activities = new AtomicReference(Collections.emptyList());
            this.group = group;
            this.userIdSupplier = Suppliers.memoize(var1_1.userIdSupplier(((AutoScalingGroupMinimumView)group).getOwnerAccountNumber()));
        }

        ScalingProcessTask(GVT group, String activity) {
            this(var1_1, ((AutoScalingGroupMinimumView)group).getArn(), (AutoScalingGroupCoreView)group, activity);
        }

        List<ScalingActivity> getActivities() {
            return this.activities.get();
        }

        GVT getGroup() {
            return this.group;
        }

        OwnerFullName getOwner() {
            return ((AutoScalingGroupMinimumView)this.getGroup()).getOwner();
        }

        public String getUserId() {
            return (String)this.userIdSupplier.get();
        }

        @Override
        public EucalyptusClient getEucalyptusClient() {
            return this.this$0.createEucalyptusClientForUser(this.getUserId());
        }

        @Override
        public ElbClient getElbClient() {
            return this.this$0.createElbClientForUser(this.getUserId());
        }

        @Override
        public CloudWatchClient getCloudWatchClient() {
            return this.this$0.createCloudWatchClientForUser(this.getUserId());
        }

        @Override
        public VmTypesClient getVmTypesClient() {
            return this.this$0.createVmTypesClientForUser(this.getUserId());
        }

        final ActivityCause cause(String cause) {
            return new ActivityCause(new Date(this.this$0.timestamp()), cause);
        }

        ScalingActivity newActivity() {
            return this.newActivity(null, 0, null, Collections.emptyList(), null);
        }

        ScalingActivity newActivity(@Nullable String description, int progress, @Nullable String clientToken, @Nonnull List<ActivityCause> activityCauses, @Nullable ActivityStatusCode activityStatusCode) {
            ArrayList causes = Lists.newArrayList();
            Iterables.addAll((Collection)causes, (Iterable)Iterables.transform(((AutoScalingGroupCoreView)this.group).getScalingCauses(), (Function)CauseTransform.INSTANCE));
            Iterables.addAll((Collection)causes, activityCauses);
            ScalingActivity scalingActivity = ((AutoScalingGroupMinimumView)this.getGroup()).createActivity(clientToken, causes);
            if (description != null) {
                scalingActivity.setDescription(description);
            }
            scalingActivity.setProgress(progress);
            if (activityStatusCode != null) {
                scalingActivity.setStatusCode(activityStatusCode);
            }
            return scalingActivity;
        }

        abstract boolean shouldRun();

        abstract List<AT> buildActivityTasks() throws AutoScalingMetadataException;

        @Override
        ScalingProcessTask onSuccess() {
            return null;
        }

        void partialSuccess(List<AT> tasks) {
        }

        void failure(List<AT> tasks) {
        }

        Future<Boolean> getFuture() {
            CheckedListenableFuture future = this.taskFuture;
            if (future == null) {
                future = Futures.predestinedFuture((Object)false);
            }
            return future;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void runTask() {
            block10: {
                ArrayList activities;
                ArrayList dispatchFutures;
                block8: {
                    if (!this.shouldRun()) {
                        this.success();
                        return;
                    }
                    dispatchFutures = Lists.newArrayList();
                    activities = Lists.newArrayList();
                    ArrayList scalingActivities = Lists.newArrayList();
                    try {
                        activities.addAll(this.buildActivityTasks());
                        for (ScalingActivityTask activity : activities) {
                            dispatchFutures.add(activity.dispatch(this));
                            scalingActivities.add(activity.getActivity());
                        }
                        this.activities.set((List<ScalingActivity>)ImmutableList.copyOf((Collection)scalingActivities));
                        if (!dispatchFutures.isEmpty()) break block8;
                    }
                    catch (Exception e) {
                        block9: {
                            try {
                                logger.error((Object)e, (Throwable)e);
                                if (!dispatchFutures.isEmpty()) break block9;
                            }
                            catch (Throwable throwable) {
                                if (dispatchFutures.isEmpty()) {
                                    this.failure();
                                } else {
                                    this.taskFuture = Futures.newGenericeFuture();
                                    CheckedListenableFuture resultFuture = Futures.allAsList((List)dispatchFutures);
                                    resultFuture.addListener(new Runnable(resultFuture, activities){
                                        final /* synthetic */ CheckedListenableFuture val$resultFuture;
                                        final /* synthetic */ List val$activities;
                                        {
                                            this.val$resultFuture = checkedListenableFuture;
                                            this.val$activities = list;
                                        }

                                        @Override
                                        public void run() {
                                            boolean success = false;
                                            try {
                                                success = ((List)this.val$resultFuture.get()).contains(true);
                                            }
                                            catch (Exception e) {
                                                logger.error((Object)e, (Throwable)e);
                                            }
                                            if (success) {
                                                ScalingProcessTask.this.partialSuccess(this.val$activities);
                                                ScalingProcessTask.this.success();
                                                ScalingProcessTask.this.taskFuture.set((Object)true);
                                            } else {
                                                ScalingProcessTask.this.failure(this.val$activities);
                                                ScalingProcessTask.this.failure();
                                                ScalingProcessTask.this.taskFuture.set((Object)false);
                                            }
                                        }
                                    });
                                }
                                throw throwable;
                            }
                            this.failure();
                        }
                        this.taskFuture = Futures.newGenericeFuture();
                        CheckedListenableFuture resultFuture = Futures.allAsList((List)dispatchFutures);
                        resultFuture.addListener(new /* invalid duplicate definition of identical inner class */);
                    }
                    this.failure();
                    break block10;
                }
                this.taskFuture = Futures.newGenericeFuture();
                CheckedListenableFuture resultFuture = Futures.allAsList((List)dispatchFutures);
                resultFuture.addListener(new /* invalid duplicate definition of identical inner class */);
            }
        }
    }

    private abstract class ScalingActivityTask<GVT extends AutoScalingGroupCoreView, RES extends BaseMessage> {
        private final GVT group;
        private volatile ScalingActivity activity;
        private final boolean persist;
        final /* synthetic */ ActivityManager this$0;

        protected ScalingActivityTask(GVT group, ScalingActivity activity) {
            this(var1_1, (AutoScalingGroupCoreView)group, activity, true);
        }

        /*
         * WARNING - Possible parameter corruption
         */
        protected ScalingActivityTask(GVT group, ScalingActivity activity, boolean persist) {
            this.this$0 = (ActivityManager)n;
            this.group = group;
            this.activity = activity;
            this.persist = persist;
        }

        ScalingActivity getActivity() {
            return this.activity;
        }

        GVT getGroup() {
            return this.group;
        }

        OwnerFullName getOwner() {
            return ((AutoScalingGroupMinimumView)this.getGroup()).getOwner();
        }

        final CheckedListenableFuture<Boolean> dispatch(final ActivityContext context) {
            try {
                this.activity = this.persist ? this.this$0.scalingActivities.save(this.activity) : this.activity;
                final CheckedListenableFuture future = Futures.newGenericeFuture();
                this.dispatchInternal(context, new Callback.Checked<RES>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void fireException(Throwable throwable) {
                        boolean result = false;
                        try {
                            result = ScalingActivityTask.this.dispatchFailure(context, throwable);
                        }
                        finally {
                            future.set((Object)result);
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void fire(RES response) {
                        try {
                            ScalingActivityTask.this.dispatchSuccess(context, response);
                        }
                        finally {
                            future.set((Object)true);
                        }
                    }
                });
                return future;
            }
            catch (Throwable e) {
                this.dispatchFailure(context, e);
                logger.error((Object)e, e);
                return Futures.predestinedFuture((Object)false);
            }
        }

        abstract void dispatchInternal(ActivityContext var1, Callback.Checked<RES> var2);

        boolean dispatchFailure(ActivityContext context, Throwable throwable) {
            String message;
            Logs.extreme().error((Object)"Activity error", throwable);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Activity error", throwable);
            }
            FailedRequestException failedRequestException = (FailedRequestException)Exceptions.findCause((Throwable)throwable, FailedRequestException.class);
            EucalyptusRemoteFault remoteFault = (EucalyptusRemoteFault)Exceptions.findCause((Throwable)throwable, EucalyptusRemoteFault.class);
            EucalyptusCloudException cloudException = (EucalyptusCloudException)Exceptions.findCause((Throwable)throwable, EucalyptusCloudException.class);
            ComponentException componentException = (ComponentException)Exceptions.findCause((Throwable)throwable, ComponentException.class);
            if (failedRequestException != null) {
                message = failedRequestException.getRequest().toSimpleString();
            } else if (remoteFault != null) {
                String code = remoteFault.getFaultCode();
                String detail = remoteFault.getFaultDetail();
                message = "Service error (" + code + "): " + detail;
            } else {
                message = cloudException != null ? cloudException.getMessage() : (componentException != null && componentException.getCause() != null ? componentException.getCause().getMessage() : throwable.getMessage());
            }
            this.setActivityFinalStatus(ActivityStatusCode.Failed, message, null);
            return false;
        }

        abstract void dispatchSuccess(ActivityContext var1, RES var2);

        void setActivityStatus(final ActivityStatusCode activityStatusCode, final int progress) {
            this.updateActivity(new Callback<ScalingActivity>(){

                public void fire(ScalingActivity input) {
                    input.setStatusCode(activityStatusCode);
                    input.setProgress(progress);
                }
            });
        }

        void setActivityFinalStatus(ActivityStatusCode activityStatusCode) {
            this.setActivityFinalStatus(activityStatusCode, null, null);
        }

        void setActivityFinalStatus(final @Nonnull ActivityStatusCode activityStatusCode, final @Nullable String message, final @Nullable String description) {
            this.updateActivity(new Callback<ScalingActivity>(){

                public void fire(ScalingActivity input) {
                    input.setStatusCode(activityStatusCode);
                    if (message != null) {
                        input.setStatusMessage((String)Iterables.getFirst((Iterable)Splitter.fixedLength((int)255).split((CharSequence)message), null));
                    }
                    if (description != null) {
                        input.setDescription((String)Iterables.getFirst((Iterable)Splitter.fixedLength((int)255).split((CharSequence)description), null));
                    }
                    input.setProgress(100);
                    input.setEndTime(new Date());
                }
            });
        }

        void updateActivity(@Nonnull Callback<ScalingActivity> callback) {
            ScalingActivity activity = this.getActivity();
            if (activity.getCreationTimestamp() != null) {
                try {
                    this.this$0.scalingActivities.update(activity.getOwner(), activity.getActivityId(), callback);
                }
                catch (AutoScalingMetadataNotFoundException e) {
                    Logs.exhaust().debug((Object)e, (Throwable)e);
                }
                catch (AutoScalingMetadataException e) {
                    logger.error((Object)e, (Throwable)e);
                }
            }
        }
    }

    private static interface ActivityContext {
        public EucalyptusClient getEucalyptusClient();

        public ElbClient getElbClient();

        public CloudWatchClient getCloudWatchClient();

        public VmTypesClient getVmTypesClient();
    }

    public static enum ActivityTask {
        Timeout,
        Expiry,
        ZoneHealth,
        Recovery,
        Scaling,
        InstanceCleanup,
        MetricsSubmission;

    }

    private static final class UnstableInstanceState {
        private final LifecycleState lifecycleState;
        private final ConfigurationState configurationState;
        private final Function<Iterable<AutoScalingInstanceGroupView>, ? extends ScalingProcessTask<?, ?>> stateProgressFunction;

        private UnstableInstanceState(LifecycleState lifecycleState, ConfigurationState configurationState, Function<Iterable<AutoScalingInstanceGroupView>, ? extends ScalingProcessTask<?, ?>> stateProgressFunction) {
            this.lifecycleState = lifecycleState;
            this.configurationState = configurationState;
            this.stateProgressFunction = stateProgressFunction;
        }

        public LifecycleState getLifecycleState() {
            return this.lifecycleState;
        }

        public ConfigurationState getConfigurationState() {
            return this.configurationState;
        }

        public Function<Iterable<AutoScalingInstanceGroupView>, ? extends ScalingProcessTask<?, ?>> getStateProgressFunction() {
            return this.stateProgressFunction;
        }
    }
}

