/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.config.ws;

import com.eucalyptus.configurable.ConfigurableFieldType;
import com.eucalyptus.configurable.ConfigurableProperty;
import com.eucalyptus.configurable.PropertyDirectory;
import com.eucalyptus.util.Strings;
import com.eucalyptus.ws.protocol.OperationParameter;
import com.eucalyptus.ws.protocol.RequestLoggingFilter;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;

public final class PropertiesRequestLoggingFilter
implements RequestLoggingFilter {
    private static final Iterable<String> ACTION_NVPS = Iterables.unmodifiableIterable((Iterable)Iterables.transform(Arrays.asList(OperationParameter.values()), (Function)Functions.compose((Function)Strings.append((String)"=ModifyPropertyValue"), (Function)Functions.toStringFunction())));
    private static final String NAME_PARAMETER = "Name=";
    private static final String VALUE_PARAMETER = "Value=";
    private static final String VALUE_PARAMETER_REDACTED = "Value=********";

    public Collection<String> apply(Collection<String> parametersOrBody) {
        if (Iterables.tryFind(ACTION_NVPS, (Predicate)Predicates.in(parametersOrBody)).isPresent()) {
            Optional nameParameterAndValue = Iterables.tryFind(parametersOrBody, (Predicate)Strings.startsWith((String)NAME_PARAMETER));
            Optional valueParameterAndValue = Iterables.tryFind(parametersOrBody, (Predicate)Strings.startsWith((String)VALUE_PARAMETER));
            if (nameParameterAndValue.isPresent() && valueParameterAndValue.isPresent()) {
                try {
                    ConfigurableProperty entry = PropertyDirectory.getPropertyEntry((String)Strings.trimPrefix((String)NAME_PARAMETER, (String)((String)nameParameterAndValue.get())));
                    if (ConfigurableFieldType.KEYVALUEHIDDEN == entry.getWidgetType()) {
                        ArrayList parametersCopy = Lists.newArrayList(parametersOrBody);
                        parametersCopy.set(parametersCopy.indexOf(valueParameterAndValue.get()), VALUE_PARAMETER_REDACTED);
                        return parametersCopy;
                    }
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }
        }
        return parametersOrBody;
    }
}

