/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.config;

import com.eucalyptus.component.annotation.ServiceOperation;
import com.eucalyptus.config.DescribePropertiesResponseType;
import com.eucalyptus.config.DescribePropertiesType;
import com.eucalyptus.config.ModifyPropertyValueResponseType;
import com.eucalyptus.config.ModifyPropertyValueType;
import com.eucalyptus.config.Property;
import com.eucalyptus.configurable.ConfigurableFieldType;
import com.eucalyptus.configurable.ConfigurableProperty;
import com.eucalyptus.configurable.PropertyDirectory;
import com.eucalyptus.context.Contexts;
import com.eucalyptus.scripting.Groovyness;
import com.eucalyptus.util.EucalyptusCloudException;
import com.eucalyptus.util.Exceptions;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class PropertiesManager {
    private static Logger LOG = Logger.getLogger(PropertiesManager.class);
    private static final String INTERNAL_OP = "euca";

    public static DescribePropertiesResponseType describeProperties(final DescribePropertiesType request) throws EucalyptusCloudException {
        DescribePropertiesResponseType reply = (DescribePropertiesResponseType)request.getReply();
        ArrayList<Property> props = reply.getProperties();
        Predicate<ConfigurableProperty> filter = new Predicate<ConfigurableProperty>(){

            public boolean apply(ConfigurableProperty input) {
                if (request.getProperties().isEmpty()) {
                    return true;
                }
                if (request.getProperties().contains(input.getQualifiedName())) {
                    return true;
                }
                for (String propRequest : request.getProperties()) {
                    if (!input.getQualifiedName().startsWith(propRequest)) continue;
                    return true;
                }
                return false;
            }
        };
        for (ConfigurableProperty entry : Iterables.filter((Iterable)PropertyDirectory.getPropertyEntrySet(), (Predicate)filter)) {
            if (!filter.apply((Object)entry)) continue;
            String value = "********";
            if (!entry.getWidgetType().equals((Object)ConfigurableFieldType.KEYVALUEHIDDEN)) {
                value = entry.getValue();
            }
            props.add(new Property(entry.getQualifiedName(), value, entry.getDescription()));
        }
        return reply;
    }

    public static ModifyPropertyValueResponseType modifyProperty(ModifyPropertyValueType request) throws EucalyptusCloudException {
        ModifyPropertyValueResponseType reply = (ModifyPropertyValueResponseType)request.getReply();
        if (INTERNAL_OP.equals(request.getName())) {
            if (!Contexts.lookup().hasAdministrativePrivileges()) {
                throw new EucalyptusCloudException("You are not authorized to interact with this service.");
            }
            LOG.debug((Object)("Performing euca operation: \n" + request.getValue()));
            try {
                reply.setName(INTERNAL_OP);
                reply.setValue("" + Groovyness.eval((String)request.getValue()));
                reply.setOldValue("executed successfully.");
            }
            catch (Exception ex) {
                LOG.error((Object)ex, (Throwable)ex);
                reply.setName(INTERNAL_OP);
                reply.setOldValue("euca operation failed because of: " + ex.getMessage());
                reply.setValue(Exceptions.string((Throwable)ex));
            }
        } else {
            try {
                ConfigurableProperty entry = PropertyDirectory.getPropertyEntry((String)request.getName());
                String oldValue = "********";
                if (!entry.getWidgetType().equals((Object)ConfigurableFieldType.KEYVALUEHIDDEN)) {
                    oldValue = entry.getValue();
                }
                reply.setOldValue(oldValue);
                Boolean reset = request.getReset();
                if (reset != null) {
                    if (Boolean.TRUE.equals(reset)) {
                        entry.setValue(entry.getDefaultValue());
                    }
                } else {
                    try {
                        String inValue = request.getValue();
                        entry.setValue(inValue == null ? "" : inValue);
                    }
                    catch (Exception e) {
                        entry.setValue(oldValue);
                        Exceptions.findAndRethrow((Throwable)e, EucalyptusCloudException.class);
                        throw e;
                    }
                }
                reply.setValue(entry.getValue());
                reply.setName(request.getName());
            }
            catch (IllegalAccessException e) {
                throw new EucalyptusCloudException("Failed to set property: " + e.getMessage());
            }
            catch (EucalyptusCloudException e) {
                throw e;
            }
            catch (Throwable e) {
                throw new EucalyptusCloudException(e);
            }
        }
        return reply;
    }

    @ServiceOperation
    public static enum DescribeProperties implements Function<DescribePropertiesType, DescribePropertiesResponseType>
    {
        INSTANCE;


        public DescribePropertiesResponseType apply(DescribePropertiesType input) {
            try {
                return PropertiesManager.describeProperties(input);
            }
            catch (Exception ex) {
                throw Exceptions.toUndeclared((Throwable)ex);
            }
        }
    }

    @ServiceOperation
    public static enum ModifyProperty implements Function<ModifyPropertyValueType, ModifyPropertyValueResponseType>
    {
        INSTANCE;


        public ModifyPropertyValueResponseType apply(ModifyPropertyValueType input) {
            try {
                return PropertiesManager.modifyProperty(input);
            }
            catch (Exception ex) {
                throw Exceptions.toUndeclared((Throwable)ex);
            }
        }
    }
}

