/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.config;

import com.eucalyptus.component.Component;
import com.eucalyptus.component.ComponentId;
import com.eucalyptus.component.ComponentRegistrationHandler;
import com.eucalyptus.component.Components;
import com.eucalyptus.component.ServiceBuilder;
import com.eucalyptus.component.ServiceBuilders;
import com.eucalyptus.component.ServiceConfiguration;
import com.eucalyptus.component.ServiceConfigurations;
import com.eucalyptus.config.ComponentInfoType;
import com.eucalyptus.config.DeregisterComponentResponseType;
import com.eucalyptus.config.DeregisterComponentType;
import com.eucalyptus.config.DescribeComponentsResponseType;
import com.eucalyptus.config.DescribeComponentsType;
import com.eucalyptus.config.ModifyComponentAttributeResponseType;
import com.eucalyptus.config.ModifyComponentAttributeType;
import com.eucalyptus.config.RegisterComponentResponseType;
import com.eucalyptus.config.RegisterComponentType;
import com.eucalyptus.util.EucalyptusCloudException;
import com.eucalyptus.util.Parameters;
import com.eucalyptus.util.TypeMapper;
import com.eucalyptus.util.TypeMappers;
import com.google.common.base.Function;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Set;
import org.apache.log4j.Logger;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

public class ConfigurationManager {
    public static Logger LOG = Logger.getLogger(ConfigurationManager.class);
    static String CLUSTER_KEY_FSTRING = "cc-%s";
    static String NODE_KEY_FSTRING = "nc-%s";
    private static final Set<String> attributes = Sets.newHashSet((Object[])new String[]{"partition", "state"});

    public static RegisterComponentResponseType registerComponent(RegisterComponentType request) throws EucalyptusCloudException {
        ServiceBuilder builder = ServiceBuilders.handles(((Object)((Object)request)).getClass());
        ComponentId componentId = builder.getComponentId();
        RegisterComponentResponseType reply = (RegisterComponentResponseType)request.getReply();
        String name = request.getName();
        String hostName = request.getHost();
        Integer port = request.getPort();
        Parameters.checkParam((String)("Name must not be null: " + (Object)((Object)request)), (Object)name, (Matcher)Matchers.notNullValue());
        Parameters.checkParam((String)("Hostname must not be null: " + (Object)((Object)request)), (Object)hostName, (Matcher)Matchers.notNullValue());
        Parameters.checkParam((String)("Port must not be null: " + (Object)((Object)request)), (Object)port, (Matcher)Matchers.notNullValue());
        String partition = request.getPartition();
        if (!componentId.isPartitioned()) {
            partition = componentId.getPartition();
        } else if (componentId.isPartitioned() && partition == null) {
            partition = name;
            LOG.error((Object)("Partitioned component is being registered w/o a partition.  Using partition=name=" + partition + " for request: " + (Object)((Object)request)));
        }
        try {
            reply.set_return(ComponentRegistrationHandler.register((ComponentId)componentId, (String)partition, (String)name, (String)hostName, (Integer)port) != null);
        }
        catch (Throwable ex) {
            reply.set_return(false);
            reply.setStatusMessage(ex.getMessage());
        }
        return reply;
    }

    public static DeregisterComponentResponseType deregisterComponent(DeregisterComponentType request) throws EucalyptusCloudException {
        ServiceBuilder builder = ServiceBuilders.handles(((Object)((Object)request)).getClass());
        ComponentId componentId = builder.getComponentId();
        DeregisterComponentResponseType reply = (DeregisterComponentResponseType)request.getReply();
        try {
            reply.set_return(ComponentRegistrationHandler.deregister((ComponentId)componentId, (String)request.getName()) != null);
        }
        catch (Throwable ex) {
            reply.set_return(false);
            reply.setStatusMessage(ex.getMessage());
        }
        return reply;
    }

    public static ModifyComponentAttributeResponseType modify(ModifyComponentAttributeType request) throws EucalyptusCloudException {
        ModifyComponentAttributeResponseType reply = (ModifyComponentAttributeResponseType)request.getReply();
        if (!attributes.contains(request.getAttribute())) {
            throw new EucalyptusCloudException("Request to modify unknown attribute: " + request.getAttribute());
        }
        ServiceBuilder builder = ServiceBuilders.handles(((Object)((Object)request)).getClass());
        LOG.info((Object)("Using builder: " + builder.getClass().getSimpleName()));
        LOG.error((Object)("Nothing to do while processing: " + (Object)((Object)request)));
        return reply;
    }

    public DescribeComponentsResponseType listComponents(DescribeComponentsType request) throws EucalyptusCloudException {
        DescribeComponentsResponseType reply = (DescribeComponentsResponseType)request.getReply();
        ArrayList<ComponentInfoType> listConfigs = reply.getRegistered();
        if (DescribeComponentsType.class.equals(((Object)((Object)request)).getClass())) {
            for (final Component c : Components.list()) {
                if (!c.hasLocalService().booleanValue()) {
                    listConfigs.add(new ComponentInfoType(){
                        private static final long serialVersionUID = 1L;
                        {
                            this.setType(c.getComponentId().name());
                            this.setPartition(c.getComponentId().getPartition());
                            this.setName("");
                            this.setHostName("");
                            this.setFullName("");
                            this.setState(c.getState().toString());
                            this.setDetail("");
                        }
                    });
                    continue;
                }
                ServiceConfiguration config = c.getLocalServiceConfiguration();
                ComponentInfoType info = (ComponentInfoType)((Object)TypeMappers.transform((Object)config, ComponentInfoType.class));
                if (!Boolean.TRUE.equals(request.getVerbose())) {
                    info.setDetail("");
                }
                listConfigs.add(info);
            }
        } else {
            ServiceBuilder compId = ServiceBuilders.handles(((Object)((Object)request)).getClass());
            for (ServiceConfiguration config : ServiceConfigurations.list(compId.getComponentId().getClass())) {
                ComponentInfoType info = (ComponentInfoType)((Object)TypeMappers.transform((Object)config, ComponentInfoType.class));
                if (!Boolean.TRUE.equals(request.getVerbose())) {
                    info.setDetail("");
                }
                listConfigs.add(info);
            }
        }
        return reply;
    }

    @TypeMapper
    public static enum ComponentInfoMapper implements Function<ServiceConfiguration, ComponentInfoType>
    {
        INSTANCE;


        public ComponentInfoType apply(final ServiceConfiguration input) {
            return new ComponentInfoType(){
                private static final long serialVersionUID = 1L;
                {
                    this.setType(input.getComponentId().name());
                    this.setPartition(input.getPartition());
                    this.setName(input.getName());
                    this.setHostName(input.getHostName());
                    this.setFullName(input.getFullName().toString());
                    try {
                        this.setState(input.lookupState().toString());
                    }
                    catch (Exception ex) {
                        this.setState("n/a: " + ex.getMessage());
                    }
                    this.setDetail("");
                }
            };
        }
    }
}

