/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.config;

import com.eucalyptus.component.Faults;
import com.eucalyptus.component.ServiceConfiguration;
import com.eucalyptus.component.ServiceConfigurations;
import com.eucalyptus.config.ArbitratorConfiguration;
import com.eucalyptus.empyrean.Arbitrator;
import com.eucalyptus.system.Threads;
import com.eucalyptus.util.Exceptions;
import com.eucalyptus.util.Internets;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.net.InetAddress;
import java.net.NoRouteToHostException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.log4j.Logger;

public class ArbitratorControl {
    private static Logger LOG = Logger.getLogger(ArbitratorControl.class);
    private static Map<ArbitratorConfiguration, Exception> error = Maps.newConcurrentMap();
    private static Map<ArbitratorConfiguration, ArbitratorConfiguration> okay = Maps.newConcurrentMap();
    private static volatile boolean wasSet;
    private static ScheduledExecutorService monitor;
    private static final int CHECK_PERIODICITY = 5;

    public static void start() {
    }

    public static void check() throws Exception {
        Threads.lookup(Arbitrator.class, ArbitratorControl.class).submit(new Runnable(){

            @Override
            public void run() {
                List configs = ServiceConfigurations.list(Arbitrator.class);
                for (ArbitratorConfiguration config : configs) {
                    String hostName;
                    if (!Internets.testLocal((String)config.getHostName()) || (hostName = config.getGatewayHost()) == null) continue;
                    try {
                        InetAddress addr = InetAddress.getByName(hostName);
                        if (Internets.isReachable((InetAddress)addr, (int)2000)) {
                            error.remove(config);
                            okay.put(config, config);
                            continue;
                        }
                        error.put(config, Exceptions.filterStackTrace((Throwable)new NoRouteToHostException(addr.toString())));
                        okay.remove(config);
                    }
                    catch (UnknownHostException e) {
                        error.put(config, Exceptions.filterStackTrace((Throwable)e));
                        okay.remove(config);
                    }
                    catch (IOException e) {
                        error.put(config, Exceptions.filterStackTrace((Throwable)e));
                        okay.remove(config);
                    }
                }
                wasSet = true;
            }
        });
        try {
            HashSet downArbitrators;
            if (wasSet && (downArbitrators = Sets.newHashSet(error.keySet())).size() > 0) {
                ArbitratorConfiguration anyConfig = null;
                ArrayList<Exception> exceptions = new ArrayList<Exception>();
                Iterator i$ = downArbitrators.iterator();
                while (i$.hasNext()) {
                    ArbitratorConfiguration key;
                    anyConfig = key = (ArbitratorConfiguration)i$.next();
                    exceptions.add(error.get(key));
                }
                if (okay.isEmpty()) {
                    throw Faults.fatal((ServiceConfiguration)anyConfig, exceptions);
                }
                throw Faults.advisory((ServiceConfiguration)anyConfig, exceptions);
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (wasSet) {
                okay.clear();
                error.clear();
                wasSet = false;
            }
        }
    }
}

