/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.imaging.service.config;

import com.eucalyptus.component.ComponentIds;
import com.eucalyptus.component.ServiceBuilder;
import com.eucalyptus.component.ServiceBuilders;
import com.eucalyptus.component.ServiceConfiguration;
import com.eucalyptus.component.ServiceConfigurations;
import com.eucalyptus.component.annotation.ComponentPart;
import com.eucalyptus.compute.common.Compute;
import com.eucalyptus.config.ComponentConfiguration;
import com.eucalyptus.imaging.common.Imaging;
import com.eucalyptus.upgrade.Upgrades;
import com.google.common.base.Predicate;
import java.io.Serializable;
import java.util.NoSuchElementException;
import javax.annotation.Nullable;
import javax.persistence.Entity;
import javax.persistence.PersistenceContext;
import org.apache.log4j.Logger;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

@Entity
@PersistenceContext(name="eucalyptus_config")
@Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
@ComponentPart(value=Imaging.class)
public class ImagingConfiguration
extends ComponentConfiguration
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERVICE_PATH = "/services/Imaging";

    public ImagingConfiguration() {
    }

    public ImagingConfiguration(String partition, String name, String hostName, Integer port) {
        super(partition, name, hostName, port, SERVICE_PATH);
    }

    @Upgrades.EntityUpgrade(entities={ImagingConfiguration.class}, value=Imaging.class, since=Upgrades.Version.v4_1_0)
    public static enum Imaging410RegistrationUpgrade implements Predicate<Class>
    {
        INSTANCE;

        private static final Logger logger;

        public boolean apply(@Nullable Class entityClass) {
            try {
                if (ServiceConfigurations.list(Imaging.class).isEmpty()) {
                    String imaging = ((Imaging)ComponentIds.lookup(Imaging.class)).name();
                    String compute = ((Compute)ComponentIds.lookup(Compute.class)).name();
                    ServiceBuilder builder = ServiceBuilders.lookup(Imaging.class);
                    for (ServiceConfiguration configuration : ServiceConfigurations.list(Compute.class)) {
                        String imagingServiceName = configuration.getName().equals(configuration.getPartition() + "." + compute) ? configuration.getPartition() + "." + imaging : configuration.getHostName() + "_" + imaging;
                        try {
                            ServiceConfigurations.lookupByName(Imaging.class, (String)imagingServiceName);
                            logger.warn((Object)("Existing imaging service found with name: " + imagingServiceName));
                        }
                        catch (NoSuchElementException e) {
                            logger.info((Object)("Registering imaging service on host " + configuration.getHostName()));
                            ServiceConfigurations.store((ServiceConfiguration)builder.newInstance(configuration.getPartition(), imagingServiceName, configuration.getHostName(), configuration.getPort()));
                        }
                    }
                } else {
                    logger.info((Object)"Not registering imaging services on upgrade, existing service found");
                }
            }
            catch (Exception e) {
                logger.error((Object)"Error registering imaging services on upgrade", (Throwable)e);
            }
            return true;
        }

        static {
            logger = Logger.getLogger(Imaging410RegistrationUpgrade.class);
        }
    }
}

