/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.imaging.service;

import com.eucalyptus.auth.AuthContextSupplier;
import com.eucalyptus.component.Partition;
import com.eucalyptus.component.ServiceConfiguration;
import com.eucalyptus.component.Topology;
import com.eucalyptus.context.Context;
import com.eucalyptus.context.Contexts;
import com.eucalyptus.context.ServiceDispatchException;
import com.eucalyptus.imaging.common.GetInstanceImportTaskType;
import com.eucalyptus.imaging.common.ImagingBackend;
import com.eucalyptus.imaging.common.ImagingMessage;
import com.eucalyptus.imaging.common.backend.msgs.ImagingBackendMessage;
import com.eucalyptus.imaging.common.backend.msgs.PutInstanceImportTaskStatusType;
import com.eucalyptus.imaging.service.ImagingAuthorizationException;
import com.eucalyptus.imaging.service.ImagingClientException;
import com.eucalyptus.imaging.service.ImagingException;
import com.eucalyptus.imaging.service.ImagingInvalidConfigurationException;
import com.eucalyptus.imaging.service.ImagingUnavailableException;
import com.eucalyptus.util.EucalyptusCloudException;
import com.eucalyptus.util.Exceptions;
import com.eucalyptus.util.async.AsyncRequests;
import com.eucalyptus.util.async.FailedRequestException;
import com.eucalyptus.ws.EucalyptusRemoteFault;
import com.eucalyptus.ws.EucalyptusWebServiceException;
import com.eucalyptus.ws.Role;
import com.google.common.base.Objects;
import edu.ucsb.eucalyptus.msgs.BaseMessage;
import edu.ucsb.eucalyptus.msgs.BaseMessages;
import java.net.InetSocketAddress;
import java.util.NoSuchElementException;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.mule.component.ComponentException;

public class ImagingService {
    public ImagingMessage dispatchAction(ImagingMessage request) throws EucalyptusCloudException {
        Context ctx = Contexts.lookup();
        AuthContextSupplier user = ctx.getAuthContext();
        try {
            ImagingBackendMessage backendRequest = (ImagingBackendMessage)BaseMessages.deepCopy((BaseMessage)request, (Class)ImagingService.getBackendMessageClass((BaseMessage)request));
            InetSocketAddress remoteAddr = (InetSocketAddress)ctx.getChannel().getRemoteAddress();
            if (remoteAddr != null) {
                String remoteHost = remoteAddr.getAddress().getHostAddress();
                if (request instanceof GetInstanceImportTaskType) {
                    ((com.eucalyptus.imaging.common.backend.msgs.GetInstanceImportTaskType)backendRequest).setSourceIp(remoteHost);
                } else if (request instanceof com.eucalyptus.imaging.common.PutInstanceImportTaskStatusType) {
                    ((PutInstanceImportTaskStatusType)backendRequest).setSourceIp(remoteHost);
                }
            }
            BaseMessage backendResponse = ImagingService.send(backendRequest);
            ImagingMessage response = (ImagingMessage)BaseMessages.deepCopy((BaseMessage)backendResponse, request.getReply().getClass());
            response.setCorrelationId(request.getCorrelationId());
            return response;
        }
        catch (Exception e) {
            this.handleRemoteException(e);
            Exceptions.findAndRethrow((Throwable)e, EucalyptusWebServiceException.class, EucalyptusCloudException.class);
            throw new EucalyptusCloudException((Throwable)e);
        }
    }

    private static Class getBackendMessageClass(BaseMessage request) throws ClassNotFoundException {
        return Class.forName(request.getClass().getName().replace(".common.", ".common.backend.msgs."));
    }

    private static BaseMessage send(ImagingBackendMessage request) throws Exception {
        try {
            return AsyncRequests.sendSyncWithCurrentIdentity((ServiceConfiguration)Topology.lookup(ImagingBackend.class, (Partition[])new Partition[0]), (BaseMessage)((BaseMessage)request));
        }
        catch (NoSuchElementException e) {
            throw new ImagingUnavailableException("Service Unavailable");
        }
        catch (ServiceDispatchException e) {
            ComponentException componentException = (ComponentException)Exceptions.findCause((Throwable)e, ComponentException.class);
            if (componentException != null && componentException.getCause() instanceof Exception) {
                throw (Exception)componentException.getCause();
            }
            throw e;
        }
        catch (FailedRequestException e) {
            if (((BaseMessage)request).getReply().getClass().isInstance(e.getRequest())) {
                return e.getRequest();
            }
            throw e.getRequest() == null ? e : new ImagingException("InternalError", Role.Receiver, "Internal error " + e.getRequest().getClass().getSimpleName() + ":false");
        }
    }

    private void handleRemoteException(Exception e) throws EucalyptusCloudException {
        EucalyptusRemoteFault remoteFault = (EucalyptusRemoteFault)Exceptions.findCause((Throwable)e, EucalyptusRemoteFault.class);
        if (remoteFault != null) {
            HttpResponseStatus status = (HttpResponseStatus)Objects.firstNonNull((Object)remoteFault.getStatus(), (Object)HttpResponseStatus.INTERNAL_SERVER_ERROR);
            String code = remoteFault.getFaultCode();
            String message = remoteFault.getFaultDetail();
            switch (status.getCode()) {
                case 400: {
                    throw new ImagingClientException(code, message);
                }
                case 403: {
                    throw new ImagingAuthorizationException(code, message);
                }
                case 409: {
                    throw new ImagingInvalidConfigurationException(code, message);
                }
                case 503: {
                    throw new ImagingUnavailableException(message);
                }
            }
            throw new ImagingException(code, Role.Receiver, message);
        }
    }
}

