/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.simpleworkflow.common.model;

import com.eucalyptus.component.annotation.ComponentMessage;
import com.eucalyptus.simpleworkflow.common.SimpleWorkflow;
import com.eucalyptus.system.Ats;
import com.eucalyptus.util.MessageValidation;
import com.eucalyptus.util.Pair;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import edu.ucsb.eucalyptus.msgs.BaseMessage;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

@ComponentMessage(value=SimpleWorkflow.class)
public class SimpleWorkflowMessage
extends BaseMessage {
    public <TYPE extends SimpleWorkflowMessage> TYPE reply(TYPE response) {
        return (TYPE)((Object)((SimpleWorkflowMessage)super.reply(response)));
    }

    public Map<String, String> validate() {
        return MessageValidation.validateRecursively((Map)Maps.newTreeMap(), (MessageValidation.ValidationAssistant)new SimpleWorkflowMessageValidationAssistant(), (String)"", (Object)((Object)this));
    }

    public static enum FieldRegexValue {
        STRING_128("(?s).{1,128}"),
        STRING_256("(?s).{1,256}"),
        STRING_1024("(?s).{1,1024}"),
        OPT_STRING_128("(?s).{0,128}"),
        OPT_STRING_256("(?s).{0,256}"),
        OPT_STRING_1024("(?s).{0,1024}"),
        OPT_STRING_2048("(?s).{0,2048}"),
        OPT_STRING_32768("(?s).{0,32768}"),
        DURATION_8("[0-9]|[1-9][0-9]{1,7}"),
        DURATION_8_NONE("NONE|[0-9]|[1-9][0-9]{1,7}"),
        NAME_64("(?U)[^\\s:/|\u0000-\u001f\u007f-\u009f]{1,2}|(?!.*arn)[^\\s:/|\u0000-\u001f\u007f-\u009f][^:/|\u0000-\u001f\u007f-\u009f]{1,62}[^\\s:/|\u0000-\u001f\u007f-\u009f]"),
        NAME_256("(?U)[^\\s:/|\u0000-\u001f\u007f-\u009f]{1,2}|(?!.*arn)[^\\s:/|\u0000-\u001f\u007f-\u009f][^:/|\u0000-\u001f\u007f-\u009f]{1,254}[^\\s:/|\u0000-\u001f\u007f-\u009f]"),
        CHILD_POLICY("TERMINATE|REQUEST_CANCEL|ABANDON"),
        CLOSE_STATUS("COMPLETED|FAILED|CANCELED|TERMINATED|CONTINUED_AS_NEW|TIMED_OUT"),
        DECISION("ScheduleActivityTask|RequestCancelActivityTask|CompleteWorkflowExecution|FailWorkflowExecution|CancelWorkflowExecution|ContinueAsNewWorkflowExecution|RecordMarker|StartTimer|CancelTimer|SignalExternalWorkflowExecution|RequestCancelExternalWorkflowExecution|StartChildWorkflowExecution"),
        REGISTRATION_STATUS("REGISTERED|DEPRECATED");

        private final Pattern pattern;

        private FieldRegexValue(String regex) {
            this.pattern = Pattern.compile(regex);
        }

        public Pattern pattern() {
            return this.pattern;
        }
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface FieldRange {
        public long min() default 0L;

        public long max() default 0x7FFFFFFFFFFFFFFFL;
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface FieldRegex {
        public FieldRegexValue value();
    }

    private static class SimpleWorkflowMessageValidationAssistant
    implements MessageValidation.ValidationAssistant {
        private final Set<Class<?>> simpleTypes = ImmutableSet.of(Boolean.class, Date.class, Integer.class, Long.class, String.class);

        private SimpleWorkflowMessageValidationAssistant() {
        }

        public boolean validate(Object object) {
            return object != null && !this.simpleTypes.contains(object.getClass()) && !Iterable.class.isAssignableFrom(object.getClass());
        }

        public Pair<Long, Long> range(Ats ats) {
            FieldRange range = (FieldRange)ats.get(FieldRange.class);
            return range == null ? null : Pair.pair((Object)range.min(), (Object)range.max());
        }

        public Pattern regex(Ats ats) {
            FieldRegex regex = (FieldRegex)ats.get(FieldRegex.class);
            return regex == null ? null : regex.value().pattern();
        }
    }
}

