/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.simpleworkflow.common.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.eucalyptus.auth.policy.PolicyAction;
import com.eucalyptus.simpleworkflow.common.model.Decision;
import com.eucalyptus.simpleworkflow.common.model.SimpleWorkflowMessage;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;

@PolicyAction(vendor="swf", action="responddecisiontaskcompleted")
public class RespondDecisionTaskCompletedRequest
extends SimpleWorkflowMessage
implements Serializable {
    @Nonnull
    @SimpleWorkflowMessage.FieldRegex(value=SimpleWorkflowMessage.FieldRegexValue.STRING_1024)
    private String taskToken;
    private ListWithAutoConstructFlag<Decision> decisions;
    @SimpleWorkflowMessage.FieldRegex(value=SimpleWorkflowMessage.FieldRegexValue.OPT_STRING_32768)
    private String executionContext;

    public String getTaskToken() {
        return this.taskToken;
    }

    public void setTaskToken(String taskToken) {
        this.taskToken = taskToken;
    }

    public RespondDecisionTaskCompletedRequest withTaskToken(String taskToken) {
        this.taskToken = taskToken;
        return this;
    }

    public List<Decision> getDecisions() {
        if (this.decisions == null) {
            this.decisions = new ListWithAutoConstructFlag();
            this.decisions.setAutoConstruct(true);
        }
        return this.decisions;
    }

    public void setDecisions(Collection<Decision> decisions) {
        if (decisions == null) {
            this.decisions = null;
            return;
        }
        ListWithAutoConstructFlag decisionsCopy = new ListWithAutoConstructFlag(decisions.size());
        decisionsCopy.addAll(decisions);
        this.decisions = decisionsCopy;
    }

    public RespondDecisionTaskCompletedRequest withDecisions(Decision ... decisions) {
        if (this.getDecisions() == null) {
            this.setDecisions(new ArrayList<Decision>(decisions.length));
        }
        for (Decision value : decisions) {
            this.getDecisions().add(value);
        }
        return this;
    }

    public RespondDecisionTaskCompletedRequest withDecisions(Collection<Decision> decisions) {
        if (decisions == null) {
            this.decisions = null;
        } else {
            ListWithAutoConstructFlag decisionsCopy = new ListWithAutoConstructFlag(decisions.size());
            decisionsCopy.addAll(decisions);
            this.decisions = decisionsCopy;
        }
        return this;
    }

    public String getExecutionContext() {
        return this.executionContext;
    }

    public void setExecutionContext(String executionContext) {
        this.executionContext = executionContext;
    }

    public RespondDecisionTaskCompletedRequest withExecutionContext(String executionContext) {
        this.executionContext = executionContext;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getTaskToken() != null) {
            sb.append("TaskToken: " + this.getTaskToken() + ",");
        }
        if (this.getDecisions() != null) {
            sb.append("Decisions: " + this.getDecisions() + ",");
        }
        if (this.getExecutionContext() != null) {
            sb.append("ExecutionContext: " + this.getExecutionContext());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getTaskToken() == null ? 0 : this.getTaskToken().hashCode());
        hashCode = 31 * hashCode + (this.getDecisions() == null ? 0 : this.getDecisions().hashCode());
        hashCode = 31 * hashCode + (this.getExecutionContext() == null ? 0 : this.getExecutionContext().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RespondDecisionTaskCompletedRequest)) {
            return false;
        }
        RespondDecisionTaskCompletedRequest other = (RespondDecisionTaskCompletedRequest)obj;
        if (other.getTaskToken() == null ^ this.getTaskToken() == null) {
            return false;
        }
        if (other.getTaskToken() != null && !other.getTaskToken().equals(this.getTaskToken())) {
            return false;
        }
        if (other.getDecisions() == null ^ this.getDecisions() == null) {
            return false;
        }
        if (other.getDecisions() != null && !other.getDecisions().equals(this.getDecisions())) {
            return false;
        }
        if (other.getExecutionContext() == null ^ this.getExecutionContext() == null) {
            return false;
        }
        return other.getExecutionContext() == null || other.getExecutionContext().equals(this.getExecutionContext());
    }
}

