/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.simpleworkflow.common.client;

import com.eucalyptus.component.ComponentId;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import javax.annotation.Nonnull;

public class WorkflowRegistry {
    private static final ListMultimap<Class<? extends ComponentId>, Class<?>> workflowClasses = Multimaps.synchronizedListMultimap((ListMultimap)ArrayListMultimap.create());
    private static final ListMultimap<Class<? extends ComponentId>, Class<?>> activityClasses = Multimaps.synchronizedListMultimap((ListMultimap)ArrayListMultimap.create());

    static void registerWorkflow(@Nonnull Class<? extends ComponentId> componentIdClass, @Nonnull Class<?> implementationClass) {
        WorkflowRegistry.register(workflowClasses, componentIdClass, implementationClass);
    }

    static void registerActivities(@Nonnull Class<? extends ComponentId> componentIdClass, @Nonnull Class<?> implementationClass) {
        WorkflowRegistry.register(activityClasses, componentIdClass, implementationClass);
    }

    @Nonnull
    static Iterable<Class<?>> lookupWorkflows(Class<? extends ComponentId> componentIdClass) {
        return WorkflowRegistry.lookup(workflowClasses, componentIdClass);
    }

    @Nonnull
    static Iterable<Class<?>> lookupActivities(Class<? extends ComponentId> componentIdClass) {
        return WorkflowRegistry.lookup(activityClasses, componentIdClass);
    }

    private static void register(Multimap<Class<? extends ComponentId>, Class<?>> registry, Class<? extends ComponentId> componentIdClass, Class<?> implementationClass) {
        registry.put(componentIdClass, implementationClass);
    }

    private static Iterable<Class<?>> lookup(Multimap<Class<? extends ComponentId>, Class<?>> registry, Class<? extends ComponentId> componentIdClass) {
        return registry.get(componentIdClass);
    }
}

