/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.simpleworkflow.common.client;

import com.amazonaws.services.simpleworkflow.flow.annotations.Activities;
import com.amazonaws.services.simpleworkflow.flow.annotations.Workflow;
import com.eucalyptus.bootstrap.ServiceJarDiscovery;
import com.eucalyptus.component.annotation.ComponentPart;
import com.eucalyptus.simpleworkflow.common.client.WorkflowRegistry;
import com.eucalyptus.system.Ats;
import java.lang.reflect.Modifier;
import org.apache.log4j.Logger;

public class WorkflowDiscovery
extends ServiceJarDiscovery {
    private static final Logger logger = Logger.getLogger(WorkflowDiscovery.class);

    public boolean processClass(Class candidate) throws Exception {
        Ats ats = Ats.inClassHierarchy((Object)candidate);
        if (!(!ats.has(Workflow.class) && !ats.has(Activities.class) || !ats.has(ComponentPart.class) || Modifier.isAbstract(candidate.getModifiers()) || Modifier.isInterface(candidate.getModifiers()) || candidate.isLocalClass() || candidate.isAnonymousClass())) {
            Class componentIdClass = ((ComponentPart)ats.get(ComponentPart.class)).value();
            if (ats.has(Workflow.class)) {
                WorkflowRegistry.registerWorkflow(componentIdClass, candidate);
            } else {
                WorkflowRegistry.registerActivities(componentIdClass, candidate);
            }
            logger.debug((Object)("Discovered workflow implementation class: " + candidate.getName()));
            return true;
        }
        return false;
    }

    public Double getPriority() {
        return 0.3;
    }
}

