/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.simpleworkflow.common.client;

import com.amazonaws.services.simpleworkflow.AmazonSimpleWorkflow;
import com.amazonaws.services.simpleworkflow.flow.ActivityWorker;
import com.amazonaws.services.simpleworkflow.flow.WorkflowWorker;
import com.eucalyptus.auth.AuthException;
import com.eucalyptus.auth.principal.User;
import com.eucalyptus.component.ComponentId;
import com.eucalyptus.simpleworkflow.common.client.Config;
import com.google.common.base.Supplier;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class WorkflowClient {
    private static final Logger logger = Logger.getLogger(WorkflowClient.class);
    private final boolean shutdownClient;
    private final AmazonSimpleWorkflow simpleWorkflow;
    private final WorkflowWorker workflowWorker;
    private final ActivityWorker activityWorker;

    public WorkflowClient(Class<? extends ComponentId> componentIdClass, Supplier<User> user, String clientConfig, String domain, String taskList, String workflowWorkerConfig, String activityWorkerConfig) throws AuthException {
        this(componentIdClass, true, Config.buildClient(user, clientConfig), domain, taskList, workflowWorkerConfig, activityWorkerConfig);
    }

    public WorkflowClient(Class<? extends ComponentId> componentIdClass, AmazonSimpleWorkflow simpleWorkflow, String domain, String taskList, String workflowWorkerConfig, String activityWorkerConfig) {
        this(componentIdClass, false, simpleWorkflow, domain, taskList, workflowWorkerConfig, activityWorkerConfig);
    }

    public WorkflowClient(Class<? extends ComponentId> componentIdClass, boolean shutdownClient, AmazonSimpleWorkflow simpleWorkflow, String domain, String taskList, String workflowWorkerConfig, String activityWorkerConfig) {
        this.shutdownClient = shutdownClient;
        this.simpleWorkflow = simpleWorkflow;
        try {
            this.workflowWorker = Config.buildWorkflowWorker(componentIdClass, this.simpleWorkflow, domain, taskList, workflowWorkerConfig);
            this.workflowWorker.setDisableServiceShutdownOnStop(!shutdownClient);
            this.activityWorker = Config.buildActivityWorker(componentIdClass, this.simpleWorkflow, domain, taskList, activityWorkerConfig);
            this.activityWorker.setDisableServiceShutdownOnStop(!shutdownClient);
        }
        catch (Throwable e) {
            try {
                this.stop();
            }
            catch (InterruptedException e2) {
                logger.warn((Object)"Interrupted during stop");
            }
            throw e;
        }
    }

    public AmazonSimpleWorkflow getAmazonSimpleWorkflow() {
        return this.simpleWorkflow;
    }

    public void start() {
        this.workflowWorker.start();
        this.activityWorker.start();
    }

    public void stop() throws InterruptedException {
        boolean waitForWorkflowWorker = false;
        if (this.workflowWorker != null && this.workflowWorker.isRunning()) {
            waitForWorkflowWorker = true;
            this.workflowWorker.shutdown();
        }
        boolean waitForActivityWorker = false;
        if (this.activityWorker != null && this.activityWorker.isRunning()) {
            waitForActivityWorker = true;
            this.activityWorker.shutdown();
        }
        if (waitForWorkflowWorker && !this.workflowWorker.awaitTermination(30L, TimeUnit.SECONDS)) {
            logger.warn((Object)"Workflow worker not yet terminated.");
        }
        if (waitForActivityWorker && !this.activityWorker.awaitTermination(30L, TimeUnit.SECONDS)) {
            logger.warn((Object)"Activity worker not yet terminated.");
        }
        if (this.simpleWorkflow != null && this.shutdownClient) {
            this.simpleWorkflow.shutdown();
        }
    }
}

