/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.simpleworkflow.common.client;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.handlers.RequestHandler2;
import com.amazonaws.services.simpleworkflow.AmazonSimpleWorkflow;
import com.amazonaws.services.simpleworkflow.AmazonSimpleWorkflowClient;
import com.amazonaws.services.simpleworkflow.flow.ActivityWorker;
import com.amazonaws.services.simpleworkflow.flow.DataConverter;
import com.amazonaws.services.simpleworkflow.flow.JsonDataConverter;
import com.amazonaws.services.simpleworkflow.flow.WorkerBase;
import com.amazonaws.services.simpleworkflow.flow.WorkflowWorker;
import com.amazonaws.util.json.JSONException;
import com.eucalyptus.auth.AuthException;
import com.eucalyptus.auth.principal.User;
import com.eucalyptus.auth.tokens.SecurityTokenAWSCredentialsProvider;
import com.eucalyptus.component.ComponentId;
import com.eucalyptus.component.Partition;
import com.eucalyptus.component.ServiceConfiguration;
import com.eucalyptus.component.ServiceUris;
import com.eucalyptus.component.Topology;
import com.eucalyptus.configurable.ConfigurableProperty;
import com.eucalyptus.configurable.ConfigurablePropertyException;
import com.eucalyptus.configurable.PropertyChangeListener;
import com.eucalyptus.simpleworkflow.common.SimpleWorkflow;
import com.eucalyptus.simpleworkflow.common.client.WorkflowRegistry;
import com.eucalyptus.simpleworkflow.common.model.SimpleWorkflowMessage;
import com.eucalyptus.util.Exceptions;
import com.eucalyptus.util.Strings;
import com.eucalyptus.util.UpperCamelPropertyNamingStrategy;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.introspect.JacksonAnnotationIntrospector;
import com.google.common.base.Supplier;
import com.google.common.reflect.AbstractInvocationHandler;
import java.beans.Introspector;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.net.ConnectException;
import java.util.UUID;
import javax.annotation.Nonnull;
import org.apache.http.NoHttpResponseException;
import org.apache.log4j.Logger;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.PropertyNamingStrategy;
import org.mule.api.MessagingException;

public class Config {
    private static final ObjectMapper mapper = new ObjectMapper().setPropertyNamingStrategy((PropertyNamingStrategy)new UpperCamelPropertyNamingStrategy());
    private static final com.fasterxml.jackson.databind.ObjectMapper workerObjectMapper = Config.buildWorkerObjectMapper();

    public static ClientConfiguration buildConfiguration(String text) {
        try {
            return com.google.common.base.Strings.isNullOrEmpty((String)text) ? new ClientConfiguration() : (ClientConfiguration)mapper.readValue((Reader)Config.source(text), ClientConfiguration.class);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Invalid configuration: " + e.getMessage(), e);
        }
    }

    public static AmazonSimpleWorkflow buildClient(Supplier<User> user, String text) throws AuthException {
        final AmazonSimpleWorkflowClient client = new AmazonSimpleWorkflowClient((AWSCredentialsProvider)new SecurityTokenAWSCredentialsProvider(user), Config.buildConfiguration(text));
        client.setEndpoint(ServiceUris.remote((ServiceConfiguration)Topology.lookup(SimpleWorkflow.class, (Partition[])new Partition[0]), (String[])new String[0]).toString());
        client.addRequestHandler(new RequestHandler2(){

            public void beforeRequest(Request<?> request) {
                request.addHeader("Euca-Nonce", UUID.randomUUID().toString());
            }

            public void afterResponse(Request<?> request, Response<?> response) {
            }

            public void afterError(Request<?> request, Response<?> response, Exception e) {
                String errorMessage = com.google.common.base.Strings.nullToEmpty((String)e.getMessage());
                boolean resetEndpoint = false;
                if (Exceptions.isCausedBy((Throwable)e, JSONException.class) && (errorMessage.contains("Response Code: 404") || errorMessage.contains("Response Code: 503"))) {
                    resetEndpoint = true;
                } else if (Exceptions.isCausedBy((Throwable)e, ConnectException.class)) {
                    resetEndpoint = true;
                } else if (Exceptions.isCausedBy((Throwable)e, NoHttpResponseException.class)) {
                    resetEndpoint = true;
                }
                if (resetEndpoint) {
                    try {
                        client.setEndpoint(ServiceUris.remote((ServiceConfiguration)Topology.lookup(SimpleWorkflow.class, (Partition[])new Partition[0]), (String[])new String[0]).toString());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        });
        return client;
    }

    public static WorkflowWorker buildWorkflowWorker(Class<? extends ComponentId> componentIdClass, AmazonSimpleWorkflow client, String domain, String taskList, String text) {
        WorkflowWorker workflowWorker = new WorkflowWorker(client, domain, taskList);
        workflowWorker.setRegisterDomain(true);
        workflowWorker.setDefaultConverter((DataConverter)new JsonDataConverter(workerObjectMapper));
        Config.configure(workflowWorker, text);
        Package workerPackage = null;
        for (Class<?> workflowImplementation : WorkflowRegistry.lookupWorkflows(componentIdClass)) {
            try {
                if (workerPackage == null) {
                    workerPackage = workflowImplementation.getPackage();
                }
                workflowWorker.addWorkflowImplementationType(workflowImplementation);
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new IllegalArgumentException("Invalid workflow implementation: " + workflowImplementation, e);
            }
        }
        Config.perhapsSetExceptionHandler(workerPackage, "decision", (WorkerBase)workflowWorker);
        return workflowWorker;
    }

    public static ActivityWorker buildActivityWorker(Class<? extends ComponentId> componentIdClass, AmazonSimpleWorkflow client, String domain, String taskList, String text) {
        ActivityWorker activityWorker = Config.configure(new ActivityWorker(client, domain, taskList), text);
        activityWorker.setDataConverter((DataConverter)new JsonDataConverter(workerObjectMapper));
        Package workerPackage = null;
        for (Class<?> activitiesImplementation : WorkflowRegistry.lookupActivities(componentIdClass)) {
            try {
                if (workerPackage == null) {
                    workerPackage = activitiesImplementation.getPackage();
                }
                activityWorker.addActivitiesImplementation(activitiesImplementation.newInstance());
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException e) {
                throw new IllegalArgumentException("Invalid activities implementation: " + activitiesImplementation, e);
            }
        }
        Config.perhapsSetExceptionHandler(workerPackage, "activity", (WorkerBase)activityWorker);
        return activityWorker;
    }

    private static <T extends WorkerBase> T configure(T worker, String text) {
        try {
            return (T)(com.google.common.base.Strings.isNullOrEmpty((String)text) ? worker : (WorkerBase)mapper.updatingReader(worker).readValue((Reader)Config.source(text)));
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Invalid configuration: " + e.getMessage(), e);
        }
    }

    private static void perhapsSetExceptionHandler(Package logPackage, final String type, WorkerBase worker) {
        if (logPackage != null) {
            final Logger logger = Logger.getLogger((String)logPackage.getName());
            worker.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                @Override
                public void uncaughtException(Thread t, Throwable e) {
                    logger.error((Object)("Uncaught exception in " + type + " worker " + t.getName() + "/" + t.getId()), e);
                }
            });
        }
    }

    private static StringReader source(String text) {
        return new StringReader(text){

            public String toString() {
                return "property";
            }
        };
    }

    private static AmazonSimpleWorkflow client() {
        return (AmazonSimpleWorkflow)Proxy.newProxyInstance(AmazonSimpleWorkflow.class.getClassLoader(), new Class[]{AmazonSimpleWorkflow.class}, (InvocationHandler)new AbstractInvocationHandler(){

            protected Object handleInvocation(@Nonnull Object o, @Nonnull Method method, @Nonnull Object[] objects) throws Throwable {
                throw new Exception("dummy-client");
            }
        });
    }

    private static com.fasterxml.jackson.databind.ObjectMapper buildWorkerObjectMapper() {
        com.fasterxml.jackson.databind.ObjectMapper workerObjectMapper = new com.fasterxml.jackson.databind.ObjectMapper();
        workerObjectMapper.setAnnotationIntrospector((AnnotationIntrospector)new JacksonAnnotationIntrospector(){
            private static final long serialVersionUID = 1L;

            public boolean hasIgnoreMarker(AnnotatedMember m) {
                return Config.isMethodBackedByTransientField(m) || super.hasIgnoreMarker(m);
            }
        });
        workerObjectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        workerObjectMapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        workerObjectMapper.addMixInAnnotations(MessagingException.class, MuleMixin.class);
        workerObjectMapper.enableDefaultTyping(ObjectMapper.DefaultTyping.NON_FINAL);
        return workerObjectMapper;
    }

    private static boolean isMethodBackedByTransientField(AnnotatedMember m) {
        boolean isMethodBackedByTransientField = false;
        if (m instanceof AnnotatedMethod) {
            String fieldName = Introspector.decapitalize(Strings.trimPrefix((String)"get", (String)m.getName()));
            for (Field field : m.getMember().getDeclaringClass().getDeclaredFields()) {
                if (!fieldName.equals(field.getName())) continue;
                isMethodBackedByTransientField = Modifier.isTransient(field.getModifiers());
                break;
            }
        }
        return isMethodBackedByTransientField;
    }

    @JsonIgnoreProperties(value={"failingMessageProcessor"})
    private static final class MuleMixin {
        private MuleMixin() {
        }
    }

    public static final class WorkflowWorkerConfigurationValidatingChangeListener
    implements PropertyChangeListener {
        public void fireChange(ConfigurableProperty t, Object newValue) throws ConfigurablePropertyException {
            if (newValue != null && !newValue.toString().trim().isEmpty()) {
                try {
                    Config.buildWorkflowWorker(SimpleWorkflow.class, Config.client(), "domain", "task-list", newValue.toString().trim());
                }
                catch (IllegalArgumentException e) {
                    throw new ConfigurablePropertyException(e.getMessage());
                }
            }
        }
    }

    public static final class ActivityWorkerConfigurationValidatingChangeListener
    implements PropertyChangeListener {
        public void fireChange(ConfigurableProperty t, Object newValue) throws ConfigurablePropertyException {
            if (newValue != null && !newValue.toString().trim().isEmpty()) {
                try {
                    Config.buildActivityWorker(SimpleWorkflow.class, Config.client(), "domain", "task-list", newValue.toString().trim());
                }
                catch (IllegalArgumentException e) {
                    throw new ConfigurablePropertyException(e.getMessage());
                }
            }
        }
    }

    public static final class ClientConfigurationValidatingChangeListener
    implements PropertyChangeListener {
        public void fireChange(ConfigurableProperty t, Object newValue) throws ConfigurablePropertyException {
            if (newValue != null && !newValue.toString().trim().isEmpty()) {
                try {
                    Config.buildConfiguration(newValue.toString().trim());
                }
                catch (IllegalArgumentException e) {
                    throw new ConfigurablePropertyException(e.getMessage());
                }
            }
        }
    }

    public static final class NameValidatingChangeListener
    implements PropertyChangeListener {
        public void fireChange(ConfigurableProperty t, Object newValue) throws ConfigurablePropertyException {
            if (newValue == null || !SimpleWorkflowMessage.FieldRegexValue.NAME_256.pattern().matcher(newValue.toString()).matches()) {
                throw new ConfigurablePropertyException("Value length must be 1 - 256 characters");
            }
        }
    }
}

