/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.autoscaling.service.ws;

import com.eucalyptus.autoscaling.common.msgs.Error;
import com.eucalyptus.autoscaling.common.msgs.ErrorResponse;
import com.eucalyptus.autoscaling.service.ws.AutoScalingQueryBinding;
import com.eucalyptus.component.annotation.ComponentNamed;
import com.eucalyptus.ws.Role;
import com.eucalyptus.ws.util.ErrorHandlerSupport;
import edu.ucsb.eucalyptus.msgs.BaseMessage;
import org.apache.log4j.Logger;

@ComponentNamed
public class AutoScalingErrorHandler
extends ErrorHandlerSupport {
    private static final Logger LOG = Logger.getLogger(AutoScalingErrorHandler.class);
    private static final String INTERNAL_FAILURE = "InternalFailure";

    public AutoScalingErrorHandler() {
        super(LOG, AutoScalingQueryBinding.SCALING_DEFAULT_NAMESPACE, INTERNAL_FAILURE);
    }

    protected BaseMessage buildErrorResponse(String correlationId, Role role, String code, String message) {
        ErrorResponse errorResp = new ErrorResponse();
        errorResp.setCorrelationId(correlationId);
        errorResp.setRequestId(correlationId);
        Error error = new Error();
        error.setType(role == Role.Receiver ? "Receiver" : "Sender");
        error.setCode(code);
        error.setMessage(message);
        errorResp.getError().add(error);
        return errorResp;
    }
}

