/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.autoscaling.service;

import com.eucalyptus.auth.AuthContextSupplier;
import com.eucalyptus.auth.Permissions;
import com.eucalyptus.autoscaling.common.AutoScalingBackend;
import com.eucalyptus.autoscaling.common.backend.msgs.AutoScalingBackendMessage;
import com.eucalyptus.autoscaling.common.msgs.AutoScalingMessage;
import com.eucalyptus.autoscaling.common.msgs.ResponseMetadata;
import com.eucalyptus.autoscaling.service.AutoScalingAuthorizationException;
import com.eucalyptus.autoscaling.service.AutoScalingClientException;
import com.eucalyptus.autoscaling.service.AutoScalingException;
import com.eucalyptus.autoscaling.service.AutoScalingUnavailableException;
import com.eucalyptus.component.Partition;
import com.eucalyptus.component.ServiceConfiguration;
import com.eucalyptus.component.Topology;
import com.eucalyptus.component.annotation.ComponentNamed;
import com.eucalyptus.context.Contexts;
import com.eucalyptus.context.ServiceDispatchException;
import com.eucalyptus.util.EucalyptusCloudException;
import com.eucalyptus.util.Exceptions;
import com.eucalyptus.util.RestrictedTypes;
import com.eucalyptus.util.async.AsyncRequests;
import com.eucalyptus.util.async.FailedRequestException;
import com.eucalyptus.ws.EucalyptusRemoteFault;
import com.eucalyptus.ws.EucalyptusWebServiceException;
import com.eucalyptus.ws.Role;
import com.google.common.base.Objects;
import edu.ucsb.eucalyptus.msgs.BaseMessage;
import edu.ucsb.eucalyptus.msgs.BaseMessages;
import java.util.Map;
import java.util.NoSuchElementException;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.mule.component.ComponentException;

@ComponentNamed
public class AutoScalingService {
    public AutoScalingMessage dispatchAction(AutoScalingMessage request) throws EucalyptusCloudException {
        AuthContextSupplier user = Contexts.lookup().getAuthContext();
        if (!Permissions.perhapsAuthorized((String)"autoscaling", (String)RestrictedTypes.getIamActionByMessageType((BaseMessage)request), (AuthContextSupplier)user)) {
            throw new AutoScalingAuthorizationException("UnauthorizedOperation", "You are not authorized to perform this operation.");
        }
        Map validationErrorsByField = request.validate();
        if (!validationErrorsByField.isEmpty()) {
            throw new AutoScalingClientException("ValidationError", (String)validationErrorsByField.values().iterator().next());
        }
        try {
            AutoScalingBackendMessage backendRequest = (AutoScalingBackendMessage)BaseMessages.deepCopy((BaseMessage)request, (Class)AutoScalingService.getBackendMessageClass((BaseMessage)request));
            BaseMessage backendResponse = AutoScalingService.send((BaseMessage)backendRequest);
            AutoScalingMessage response = (AutoScalingMessage)BaseMessages.deepCopy((BaseMessage)backendResponse, request.getReply().getClass());
            ResponseMetadata metadata = AutoScalingMessage.getResponseMetadata((BaseMessage)response);
            if (metadata != null) {
                metadata.setRequestId(request.getCorrelationId());
            }
            response.setCorrelationId(request.getCorrelationId());
            return response;
        }
        catch (Exception e) {
            this.handleRemoteException(e);
            Exceptions.findAndRethrow((Throwable)e, EucalyptusWebServiceException.class, EucalyptusCloudException.class);
            throw new EucalyptusCloudException((Throwable)e);
        }
    }

    private static Class getBackendMessageClass(BaseMessage request) throws ClassNotFoundException {
        return Class.forName(request.getClass().getName().replace(".common.msgs.", ".common.backend.msgs."));
    }

    private static BaseMessage send(BaseMessage request) throws Exception {
        try {
            return AsyncRequests.sendSyncWithCurrentIdentity((ServiceConfiguration)Topology.lookup(AutoScalingBackend.class, (Partition[])new Partition[0]), (BaseMessage)request);
        }
        catch (NoSuchElementException e) {
            throw new AutoScalingUnavailableException("Service Unavailable");
        }
        catch (ServiceDispatchException e) {
            ComponentException componentException = (ComponentException)Exceptions.findCause((Throwable)e, ComponentException.class);
            if (componentException != null && componentException.getCause() instanceof Exception) {
                throw (Exception)componentException.getCause();
            }
            throw e;
        }
        catch (FailedRequestException e) {
            if (request.getReply().getClass().isInstance(e.getRequest())) {
                return e.getRequest();
            }
            throw e.getRequest() == null ? e : new AutoScalingException("InternalError", Role.Receiver, "Internal error " + e.getRequest().getClass().getSimpleName() + ":false");
        }
    }

    private void handleRemoteException(Exception e) throws EucalyptusCloudException {
        EucalyptusRemoteFault remoteFault = (EucalyptusRemoteFault)Exceptions.findCause((Throwable)e, EucalyptusRemoteFault.class);
        if (remoteFault != null) {
            HttpResponseStatus status = (HttpResponseStatus)Objects.firstNonNull((Object)remoteFault.getStatus(), (Object)HttpResponseStatus.INTERNAL_SERVER_ERROR);
            String code = remoteFault.getFaultCode();
            String message = remoteFault.getFaultDetail();
            switch (status.getCode()) {
                case 400: {
                    throw new AutoScalingClientException(code, message);
                }
                case 403: {
                    throw new AutoScalingAuthorizationException(code, message);
                }
                case 503: {
                    throw new AutoScalingUnavailableException(message);
                }
            }
            throw new AutoScalingException(code, Role.Receiver, message);
        }
    }
}

