/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.blockstorage.util;

import com.eucalyptus.blockstorage.Storage;
import com.eucalyptus.component.Components;
import com.eucalyptus.component.Partition;
import com.eucalyptus.component.ServiceConfiguration;
import com.eucalyptus.component.ServiceUris;
import com.eucalyptus.component.Topology;
import com.eucalyptus.objectstorage.ObjectStorage;
import com.eucalyptus.system.BaseDirectory;
import edu.ucsb.eucalyptus.util.ConfigParser;
import edu.ucsb.eucalyptus.util.StreamConsumer;
import java.util.NoSuchElementException;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class StorageProperties {
    private static Logger LOG = Logger.getLogger(StorageProperties.class);
    public static final long FAILED_STATE_CLEANUP_THRESHOLD_MS = 600000L;
    public static final String storageRootDirectory = BaseDirectory.VAR.getChildPath(new String[]{"volumes"});
    public static final long GB = 0x40000000L;
    public static final long MB = 0x100000L;
    public static final long KB = 1024L;
    public static final String iface = "eth0";
    public static final int MAX_TOTAL_VOLUME_SIZE = 100;
    public static final int MAX_VOLUME_SIZE = 15;
    public static int TRANSFER_CHUNK_SIZE = 8192;
    public static final boolean zeroFillVolumes = false;
    public static final long timeoutInMillis = 10000L;
    public static boolean enableSnapshots = false;
    public static boolean enableStorage = false;
    public static boolean shouldEnforceUsageLimits = true;
    public static String STORE_PREFIX = "iqn.2009-06.com.eucalyptus.";
    public static String WALRUS_URL = "http://localhost:8773/services/objectstorage";
    public static String NAME = "unregistered";
    public static String STORAGE_HOST = "127.0.0.1";
    public static final String ISCSI_INITIATOR_NAME_CONF = "/etc/iscsi/initiatorname.iscsi";
    public static String SC_INITIATOR_IQN = null;
    public static final String EUCA_ROOT_WRAPPER = BaseDirectory.LIBEXEC.toString() + "/euca_rootwrap";
    public static final String blockSize = "1M";
    public static String DAS_DEVICE = "/dev/blockdev";
    public static final String TOKEN_PREFIX = "sc://";
    public static final String SNAPSHOT_BUCKET_PREFIX = "snapshots-";
    public static final String EBS_ROLE_NAME = "EBSUpload";
    public static final String S3_BUCKET_ACCESS_POLICY_NAME = "S3EBSBucketAccess";
    public static final String S3_OBJECT_ACCESS_POLICY_NAME = "S3EBSObjectAccess";
    public static final String DEFAULT_ASSUME_ROLE_POLICY = "{\"Statement\":[{\"Effect\":\"Allow\",\"Principal\":{\"Service\":[\"s3.amazonaws.com\"]},\"Action\":[\"sts:AssumeRole\"]}]}";
    public static final String S3_SNAPSHOT_BUCKET_ACCESS_POLICY = "{\"Statement\":[{\"Effect\":\"Allow\",\"Action\": [\"s3:*\"],\"Resource\": \"arn:aws:s3:::*\"}]}";
    public static final String S3_SNAPSHOT_OBJECT_ACCESS_POLICY = "{\"Statement\":[{\"Effect\":\"Allow\",\"Action\": [\"s3:*\"],\"Resource\": \"arn:aws:s3:::*/*\"}]}";
    public static final Integer DELETED_VOLUME_EXPIRATION_TIME = 24;
    public static final Pattern PARSE_BLOCK_DEVICE = Pattern.compile("source.* dev='([^']*)'");

    public static String formatVolumeAttachmentTokenForTransfer(String token, String volumeId) {
        return TOKEN_PREFIX + volumeId + "," + token;
    }

    private static String getSCIqn() {
        try {
            Runtime rt = Runtime.getRuntime();
            Process proc = rt.exec(new String[]{EUCA_ROOT_WRAPPER, "cat", ISCSI_INITIATOR_NAME_CONF});
            StreamConsumer error = new StreamConsumer(proc.getErrorStream());
            ConfigParser output = new ConfigParser(proc.getInputStream());
            error.start();
            output.start();
            output.join();
            error.join();
            if (output.getValues() != null && output.getValues().containsKey("InitiatorName")) {
                return (String)output.getValues().get("InitiatorName");
            }
        }
        catch (Exception t) {
            LOG.error((Object)"Failed to get local SC's initiator iqn from /etc/iscsi/initiatorname.iscsi", (Throwable)t);
        }
        return null;
    }

    public static String getStorageIqn() {
        if (SC_INITIATOR_IQN == null) {
            SC_INITIATOR_IQN = StorageProperties.getSCIqn();
        }
        return SC_INITIATOR_IQN;
    }

    public static void updateName() {
        try {
            NAME = Components.lookup(Storage.class).getLocalServiceConfiguration().getPartition();
        }
        catch (NoSuchElementException ex) {
            LOG.error((Object)ex, (Throwable)ex);
            LOG.error((Object)"Failed to configure Storage Controller NAME.");
            throw ex;
        }
    }

    public static void updateStorageHost() {
        try {
            STORAGE_HOST = Components.lookup(Storage.class).getLocalServiceConfiguration().getHostName();
        }
        catch (NoSuchElementException ex) {
            LOG.error((Object)ex, (Throwable)ex);
            LOG.error((Object)("Failed to configure Storage Controller HOST (given the name " + NAME + "."));
        }
    }

    public static void updateStorageHost(String hostName) {
        STORAGE_HOST = hostName;
    }

    public static void updateWalrusUrl() {
        try {
            ServiceConfiguration walrusConfig = Topology.lookup(ObjectStorage.class, (Partition[])new Partition[0]);
            WALRUS_URL = ServiceUris.remote((ServiceConfiguration)walrusConfig, (String[])new String[0]).toASCIIString();
            enableSnapshots = true;
            LOG.info((Object)("Setting WALRUS_URL to: " + WALRUS_URL));
        }
        catch (Exception e) {
            LOG.warn((Object)"Could not obtain walrus information. Snapshot functionality may be unavailable. Have you registered ObjectStorage?");
            enableSnapshots = false;
        }
    }

    public static enum StorageParameters {
        EucaSignature,
        EucaSnapSize,
        EucaCert,
        EucaEffectiveUserId;

    }

    public static enum Status {
        creating,
        available,
        pending,
        completed,
        failed,
        error,
        deleting,
        deleted;

    }
}

