/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.blockstorage.util;

import com.eucalyptus.auth.Accounts;
import com.eucalyptus.auth.principal.Account;
import com.eucalyptus.auth.principal.Policy;
import com.eucalyptus.auth.principal.Role;
import com.eucalyptus.blockstorage.Storage;
import com.eucalyptus.component.ComponentId;
import com.eucalyptus.component.Components;
import com.eucalyptus.component.Partition;
import com.eucalyptus.component.Partitions;
import com.eucalyptus.component.ServiceConfiguration;
import com.eucalyptus.component.auth.SystemCredentials;
import com.eucalyptus.component.id.Eucalyptus;
import com.eucalyptus.crypto.Ciphers;
import com.eucalyptus.crypto.Crypto;
import com.eucalyptus.util.EucalyptusCloudException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.util.List;
import javax.crypto.Cipher;
import org.apache.log4j.Logger;
import org.bouncycastle.util.encoders.Base64;

public class BlockStorageUtil {
    private static Logger LOG = Logger.getLogger(BlockStorageUtil.class);

    public static <C extends ComponentId> Partition getPartitionForLocalService(Class<C> compClass) throws EucalyptusCloudException {
        try {
            return Partitions.lookup((ServiceConfiguration)Components.lookup(compClass).getLocalServiceConfiguration());
        }
        catch (Exception e) {
            LOG.error((Object)("Error finding partition for local component: " + compClass.getCanonicalName()));
            throw new EucalyptusCloudException("Failed lookup", (Throwable)e);
        }
    }

    public static String encryptNodeTargetPassword(String password, Partition partition) throws EucalyptusCloudException {
        try {
            if (partition == null) {
                throw new EucalyptusCloudException("Invalid partition specified. Got null");
            }
            PublicKey ncPublicKey = partition.getNodeCertificate().getPublicKey();
            Cipher cipher = Ciphers.RSA_PKCS1.get();
            cipher.init(1, (Key)ncPublicKey, (SecureRandom)Crypto.getSecureRandomSupplier().get());
            return new String(Base64.encode((byte[])cipher.doFinal(password.getBytes())));
        }
        catch (Exception e) {
            LOG.error((Object)("Unable to encrypt storage target password: " + e.getMessage()), (Throwable)e);
            throw new EucalyptusCloudException("Unable to encrypt storage target password: " + e.getMessage(), (Throwable)e);
        }
    }

    public static String encryptSCTargetPassword(String password) throws EucalyptusCloudException {
        PublicKey scPublicKey = SystemCredentials.lookup(Storage.class).getKeyPair().getPublic();
        try {
            Cipher cipher = Ciphers.RSA_PKCS1.get();
            cipher.init(1, (Key)scPublicKey, (SecureRandom)Crypto.getSecureRandomSupplier().get());
            return new String(Base64.encode((byte[])cipher.doFinal(password.getBytes())));
        }
        catch (Exception e) {
            LOG.error((Object)"Unable to encrypted storage target password");
            throw new EucalyptusCloudException(e.getMessage(), (Throwable)e);
        }
    }

    public static String decryptSCTargetPassword(String encryptedPassword) throws EucalyptusCloudException {
        PrivateKey scPrivateKey = SystemCredentials.lookup(Storage.class).getPrivateKey();
        try {
            Cipher cipher = Ciphers.RSA_PKCS1.get();
            cipher.init(2, (Key)scPrivateKey, (SecureRandom)Crypto.getSecureRandomSupplier().get());
            return new String(cipher.doFinal(Base64.decode((String)encryptedPassword)));
        }
        catch (Exception ex) {
            LOG.error((Object)ex);
            throw new EucalyptusCloudException("Unable to decrypt storage target password", (Throwable)ex);
        }
    }

    public static String encryptForNode(String data, Partition partition) throws EucalyptusCloudException {
        try {
            if (partition == null) {
                throw new EucalyptusCloudException("Invalid partition specified. Got null");
            }
            PublicKey ncPublicKey = partition.getNodeCertificate().getPublicKey();
            Cipher cipher = Ciphers.RSA_PKCS1.get();
            cipher.init(1, (Key)ncPublicKey, (SecureRandom)Crypto.getSecureRandomSupplier().get());
            return new String(Base64.encode((byte[])cipher.doFinal(data.getBytes())));
        }
        catch (Exception e) {
            LOG.error((Object)("Unable to encrypt data: " + e.getMessage()), (Throwable)e);
            throw new EucalyptusCloudException("Unable to encrypt data: " + e.getMessage(), (Throwable)e);
        }
    }

    public static String decryptForNode(String data, Partition partition) throws EucalyptusCloudException {
        try {
            if (partition == null) {
                throw new EucalyptusCloudException("Invalid partition specified. Got null");
            }
            PrivateKey ncPrivateKey = partition.getNodePrivateKey();
            Cipher cipher = Ciphers.RSA_PKCS1.get();
            cipher.init(2, (Key)ncPrivateKey, (SecureRandom)Crypto.getSecureRandomSupplier().get());
            return new String(cipher.doFinal(Base64.decode((String)data)));
        }
        catch (Exception e) {
            LOG.error((Object)("Unable to dencrypt data with node private key: " + e.getMessage()), (Throwable)e);
            throw new EucalyptusCloudException("Unable to encrypt data with node private key: " + e.getMessage(), (Throwable)e);
        }
    }

    public static String encryptForCloud(String data) throws EucalyptusCloudException {
        try {
            PublicKey clcPublicKey = SystemCredentials.lookup(Eucalyptus.class).getCertificate().getPublicKey();
            Cipher cipher = Ciphers.RSA_PKCS1.get();
            cipher.init(1, (Key)clcPublicKey, (SecureRandom)Crypto.getSecureRandomSupplier().get());
            return new String(Base64.encode((byte[])cipher.doFinal(data.getBytes())));
        }
        catch (Exception e) {
            LOG.error((Object)("Unable to encrypt data: " + e.getMessage()), (Throwable)e);
            throw new EucalyptusCloudException("Unable to encrypt data: " + e.getMessage(), (Throwable)e);
        }
    }

    public static String decryptWithCloud(String data) throws EucalyptusCloudException {
        PrivateKey clcPrivateKey = SystemCredentials.lookup(Eucalyptus.class).getPrivateKey();
        try {
            Cipher cipher = Ciphers.RSA_PKCS1.get();
            cipher.init(2, (Key)clcPrivateKey, (SecureRandom)Crypto.getSecureRandomSupplier().get());
            return new String(cipher.doFinal(Base64.decode((String)data)));
        }
        catch (Exception ex) {
            LOG.error((Object)ex);
            throw new EucalyptusCloudException("Unable to decrypt data with cloud private key", (Throwable)ex);
        }
    }

    public static Role checkAndConfigureBlockStorageAccount() throws EucalyptusCloudException {
        Account blockStorageAccount = null;
        Role role = null;
        try {
            blockStorageAccount = Accounts.lookupAccountByName((String)"(eucalyptus)blockstorage");
        }
        catch (Exception e) {
            LOG.warn((Object)"Could not find account (eucalyptus)blockstorage. Account may not exist, trying to create it");
            try {
                blockStorageAccount = Accounts.addSystemAccountWithAdmin((String)"(eucalyptus)blockstorage");
            }
            catch (Exception e1) {
                LOG.warn((Object)"Failed to create account (eucalyptus)blockstorage");
                throw new EucalyptusCloudException("Failed to create account (eucalyptus)blockstorage");
            }
        }
        try {
            role = blockStorageAccount.lookupRoleByName("EBSUpload");
        }
        catch (Exception e) {
            LOG.debug((Object)"Could not find EBSUpload role for (eucalyptus)blockstorage account. The role may not exist, trying to add role to the account");
            try {
                role = blockStorageAccount.addRole("EBSUpload", "/blockstorage", "{\"Statement\":[{\"Effect\":\"Allow\",\"Principal\":{\"Service\":[\"s3.amazonaws.com\"]},\"Action\":[\"sts:AssumeRole\"]}]}");
            }
            catch (Exception e1) {
                LOG.debug((Object)"Failed to add EBSUpload role. Checking if the role is assigned to the account");
                try {
                    role = blockStorageAccount.lookupRoleByName("EBSUpload");
                }
                catch (Exception e2) {
                    LOG.warn((Object)"Could not find EBSUpload role for (eucalyptus)blockstorage account and failed to assign the role to the account", (Throwable)e2);
                    throw new EucalyptusCloudException("Could not find EBSUpload role for (eucalyptus)blockstorage account and failed to assign the role to the account");
                }
            }
        }
        try {
            block25: {
                List policies;
                boolean foundObjectPolicy;
                block24: {
                    boolean foundBucketPolicy = false;
                    foundObjectPolicy = false;
                    policies = role.getPolicies();
                    for (Policy policy : policies) {
                        if (policy.getName().equals("S3EBSBucketAccess")) {
                            foundBucketPolicy = true;
                        }
                        if (policy.getName().equals("S3EBSObjectAccess")) {
                            foundObjectPolicy = true;
                        }
                        if (!foundBucketPolicy || !foundObjectPolicy) continue;
                        break;
                    }
                    if (!foundBucketPolicy) {
                        try {
                            role.putPolicy("S3EBSBucketAccess", "{\"Statement\":[{\"Effect\":\"Allow\",\"Action\": [\"s3:*\"],\"Resource\": \"arn:aws:s3:::*\"}]}");
                        }
                        catch (Exception e) {
                            LOG.debug((Object)"Failed to assign S3EBSBucketAccess policy to EBSUpload role. Checking if the policy is assigned to the role");
                            foundBucketPolicy = false;
                            policies = role.getPolicies();
                            for (Policy policy : policies) {
                                if (!policy.getName().equals("S3EBSBucketAccess")) continue;
                                foundBucketPolicy = true;
                                break;
                            }
                            if (foundBucketPolicy) break block24;
                            LOG.warn((Object)"Could not find S3EBSBucketAccess policy assigned to EBSUpload role and failed to assign the policy to the role", (Throwable)e);
                            throw new EucalyptusCloudException("Could not find S3EBSBucketAccess policy assigned to EBSUpload role and failed to assign the policy to the role");
                        }
                    }
                }
                if (!foundObjectPolicy) {
                    try {
                        role.putPolicy("S3EBSObjectAccess", "{\"Statement\":[{\"Effect\":\"Allow\",\"Action\": [\"s3:*\"],\"Resource\": \"arn:aws:s3:::*/*\"}]}");
                    }
                    catch (Exception e) {
                        LOG.debug((Object)"Failed to assign S3EBSObjectAccess policy to EBSUpload role. Checking if the policy is assigned to the role");
                        foundObjectPolicy = false;
                        policies = role.getPolicies();
                        for (Policy policy : policies) {
                            if (!policy.getName().equals("S3EBSObjectAccess")) continue;
                            foundObjectPolicy = true;
                            break;
                        }
                        if (foundObjectPolicy) break block25;
                        LOG.warn((Object)"Could not find S3EBSObjectAccess policy assigned to EBSUpload role and failed to assign the policy to the role", (Throwable)e);
                        throw new EucalyptusCloudException("Could not find S3EBSObjectAccess policy assigned to EBSUpload role and failed to assign the policy to the role");
                    }
                }
            }
            return role;
        }
        catch (EucalyptusCloudException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.warn((Object)"Could not fetch the policies for EBSUpload role assigned to (eucalyptus)blockstorage account", (Throwable)e);
            throw new EucalyptusCloudException("Could not fetch the policies for EBSUpload role assigned to (eucalyptus)blockstorage account");
        }
    }
}

