/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.blockstorage.upgrade;

import com.eucalyptus.blockstorage.Storage;
import com.eucalyptus.blockstorage.san.common.entities.SANVolumeInfo;
import com.eucalyptus.entities.Entities;
import com.eucalyptus.upgrade.Upgrades;
import com.eucalyptus.util.Exceptions;
import com.google.common.base.Predicate;
import groovy.sql.Sql;
import java.util.List;
import java.util.concurrent.Callable;
import javax.annotation.Nullable;
import javax.persistence.EntityTransaction;
import org.apache.log4j.Logger;

public class SANVolumeInfo400Upgrade {
    static final String OLDTABLE = "equallogicvolumeinfo";
    static final String NEWTABLE = "san_volume_info";

    @Upgrades.PostUpgrade(since=Upgrades.Version.v4_0_0, value=Storage.class)
    public static class DropTable
    implements Callable<Boolean> {
        private static final Logger LOG = Logger.getLogger(DropTable.class);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Boolean call() throws Exception {
            LOG.info((Object)"Dropping table equallogicvolumeinfo");
            try (Sql sql = null;){
                sql = Upgrades.DatabaseFilters.NEWVERSION.getConnection("eucalyptus_storage");
                sql.execute(String.format("drop table if exists %s", SANVolumeInfo400Upgrade.OLDTABLE));
                Boolean bl = true;
                return bl;
            }
        }
    }

    @Upgrades.EntityUpgrade(entities={SANVolumeInfo.class}, since=Upgrades.Version.v4_0_0, value=Storage.class)
    public static enum AddResourceName implements Predicate<Class>
    {
        INSTANCE;

        private static final Logger LOG;

        public boolean apply(@Nullable Class arg0) {
            LOG.info((Object)"Entity upgrade for SANVolumeInfo entities - populating sanVolumeId field");
            SANVolumeInfo example = new SANVolumeInfo();
            example.setScName(null);
            EntityTransaction tran = Entities.get(SANVolumeInfo.class);
            try {
                List volumeList = Entities.query((Object)((Object)example));
                if (volumeList != null && !volumeList.isEmpty()) {
                    for (SANVolumeInfo volumeInfo : volumeList) {
                        if (volumeInfo.getSanVolumeId() != null) continue;
                        volumeInfo.setSanVolumeId(volumeInfo.getVolumeId());
                    }
                }
                tran.commit();
            }
            catch (Exception e) {
                LOG.error((Object)"Failed to perform entity upgrade for SANVolumeInfo entities", (Throwable)e);
                tran.rollback();
                Exceptions.toUndeclared((String)"Failed to perform entity upgrade for SANVolumeInfo entities", (Throwable[])new Exception[]{e});
            }
            return true;
        }

        static {
            LOG = Logger.getLogger(AddResourceName.class);
        }
    }

    @Upgrades.PreUpgrade(since=Upgrades.Version.v4_0_0, value=Storage.class)
    public static class CopyRows
    implements Callable<Boolean> {
        private static final Logger LOG = Logger.getLogger(CopyRows.class);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Boolean call() throws Exception {
            LOG.info((Object)"Copying rows from equallogicvolumeinfo table to san_volume_info");
            try (Sql sql = null;){
                List result;
                sql = Upgrades.DatabaseFilters.NEWVERSION.getConnection("eucalyptus_storage");
                try {
                    result = sql.rows(String.format("select id from %s where id is not null", SANVolumeInfo400Upgrade.NEWTABLE));
                    if (result != null && result.size() > 0) {
                        Boolean bl = true;
                        return bl;
                    }
                }
                catch (Exception e) {
                    LOG.error((Object)"Select statement from san_volume_info failed. The table may not exist or was not setup correctly");
                    Boolean bl = false;
                    return bl;
                }
                result = sql.rows(String.format("select id from %s where id is not null", SANVolumeInfo400Upgrade.OLDTABLE));
                if (result == null || result.size() <= 0) {
                    Boolean bl = true;
                    return bl;
                }
                try {
                    sql.execute(String.format("insert into %s (id, creation_timestamp, last_update_timestamp, metadata_perm_uuid, version, encryptedpassword, iqn, scname, size, snapshot_of, status, storeuser, volumeid) select id, creation_timestamp, last_update_timestamp, metadata_perm_uuid, version, encryptedpassword, iqn, scname, size, snapshot_of, status, storeuser, volumeid from %s", SANVolumeInfo400Upgrade.NEWTABLE, SANVolumeInfo400Upgrade.OLDTABLE));
                }
                catch (Exception e) {
                    LOG.error((Object)"Failed to copy rows using select into statement from equallogicvolumeinfo to san_volume_info");
                    Boolean bl = false;
                    if (sql != null) {
                        sql.close();
                    }
                    return bl;
                }
                Boolean e = true;
                return e;
            }
        }
    }
}

