/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.blockstorage.san.common.entities;

import com.eucalyptus.blockstorage.Storage;
import com.eucalyptus.blockstorage.entities.SnapshotInfo;
import com.eucalyptus.blockstorage.util.StorageProperties;
import com.eucalyptus.entities.AbstractPersistent;
import com.eucalyptus.entities.Entities;
import com.eucalyptus.upgrade.Upgrades;
import com.eucalyptus.util.Exceptions;
import com.google.common.base.Predicate;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EntityTransaction;
import javax.persistence.Lob;
import javax.persistence.PersistenceContext;
import javax.persistence.Table;
import org.apache.log4j.Logger;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Type;

@Entity
@PersistenceContext(name="eucalyptus_storage")
@Table(name="san_volume_info")
@Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
public class SANVolumeInfo
extends AbstractPersistent {
    protected String volumeId;
    private String scName = StorageProperties.NAME;
    private String iqn;
    private String storeUser;
    @Type(type="org.hibernate.type.StringClobType")
    @Lob
    private String encryptedPassword;
    @Column(name="size")
    protected Integer size;
    @Column(name="status")
    private String status;
    @Column(name="snapshot_of")
    private String snapshotOf;
    @Column(name="san_volume_Id")
    private String sanVolumeId;

    public SANVolumeInfo() {
    }

    public SANVolumeInfo(String volumeId) {
        this();
        this.volumeId = volumeId;
    }

    public SANVolumeInfo(String volumeId, String iqn, int size) {
        this();
        this.volumeId = volumeId;
        this.iqn = iqn;
        this.size = size;
    }

    public String getIqn() {
        return this.iqn;
    }

    public void setIqn(String iqn) {
        this.iqn = iqn;
    }

    public String getStoreUser() {
        return this.storeUser;
    }

    public void setStoreUser(String storeUser) {
        this.storeUser = storeUser;
    }

    public String getEncryptedPassword() {
        return this.encryptedPassword;
    }

    public void setEncryptedPassword(String encryptedPassword) {
        this.encryptedPassword = encryptedPassword;
    }

    public String getVolumeId() {
        return this.volumeId;
    }

    public void setVolumeId(String volumeId) {
        this.volumeId = volumeId;
    }

    public String getScName() {
        return this.scName;
    }

    public void setScName(String scName) {
        this.scName = scName;
    }

    public Integer getSize() {
        return this.size;
    }

    public void setSize(Integer size) {
        this.size = size;
    }

    public SANVolumeInfo withSize(Integer size) {
        this.size = size;
        return this;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getSnapshotOf() {
        return this.snapshotOf;
    }

    public void setSnapshotOf(String snapshotOf) {
        this.snapshotOf = snapshotOf;
    }

    public SANVolumeInfo withSnapshotOf(String snapshotOf) {
        this.snapshotOf = snapshotOf;
        return this;
    }

    public String getSanVolumeId() {
        return this.sanVolumeId;
    }

    public void setSanVolumeId(String sanVolumeId) {
        this.sanVolumeId = sanVolumeId;
    }

    public SANVolumeInfo withSanVolumeId(String sanVolumeId) {
        this.sanVolumeId = sanVolumeId;
        return this;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.volumeId == null ? 0 : this.volumeId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        SANVolumeInfo other = (SANVolumeInfo)((Object)obj);
        return !(this.volumeId == null ? other.volumeId != null : !this.volumeId.equals(other.volumeId));
    }

    @Upgrades.EntityUpgrade(entities={SANVolumeInfo.class}, since=Upgrades.Version.v3_4_0, value=Storage.class)
    public static enum SANSnapshotSizeUpgrade3_4 implements Predicate<Class>
    {
        INSTANCE;

        private static Logger LOG;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean apply(Class arg0) {
            EntityTransaction db = Entities.get(SANVolumeInfo.class);
            try {
                SANVolumeInfo example = new SANVolumeInfo();
                example.setScName(null);
                List entities = Entities.query((Object)((Object)example));
                for (SANVolumeInfo entry : entities) {
                    if (entry.getVolumeId().startsWith("snap-")) {
                        EntityTransaction snapDb = Entities.get(SnapshotInfo.class);
                        try {
                            SnapshotInfo exampleSnap = new SnapshotInfo(entry.getVolumeId());
                            exampleSnap.setScName(null);
                            List snaps = Entities.query((Object)((Object)exampleSnap));
                            for (SnapshotInfo snap : snaps) {
                                if (snap.getSizeGb() != null) continue;
                                snap.setSizeGb(entry.getSize());
                                LOG.debug((Object)("Upgrading: " + entry.getVolumeId() + " putting size from back-end to SnapshotInfo. Setting size to " + snap.getSizeGb()));
                            }
                            snapDb.commit();
                            continue;
                        }
                        finally {
                            snapDb.rollback();
                            snapDb = null;
                            continue;
                        }
                    }
                    LOG.debug((Object)("Skipping snapshot upgrade of " + entry.getVolumeId() + " because not a snapshot"));
                }
                db.commit();
                return true;
            }
            catch (Exception ex) {
                db.rollback();
                throw Exceptions.toUndeclared((Throwable)ex);
            }
        }

        static {
            LOG = Logger.getLogger(SANSnapshotSizeUpgrade3_4.class);
        }
    }
}

