/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.blockstorage.san.common.entities;

import com.eucalyptus.blockstorage.util.BlockStorageUtil;
import com.eucalyptus.blockstorage.util.StorageProperties;
import com.eucalyptus.configurable.ConfigurableClass;
import com.eucalyptus.configurable.ConfigurableField;
import com.eucalyptus.configurable.ConfigurableFieldType;
import com.eucalyptus.configurable.ConfigurableIdentifier;
import com.eucalyptus.configurable.ConfigurableProperty;
import com.eucalyptus.configurable.ConfigurablePropertyException;
import com.eucalyptus.configurable.PropertyChangeListener;
import com.eucalyptus.entities.AbstractPersistent;
import com.eucalyptus.entities.Transactions;
import com.eucalyptus.util.EucalyptusCloudException;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.net.HostSpecifier;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Lob;
import javax.persistence.PersistenceContext;
import javax.persistence.PostLoad;
import javax.persistence.PreUpdate;
import javax.persistence.Table;
import org.apache.log4j.Logger;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Type;

@Entity
@PersistenceContext(name="eucalyptus_storage")
@Table(name="san_info")
@Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
@ConfigurableClass(root="storage", alias="san", description="Basic storage controller configuration for SAN.", singleton=false, deferred=true)
public class SANInfo
extends AbstractPersistent {
    private static Logger LOG = Logger.getLogger(SANInfo.class);
    private static String currentSanHosts = null;
    private static TreeMap<String, Long> sanControllerAddresses = Maps.newTreeMap();
    private static final Long ADDRESS_FAILURE_RETRY_INTERVAL_IN_MILLIS = 300000L;
    private static final long TASK_TIMEOUT = 300000L;
    public static final String DEFAULT_CHAP_USER = "nouser";
    @ConfigurableIdentifier
    @Column(name="storage_name", unique=true)
    protected String name;
    @ConfigurableField(description="Hostname for SAN device.", displayName="SAN Host")
    @Column(name="san_host")
    private String sanHost;
    @ConfigurableField(description="Username for SAN device.", displayName="SAN Username")
    @Column(name="san_user")
    private String sanUser;
    @ConfigurableField(description="Password for SAN device.", displayName="SAN Password", type=ConfigurableFieldType.KEYVALUEHIDDEN)
    @Column(name="san_password")
    @Type(type="org.hibernate.type.StringClobType")
    @Lob
    private String sanPassword;
    @ConfigurableField(description="User ID for CHAP authentication", displayName="CHAP user", type=ConfigurableFieldType.KEYVALUE)
    @Column(name="chap_user")
    private String chapUser;
    @ConfigurableField(description="iSCSI Paths for NC", displayName="NC paths", type=ConfigurableFieldType.KEYVALUE, changeListener=PathsChangeListener.class)
    @Column(name="ncpaths")
    private String ncPaths;
    @ConfigurableField(description="iSCSI Paths for SC", displayName="SC paths", type=ConfigurableFieldType.KEYVALUE, changeListener=PathsChangeListener.class)
    @Column(name="scpaths")
    private String scPaths;
    @ConfigurableField(description="Timeout for SAN commands.", displayName="SAN Task Timeout")
    @Column(name="task_timeout")
    private Long taskTimeout;
    @ConfigurableField(description="Prefix for resource name on SAN", displayName="Resource Prefix", initial="")
    @Column(name="resource_prefix")
    private String resourcePrefix;
    @ConfigurableField(description="Suffix for resource name on SAN", displayName="Resource Suffix", initial="")
    @Column(name="resource_suffix")
    private String resourceSuffix;
    public static final String DEFAULT_PATHS = "nopath";
    private static final String PATH_SEPARATOR = ",";
    private static final String PATH_FIELD_SEPARATOR = ":";

    public SANInfo() {
        this.name = StorageProperties.NAME;
    }

    public SANInfo(String name) {
        this.name = name;
    }

    public SANInfo(String name, String sanHost, String sanUser, String sanPassword) {
        this.name = name;
        this.sanHost = sanHost;
        this.sanUser = sanUser;
        this.sanPassword = sanPassword;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getSanHost() {
        return this.sanHost;
    }

    public void setSanHost(String sanHost) {
        this.sanHost = sanHost;
    }

    public String getSanUser() {
        return this.sanUser;
    }

    public void setSanUser(String sanUser) {
        this.sanUser = sanUser;
    }

    public String getSanPassword() {
        try {
            return BlockStorageUtil.decryptSCTargetPassword(this.sanPassword);
        }
        catch (EucalyptusCloudException ex) {
            LOG.error((Object)ex);
            return null;
        }
    }

    public void setSanPassword(String sanPassword) {
        try {
            this.sanPassword = BlockStorageUtil.encryptSCTargetPassword(sanPassword);
        }
        catch (EucalyptusCloudException ex) {
            LOG.error((Object)ex);
        }
    }

    public String getChapUser() {
        return this.chapUser;
    }

    public void setChapUser(String chapUser) {
        this.chapUser = chapUser;
    }

    public String getNcPaths() {
        return this.ncPaths;
    }

    public void setNcPaths(String paths) {
        this.ncPaths = paths;
    }

    public String getScPaths() {
        return this.scPaths;
    }

    public void setScPaths(String scPaths) {
        this.scPaths = scPaths;
    }

    public Long getTaskTimeout() {
        return this.taskTimeout;
    }

    public void setTaskTimeout(Long taskTimeout) {
        this.taskTimeout = taskTimeout;
    }

    public String getResourcePrefix() {
        return this.resourcePrefix;
    }

    public void setResourcePrefix(String resourcePrefix) {
        this.resourcePrefix = resourcePrefix;
    }

    public String getResourceSuffix() {
        return this.resourceSuffix;
    }

    public void setResourceSuffix(String resourceSuffix) {
        this.resourceSuffix = resourceSuffix;
    }

    @PreUpdate
    @PostLoad
    public void setDefaults() {
        if (this.taskTimeout == null) {
            this.taskTimeout = 300000L;
        }
        if (this.chapUser == null) {
            this.chapUser = DEFAULT_CHAP_USER;
        }
    }

    private static SANInfo newDefault() {
        SANInfo sanInfo = new SANInfo();
        sanInfo.setName(StorageProperties.NAME);
        sanInfo.setSanHost("sanHost");
        sanInfo.setSanUser("sanUser");
        sanInfo.setSanPassword("sanPassword");
        sanInfo.setChapUser(DEFAULT_CHAP_USER);
        sanInfo.setNcPaths(DEFAULT_PATHS);
        sanInfo.setScPaths(DEFAULT_PATHS);
        sanInfo.setTaskTimeout(300000L);
        return sanInfo;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        SANInfo other = (SANInfo)((Object)obj);
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public String toString() {
        return this.name;
    }

    public static SANInfo getStorageInfo() {
        SANInfo conf = null;
        try {
            conf = (SANInfo)((Object)Transactions.find((Object)((Object)new SANInfo())));
        }
        catch (Exception e) {
            LOG.warn((Object)("Storage information for " + StorageProperties.NAME + " not found. Loading defaults."));
            try {
                conf = (SANInfo)((Object)Transactions.saveDirect((Object)((Object)SANInfo.newDefault())));
            }
            catch (Exception e1) {
                try {
                    conf = (SANInfo)((Object)Transactions.find((Object)((Object)new SANInfo())));
                }
                catch (Exception e2) {
                    LOG.warn((Object)"Failed to persist and retrieve SANInfo entity");
                }
            }
        }
        if (conf == null) {
            conf = SANInfo.newDefault();
        }
        return conf;
    }

    private static void loadSanControllerAddressesIfChanged() {
        String hosts = SANInfo.getStorageInfo().getSanHost();
        if (currentSanHosts == null || !currentSanHosts.equals(hosts)) {
            sanControllerAddresses.clear();
            if ("sanHost".equals(hosts) || Strings.isNullOrEmpty((String)hosts)) {
                return;
            }
            for (String host : hosts.split(PATH_SEPARATOR)) {
                if (Strings.isNullOrEmpty((String)(host = host.trim()))) continue;
                sanControllerAddresses.put(host, 0L);
            }
            currentSanHosts = hosts;
        }
    }

    public static synchronized String getSanControllerAddress() {
        SANInfo.loadSanControllerAddressesIfChanged();
        for (String addr : sanControllerAddresses.keySet()) {
            Long lastFailureTime = sanControllerAddresses.get(addr);
            if (System.currentTimeMillis() - lastFailureTime <= ADDRESS_FAILURE_RETRY_INTERVAL_IN_MILLIS) continue;
            return addr;
        }
        return null;
    }

    public static synchronized void setSanControllerAddressFailure(String address) {
        sanControllerAddresses.put(address, System.currentTimeMillis());
    }

    public static List<Path> parsePaths(String paths) {
        if (Strings.isNullOrEmpty((String)paths)) {
            throw new IllegalArgumentException("Empty paths");
        }
        String[] splitPaths = paths.split(PATH_SEPARATOR);
        if (splitPaths == null || splitPaths.length < 1) {
            throw new IllegalArgumentException("Invalid paths " + paths);
        }
        ArrayList parsed = Lists.newArrayList();
        for (String path : splitPaths) {
            String ip;
            String iface;
            String[] splitOnePath = path.split(PATH_FIELD_SEPARATOR);
            if (splitOnePath == null || splitOnePath.length < 1 || splitOnePath.length > 2) {
                throw new IllegalArgumentException("Invalid path " + path);
            }
            if (splitOnePath.length == 1) {
                iface = "";
                ip = splitOnePath[0];
            } else {
                iface = splitOnePath[0];
                ip = splitOnePath[1];
            }
            HostSpecifier.fromValid((String)ip);
            parsed.add(new Path(iface, ip));
        }
        return parsed;
    }

    public static class PathsChangeListener
    implements PropertyChangeListener {
        public void fireChange(ConfigurableProperty t, Object newValue) throws ConfigurablePropertyException {
            try {
                if (!SANInfo.DEFAULT_PATHS.equals(newValue)) {
                    SANInfo.parsePaths((String)newValue);
                }
            }
            catch (IllegalArgumentException e) {
                throw new ConfigurablePropertyException("Invalid paths: " + e, (Throwable)e);
            }
        }
    }

    public static class Path {
        public String iface;
        public String ip;
        public String sp;
        public String portId;
        public String iqn;

        public Path(String iface, String ip) {
            this.iface = iface;
            this.ip = ip;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.iface).append(',').append(this.ip);
            return sb.toString();
        }
    }
}

