/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.blockstorage.entities;

import com.eucalyptus.blockstorage.entities.VolumeExportRecord;
import com.eucalyptus.blockstorage.entities.VolumeInfo;
import com.eucalyptus.crypto.Crypto;
import com.eucalyptus.entities.AbstractPersistent;
import com.eucalyptus.entities.Entities;
import com.eucalyptus.entities.TransactionResource;
import com.eucalyptus.util.EucalyptusCloudException;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.PersistenceContext;
import javax.persistence.Table;
import org.apache.log4j.Logger;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

@Entity
@PersistenceContext(name="eucalyptus_storage")
@Table(name="volume_tokens")
@Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
public class VolumeToken
extends AbstractPersistent {
    private static final Logger LOG = Logger.getLogger(VolumeToken.class);
    private static final long serialVersionUID = 1L;
    private static final Integer TX_RETRIES = 3;
    @Column(name="token", unique=true, nullable=false)
    private String token;
    @ManyToOne
    @JoinColumn(name="volume", nullable=true)
    @Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
    private VolumeInfo volume;
    @Column(name="is_valid")
    private Boolean isValid;
    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="token")
    private List<VolumeExportRecord> exportRecords;

    public VolumeToken() {
        this.volume = null;
        this.token = null;
    }

    public VolumeToken(VolumeInfo vol) {
        this.volume = vol;
        this.token = null;
        this.exportRecords = null;
        this.isValid = null;
    }

    public VolumeToken(VolumeInfo vol, String token, boolean valid) {
        this.volume = vol;
        this.token = token;
        this.exportRecords = null;
        this.isValid = valid;
    }

    public VolumeToken(boolean isValid) {
        this.volume = null;
        this.token = null;
        this.exportRecords = null;
        this.isValid = isValid;
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public Boolean getIsValid() {
        return this.isValid;
    }

    public void setIsValid(Boolean isValid) {
        this.isValid = isValid;
    }

    public List<VolumeExportRecord> getExportRecords() {
        return this.exportRecords;
    }

    public void setExportRecords(List<VolumeExportRecord> exportRecords) {
        this.exportRecords = exportRecords;
    }

    public VolumeInfo getVolume() {
        return this.volume;
    }

    public void setVolume(VolumeInfo volumeInfo) {
        this.volume = volumeInfo;
    }

    public static VolumeToken generate(final VolumeInfo vol) throws EucalyptusCloudException {
        Function<VolumeInfo, VolumeToken> addToken = new Function<VolumeInfo, VolumeToken>(){

            public VolumeToken apply(VolumeInfo src) {
                try {
                    VolumeInfo volRecord = (VolumeInfo)((Object)Entities.merge((Object)((Object)src)));
                    VolumeToken token = new VolumeToken();
                    token.setVolume(volRecord);
                    token.setIsValid(true);
                    token.setToken(Crypto.generateSessionToken());
                    return token;
                }
                catch (Exception e) {
                    LOG.error((Object)("Error creating new volume token for " + vol.getVolumeId()));
                    return null;
                }
            }
        };
        try {
            return (VolumeToken)((Object)Entities.asTransaction(VolumeInfo.class, (Function)addToken, (int)TX_RETRIES).apply((Object)vol));
        }
        catch (RuntimeException e) {
            LOG.error((Object)("Failed to create new token for volume " + vol.getVolumeId() + " Msg: " + e.getMessage()), (Throwable)e);
            throw new EucalyptusCloudException("Failed new token creation.", (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public VolumeExportRecord getValidExport(String ip, String iqn) throws EucalyptusCloudException {
        try (TransactionResource tran = Entities.transactionFor(VolumeToken.class);){
            VolumeToken tokenEntity = (VolumeToken)((Object)Entities.merge((Object)((Object)this)));
            for (VolumeExportRecord rec : tokenEntity.getExportRecords()) {
                if (!rec.getIsActive().booleanValue() || !rec.getHostIp().equals(ip) || !rec.getHostIqn().equals(iqn)) continue;
                tran.commit();
                VolumeExportRecord volumeExportRecord = rec;
                return volumeExportRecord;
            }
            tran.commit();
            return null;
        }
        catch (Exception e) {
            LOG.error((Object)("Error when checking for valid export to " + ip + " and " + iqn + " for volume " + this.getVolume().getVolumeId() + " and token " + this.getToken()));
            throw new EucalyptusCloudException("Failed to check for valid export", (Throwable)e);
        }
    }

    public boolean hasActiveExports() throws EucalyptusCloudException {
        try {
            return Iterables.any(this.getExportRecords(), (Predicate)new Predicate<VolumeExportRecord>(){

                public boolean apply(VolumeExportRecord rec) {
                    return rec.getIsActive();
                }
            });
        }
        catch (Exception e) {
            LOG.error((Object)("Error when checking for active exports volume " + this.getVolume().getVolumeId() + " and token " + this.getToken()));
            throw new EucalyptusCloudException("Failed to check for valid export", (Throwable)e);
        }
    }

    public boolean hasOnlyExport(final String ip, final String iqn) throws EucalyptusCloudException {
        try {
            return Iterables.all(this.getExportRecords(), (Predicate)new Predicate<VolumeExportRecord>(){

                public boolean apply(VolumeExportRecord rec) {
                    if (rec.getIsActive().booleanValue()) {
                        return rec.getHostIp().equals(ip) && rec.getHostIqn().equals(iqn);
                    }
                    return true;
                }
            });
        }
        catch (Exception e) {
            LOG.error((Object)("Error checking for only export on " + ip + " : " + iqn + ". Error:" + e.getMessage()));
            throw new EucalyptusCloudException((Throwable)e);
        }
    }

    public void invalidateExport(final String ip, final String iqn) throws EucalyptusCloudException {
        Function<VolumeToken, VolumeToken> deactivateExport = new Function<VolumeToken, VolumeToken>(){

            public VolumeToken apply(VolumeToken tok) {
                VolumeToken tokenEntity = (VolumeToken)((Object)Entities.merge((Object)((Object)tok)));
                try {
                    for (VolumeExportRecord rec : tokenEntity.getExportRecords()) {
                        if (!rec.getIsActive().booleanValue() || !rec.getHostIp().equals(ip) || !rec.getHostIqn().equals(iqn)) continue;
                        rec.setIsActive(Boolean.FALSE);
                        break;
                    }
                    Predicate<VolumeExportRecord> notActive = new Predicate<VolumeExportRecord>(){

                        public boolean apply(VolumeExportRecord record) {
                            return record.getIsActive() == false;
                        }
                    };
                    if (Iterators.all(tokenEntity.getExportRecords().iterator(), (Predicate)notActive)) {
                        tok.setIsValid(Boolean.FALSE);
                    }
                    Entities.flush((Object)((Object)tokenEntity));
                    return tokenEntity;
                }
                catch (Exception e) {
                    LOG.error((Object)("Could not invalidate export record for volume " + tok.getVolume().getVolumeId() + " token " + tok.getToken() + " ip " + ip + " iqn " + iqn), (Throwable)e);
                    return null;
                }
            }
        };
        try {
            if (Entities.asTransaction(VolumeExportRecord.class, (Function)deactivateExport).apply((Object)this) == null) {
                throw new Exception("Failed to invalidate export, got null result from deactivation");
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Failed to invalidate export: " + e.getMessage()), (Throwable)e);
            throw new EucalyptusCloudException("Failed to invalidate export");
        }
    }

    public void addExport(final String ip, final String iqn, final String connectionString) throws EucalyptusCloudException {
        Function<VolumeToken, VolumeToken> createExport = new Function<VolumeToken, VolumeToken>(){

            public VolumeToken apply(VolumeToken token) {
                VolumeToken tok = null;
                tok = (VolumeToken)((Object)Entities.merge((Object)((Object)token)));
                try {
                    if (tok.getValidExport(ip, iqn) == null || !connectionString.equals(tok.getValidExport(ip, iqn).getConnectionString())) {
                        LOG.trace((Object)"Adding new volume export record to token");
                        VolumeExportRecord record = new VolumeExportRecord();
                        record.setToken(tok);
                        record.setVolume(tok.getVolume());
                        record.setHostIp(ip);
                        record.setHostIqn(iqn);
                        record.setConnectionString(connectionString);
                        record.setIsActive(true);
                        Entities.flush((Object)((Object)record));
                        tok.exportRecords.add(record);
                        return tok;
                    }
                }
                catch (Exception e) {
                    LOG.error((Object)"Error adding new export record", (Throwable)e);
                }
                return tok;
            }
        };
        try {
            Entities.asTransaction(VolumeToken.class, (Function)createExport).apply((Object)this);
        }
        catch (Exception e) {
            LOG.error((Object)"Failed to add export");
        }
    }

    public void invalidateAllExportsAndToken() throws EucalyptusCloudException {
        Function<VolumeToken, VolumeToken> invalidateToken = new Function<VolumeToken, VolumeToken>(){

            public VolumeToken apply(VolumeToken tok) {
                VolumeToken tokenEntity = (VolumeToken)((Object)Entities.merge((Object)((Object)tok)));
                try {
                    for (VolumeExportRecord rec : tokenEntity.getExportRecords()) {
                        rec.setIsActive(Boolean.FALSE);
                    }
                    tok.setIsValid(Boolean.FALSE);
                    return tokenEntity;
                }
                catch (Exception e) {
                    LOG.error((Object)("Could not invalidate export record for volume " + tok.getVolume().getVolumeId() + " token " + tok.getToken()), (Throwable)e);
                    return null;
                }
            }
        };
        try {
            if (Entities.asTransaction(VolumeExportRecord.class, (Function)invalidateToken).apply((Object)this) == null) {
                throw new Exception("Failed to invalidate export, got null result from deactivation");
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Failed to invalidate export: " + e.getMessage()), (Throwable)e);
            throw new EucalyptusCloudException("Failed to invalidate export");
        }
    }
}

