/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.blockstorage.entities;

import com.eucalyptus.blockstorage.entities.StorageInfo;
import com.eucalyptus.blockstorage.entities.VolumeToken;
import com.eucalyptus.blockstorage.util.BlockStorageUtil;
import com.eucalyptus.blockstorage.util.StorageProperties;
import com.eucalyptus.entities.AbstractPersistent;
import com.eucalyptus.entities.Entities;
import com.eucalyptus.util.EucalyptusCloudException;
import com.google.common.base.Function;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.OneToMany;
import javax.persistence.PersistenceContext;
import javax.persistence.Table;
import org.apache.log4j.Logger;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.NotFound;
import org.hibernate.annotations.NotFoundAction;

@Entity
@PersistenceContext(name="eucalyptus_storage")
@Table(name="Volumes")
@Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
public class VolumeInfo
extends AbstractPersistent {
    private static final Logger LOG = Logger.getLogger(VolumeInfo.class);
    @Column(name="volume_user_name")
    private String userName;
    @Column(name="volume_name", unique=true)
    private String volumeId;
    @Column(name="sc_name")
    private String scName = StorageProperties.NAME;
    @Column(name="size")
    private Integer size;
    @Column(name="status")
    private String status;
    @Column(name="create_time")
    private Date createTime;
    @Column(name="zone")
    private String zone;
    @Column(name="snapshot_id")
    private String snapshotId;
    @Column(name="deletion_time")
    private Date deletionTime;
    @NotFound(action=NotFoundAction.IGNORE)
    @OneToMany(fetch=FetchType.LAZY, mappedBy="volume", orphanRemoval=true, cascade={CascadeType.ALL})
    @Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
    private List<VolumeToken> attachmentTokens;

    public VolumeInfo() {
    }

    public VolumeInfo(String volumeId) {
        this();
        this.volumeId = volumeId;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getVolumeId() {
        return this.volumeId;
    }

    public void setVolumeId(String volumeId) {
        this.volumeId = volumeId;
    }

    public String getScName() {
        return this.scName;
    }

    public void setScName(String scName) {
        this.scName = scName;
    }

    public Integer getSize() {
        return this.size;
    }

    public void setSize(Integer size) {
        this.size = size;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public String getZone() {
        return this.zone;
    }

    public void setZone(String zone) {
        this.zone = zone;
    }

    public String getSnapshotId() {
        return this.snapshotId;
    }

    public void setSnapshotId(String snapshotId) {
        this.snapshotId = snapshotId;
    }

    public Date getDeletionTime() {
        return this.deletionTime;
    }

    public void setDeletionTime(Date deletionTime) {
        this.deletionTime = deletionTime;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        VolumeInfo other = (VolumeInfo)((Object)obj);
        if (this.scName == null ? other.scName != null : !this.scName.equals(other.scName)) {
            return false;
        }
        return !(this.volumeId == null ? other.volumeId != null : !this.volumeId.equals(other.volumeId));
    }

    public int hashCode() {
        return this.scName.hashCode() + this.volumeId.hashCode();
    }

    public List<VolumeToken> getAttachmentTokens() {
        return this.attachmentTokens;
    }

    public void setAttachmentTokens(List<VolumeToken> attachmentTokens) {
        this.attachmentTokens = attachmentTokens;
    }

    private static String decryptToken(String tokenCipher) throws EucalyptusCloudException {
        try {
            return BlockStorageUtil.decryptWithCloud(tokenCipher);
        }
        catch (EucalyptusCloudException e) {
            LOG.error((Object)("Failed to decrypt token: " + tokenCipher));
            throw e;
        }
    }

    private static String redactToken(String rawToken) {
        String tokenSuffix = new String(rawToken).substring(rawToken.length() - 4);
        StringBuilder redact = new StringBuilder();
        for (int i = 0; i < rawToken.length() - 4; ++i) {
            redact.append('*');
        }
        redact.append(tokenSuffix);
        return redact.toString();
    }

    public VolumeToken getAttachmentTokenIfValid(String encryptedTokenValue) throws EucalyptusCloudException {
        try {
            String decryptedToken = VolumeInfo.decryptToken(encryptedTokenValue);
            VolumeToken tok = this.getCurrentValidToken();
            if (tok == null) {
                LOG.warn((Object)("Got request for attachment token, no valid token found for volume  " + this.getVolumeId()));
                throw new EucalyptusCloudException("No valid token found");
            }
            if (!decryptedToken.equals(tok.getToken())) {
                LOG.error((Object)("Token requested is not valid token for volume " + this.getVolumeId() + " request token: " + VolumeInfo.redactToken(decryptedToken) + " current token: " + VolumeInfo.redactToken(tok.getToken())));
                throw new EucalyptusCloudException("Requested token is not the current valid token");
            }
            return tok;
        }
        catch (Exception e) {
            LOG.error((Object)"Error checking for valid attachment token", (Throwable)e);
            throw new EucalyptusCloudException((Throwable)e);
        }
    }

    public VolumeToken getCurrentValidToken() throws EucalyptusCloudException {
        Function<VolumeInfo, VolumeToken> getValidToken = new Function<VolumeInfo, VolumeToken>(){

            public VolumeToken apply(VolumeInfo src) {
                try {
                    VolumeInfo volEntity = (VolumeInfo)((Object)Entities.merge((Object)((Object)src)));
                    for (VolumeToken tok : volEntity.getAttachmentTokens()) {
                        if (!tok.getIsValid().booleanValue()) continue;
                        return tok;
                    }
                }
                catch (Exception e) {
                    LOG.trace((Object)("Failed while looking up valid token found for volume " + src.getVolumeId()), (Throwable)e);
                }
                return null;
            }
        };
        return (VolumeToken)((Object)Entities.asTransaction(VolumeInfo.class, (Function)getValidToken).apply((Object)this));
    }

    public synchronized VolumeToken getOrCreateAttachmentToken() throws EucalyptusCloudException {
        VolumeToken token = null;
        Function<VolumeInfo, VolumeToken> checkAddToken = new Function<VolumeInfo, VolumeToken>(){

            public VolumeToken apply(VolumeInfo src) {
                src = (VolumeInfo)((Object)Entities.merge((Object)((Object)src)));
                try {
                    if (src.getCurrentValidToken() != null) {
                        return src.getCurrentValidToken();
                    }
                    VolumeToken tok = VolumeToken.generate(src);
                    Entities.flush((Object)((Object)tok));
                    src.getAttachmentTokens().add(tok);
                    return tok;
                }
                catch (Exception e) {
                    LOG.error((Object)("Error creating new volume token for " + VolumeInfo.this.volumeId));
                    return null;
                }
            }
        };
        token = (VolumeToken)((Object)Entities.asTransaction(VolumeInfo.class, (Function)checkAddToken).apply((Object)this));
        return token;
    }

    public void invalidateExport(final String tokenValue, final String nodeIp, final String nodeIqn) throws EucalyptusCloudException {
        Function<VolumeInfo, VolumeToken> invalidateToken = new Function<VolumeInfo, VolumeToken>(){

            public VolumeToken apply(VolumeInfo src) {
                try {
                    VolumeInfo volEntity = (VolumeInfo)((Object)Entities.merge((Object)((Object)src)));
                    VolumeToken token = volEntity.getAttachmentTokenIfValid(tokenValue);
                    token.invalidateExport(nodeIp, nodeIqn);
                    Entities.flush((Object)((Object)token));
                    return token;
                }
                catch (Exception e) {
                    LOG.error((Object)("Could not invalidate requested export with token " + tokenValue + " to " + nodeIp + " with iqn " + nodeIqn));
                    return null;
                }
            }
        };
        if (Entities.asTransaction(VolumeInfo.class, (Function)invalidateToken).apply((Object)this) == null) {
            throw new EucalyptusCloudException("Failed on invalidation of token");
        }
    }

    public boolean cleanupOnDeletion() {
        return this.deletionTime != null && System.currentTimeMillis() > this.deletionTime.getTime() + TimeUnit.MILLISECONDS.convert(StorageInfo.getStorageInfo().getDeletedVolExpiration().intValue(), TimeUnit.HOURS);
    }
}

