/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.blockstorage.entities;

import com.eucalyptus.blockstorage.entities.VolumeInfo;
import com.eucalyptus.blockstorage.entities.VolumeToken;
import com.eucalyptus.entities.AbstractPersistent;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.PersistenceContext;
import javax.persistence.Table;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

@Entity
@PersistenceContext(name="eucalyptus_storage")
@Table(name="volume_exports")
@Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
public class VolumeExportRecord
extends AbstractPersistent {
    private static final long serialVersionUID = 1L;
    @ManyToOne
    @JoinColumn(name="token", nullable=false)
    private VolumeToken token;
    @ManyToOne
    @JoinColumn(name="volume", nullable=false)
    private VolumeInfo volume;
    @Column(name="host_ip", updatable=false, nullable=false)
    private String hostIp;
    @Column(name="host_iqn", updatable=false, nullable=false)
    private String hostIqn;
    @Column(name="is_active")
    private Boolean isActive;
    @Column(name="connection_string", length=4096)
    private String connectionString;

    public VolumeExportRecord() {
        this.token = null;
        this.hostIp = null;
        this.hostIqn = null;
        this.volume = null;
    }

    public VolumeExportRecord(VolumeInfo vol, VolumeToken tok, String ip, String iqn) {
        this.volume = vol;
        this.token = tok;
        this.hostIp = ip;
        this.hostIqn = iqn;
    }

    public Boolean getIsActive() {
        return this.isActive;
    }

    public void setIsActive(Boolean isActive) {
        this.isActive = isActive;
    }

    public VolumeToken getToken() {
        return this.token;
    }

    public void setToken(VolumeToken token) {
        this.token = token;
    }

    public String getHostIp() {
        return this.hostIp;
    }

    public void setHostIp(String hostIp) {
        this.hostIp = hostIp;
    }

    public String getHostIqn() {
        return this.hostIqn;
    }

    public void setHostIqn(String hostIqn) {
        this.hostIqn = hostIqn;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.getId() == null ? 0 : this.getId().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        VolumeExportRecord other = (VolumeExportRecord)((Object)obj);
        return !(this.volume == null ? other.volume != null : !this.volume.equals((Object)other.volume) || !this.hostIqn.equals(other.hostIqn) || !this.hostIp.equals(other.hostIp) || this.isActive == false == other.isActive);
    }

    public String getConnectionString() {
        return this.connectionString;
    }

    public void setConnectionString(String connectionString) {
        this.connectionString = connectionString;
    }

    public VolumeInfo getVolume() {
        return this.volume;
    }

    public void setVolume(VolumeInfo volume) {
        this.volume = volume;
    }
}

