/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.blockstorage.entities;

import com.eucalyptus.blockstorage.Storage;
import com.eucalyptus.blockstorage.util.StorageProperties;
import com.eucalyptus.configurable.ConfigurableClass;
import com.eucalyptus.configurable.ConfigurableField;
import com.eucalyptus.configurable.ConfigurableFieldType;
import com.eucalyptus.configurable.ConfigurableIdentifier;
import com.eucalyptus.configurable.ConfigurableProperty;
import com.eucalyptus.configurable.ConfigurablePropertyException;
import com.eucalyptus.configurable.PropertyChangeListener;
import com.eucalyptus.entities.AbstractPersistent;
import com.eucalyptus.entities.Transactions;
import com.eucalyptus.upgrade.Upgrades;
import groovy.sql.Sql;
import java.util.List;
import java.util.concurrent.Callable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.PersistenceContext;
import javax.persistence.PostLoad;
import javax.persistence.PreUpdate;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.log4j.Logger;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

@Entity
@PersistenceContext(name="eucalyptus_storage")
@Table(name="storage_info")
@Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
@ConfigurableClass(root="storage", alias="basic", description="Basic storage controller configuration.", singleton=false, deferred=true)
public class StorageInfo
extends AbstractPersistent {
    private static final Boolean DEFAULT_SHOULD_TRANSFER_SNAPSHOTS = Boolean.TRUE;
    private static final Integer DEFAULT_MAX_SNAP_TRANSFER_RETRIES = 50;
    private static final Integer DEFAULT_SNAPSHOT_PART_SIZE_IN_MB = 100;
    private static final Integer DEFAULT_MAX_SNAPSHOT_PARTS_QUEUE_SIZE = 5;
    private static final Integer DEFAULT_MAX_SNAPSHOT_CONCURRENT_TRANSFERS = 3;
    private static final Integer DEFAULT_SNAPSHOT_TRANSFER_TIMEOUT = 48;
    private static final Integer DEFAULT_READ_BUFFER_SIZE_IN_MB = 1;
    private static final Integer DEFAULT_WRITE_BUFFER_SIZE_IN_MB = 100;
    @Transient
    private static Logger LOG = Logger.getLogger(StorageInfo.class);
    @ConfigurableIdentifier
    @Column(name="storage_name", unique=true)
    private String name;
    @ConfigurableField(description="Total disk space reserved for volumes", displayName="Disk space reserved for volumes")
    @Column(name="system_storage_volume_size_gb")
    private Integer maxTotalVolumeSizeInGb;
    @ConfigurableField(description="Max volume size", displayName="Max volume size")
    @Column(name="system_storage_max_volume_size_gb")
    private Integer maxVolumeSizeInGB;
    @ConfigurableField(description="Should transfer snapshots", displayName="Transfer snapshots to ObjectStorage", type=ConfigurableFieldType.BOOLEAN)
    @Column(name="system_storage_transfer_snapshots")
    private Boolean shouldTransferSnapshots;
    @ConfigurableField(description="Maximum retry count for snapshot transfer", displayName="Max Snaphot Transfer Retries", initial="50")
    @Column(name="max_snap_transfer_retries")
    private Integer maxSnapTransferRetries;
    @ConfigurableField(description="Expiration time for deleted volumes (hours)", displayName="Deleted Volumes Expiration Time (Hours)")
    @Column(name="deleted_vol_expiration")
    private Integer deletedVolExpiration;
    @ConfigurableField(description="Snapshot part size in MB for snapshot transfers using multipart upload. Minimum part size is 5MB", displayName="Snapshot Part Size", initial="100", changeListener=MinimumPartSizeChangeListener.class)
    @Column(name="snapshot_part_size_mb")
    private Integer snapshotPartSizeInMB;
    @ConfigurableField(description="Maximum number of snapshot parts per snapshot that can be spooled on the disk", displayName="Maximum Queue Size", initial="5", changeListener=PositiveIntegerChangeListener.class)
    @Column(name="max_snapshot_parts_queue_size")
    private Integer maxSnapshotPartsQueueSize;
    @ConfigurableField(description="Maximum number of snapshots that can be uploaded concurrently", displayName="Maximum Concurrent Snapshot Uploads", initial="3", changeListener=PositiveIntegerChangeListener.class)
    @Column(name="max_concurrent_snapshot_transfers")
    private Integer maxConcurrentSnapshotTransfers;
    @ConfigurableField(description="Snapshot upload wait time in hours after which the upload will be cancelled", displayName="Snapshot Upload Timeout", initial="48", changeListener=PositiveIntegerChangeListener.class)
    @Column(name="snapshot_transfer_timeout_hours")
    private Integer snapshotTransferTimeoutInHours;
    @ConfigurableField(description="Buffer size in MB for reading data from snapshot when uploading snapshot to objectstorage gateway", displayName="Read Buffer Size", initial="1", changeListener=PositiveIntegerChangeListener.class)
    @Column(name="read_buffer_size_mb")
    private Integer readBufferSizeInMB;
    @ConfigurableField(description="Buffer size in MB for writing data to snapshot when downloading snapshot from objectstorage gateway", displayName="Write Buffer Size", initial="100", changeListener=PositiveIntegerChangeListener.class)
    @Column(name="write_buffer_size_mb")
    private Integer writeBufferSizeInMB;

    public StorageInfo() {
        this.name = StorageProperties.NAME;
    }

    public StorageInfo(String name) {
        this.name = name;
    }

    public StorageInfo(String name, Integer maxTotalVolumeSizeInGb, Integer maxVolumeSizeInGB, Boolean shouldTransferSnapshots) {
        this.name = name;
        this.maxTotalVolumeSizeInGb = maxTotalVolumeSizeInGb;
        this.maxVolumeSizeInGB = maxVolumeSizeInGB;
        this.shouldTransferSnapshots = shouldTransferSnapshots;
        this.deletedVolExpiration = StorageProperties.DELETED_VOLUME_EXPIRATION_TIME;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getMaxTotalVolumeSizeInGb() {
        return this.maxTotalVolumeSizeInGb;
    }

    public void setMaxTotalVolumeSizeInGb(Integer maxTotalVolumeSizeInGb) {
        this.maxTotalVolumeSizeInGb = maxTotalVolumeSizeInGb;
    }

    public Integer getMaxVolumeSizeInGB() {
        return this.maxVolumeSizeInGB;
    }

    public void setMaxVolumeSizeInGB(Integer maxVolumeSizeInGB) {
        this.maxVolumeSizeInGB = maxVolumeSizeInGB;
    }

    public Boolean getShouldTransferSnapshots() {
        return this.shouldTransferSnapshots;
    }

    public void setShouldTransferSnapshots(Boolean shouldTransferSnapshots) {
        this.shouldTransferSnapshots = shouldTransferSnapshots;
    }

    public Integer getMaxSnapTransferRetries() {
        return this.maxSnapTransferRetries;
    }

    public void setMaxSnapTransferRetries(Integer maxSnapTransferRetries) {
        this.maxSnapTransferRetries = maxSnapTransferRetries;
    }

    public Integer getDeletedVolExpiration() {
        return this.deletedVolExpiration == null ? StorageProperties.DELETED_VOLUME_EXPIRATION_TIME : this.deletedVolExpiration;
    }

    public void setDeletedVolExpiration(Integer deletedVolExpiration) {
        this.deletedVolExpiration = deletedVolExpiration;
    }

    public Integer getSnapshotPartSizeInMB() {
        return this.snapshotPartSizeInMB;
    }

    public void setSnapshotPartSizeInMB(Integer snapshotPartSizeInMB) {
        this.snapshotPartSizeInMB = snapshotPartSizeInMB;
    }

    public Integer getMaxSnapshotPartsQueueSize() {
        return this.maxSnapshotPartsQueueSize;
    }

    public void setMaxSnapshotPartsQueueSize(Integer maxSnapshotPartsQueueSize) {
        this.maxSnapshotPartsQueueSize = maxSnapshotPartsQueueSize;
    }

    public Integer getMaxConcurrentSnapshotTransfers() {
        return this.maxConcurrentSnapshotTransfers;
    }

    public void setMaxConcurrentSnapshotTransfers(Integer maxConcurrentSnapshotTransfers) {
        this.maxConcurrentSnapshotTransfers = maxConcurrentSnapshotTransfers;
    }

    public Integer getSnapshotTransferTimeoutInHours() {
        return this.snapshotTransferTimeoutInHours;
    }

    public void setSnapshotTransferTimeoutInHours(Integer snapshotTransferTimeoutInHours) {
        this.snapshotTransferTimeoutInHours = snapshotTransferTimeoutInHours;
    }

    public Integer getReadBufferSizeInMB() {
        return this.readBufferSizeInMB;
    }

    public void setReadBufferSizeInMB(Integer readBufferSizeInMB) {
        this.readBufferSizeInMB = readBufferSizeInMB;
    }

    public Integer getWriteBufferSizeInMB() {
        return this.writeBufferSizeInMB;
    }

    public void setWriteBufferSizeInMB(Integer writeBufferSizeInMB) {
        this.writeBufferSizeInMB = writeBufferSizeInMB;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        StorageInfo other = (StorageInfo)((Object)obj);
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public String toString() {
        return this.name;
    }

    @PreUpdate
    @PostLoad
    public void setDefaults() {
        if (this.maxTotalVolumeSizeInGb == null) {
            this.maxTotalVolumeSizeInGb = 100;
        }
        if (this.maxVolumeSizeInGB == null) {
            this.maxVolumeSizeInGB = 100;
        }
        if (this.shouldTransferSnapshots == null) {
            this.shouldTransferSnapshots = DEFAULT_SHOULD_TRANSFER_SNAPSHOTS;
        }
        if (this.maxSnapTransferRetries == null) {
            this.maxSnapTransferRetries = DEFAULT_MAX_SNAP_TRANSFER_RETRIES;
        }
        if (this.deletedVolExpiration == null) {
            this.deletedVolExpiration = StorageProperties.DELETED_VOLUME_EXPIRATION_TIME;
        }
        if (this.snapshotPartSizeInMB == null) {
            this.snapshotPartSizeInMB = DEFAULT_SNAPSHOT_PART_SIZE_IN_MB;
        }
        if (this.maxSnapshotPartsQueueSize == null) {
            this.maxSnapshotPartsQueueSize = DEFAULT_MAX_SNAPSHOT_PARTS_QUEUE_SIZE;
        }
        if (this.maxConcurrentSnapshotTransfers == null) {
            this.maxConcurrentSnapshotTransfers = DEFAULT_MAX_SNAPSHOT_CONCURRENT_TRANSFERS;
        }
        if (this.snapshotTransferTimeoutInHours == null) {
            this.snapshotTransferTimeoutInHours = DEFAULT_SNAPSHOT_TRANSFER_TIMEOUT;
        }
        if (this.readBufferSizeInMB == null) {
            this.readBufferSizeInMB = DEFAULT_READ_BUFFER_SIZE_IN_MB;
        }
        if (this.writeBufferSizeInMB == null) {
            this.writeBufferSizeInMB = DEFAULT_WRITE_BUFFER_SIZE_IN_MB;
        }
    }

    private static StorageInfo getDefaultInstance() {
        StorageInfo info = new StorageInfo(StorageProperties.NAME);
        info.setMaxTotalVolumeSizeInGb(100);
        info.setMaxVolumeSizeInGB(15);
        info.setShouldTransferSnapshots(DEFAULT_SHOULD_TRANSFER_SNAPSHOTS);
        info.setDeletedVolExpiration(StorageProperties.DELETED_VOLUME_EXPIRATION_TIME);
        info.setMaxSnapTransferRetries(DEFAULT_MAX_SNAP_TRANSFER_RETRIES);
        info.setSnapshotPartSizeInMB(DEFAULT_SNAPSHOT_PART_SIZE_IN_MB);
        info.setMaxSnapshotPartsQueueSize(DEFAULT_MAX_SNAPSHOT_PARTS_QUEUE_SIZE);
        info.setMaxConcurrentSnapshotTransfers(DEFAULT_MAX_SNAPSHOT_CONCURRENT_TRANSFERS);
        info.setSnapshotTransferTimeoutInHours(DEFAULT_SNAPSHOT_TRANSFER_TIMEOUT);
        info.setReadBufferSizeInMB(DEFAULT_READ_BUFFER_SIZE_IN_MB);
        info.setWriteBufferSizeInMB(DEFAULT_WRITE_BUFFER_SIZE_IN_MB);
        return info;
    }

    public static StorageInfo getStorageInfo() {
        StorageInfo conf = null;
        try {
            conf = (StorageInfo)((Object)Transactions.find((Object)((Object)new StorageInfo())));
        }
        catch (Exception e) {
            LOG.warn((Object)("Storage controller properties for " + StorageProperties.NAME + " not found. Loading defaults."));
            try {
                conf = (StorageInfo)((Object)Transactions.saveDirect((Object)((Object)StorageInfo.getDefaultInstance())));
            }
            catch (Exception e1) {
                try {
                    conf = (StorageInfo)((Object)Transactions.find((Object)((Object)new StorageInfo())));
                }
                catch (Exception e2) {
                    LOG.warn((Object)"Failed to persist and retrieve StorageInfo entity");
                }
            }
        }
        if (conf == null) {
            conf = StorageInfo.getDefaultInstance();
        }
        return conf;
    }

    @Upgrades.PreUpgrade(since=Upgrades.Version.v4_1_0, value=Storage.class)
    public static class RenameColumns
    implements Callable<Boolean> {
        private static final Logger LOG = Logger.getLogger(RenameColumns.class);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Boolean call() throws Exception {
            LOG.info((Object)"Renaming columns in table storage_info");
            try (Sql sql = null;){
                sql = Upgrades.DatabaseFilters.NEWVERSION.getConnection("eucalyptus_storage");
                String table = "storage_info";
                String oldName = "max_concurrent_snapshot_uploads";
                String newName = "max_concurrent_snapshot_transfers";
                List result = sql.rows(String.format("select column_name from information_schema.columns where table_name='%s' and column_name='%s'", table, oldName));
                if (result != null && !result.isEmpty()) {
                    LOG.info((Object)("Dropping column if it exists " + newName));
                    sql.execute(String.format("alter table %s drop column if exists %s", table, newName));
                    LOG.info((Object)("Renaming column " + oldName + " to " + newName));
                    sql.execute(String.format("alter table %s rename column %s to %s", table, oldName, newName));
                } else {
                    LOG.debug((Object)("Column " + oldName + " not found, nothing to rename"));
                }
                oldName = "snapshot_upload_timeout_hours";
                newName = "snapshot_transfer_timeout_hours";
                result = sql.rows(String.format("select column_name from information_schema.columns where table_name='%s' and column_name='%s'", table, oldName));
                if (result != null && !result.isEmpty()) {
                    LOG.info((Object)("Dropping column if it exists " + newName));
                    sql.execute(String.format("alter table %s drop column if exists %s", table, newName));
                    LOG.info((Object)("Renaming column " + oldName + " to " + newName));
                    sql.execute(String.format("alter table %s rename column %s to %s", table, oldName, newName));
                } else {
                    LOG.debug((Object)("Column " + oldName + " not found, nothing to rename"));
                }
                Boolean bl = Boolean.TRUE;
                return bl;
            }
        }
    }

    public static class PositiveIntegerChangeListener
    implements PropertyChangeListener<Integer> {
        public void fireChange(ConfigurableProperty t, Integer newValue) throws ConfigurablePropertyException {
            if (newValue == null) {
                LOG.error((Object)("Invalid value for " + t.getFieldName()));
                throw new ConfigurablePropertyException("Invalid value for " + t.getFieldName());
            }
            if (newValue <= 0) {
                LOG.error((Object)(t.getFieldName() + " cannot be modified to " + newValue + ". It must be an integer greater than 0"));
                throw new ConfigurablePropertyException(t.getFieldName() + " cannot be modified to " + newValue + ". It must be an integer greater than 0");
            }
        }
    }

    public static class MinimumPartSizeChangeListener
    implements PropertyChangeListener<Integer> {
        public void fireChange(ConfigurableProperty t, Integer newValue) throws ConfigurablePropertyException {
            try {
                if (newValue == null) {
                    LOG.error((Object)("Invalid value for " + t.getFieldName()));
                    throw new ConfigurablePropertyException("Invalid value for " + t.getFieldName());
                }
                if (newValue < 5) {
                    LOG.error((Object)(t.getFieldName() + " cannot be modified to " + newValue + ". It must be greater than or equal to 5"));
                    throw new ConfigurablePropertyException(t.getFieldName() + " cannot be modified to " + newValue + ". It must be greater than or equal to 5");
                }
            }
            catch (IllegalArgumentException e) {
                throw new ConfigurablePropertyException("Invalid paths: " + e, (Throwable)e);
            }
        }
    }
}

