/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.blockstorage.entities;

import com.eucalyptus.blockstorage.util.StorageProperties;
import com.eucalyptus.entities.AbstractPersistent;
import com.eucalyptus.entities.Entities;
import com.eucalyptus.entities.TransactionResource;
import com.eucalyptus.util.EucalyptusCloudException;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.PersistenceContext;
import javax.persistence.Table;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

@PersistenceContext(name="eucalyptus_storage")
@Table(name="snapshot_upload_info")
@Entity
@Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
public class SnapshotUploadInfo
extends AbstractPersistent {
    public static final Long PURGE_INTERVAL = 3600000L;
    @Column(name="sc_name")
    private String scName = StorageProperties.NAME;
    @Column(name="snapshot_id")
    private String snapshotId;
    @Column(name="bucket_name")
    private String bucketName;
    @Column(name="key_name")
    private String keyName;
    @Column(name="upload_id")
    private String uploadId;
    @Column(name="state")
    @Enumerated(value=EnumType.STRING)
    private SnapshotUploadState state;
    @Column(name="total_parts")
    private Integer totalParts;
    @Column(name="etag")
    private String etag;
    @Column(name="purge_time")
    private Long purgeTime;

    public SnapshotUploadInfo() {
    }

    public SnapshotUploadInfo(String snapshotId, String bucketName, String keyName) {
        this();
        this.snapshotId = snapshotId;
        this.bucketName = bucketName;
        this.keyName = keyName;
    }

    public SnapshotUploadInfo(String snapshotId, String bucketName, String keyName, String uploadId) {
        this();
        this.snapshotId = snapshotId;
        this.bucketName = bucketName;
        this.keyName = keyName;
        this.uploadId = uploadId;
    }

    public SnapshotUploadInfo(String snapshotId, String bucketName, String keyName, SnapshotUploadState state) {
        this();
        this.snapshotId = snapshotId;
        this.bucketName = bucketName;
        this.keyName = keyName;
        this.state = state;
    }

    public String getScName() {
        return this.scName;
    }

    public void setScName(String scName) {
        this.scName = scName;
    }

    public String getSnapshotId() {
        return this.snapshotId;
    }

    public void setSnapshotId(String snapshotId) {
        this.snapshotId = snapshotId;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }

    public String getKeyName() {
        return this.keyName;
    }

    public void setKeyName(String keyName) {
        this.keyName = keyName;
    }

    public String getUploadId() {
        return this.uploadId;
    }

    public void setUploadId(String uploadId) {
        this.uploadId = uploadId;
    }

    public SnapshotUploadState getState() {
        return this.state;
    }

    public void setState(SnapshotUploadState state) {
        this.state = state;
    }

    public SnapshotUploadInfo withState(SnapshotUploadState state) {
        this.state = state;
        return this;
    }

    public Integer getTotalParts() {
        return this.totalParts;
    }

    public void setTotalParts(Integer totalParts) {
        this.totalParts = totalParts;
    }

    public String getEtag() {
        return this.etag;
    }

    public void setEtag(String etag) {
        this.etag = etag;
    }

    public Long getPurgeTime() {
        return this.purgeTime;
    }

    public void setPurgeTime(Long purgeTime) {
        this.purgeTime = purgeTime;
    }

    public String toString() {
        return "SnapshotMpuInfo [snapshotId=" + this.snapshotId + ", bucketName=" + this.bucketName + ", keyName=" + this.keyName + ", uploadId=" + this.uploadId + "]";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static SnapshotUploadInfo create(String snapshotId, String bucketName, String keyName) throws EucalyptusCloudException {
        try (TransactionResource transaction = Entities.transactionFor(SnapshotUploadInfo.class);){
            SnapshotUploadInfo snapUploadInfo = (SnapshotUploadInfo)((Object)Entities.persist((Object)((Object)new SnapshotUploadInfo(snapshotId, bucketName, keyName, SnapshotUploadState.creatingparts))));
            transaction.commit();
            SnapshotUploadInfo snapshotUploadInfo = snapUploadInfo;
            return snapshotUploadInfo;
        }
        catch (Exception ex) {
            throw new EucalyptusCloudException("Failed to create snapshot upload info enity. snapshot Id=" + snapshotId + ", bucket=" + bucketName + ", key=" + keyName, (Throwable)ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SnapshotUploadInfo updateUploadId(String uploadId) throws EucalyptusCloudException {
        try (TransactionResource transaction = Entities.transactionFor(SnapshotUploadInfo.class);){
            SnapshotUploadInfo snapUploadInfo = (SnapshotUploadInfo)((Object)Entities.uniqueResult((Object)((Object)new SnapshotUploadInfo(this.snapshotId, this.bucketName, this.keyName))));
            snapUploadInfo.setUploadId(uploadId);
            transaction.commit();
            SnapshotUploadInfo snapshotUploadInfo = snapUploadInfo;
            return snapshotUploadInfo;
        }
        catch (Exception ex) {
            throw new EucalyptusCloudException("Failed to update upload ID for snapshot upload info enity " + (Object)((Object)this), (Throwable)ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SnapshotUploadInfo updateStateCreatedParts(Integer totalParts) throws EucalyptusCloudException {
        try (TransactionResource transaction = Entities.transactionFor(SnapshotUploadInfo.class);){
            SnapshotUploadInfo snapUploadInfo = (SnapshotUploadInfo)((Object)Entities.uniqueResult((Object)((Object)new SnapshotUploadInfo(this.snapshotId, this.bucketName, this.keyName, this.uploadId))));
            snapUploadInfo.setTotalParts(totalParts);
            snapUploadInfo.setState(SnapshotUploadState.createdparts);
            transaction.commit();
            SnapshotUploadInfo snapshotUploadInfo = snapUploadInfo;
            return snapshotUploadInfo;
        }
        catch (Exception ex) {
            throw new EucalyptusCloudException("Failed to update state for snapshot upload info enity " + (Object)((Object)this) + " to " + SnapshotUploadState.createdparts.toString() + (Object)((Object)this), (Throwable)ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SnapshotUploadInfo updateStateUploaded(String etag) throws EucalyptusCloudException {
        try (TransactionResource transaction = Entities.transactionFor(SnapshotUploadInfo.class);){
            SnapshotUploadInfo snapUploadInfo = (SnapshotUploadInfo)((Object)Entities.uniqueResult((Object)((Object)new SnapshotUploadInfo(this.snapshotId, this.bucketName, this.keyName, this.uploadId))));
            snapUploadInfo.setState(SnapshotUploadState.uploaded);
            snapUploadInfo.setEtag(etag);
            snapUploadInfo.setPurgeTime(System.currentTimeMillis() + PURGE_INTERVAL);
            transaction.commit();
            SnapshotUploadInfo snapshotUploadInfo = snapUploadInfo;
            return snapshotUploadInfo;
        }
        catch (Exception ex) {
            throw new EucalyptusCloudException("Failed to update state for snapshot upload info enity " + (Object)((Object)this) + " to " + SnapshotUploadState.uploaded.toString() + (Object)((Object)this), (Throwable)ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SnapshotUploadInfo updateStateAborted() throws EucalyptusCloudException {
        try (TransactionResource transaction = Entities.transactionFor(SnapshotUploadInfo.class);){
            SnapshotUploadInfo snapUploadInfo = (SnapshotUploadInfo)((Object)Entities.uniqueResult((Object)((Object)new SnapshotUploadInfo(this.snapshotId, this.bucketName, this.keyName, this.uploadId))));
            snapUploadInfo.setState(SnapshotUploadState.aborted);
            transaction.commit();
            SnapshotUploadInfo snapshotUploadInfo = snapUploadInfo;
            return snapshotUploadInfo;
        }
        catch (Exception ex) {
            throw new EucalyptusCloudException("Failed to update state for snapshot upload info enity " + (Object)((Object)this) + " to " + SnapshotUploadState.aborted.toString() + (Object)((Object)this), (Throwable)ex);
        }
    }

    public static enum SnapshotUploadState {
        creatingparts,
        createdparts,
        uploaded,
        aborted,
        cleaned;

    }
}

