/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.blockstorage.entities;

import com.eucalyptus.entities.AbstractPersistent;
import com.eucalyptus.entities.Entities;
import com.eucalyptus.entities.TransactionException;
import com.eucalyptus.entities.TransactionResource;
import com.eucalyptus.entities.Transactions;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.PersistenceContext;
import javax.persistence.Table;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

@Entity
@PersistenceContext(name="eucalyptus_storage")
@Table(name="snapshot_transfer_configuration")
@Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
public class SnapshotTransferConfiguration
extends AbstractPersistent {
    private static final String DEFAULT_SINGLETON_ID = "singleton";
    public static final int DEFAULT_BUCKET_CREATION_RETRIES = 10;
    public static final String OSG = "objectstoragegateway";
    @Column(name="singleton_id")
    private String singletonId = "singleton";
    @Column(name="snapshot_bucket")
    private String snapshotBucket;

    public SnapshotTransferConfiguration() {
    }

    public SnapshotTransferConfiguration(String snapshotBucket) {
        this();
        this.snapshotBucket = snapshotBucket;
    }

    public String getSnapshotBucket() {
        return this.snapshotBucket;
    }

    public void setSnapshotBucket(String snapshotBucket) {
        this.snapshotBucket = snapshotBucket;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.snapshotBucket == null ? 0 : this.snapshotBucket.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        SnapshotTransferConfiguration other = (SnapshotTransferConfiguration)((Object)obj);
        return !(this.snapshotBucket == null ? other.snapshotBucket != null : !this.snapshotBucket.equals(other.snapshotBucket));
    }

    public static synchronized SnapshotTransferConfiguration getInstance() throws TransactionException {
        return (SnapshotTransferConfiguration)((Object)Transactions.one((Object)((Object)new SnapshotTransferConfiguration()), (Function)Functions.identity()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized SnapshotTransferConfiguration updateBucketName(String snapshotBucket) {
        try (TransactionResource db = Entities.transactionFor(SnapshotTransferConfiguration.class);){
            SnapshotTransferConfiguration conf = null;
            try {
                conf = (SnapshotTransferConfiguration)((Object)Entities.uniqueResult((Object)((Object)new SnapshotTransferConfiguration())));
                conf.setSnapshotBucket(snapshotBucket);
            }
            catch (Exception ex) {
                conf = new SnapshotTransferConfiguration(snapshotBucket);
                Entities.persist((Object)((Object)conf));
            }
            finally {
                db.commit();
            }
            SnapshotTransferConfiguration snapshotTransferConfiguration = conf;
            return snapshotTransferConfiguration;
        }
    }
}

