/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.blockstorage.entities;

import com.eucalyptus.blockstorage.entities.SnapshotUploadInfo;
import com.eucalyptus.blockstorage.util.StorageProperties;
import com.eucalyptus.entities.AbstractPersistent;
import com.eucalyptus.entities.Entities;
import com.eucalyptus.entities.TransactionResource;
import com.eucalyptus.util.EucalyptusCloudException;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.PersistenceContext;
import javax.persistence.Table;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

@PersistenceContext(name="eucalyptus_storage")
@Table(name="snapshot_part")
@Entity
@Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
public class SnapshotPart
extends AbstractPersistent {
    @Column(name="sc_name")
    private String scName = StorageProperties.NAME;
    @Column(name="snapshot_id")
    private String snapshotId;
    @Column(name="bucket_name")
    private String bucketName;
    @Column(name="key_name")
    private String keyName;
    @Column(name="upload_id")
    private String uploadId;
    @Column(name="file_name")
    private String fileName;
    @Column(name="part_number")
    private Integer partNumber;
    @Column(name="size")
    private Long size;
    @Column(name="input_file_read_offset")
    private Long inputFileReadOffset;
    @Column(name="input_file_bytes_read")
    private Long inputFileBytesRead;
    @Column(name="is_last")
    private Boolean isLast;
    @Column(name="state")
    @Enumerated(value=EnumType.STRING)
    private SnapshotPartState state;
    @Column(name="etag")
    private String etag;

    public SnapshotPart() {
    }

    public SnapshotPart(String snapshotId, String bucketName, String keyName, String uploadId) {
        this();
        this.snapshotId = snapshotId;
        this.bucketName = bucketName;
        this.keyName = keyName;
        this.uploadId = uploadId;
    }

    public SnapshotPart(String snapshotId, String bucketName, String keyName, String uploadId, Integer partNumber) {
        this();
        this.snapshotId = snapshotId;
        this.bucketName = bucketName;
        this.keyName = keyName;
        this.uploadId = uploadId;
        this.partNumber = partNumber;
    }

    public SnapshotPart(String snapshotId, String bucketName, String keyName, String uploadId, String fileName, Integer partNumber, Long inputFileReadOffset, SnapshotPartState state) {
        this();
        this.snapshotId = snapshotId;
        this.bucketName = bucketName;
        this.keyName = keyName;
        this.uploadId = uploadId;
        this.fileName = fileName;
        this.partNumber = partNumber;
        this.inputFileReadOffset = inputFileReadOffset;
        this.state = state;
    }

    public String getScName() {
        return this.scName;
    }

    public void setScName(String scName) {
        this.scName = scName;
    }

    public String getSnapshotId() {
        return this.snapshotId;
    }

    public void setSnapshotId(String snapshotId) {
        this.snapshotId = snapshotId;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }

    public String getKeyName() {
        return this.keyName;
    }

    public void setKeyName(String keyName) {
        this.keyName = keyName;
    }

    public String getUploadId() {
        return this.uploadId;
    }

    public void setUploadId(String uploadId) {
        this.uploadId = uploadId;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public Integer getPartNumber() {
        return this.partNumber;
    }

    public void setPartNumber(Integer partNumber) {
        this.partNumber = partNumber;
    }

    public Long getSize() {
        return this.size;
    }

    public void setSize(Long size) {
        this.size = size;
    }

    public Long getInputFileReadOffset() {
        return this.inputFileReadOffset;
    }

    public void setInputFileReadOffset(Long inputFileReadOffset) {
        this.inputFileReadOffset = inputFileReadOffset;
    }

    public Long getInputFileBytesRead() {
        return this.inputFileBytesRead;
    }

    public void setInputFileBytesRead(Long inputFileBytesRead) {
        this.inputFileBytesRead = inputFileBytesRead;
    }

    public Boolean getIsLast() {
        return this.isLast;
    }

    public void setIsLast(Boolean isLast) {
        this.isLast = isLast;
    }

    public SnapshotPartState getState() {
        return this.state;
    }

    public void setState(SnapshotPartState state) {
        this.state = state;
    }

    public String getEtag() {
        return this.etag;
    }

    public void setEtag(String etag) {
        this.etag = etag;
    }

    public String toString() {
        return "SnapshotPart [snapshotId=" + this.snapshotId + ", bucketName=" + this.bucketName + ", keyName=" + this.keyName + ", uploadId=" + this.uploadId + ", partNumber=" + this.partNumber + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.snapshotId == null ? 0 : this.snapshotId.hashCode());
        result = 31 * result + (this.bucketName == null ? 0 : this.bucketName.hashCode());
        result = 31 * result + (this.keyName == null ? 0 : this.keyName.hashCode());
        result = 31 * result + (this.uploadId == null ? 0 : this.uploadId.hashCode());
        result = 31 * result + (this.partNumber == null ? 0 : this.partNumber.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        SnapshotPart other = (SnapshotPart)((Object)obj);
        if (this.snapshotId == null ? other.snapshotId != null : !this.snapshotId.equals(other.snapshotId)) {
            return false;
        }
        if (this.bucketName == null ? other.bucketName != null : !this.bucketName.equals(other.bucketName)) {
            return false;
        }
        if (this.keyName == null ? other.keyName != null : !this.keyName.equals(other.keyName)) {
            return false;
        }
        if (this.uploadId == null ? other.uploadId != null : !this.uploadId.equals(other.uploadId)) {
            return false;
        }
        return !(this.partNumber == null ? other.partNumber != null : !this.partNumber.equals(other.partNumber));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static SnapshotPart createPart(SnapshotUploadInfo snapUploadInfo, String fileName, Integer partNumber, Long inputFileReadOffset) throws EucalyptusCloudException {
        try (TransactionResource transaction = Entities.transactionFor(SnapshotPart.class);){
            SnapshotPart part = (SnapshotPart)((Object)Entities.persist((Object)((Object)new SnapshotPart(snapUploadInfo.getSnapshotId(), snapUploadInfo.getBucketName(), snapUploadInfo.getKeyName(), snapUploadInfo.getUploadId(), fileName, partNumber, inputFileReadOffset, SnapshotPartState.creating))));
            transaction.commit();
            SnapshotPart snapshotPart = part;
            return snapshotPart;
        }
        catch (Exception ex) {
            throw new EucalyptusCloudException("Failed to create part entity. snapshotId=" + snapUploadInfo.getSnapshotId() + ", bucket=" + snapUploadInfo.getBucketName() + ", key=" + snapUploadInfo.getKeyName() + ", upload ID=" + snapUploadInfo.getUploadId() + ", part number=" + partNumber, (Throwable)ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SnapshotPart updateStateCreated(String uploadId, Long size, Long inputFileBytesRead, Boolean isLast) throws EucalyptusCloudException {
        try (TransactionResource transaction = Entities.transactionFor(SnapshotPart.class);){
            SnapshotPart part = (SnapshotPart)((Object)Entities.uniqueResult((Object)((Object)new SnapshotPart(this.snapshotId, this.bucketName, this.keyName, this.uploadId, this.partNumber))));
            part.setUploadId(uploadId);
            part.setSize(size);
            part.setInputFileBytesRead(inputFileBytesRead);
            part.setIsLast(isLast);
            part.setState(SnapshotPartState.created);
            transaction.commit();
            SnapshotPart snapshotPart = part;
            return snapshotPart;
        }
        catch (Exception ex) {
            throw new EucalyptusCloudException("Failed to update state for part entity " + (Object)((Object)this) + " to " + SnapshotPartState.created.toString(), (Throwable)ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SnapshotPart updateStateCreated(Long size, Long inputFileBytesRead, Boolean isLast) throws EucalyptusCloudException {
        try (TransactionResource transaction = Entities.transactionFor(SnapshotPart.class);){
            SnapshotPart part = (SnapshotPart)((Object)Entities.uniqueResult((Object)((Object)new SnapshotPart(this.snapshotId, this.bucketName, this.keyName, this.uploadId, this.partNumber))));
            part.setSize(size);
            part.setInputFileBytesRead(inputFileBytesRead);
            part.setIsLast(isLast);
            part.setState(SnapshotPartState.created);
            transaction.commit();
            SnapshotPart snapshotPart = part;
            return snapshotPart;
        }
        catch (Exception ex) {
            throw new EucalyptusCloudException("Failed to update state for part entity " + (Object)((Object)this) + " to " + SnapshotPartState.created.toString(), (Throwable)ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SnapshotPart updateStateUploading() throws EucalyptusCloudException {
        try (TransactionResource transaction = Entities.transactionFor(SnapshotPart.class);){
            SnapshotPart part = (SnapshotPart)((Object)Entities.uniqueResult((Object)((Object)new SnapshotPart(this.snapshotId, this.bucketName, this.keyName, this.uploadId, this.partNumber))));
            part.setState(SnapshotPartState.uploading);
            transaction.commit();
            SnapshotPart snapshotPart = part;
            return snapshotPart;
        }
        catch (Exception ex) {
            throw new EucalyptusCloudException("Failed to update state for part entity " + (Object)((Object)this) + " to " + SnapshotPartState.uploading.toString(), (Throwable)ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SnapshotPart updateStateUploaded(String etag) throws EucalyptusCloudException {
        try (TransactionResource transaction = Entities.transactionFor(SnapshotPart.class);){
            SnapshotPart part = (SnapshotPart)((Object)Entities.uniqueResult((Object)((Object)new SnapshotPart(this.snapshotId, this.bucketName, this.keyName, this.uploadId, this.partNumber))));
            part.setEtag(etag);
            part.setState(SnapshotPartState.uploaded);
            transaction.commit();
            SnapshotPart snapshotPart = part;
            return snapshotPart;
        }
        catch (Exception ex) {
            throw new EucalyptusCloudException("Failed to update state for part entity " + (Object)((Object)this) + " to " + SnapshotPartState.uploaded.toString(), (Throwable)ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SnapshotPart updateStateFailed() throws EucalyptusCloudException {
        try (TransactionResource transaction = Entities.transactionFor(SnapshotPart.class);){
            SnapshotPart part = (SnapshotPart)((Object)Entities.uniqueResult((Object)((Object)new SnapshotPart(this.snapshotId, this.bucketName, this.keyName, this.uploadId, this.partNumber))));
            part.setState(SnapshotPartState.failed);
            transaction.commit();
            SnapshotPart snapshotPart = part;
            return snapshotPart;
        }
        catch (Exception ex) {
            throw new EucalyptusCloudException("Failed to update state for part entity " + (Object)((Object)this) + " to " + SnapshotPartState.failed.toString(), (Throwable)ex);
        }
    }

    public static enum SnapshotPartState {
        creating,
        created,
        uploading,
        uploaded,
        failed,
        cleaned;

    }
}

